/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.Arrays;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Condition;
import org.h2.expression.ConditionIn;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.index.IndexCondition;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.New;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Comparison
extends Condition {
    public static final int NULL_SAFE = 16;
    public static final int EQUAL = 0;
    public static final int EQUAL_NULL_SAFE = 16;
    public static final int BIGGER_EQUAL = 1;
    public static final int BIGGER = 2;
    public static final int SMALLER_EQUAL = 3;
    public static final int SMALLER = 4;
    public static final int NOT_EQUAL = 5;
    public static final int NOT_EQUAL_NULL_SAFE = 21;
    public static final int IS_NULL = 6;
    public static final int IS_NOT_NULL = 7;
    public static final int FALSE = 8;
    public static final int IN_LIST = 9;
    public static final int IN_QUERY = 10;
    private final Database aD;
    private int aC;
    private Expression aB;
    private Expression aE;

    public Comparison(Session session, int n2, Expression expression, Expression expression2) {
        this.aD = session.getDatabase();
        this.aB = expression;
        this.aE = expression2;
        this.aC = n2;
    }

    public String getSQL() {
        String string;
        switch (this.aC) {
            case 0: {
                string = this.aB.getSQL() + " = " + this.aE.getSQL();
                break;
            }
            case 16: {
                string = this.aB.getSQL() + " IS " + this.aE.getSQL();
                break;
            }
            case 1: {
                string = this.aB.getSQL() + " >= " + this.aE.getSQL();
                break;
            }
            case 2: {
                string = this.aB.getSQL() + " > " + this.aE.getSQL();
                break;
            }
            case 3: {
                string = this.aB.getSQL() + " <= " + this.aE.getSQL();
                break;
            }
            case 4: {
                string = this.aB.getSQL() + " < " + this.aE.getSQL();
                break;
            }
            case 5: {
                string = this.aB.getSQL() + " <> " + this.aE.getSQL();
                break;
            }
            case 21: {
                string = this.aB.getSQL() + " IS NOT " + this.aE.getSQL();
                break;
            }
            case 6: {
                string = this.aB.getSQL() + " IS NULL";
                break;
            }
            case 7: {
                string = this.aB.getSQL() + " IS NOT NULL";
                break;
            }
            default: {
                throw DbException.throwInternalError("compareType=" + this.aC);
            }
        }
        return "(" + string + ")";
    }

    public Expression optimize(Session session) {
        this.aB = this.aB.optimize(session);
        if (this.aE != null) {
            Object object;
            this.aE = this.aE.optimize(session);
            if (this.aE instanceof ExpressionColumn && (this.aB.isConstant() || this.aB instanceof Parameter)) {
                object = this.aB;
                this.aB = this.aE;
                this.aE = object;
                this.aC = this.a(this.aC);
            }
            if (this.aB instanceof ExpressionColumn) {
                if (this.aE.isConstant()) {
                    object = this.aE.getValue(session);
                    if (object == ValueNull.INSTANCE && (this.aC & 0x10) == 0) {
                        return ValueExpression.getNull();
                    }
                } else if (this.aE instanceof Parameter) {
                    ((Parameter)this.aE).setColumn(((ExpressionColumn)this.aB).getColumn());
                }
            }
        }
        if (this.aC == 6 || this.aC == 7) {
            if (this.aB.isConstant()) {
                return ValueExpression.get(this.getValue(session));
            }
        } else {
            if (SysProperties.CHECK && (this.aB == null || this.aE == null)) {
                DbException.throwInternalError();
            }
            if ((this.aB == ValueExpression.getNull() || this.aE == ValueExpression.getNull()) && (this.aC & 0x10) == 0) {
                return ValueExpression.getNull();
            }
            if (this.aB.isConstant() && this.aE.isConstant()) {
                return ValueExpression.get(this.getValue(session));
            }
        }
        return this;
    }

    public Value getValue(Session session) {
        Value value = this.aB.getValue(session);
        if (this.aE == null) {
            boolean bl;
            switch (this.aC) {
                case 6: {
                    bl = value == ValueNull.INSTANCE;
                    break;
                }
                case 7: {
                    bl = value != ValueNull.INSTANCE;
                    break;
                }
                default: {
                    throw DbException.throwInternalError("type=" + this.aC);
                }
            }
            return ValueBoolean.get(bl);
        }
        if (value == ValueNull.INSTANCE && (this.aC & 0x10) == 0) {
            return ValueNull.INSTANCE;
        }
        Value value2 = this.aE.getValue(session);
        if (value2 == ValueNull.INSTANCE && (this.aC & 0x10) == 0) {
            return ValueNull.INSTANCE;
        }
        int n2 = Value.getHigherOrder(this.aB.getType(), this.aE.getType());
        value = value.convertTo(n2);
        value2 = value2.convertTo(n2);
        boolean bl = Comparison.compareNotNull(this.aD, value, value2, this.aC);
        return ValueBoolean.get(bl);
    }

    static boolean compareNotNull(Database database, Value value, Value value2, int n2) {
        boolean bl;
        switch (n2) {
            case 0: 
            case 16: {
                bl = database.areEqual(value, value2);
                break;
            }
            case 5: 
            case 21: {
                bl = !database.areEqual(value, value2);
                break;
            }
            case 1: {
                bl = database.compare(value, value2) >= 0;
                break;
            }
            case 2: {
                bl = database.compare(value, value2) > 0;
                break;
            }
            case 3: {
                bl = database.compare(value, value2) <= 0;
                break;
            }
            case 4: {
                bl = database.compare(value, value2) < 0;
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + n2);
            }
        }
        return bl;
    }

    private int a(int n2) {
        switch (this.aC) {
            case 0: 
            case 5: 
            case 16: 
            case 21: {
                return n2;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
        }
        throw DbException.throwInternalError("type=" + this.aC);
    }

    private int byte() {
        switch (this.aC) {
            case 0: {
                return 5;
            }
            case 16: {
                return 21;
            }
            case 5: {
                return 0;
            }
            case 21: {
                return 16;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 1;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 6;
            }
        }
        throw DbException.throwInternalError("type=" + this.aC);
    }

    public Expression getNotIfPossible(Session session) {
        int n2 = this.byte();
        return new Comparison(session, n2, this.aB, this.aE);
    }

    public void createIndexConditions(Session session, TableFilter tableFilter) {
        boolean bl;
        ExpressionVisitor expressionVisitor;
        ExpressionColumn expressionColumn = null;
        if (this.aB instanceof ExpressionColumn && tableFilter != (expressionColumn = (ExpressionColumn)this.aB).getTableFilter()) {
            expressionColumn = null;
        }
        if (this.aE == null) {
            if (expressionColumn != null) {
                switch (this.aC) {
                    case 6: {
                        if (!session.getDatabase().getSettings().optimizeIsNull) break;
                        tableFilter.addIndexCondition(IndexCondition.get(16, expressionColumn, ValueExpression.getNull()));
                    }
                }
            }
            return;
        }
        ExpressionColumn expressionColumn2 = null;
        if (this.aE instanceof ExpressionColumn && tableFilter != (expressionColumn2 = (ExpressionColumn)this.aE).getTableFilter()) {
            expressionColumn2 = null;
        }
        if (expressionColumn == null && expressionColumn2 == null) {
            return;
        }
        if (expressionColumn != null && expressionColumn2 != null) {
            return;
        }
        if (expressionColumn == null) {
            expressionVisitor = ExpressionVisitor.getNotFromResolverVisitor(tableFilter);
            if (!this.aB.isEverything(expressionVisitor)) {
                return;
            }
        } else if (expressionColumn2 == null) {
            expressionVisitor = ExpressionVisitor.getNotFromResolverVisitor(tableFilter);
            if (!this.aE.isEverything(expressionVisitor)) {
                return;
            }
        } else {
            return;
        }
        switch (this.aC) {
            case 5: 
            case 21: {
                bl = false;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 16: {
                bl = true;
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + this.aC);
            }
        }
        if (bl) {
            if (expressionColumn != null) {
                tableFilter.addIndexCondition(IndexCondition.get(this.aC, expressionColumn, this.aE));
            } else if (expressionColumn2 != null) {
                int n2 = this.a(this.aC);
                tableFilter.addIndexCondition(IndexCondition.get(n2, expressionColumn2, this.aB));
            }
        }
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.aB.setEvaluatable(tableFilter, bl);
        if (this.aE != null) {
            this.aE.setEvaluatable(tableFilter, bl);
        }
    }

    public void updateAggregate(Session session) {
        this.aB.updateAggregate(session);
        if (this.aE != null) {
            this.aE.updateAggregate(session);
        }
    }

    public void addFilterConditions(TableFilter tableFilter, boolean bl) {
        if (this.aC == 6 && bl) {
            return;
        }
        super.addFilterConditions(tableFilter, bl);
    }

    public void mapColumns(ColumnResolver columnResolver, int n2) {
        this.aB.mapColumns(columnResolver, n2);
        if (this.aE != null) {
            this.aE.mapColumns(columnResolver, n2);
        }
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.aB.isEverything(expressionVisitor) && (this.aE == null || this.aE.isEverything(expressionVisitor));
    }

    public int getCost() {
        return this.aB.getCost() + (this.aE == null ? 0 : this.aE.getCost()) + 1;
    }

    Expression getIfEquals(Expression expression) {
        if (this.aC == 0) {
            String string = expression.getSQL();
            if (this.aB.getSQL().equals(string)) {
                return this.aE;
            }
            if (this.aE.getSQL().equals(string)) {
                return this.aB;
            }
        }
        return null;
    }

    Expression getAdditional(Session session, Comparison comparison, boolean bl) {
        if (this.aC == comparison.aC && this.aC == 0) {
            boolean bl2 = this.aB.isConstant();
            boolean bl3 = this.aE.isConstant();
            boolean bl4 = comparison.aB.isConstant();
            boolean bl5 = comparison.aE.isConstant();
            String string = this.aB.getSQL();
            String string2 = comparison.aB.getSQL();
            String string3 = this.aE.getSQL();
            String string4 = comparison.aE.getSQL();
            if (bl) {
                if (!(bl3 && bl5 || !string.equals(string2))) {
                    return new Comparison(session, 0, this.aE, comparison.aE);
                }
                if (!(bl3 && bl4 || !string.equals(string4))) {
                    return new Comparison(session, 0, this.aE, comparison.aB);
                }
                if (!(bl2 && bl5 || !string3.equals(string2))) {
                    return new Comparison(session, 0, this.aB, comparison.aE);
                }
                if (!(bl2 && bl4 || !string3.equals(string4))) {
                    return new Comparison(session, 0, this.aB, comparison.aB);
                }
            } else {
                Database database = session.getDatabase();
                if (bl3 && bl5 && string.equals(string2)) {
                    return new ConditionIn(database, this.aB, New.arrayList(Arrays.asList(this.aE, comparison.aE)));
                }
                if (bl3 && bl4 && string.equals(string4)) {
                    return new ConditionIn(database, this.aB, New.arrayList(Arrays.asList(this.aE, comparison.aB)));
                }
                if (bl2 && bl5 && string3.equals(string2)) {
                    return new ConditionIn(database, this.aE, New.arrayList(Arrays.asList(this.aB, comparison.aE)));
                }
                if (bl2 && bl4 && string3.equals(string4)) {
                    return new ConditionIn(database, this.aE, New.arrayList(Arrays.asList(this.aB, comparison.aB)));
                }
            }
        }
        return null;
    }

    public Expression getExpression(boolean bl) {
        return bl ? this.aB : this.aE;
    }
}

