/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.Condition;
import org.h2.expression.ConditionIn;
import org.h2.expression.ConditionNot;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class ConditionAndOr
extends Condition {
    public static final int AND = 0;
    public static final int OR = 1;
    private final int ay;
    private Expression aA;
    private Expression az;

    public ConditionAndOr(int n2, Expression expression, Expression expression2) {
        this.ay = n2;
        this.aA = expression;
        this.az = expression2;
        if (SysProperties.CHECK && (expression == null || expression2 == null)) {
            DbException.throwInternalError();
        }
    }

    public String getSQL() {
        String string;
        switch (this.ay) {
            case 0: {
                string = this.aA.getSQL() + " AND " + this.az.getSQL();
                break;
            }
            case 1: {
                string = this.aA.getSQL() + " OR " + this.az.getSQL();
                break;
            }
            default: {
                throw DbException.throwInternalError("andOrType=" + this.ay);
            }
        }
        return "(" + string + ")";
    }

    public void createIndexConditions(Session session, TableFilter tableFilter) {
        if (this.ay == 0) {
            this.aA.createIndexConditions(session, tableFilter);
            this.az.createIndexConditions(session, tableFilter);
        }
    }

    public Expression getNotIfPossible(Session session) {
        Expression expression;
        Expression expression2 = this.aA.getNotIfPossible(session);
        if (expression2 == null) {
            expression2 = new ConditionNot(this.aA);
        }
        if ((expression = this.az.getNotIfPossible(session)) == null) {
            expression = new ConditionNot(this.az);
        }
        int n2 = this.ay == 0 ? 1 : 0;
        return new ConditionAndOr(n2, expression2, expression);
    }

    public Value getValue(Session session) {
        Value value = this.aA.getValue(session);
        switch (this.ay) {
            case 0: {
                if (Boolean.FALSE.equals(value.getBoolean())) {
                    return value;
                }
                Value value2 = this.az.getValue(session);
                if (Boolean.FALSE.equals(value2.getBoolean())) {
                    return value2;
                }
                if (value == ValueNull.INSTANCE) {
                    return value;
                }
                if (value2 == ValueNull.INSTANCE) {
                    return value2;
                }
                return ValueBoolean.get(true);
            }
            case 1: {
                if (Boolean.TRUE.equals(value.getBoolean())) {
                    return value;
                }
                Value value3 = this.az.getValue(session);
                if (Boolean.TRUE.equals(value3.getBoolean())) {
                    return value3;
                }
                if (value == ValueNull.INSTANCE) {
                    return value;
                }
                if (value3 == ValueNull.INSTANCE) {
                    return value3;
                }
                return ValueBoolean.get(false);
            }
        }
        throw DbException.throwInternalError("type=" + this.ay);
    }

    public Expression optimize(Session session) {
        Object object;
        Expression expression;
        Expression expression2;
        this.aA = this.aA.optimize(session);
        this.az = this.az.optimize(session);
        int n2 = this.aA.getCost();
        int n3 = this.az.getCost();
        if (n3 < n2) {
            expression2 = this.aA;
            this.aA = this.az;
            this.az = expression2;
        }
        if (session.getDatabase().getSettings().optimizeTwoEquals && this.ay == 0 && this.aA instanceof Comparison && this.az instanceof Comparison && (expression = ((Comparison)(expression2 = (Comparison)this.aA)).getAdditional(session, (Comparison)(object = (Comparison)this.az), true)) != null) {
            expression = expression.optimize(session);
            ConditionAndOr conditionAndOr = new ConditionAndOr(0, this, expression);
            return conditionAndOr;
        }
        if (this.ay == 1 && session.getDatabase().getSettings().optimizeOr) {
            if (this.aA instanceof Comparison && this.az instanceof Comparison) {
                expression2 = (Comparison)this.aA;
                object = (Comparison)this.az;
                expression = ((Comparison)expression2).getAdditional(session, (Comparison)object, false);
                if (expression != null) {
                    return expression.optimize(session);
                }
            } else if (this.aA instanceof ConditionIn && this.az instanceof Comparison ? (expression2 = ((ConditionIn)this.aA).getAdditional(session, (Comparison)this.az)) != null : this.az instanceof ConditionIn && this.aA instanceof Comparison && (expression2 = ((ConditionIn)this.az).getAdditional(session, (Comparison)this.aA)) != null) {
                return expression2.optimize(session);
            }
        }
        expression2 = this.aA.isConstant() ? this.aA.getValue(session) : null;
        Object object2 = object = this.az.isConstant() ? this.az.getValue(session) : null;
        if (expression2 == null && object == null) {
            return this;
        }
        if (expression2 != null && object != null) {
            return ValueExpression.get(this.getValue(session));
        }
        switch (this.ay) {
            case 0: {
                if (expression2 != null) {
                    if (Boolean.FALSE.equals(((Value)((Object)expression2)).getBoolean())) {
                        return ValueExpression.get((Value)((Object)expression2));
                    }
                    if (!Boolean.TRUE.equals(((Value)((Object)expression2)).getBoolean())) break;
                    return this.az;
                }
                if (object == null) break;
                if (Boolean.FALSE.equals(((Value)object).getBoolean())) {
                    return ValueExpression.get((Value)object);
                }
                if (!Boolean.TRUE.equals(((Value)object).getBoolean())) break;
                return this.aA;
            }
            case 1: {
                if (expression2 != null) {
                    if (Boolean.TRUE.equals(((Value)((Object)expression2)).getBoolean())) {
                        return ValueExpression.get((Value)((Object)expression2));
                    }
                    if (!Boolean.FALSE.equals(((Value)((Object)expression2)).getBoolean())) break;
                    return this.az;
                }
                if (object == null) break;
                if (Boolean.TRUE.equals(((Value)object).getBoolean())) {
                    return ValueExpression.get((Value)object);
                }
                if (!Boolean.FALSE.equals(((Value)object).getBoolean())) break;
                return this.aA;
            }
            default: {
                DbException.throwInternalError("type=" + this.ay);
            }
        }
        return this;
    }

    public void addFilterConditions(TableFilter tableFilter, boolean bl) {
        if (this.ay == 0) {
            this.aA.addFilterConditions(tableFilter, bl);
            this.az.addFilterConditions(tableFilter, bl);
        } else {
            super.addFilterConditions(tableFilter, bl);
        }
    }

    public void mapColumns(ColumnResolver columnResolver, int n2) {
        this.aA.mapColumns(columnResolver, n2);
        this.az.mapColumns(columnResolver, n2);
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.aA.setEvaluatable(tableFilter, bl);
        this.az.setEvaluatable(tableFilter, bl);
    }

    public void updateAggregate(Session session) {
        this.aA.updateAggregate(session);
        this.az.updateAggregate(session);
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.aA.isEverything(expressionVisitor) && this.az.isEverything(expressionVisitor);
    }

    public int getCost() {
        return this.aA.getCost() + this.az.getCost();
    }

    public Expression getExpression(boolean bl) {
        return bl ? this.aA : this.az;
    }
}

