/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.ArrayList;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.Condition;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.index.IndexCondition;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.StatementBuilder;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class ConditionIn
extends Condition {
    private final Database ae;
    private Expression af;
    private final ArrayList ac;
    private int ad;

    public ConditionIn(Database database, Expression expression, ArrayList arrayList) {
        this.ae = database;
        this.af = expression;
        this.ac = arrayList;
    }

    public Value getValue(Session session) {
        Value value = this.af.getValue(session);
        if (value == ValueNull.INSTANCE) {
            return value;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Expression expression : this.ac) {
            Value value2 = expression.getValue(session);
            if (value2 == ValueNull.INSTANCE) {
                bl2 = true;
                continue;
            }
            bl = Comparison.compareNotNull(this.ae, value, value2 = value2.convertTo(value.getType()), 0);
            if (!bl) continue;
            break;
        }
        if (!bl && bl2) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(bl);
    }

    public void mapColumns(ColumnResolver columnResolver, int n2) {
        this.af.mapColumns(columnResolver, n2);
        for (Expression expression : this.ac) {
            expression.mapColumns(columnResolver, n2);
        }
        this.ad = Math.max(n2, this.ad);
    }

    public Expression optimize(Session session) {
        Expression expression;
        this.af = this.af.optimize(session);
        boolean bl = this.af.isConstant();
        if (bl && this.af == ValueExpression.getNull()) {
            return this.af;
        }
        boolean bl2 = true;
        int n2 = this.ac.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            expression = (Expression)this.ac.get(i2);
            expression = expression.optimize(session);
            if (bl2 && !expression.isConstant()) {
                bl2 = false;
            }
            this.ac.set(i2, expression);
        }
        if (bl && bl2) {
            return ValueExpression.get(this.getValue(session));
        }
        if (n2 == 1) {
            Expression expression2 = (Expression)this.ac.get(0);
            expression = new Comparison(session, 0, this.af, expression2);
            expression = expression.optimize(session);
            return expression;
        }
        return this;
    }

    public void createIndexConditions(Session session, TableFilter tableFilter) {
        if (!(this.af instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn expressionColumn = (ExpressionColumn)this.af;
        if (tableFilter != expressionColumn.getTableFilter()) {
            return;
        }
        if (session.getDatabase().getSettings().optimizeInList) {
            ExpressionVisitor expressionVisitor = ExpressionVisitor.getNotFromResolverVisitor(tableFilter);
            for (Expression expression : this.ac) {
                if (expression.isEverything(expressionVisitor)) continue;
                return;
            }
            tableFilter.addIndexCondition(IndexCondition.getInList(expressionColumn, this.ac));
            return;
        }
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.af.setEvaluatable(tableFilter, bl);
        for (Expression expression : this.ac) {
            expression.setEvaluatable(tableFilter, bl);
        }
    }

    public String getSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("(");
        statementBuilder.append(this.af.getSQL()).append(" IN(");
        for (Expression expression : this.ac) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(expression.getSQL());
        }
        return statementBuilder.append("))").toString();
    }

    public void updateAggregate(Session session) {
        this.af.updateAggregate(session);
        for (Expression expression : this.ac) {
            expression.updateAggregate(session);
        }
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        if (!this.af.isEverything(expressionVisitor)) {
            return false;
        }
        return this.a(expressionVisitor);
    }

    private boolean a(ExpressionVisitor expressionVisitor) {
        for (Expression expression : this.ac) {
            if (expression.isEverything(expressionVisitor)) continue;
            return false;
        }
        return true;
    }

    public int getCost() {
        int n2 = this.af.getCost();
        for (Expression expression : this.ac) {
            n2 += expression.getCost();
        }
        return n2;
    }

    public Expression getAdditional(Session session, Comparison comparison) {
        Expression expression = comparison.getIfEquals(this.af);
        if (expression != null) {
            this.ac.add(expression);
            return this;
        }
        return null;
    }
}

