/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.command.dml.Query;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.Condition;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.index.IndexCondition;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class ConditionInSelect
extends Condition {
    private Database aJ;
    private Expression aK;
    private Query aI;
    private boolean aF;
    private int aH;
    private int aG;

    public ConditionInSelect(Database database, Expression expression, Query query, boolean bl, int n2) {
        this.aJ = database;
        this.aK = expression;
        this.aI = query;
        this.aF = bl;
        this.aH = n2;
    }

    public Value getValue(Session session) {
        this.aI.setSession(session);
        ResultInterface resultInterface = this.aI.query(0);
        session.addTemporaryResult(resultInterface);
        boolean bl = false;
        boolean bl2 = this.aF;
        Value value = this.aK.getValue(session);
        boolean bl3 = false;
        while (resultInterface.next()) {
            boolean bl4;
            Value value2;
            if (!bl3) {
                if (value == ValueNull.INSTANCE) {
                    return value;
                }
                bl3 = true;
            }
            if ((value2 = resultInterface.currentRow()[0]) == ValueNull.INSTANCE) {
                bl4 = false;
                bl = true;
            } else {
                bl4 = Comparison.compareNotNull(this.aJ, value, value2, this.aH);
            }
            if (!bl4 && this.aF) {
                bl2 = false;
                break;
            }
            if (!bl4 || this.aF) continue;
            bl2 = true;
            break;
        }
        if (!bl3) {
            return ValueBoolean.get(false);
        }
        if (!bl2 && bl) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(bl2);
    }

    public void mapColumns(ColumnResolver columnResolver, int n2) {
        this.aK.mapColumns(columnResolver, n2);
        this.aI.mapColumns(columnResolver, n2 + 1);
        this.aG = Math.max(n2, this.aG);
    }

    public Expression optimize(Session session) {
        this.aK = this.aK.optimize(session);
        this.aI.setDistinct(true);
        this.aI.prepare();
        if (this.aI.getColumnCount() != 1) {
            throw DbException.get(90052);
        }
        return this;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.aK.setEvaluatable(tableFilter, bl);
        this.aI.setEvaluatable(tableFilter, bl);
    }

    public String getSQL() {
        return "(" + this.aK.getSQL() + " IN(" + this.aI.getPlanSQL() + "))";
    }

    public void updateAggregate(Session session) {
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.aK.isEverything(expressionVisitor) && this.aI.isEverything(expressionVisitor);
    }

    public int getCost() {
        return this.aK.getCost() + 10 + (int)(10.0 * this.aI.getCost());
    }

    public void createIndexConditions(Session session, TableFilter tableFilter) {
        if (!session.getDatabase().getSettings().optimizeInList) {
            return;
        }
        if (!(this.aK instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn expressionColumn = (ExpressionColumn)this.aK;
        if (tableFilter != expressionColumn.getTableFilter()) {
            return;
        }
        ExpressionVisitor expressionVisitor = ExpressionVisitor.getNotFromResolverVisitor(tableFilter);
        if (!this.aI.isEverything(expressionVisitor)) {
            return;
        }
        tableFilter.addIndexCondition(IndexCondition.getInQuery(expressionColumn, this.aI));
    }
}

