/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.Session;
import org.h2.expression.Condition;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class ConditionNot
extends Condition {
    private Expression aL;

    public ConditionNot(Expression expression) {
        this.aL = expression;
    }

    public Expression getNotIfPossible(Session session) {
        return this.aL;
    }

    public Value getValue(Session session) {
        Value value = this.aL.getValue(session);
        if (value == ValueNull.INSTANCE) {
            return value;
        }
        return value.convertTo(1).negate();
    }

    public void mapColumns(ColumnResolver columnResolver, int n2) {
        this.aL.mapColumns(columnResolver, n2);
    }

    public Expression optimize(Session session) {
        Expression expression = this.aL.getNotIfPossible(session);
        if (expression != null) {
            return expression.optimize(session);
        }
        Expression expression2 = this.aL.optimize(session);
        if (expression2.isConstant()) {
            Value value = expression2.getValue(session);
            if (value == ValueNull.INSTANCE) {
                return ValueExpression.getNull();
            }
            return ValueExpression.get(value.convertTo(1).negate());
        }
        this.aL = expression2;
        return this;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.aL.setEvaluatable(tableFilter, bl);
    }

    public String getSQL() {
        return "(NOT " + this.aL.getSQL() + ")";
    }

    public void updateAggregate(Session session) {
        this.aL.updateAggregate(session);
    }

    public void addFilterConditions(TableFilter tableFilter, boolean bl) {
        if (bl) {
            return;
        }
        super.addFilterConditions(tableFilter, bl);
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.aL.isEverything(expressionVisitor);
    }

    public int getCost() {
        return this.aL.getCost();
    }
}

