/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.HashMap;
import org.h2.command.Parser;
import org.h2.command.dml.Select;
import org.h2.command.dml.SelectListColumnResolver;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.index.IndexCondition;
import org.h2.message.DbException;
import org.h2.schema.Constant;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ExpressionColumn
extends Expression {
    private Database byte;
    private String else;
    private String char;
    private String for;
    private ColumnResolver case;
    private int try;
    private Column int;
    private boolean new;

    public ExpressionColumn(Database database, Column column) {
        this.byte = database;
        this.int = column;
    }

    public ExpressionColumn(Database database, String string, String string2, String string3) {
        this.byte = database;
        this.else = string;
        this.char = string2;
        this.for = string3;
    }

    public String getSQL() {
        String string = this.int != null ? this.int.getSQL() : Parser.quoteIdentifier(this.for);
        if (this.char != null) {
            string = Parser.quoteIdentifier(this.char) + "." + string;
        }
        if (this.else != null) {
            string = Parser.quoteIdentifier(this.else) + "." + string;
        }
        return string;
    }

    public TableFilter getTableFilter() {
        return this.case == null ? null : this.case.getTableFilter();
    }

    public void mapColumns(ColumnResolver columnResolver, int n2) {
        if (this.char != null && !this.char.equals(columnResolver.getTableAlias())) {
            return;
        }
        if (this.else != null && !this.else.equals(columnResolver.getSchemaName())) {
            return;
        }
        for (Column column : columnResolver.getColumns()) {
            if (!this.for.equals(column.getName())) continue;
            this.a(columnResolver, column, n2);
            return;
        }
        Column[] columnArray = columnResolver.getSystemColumns();
        for (int i2 = 0; columnArray != null && i2 < columnArray.length; ++i2) {
            Column column = columnArray[i2];
            if (!this.for.equals(column.getName())) continue;
            this.a(columnResolver, column, n2);
            return;
        }
    }

    private void a(ColumnResolver columnResolver, Column column, int n2) {
        if (this.case == null) {
            this.try = n2;
            this.int = column;
            this.case = columnResolver;
        } else if (this.try == n2 && this.case != columnResolver && !(columnResolver instanceof SelectListColumnResolver)) {
            throw DbException.get(90059, this.for);
        }
    }

    public Expression optimize(Session session) {
        if (this.case == null) {
            Object object;
            Schema schema = session.getDatabase().findSchema(this.char == null ? session.getCurrentSchemaName() : this.char);
            if (schema != null && (object = schema.findConstant(this.for)) != null) {
                return ((Constant)object).getValue();
            }
            object = this.for;
            if (this.char != null) {
                object = this.char + "." + (String)object;
                if (this.else != null) {
                    object = this.else + "." + (String)object;
                }
            }
            throw DbException.get(42122, (String)object);
        }
        return this.case.optimize(this, this.int);
    }

    public void updateAggregate(Session session) {
        Value value = this.case.getValue(this.int);
        Select select = this.case.getSelect();
        if (select == null) {
            throw DbException.get(90016, this.getSQL());
        }
        HashMap hashMap = select.getCurrentGroup();
        if (hashMap == null) {
            return;
        }
        Value value2 = (Value)hashMap.get(this);
        if (value2 == null) {
            hashMap.put(this, value);
        } else if (!this.byte.areEqual(value, value2)) {
            throw DbException.get(90016, this.getSQL());
        }
    }

    public Value getValue(Session session) {
        Value value;
        Object object;
        Select select = this.case.getSelect();
        if (select != null && (object = select.getCurrentGroup()) != null && (value = (Value)((HashMap)object).get(this)) != null) {
            return value;
        }
        object = this.case.getValue(this.int);
        if (object == null) {
            this.case.getValue(this.int);
            throw DbException.get(90016, this.getSQL());
        }
        return object;
    }

    public int getType() {
        return this.int.getType();
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        if (this.case != null && tableFilter == this.case.getTableFilter()) {
            this.new = bl;
        }
    }

    public Column getColumn() {
        return this.int;
    }

    public int getScale() {
        return this.int.getScale();
    }

    public long getPrecision() {
        return this.int.getPrecision();
    }

    public int getDisplaySize() {
        return this.int.getDisplaySize();
    }

    public String getOriginalColumnName() {
        return this.for;
    }

    public String getOriginalTableAliasName() {
        return this.char;
    }

    public String getColumnName() {
        return this.for != null ? this.for : this.int.getName();
    }

    public String getSchemaName() {
        Table table = this.int.getTable();
        return table == null ? null : table.getSchema().getName();
    }

    public String getTableName() {
        Table table = this.int.getTable();
        return table == null ? null : table.getName();
    }

    public String getAlias() {
        return this.int == null ? null : this.int.getName();
    }

    public boolean isAutoIncrement() {
        return this.int.getSequence() != null;
    }

    public int getNullable() {
        return this.int.isNullable() ? 1 : 0;
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 1: {
                return false;
            }
            case 2: 
            case 5: 
            case 8: {
                return true;
            }
            case 0: {
                return this.try < expressionVisitor.getQueryLevel();
            }
            case 3: {
                if (this.byte.getSettings().nestedJoins) {
                    if (expressionVisitor.getQueryLevel() < this.try) {
                        return true;
                    }
                    if (this.getTableFilter() == null) {
                        return false;
                    }
                    return this.getTableFilter().isEvaluatable();
                }
                return this.new || expressionVisitor.getQueryLevel() < this.try;
            }
            case 4: {
                expressionVisitor.addDataModificationId(this.int.getTable().getMaxDataModificationId());
                return true;
            }
            case 6: {
                return this.case != expressionVisitor.getResolver();
            }
            case 7: {
                expressionVisitor.addDependency(this.int.getTable());
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    public int getCost() {
        return 2;
    }

    public void createIndexConditions(Session session, TableFilter tableFilter) {
        TableFilter tableFilter2 = this.getTableFilter();
        if (tableFilter == tableFilter2 && this.int.getType() == 1) {
            IndexCondition indexCondition = IndexCondition.get(0, this, ValueExpression.get(ValueBoolean.get(true)));
            tableFilter.addIndexCondition(indexCondition);
        }
    }

    public Expression getNotIfPossible(Session session) {
        return new Comparison(session, 0, this, ValueExpression.get(ValueBoolean.get(false)));
    }
}

