/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.StatementBuilder;
import org.h2.value.Value;
import org.h2.value.ValueArray;

public class ExpressionList
extends Expression {
    private Expression[] ab;

    public ExpressionList(Expression[] expressionArray) {
        this.ab = expressionArray;
    }

    public Value getValue(Session session) {
        Value[] valueArray = new Value[this.ab.length];
        for (int i2 = 0; i2 < this.ab.length; ++i2) {
            valueArray[i2] = this.ab[i2].getValue(session);
        }
        return ValueArray.get(valueArray);
    }

    public int getType() {
        return 17;
    }

    public void mapColumns(ColumnResolver columnResolver, int n2) {
        for (Expression expression : this.ab) {
            expression.mapColumns(columnResolver, n2);
        }
    }

    public Expression optimize(Session session) {
        boolean bl = true;
        for (int i2 = 0; i2 < this.ab.length; ++i2) {
            Expression expression = this.ab[i2].optimize(session);
            if (!expression.isConstant()) {
                bl = false;
            }
            this.ab[i2] = expression;
        }
        if (bl) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        for (Expression expression : this.ab) {
            expression.setEvaluatable(tableFilter, bl);
        }
    }

    public int getScale() {
        return 0;
    }

    public long getPrecision() {
        return Integer.MAX_VALUE;
    }

    public int getDisplaySize() {
        return Integer.MAX_VALUE;
    }

    public String getSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("(");
        for (Expression expression : this.ab) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(expression.getSQL());
        }
        return statementBuilder.append(')').toString();
    }

    public void updateAggregate(Session session) {
        for (Expression expression : this.ab) {
            expression.updateAggregate(session);
        }
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        for (Expression expression : this.ab) {
            if (expression.isEverything(expressionVisitor)) continue;
            return false;
        }
        return true;
    }

    public int getCost() {
        int n2 = 1;
        for (Expression expression : this.ab) {
            n2 += expression.getCost();
        }
        return n2;
    }

    public Expression[] getExpressionColumns(Session session) {
        Expression[] expressionArray = new ExpressionColumn[this.ab.length];
        for (int i2 = 0; i2 < this.ab.length; ++i2) {
            Expression expression = this.ab[i2];
            Column column = new Column("C" + (i2 + 1), expression.getType(), expression.getPrecision(), expression.getScale(), expression.getDisplaySize());
            expressionArray[i2] = new ExpressionColumn(session.getDatabase(), column);
        }
        return expressionArray;
    }
}

