/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.PatternSyntaxException;
import org.h2.command.Command;
import org.h2.command.Parser;
import org.h2.engine.Database;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.FunctionCall;
import org.h2.expression.FunctionInfo;
import org.h2.expression.SequenceValue;
import org.h2.expression.TableFunction;
import org.h2.expression.ValueExpression;
import org.h2.expression.Variable;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.schema.Sequence;
import org.h2.security.BlockCipher;
import org.h2.security.CipherFactory;
import org.h2.security.SHA256;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.LinkSchema;
import org.h2.table.TableFilter;
import org.h2.tools.CompressTool;
import org.h2.tools.Csv;
import org.h2.util.AutoCloseInputStream;
import org.h2.util.DateTimeUtils;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDouble;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Function
extends Expression
implements FunctionCall {
    public static final int ABS = 0;
    public static final int ACOS = 1;
    public static final int ASIN = 2;
    public static final int ATAN = 3;
    public static final int ATAN2 = 4;
    public static final int BITAND = 5;
    public static final int BITOR = 6;
    public static final int BITXOR = 7;
    public static final int CEILING = 8;
    public static final int COS = 9;
    public static final int COT = 10;
    public static final int DEGREES = 11;
    public static final int EXP = 12;
    public static final int FLOOR = 13;
    public static final int LOG = 14;
    public static final int LOG10 = 15;
    public static final int MOD = 16;
    public static final int PI = 17;
    public static final int POWER = 18;
    public static final int RADIANS = 19;
    public static final int RAND = 20;
    public static final int ROUND = 21;
    public static final int ROUNDMAGIC = 22;
    public static final int SIGN = 23;
    public static final int SIN = 24;
    public static final int SQRT = 25;
    public static final int TAN = 26;
    public static final int TRUNCATE = 27;
    public static final int SECURE_RAND = 28;
    public static final int HASH = 29;
    public static final int ENCRYPT = 30;
    public static final int DECRYPT = 31;
    public static final int COMPRESS = 32;
    public static final int EXPAND = 33;
    public static final int ZERO = 34;
    public static final int RANDOM_UUID = 35;
    public static final int ASCII = 50;
    public static final int BIT_LENGTH = 51;
    public static final int CHAR = 52;
    public static final int CHAR_LENGTH = 53;
    public static final int CONCAT = 54;
    public static final int DIFFERENCE = 55;
    public static final int HEXTORAW = 56;
    public static final int INSERT = 57;
    public static final int INSTR = 58;
    public static final int LCASE = 59;
    public static final int LEFT = 60;
    public static final int LENGTH = 61;
    public static final int LOCATE = 62;
    public static final int LTRIM = 63;
    public static final int OCTET_LENGTH = 64;
    public static final int RAWTOHEX = 65;
    public static final int REPEAT = 66;
    public static final int REPLACE = 67;
    public static final int RIGHT = 68;
    public static final int RTRIM = 69;
    public static final int SOUNDEX = 70;
    public static final int SPACE = 71;
    public static final int SUBSTR = 72;
    public static final int SUBSTRING = 73;
    public static final int UCASE = 74;
    public static final int LOWER = 75;
    public static final int UPPER = 76;
    public static final int POSITION = 77;
    public static final int TRIM = 78;
    public static final int STRINGENCODE = 79;
    public static final int STRINGDECODE = 80;
    public static final int STRINGTOUTF8 = 81;
    public static final int UTF8TOSTRING = 82;
    public static final int XMLATTR = 83;
    public static final int XMLNODE = 84;
    public static final int XMLCOMMENT = 85;
    public static final int XMLCDATA = 86;
    public static final int XMLSTARTDOC = 87;
    public static final int XMLTEXT = 88;
    public static final int REGEXP_REPLACE = 89;
    public static final int RPAD = 90;
    public static final int LPAD = 91;
    public static final int CURDATE = 100;
    public static final int CURTIME = 101;
    public static final int DATE_ADD = 102;
    public static final int DATE_DIFF = 103;
    public static final int DAY_NAME = 104;
    public static final int DAY_OF_MONTH = 105;
    public static final int DAY_OF_WEEK = 106;
    public static final int DAY_OF_YEAR = 107;
    public static final int HOUR = 108;
    public static final int MINUTE = 109;
    public static final int MONTH = 110;
    public static final int MONTH_NAME = 111;
    public static final int NOW = 112;
    public static final int QUARTER = 113;
    public static final int SECOND = 114;
    public static final int WEEK = 115;
    public static final int YEAR = 116;
    public static final int CURRENT_DATE = 117;
    public static final int CURRENT_TIME = 118;
    public static final int CURRENT_TIMESTAMP = 119;
    public static final int EXTRACT = 120;
    public static final int FORMATDATETIME = 121;
    public static final int PARSEDATETIME = 122;
    public static final int ISO_YEAR = 123;
    public static final int ISO_WEEK = 124;
    public static final int ISO_DAY_OF_WEEK = 125;
    public static final int DATABASE = 150;
    public static final int USER = 151;
    public static final int CURRENT_USER = 152;
    public static final int IDENTITY = 153;
    public static final int SCOPE_IDENTITY = 154;
    public static final int AUTOCOMMIT = 155;
    public static final int READONLY = 156;
    public static final int DATABASE_PATH = 157;
    public static final int LOCK_TIMEOUT = 158;
    public static final int IFNULL = 200;
    public static final int CASEWHEN = 201;
    public static final int CONVERT = 202;
    public static final int CAST = 203;
    public static final int COALESCE = 204;
    public static final int NULLIF = 205;
    public static final int CASE = 206;
    public static final int NEXTVAL = 207;
    public static final int CURRVAL = 208;
    public static final int ARRAY_GET = 209;
    public static final int CSVREAD = 210;
    public static final int CSVWRITE = 211;
    public static final int MEMORY_FREE = 212;
    public static final int MEMORY_USED = 213;
    public static final int LOCK_MODE = 214;
    public static final int SCHEMA = 215;
    public static final int SESSION_ID = 216;
    public static final int ARRAY_LENGTH = 217;
    public static final int LINK_SCHEMA = 218;
    public static final int GREATEST = 219;
    public static final int LEAST = 220;
    public static final int CANCEL_SESSION = 221;
    public static final int SET = 222;
    public static final int TABLE = 223;
    public static final int TABLE_DISTINCT = 224;
    public static final int FILE_READ = 225;
    public static final int TRANSACTION_ID = 226;
    private static final int j = -1;
    private static final long m = -1L;
    private static final HashMap p = New.hashMap();
    private static final HashMap l = New.hashMap();
    private static final char[] o = new char[128];
    protected Expression[] args;
    private FunctionInfo n;
    private ArrayList q;
    private int t;
    private int s;
    private long r = -1L;
    private int k;
    private Database u;

    protected Function(Database database, FunctionInfo functionInfo) {
        this.u = database;
        this.n = functionInfo;
        if (functionInfo.parameterCount == -1) {
            this.q = New.arrayList();
        } else {
            this.args = new Expression[functionInfo.parameterCount];
        }
    }

    private static void a(String string, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        FunctionInfo functionInfo = new FunctionInfo();
        functionInfo.name = string;
        functionInfo.type = n2;
        functionInfo.parameterCount = n3;
        functionInfo.dataType = n4;
        functionInfo.nullIfParameterIsNull = bl;
        functionInfo.deterministic = bl2;
        functionInfo.fast = bl3;
        p.put(string, functionInfo);
    }

    private static void do(String string, int n2, int n3, int n4) {
        Function.a(string, n2, n3, n4, true, false, false);
    }

    private static void a(String string, int n2, int n3, int n4) {
        Function.a(string, n2, n3, n4, true, true, false);
    }

    private static void if(String string, int n2, int n3, int n4) {
        Function.a(string, n2, n3, n4, false, true, false);
    }

    public static FunctionInfo getFunctionInfo(String string) {
        return (FunctionInfo)p.get(string);
    }

    public static Function getFunction(Database database, String string) {
        FunctionInfo functionInfo = Function.getFunctionInfo(string);
        if (functionInfo == null) {
            return null;
        }
        switch (functionInfo.type) {
            case 223: 
            case 224: {
                return new TableFunction(database, functionInfo, Long.MAX_VALUE);
            }
        }
        return new Function(database, functionInfo);
    }

    public void setParameter(int n2, Expression expression) {
        if (this.q != null) {
            this.q.add(expression);
        } else {
            if (n2 >= this.args.length) {
                throw DbException.get(7001, this.n.name, "" + this.args.length);
            }
            this.args[n2] = expression;
        }
    }

    private strictfp double a(double d2) {
        return this.if(StrictMath.log(d2) / StrictMath.log(10.0));
    }

    public Value getValue(Session session) {
        return this.a(session, this.args);
    }

    private Value a(Session session, Expression[] expressionArray, int n2) {
        Expression expression;
        if (n2 < expressionArray.length && (expression = expressionArray[n2]) != null) {
            return expression.getValue(session);
        }
        return null;
    }

    private Value a(Session session, Value value, Expression[] expressionArray) {
        Value value2;
        block0 : switch (this.n.type) {
            case 0: {
                value2 = value.getSignum() > 0 ? value : value.negate();
                break;
            }
            case 1: {
                value2 = ValueDouble.get(Math.acos(value.getDouble()));
                break;
            }
            case 2: {
                value2 = ValueDouble.get(Math.asin(value.getDouble()));
                break;
            }
            case 3: {
                value2 = ValueDouble.get(Math.atan(value.getDouble()));
                break;
            }
            case 8: {
                value2 = ValueDouble.get(Math.ceil(value.getDouble()));
                break;
            }
            case 9: {
                value2 = ValueDouble.get(Math.cos(value.getDouble()));
                break;
            }
            case 10: {
                double d2 = Math.tan(value.getDouble());
                if (d2 == 0.0) {
                    throw DbException.get(22012, this.getSQL());
                }
                value2 = ValueDouble.get(1.0 / d2);
                break;
            }
            case 11: {
                value2 = ValueDouble.get(Math.toDegrees(value.getDouble()));
                break;
            }
            case 12: {
                value2 = ValueDouble.get(Math.exp(value.getDouble()));
                break;
            }
            case 13: {
                value2 = ValueDouble.get(Math.floor(value.getDouble()));
                break;
            }
            case 14: {
                value2 = ValueDouble.get(Math.log(value.getDouble()));
                break;
            }
            case 15: {
                value2 = ValueDouble.get(this.a(value.getDouble()));
                break;
            }
            case 17: {
                value2 = ValueDouble.get(Math.PI);
                break;
            }
            case 19: {
                value2 = ValueDouble.get(Math.toRadians(value.getDouble()));
                break;
            }
            case 20: {
                if (value != null) {
                    session.getRandom().setSeed(value.getInt());
                }
                value2 = ValueDouble.get(session.getRandom().nextDouble());
                break;
            }
            case 22: {
                value2 = ValueDouble.get(this.if(value.getDouble()));
                break;
            }
            case 23: {
                value2 = ValueInt.get(value.getSignum());
                break;
            }
            case 24: {
                value2 = ValueDouble.get(Math.sin(value.getDouble()));
                break;
            }
            case 25: {
                value2 = ValueDouble.get(Math.sqrt(value.getDouble()));
                break;
            }
            case 26: {
                value2 = ValueDouble.get(Math.tan(value.getDouble()));
                break;
            }
            case 28: {
                value2 = ValueBytes.getNoCopy(MathUtils.secureRandomBytes(value.getInt()));
                break;
            }
            case 33: {
                value2 = ValueBytes.getNoCopy(CompressTool.getInstance().expand(value.getBytesNoCopy()));
                break;
            }
            case 34: {
                value2 = ValueInt.get(0);
                break;
            }
            case 35: {
                value2 = ValueUuid.getNewRandom();
                break;
            }
            case 50: {
                String string = value.getString();
                if (string.length() == 0) {
                    value2 = ValueNull.INSTANCE;
                    break;
                }
                value2 = ValueInt.get(string.charAt(0));
                break;
            }
            case 51: {
                value2 = ValueLong.get(16L * this.a(value));
                break;
            }
            case 52: {
                value2 = ValueString.get(String.valueOf((char)value.getInt()));
                break;
            }
            case 53: 
            case 61: {
                value2 = ValueLong.get(this.a(value));
                break;
            }
            case 64: {
                value2 = ValueLong.get(2L * this.a(value));
                break;
            }
            case 54: {
                value2 = ValueNull.INSTANCE;
                for (Expression expression : expressionArray) {
                    Value value3 = expression.getValue(session);
                    if (value3 == ValueNull.INSTANCE) continue;
                    value2 = value2 == ValueNull.INSTANCE ? value3 : ValueString.get(((Value)value2).getString().concat(value3.getString()));
                }
                break;
            }
            case 56: {
                value2 = ValueString.get(Function.do(value.getString()));
                break;
            }
            case 59: 
            case 75: {
                value2 = ValueString.get(value.getString().toLowerCase());
                break;
            }
            case 65: {
                value2 = ValueString.get(Function.for(value.getString()));
                break;
            }
            case 70: {
                value2 = ValueString.get(Function.if(value.getString()));
                break;
            }
            case 71: {
                int n2 = Math.max(0, value.getInt());
                char[] cArray = new char[n2];
                for (int i2 = n2 - 1; i2 >= 0; --i2) {
                    cArray[i2] = 32;
                }
                value2 = ValueString.get(new String(cArray));
                break;
            }
            case 74: 
            case 76: {
                value2 = ValueString.get(value.getString().toUpperCase());
                break;
            }
            case 79: {
                value2 = ValueString.get(StringUtils.javaEncode(value.getString()));
                break;
            }
            case 80: {
                value2 = ValueString.get(StringUtils.javaDecode(value.getString()));
                break;
            }
            case 81: {
                value2 = ValueBytes.getNoCopy(StringUtils.utf8Encode(value.getString()));
                break;
            }
            case 82: {
                value2 = ValueString.get(StringUtils.utf8Decode(value.getBytesNoCopy()));
                break;
            }
            case 85: {
                value2 = ValueString.get(StringUtils.xmlComment(value.getString()));
                break;
            }
            case 86: {
                value2 = ValueString.get(StringUtils.xmlCData(value.getString()));
                break;
            }
            case 87: {
                value2 = ValueString.get(StringUtils.xmlStartDoc());
                break;
            }
            case 88: {
                value2 = ValueString.get(StringUtils.xmlText(value.getString()));
                break;
            }
            case 104: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE", Locale.ENGLISH);
                value2 = ValueString.get(simpleDateFormat.format(value.getDateNoCopy()));
                break;
            }
            case 105: {
                value2 = ValueInt.get(DateTimeUtils.getDatePart(value.getDateNoCopy(), 5));
                break;
            }
            case 106: {
                value2 = ValueInt.get(DateTimeUtils.getDatePart(value.getDateNoCopy(), 7));
                break;
            }
            case 107: {
                value2 = ValueInt.get(DateTimeUtils.getDatePart(value.getDateNoCopy(), 6));
                break;
            }
            case 108: {
                value2 = ValueInt.get(DateTimeUtils.getDatePart(value.getTimestampNoCopy(), 11));
                break;
            }
            case 109: {
                value2 = ValueInt.get(DateTimeUtils.getDatePart(value.getTimestampNoCopy(), 12));
                break;
            }
            case 110: {
                value2 = ValueInt.get(DateTimeUtils.getDatePart(value.getDateNoCopy(), 2));
                break;
            }
            case 111: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMM", Locale.ENGLISH);
                value2 = ValueString.get(simpleDateFormat.format(value.getDateNoCopy()));
                break;
            }
            case 113: {
                value2 = ValueInt.get((DateTimeUtils.getDatePart(value.getDateNoCopy(), 2) - 1) / 3 + 1);
                break;
            }
            case 114: {
                value2 = ValueInt.get(DateTimeUtils.getDatePart(value.getTimestampNoCopy(), 13));
                break;
            }
            case 115: {
                value2 = ValueInt.get(DateTimeUtils.getDatePart(value.getDateNoCopy(), 3));
                break;
            }
            case 116: {
                value2 = ValueInt.get(DateTimeUtils.getDatePart(value.getDateNoCopy(), 1));
                break;
            }
            case 123: {
                value2 = ValueInt.get(DateTimeUtils.getIsoYear(value.getDateNoCopy()));
                break;
            }
            case 124: {
                value2 = ValueInt.get(DateTimeUtils.getIsoWeek(value.getDateNoCopy()));
                break;
            }
            case 125: {
                value2 = ValueInt.get(DateTimeUtils.getIsoDayOfWeek(value.getDateNoCopy()));
                break;
            }
            case 100: 
            case 117: {
                value2 = ValueDate.get(new Date(System.currentTimeMillis()));
                break;
            }
            case 101: 
            case 118: {
                value2 = ValueTime.get(new Time(System.currentTimeMillis()));
                break;
            }
            case 112: 
            case 119: {
                ValueTimestamp valueTimestamp = ValueTimestamp.getNoCopy(new Timestamp(System.currentTimeMillis()));
                if (value != null) {
                    Mode mode = this.u.getMode();
                    valueTimestamp = (ValueTimestamp)valueTimestamp.convertScale(mode.convertOnlyToSmallerScale, value.getInt());
                }
                value2 = valueTimestamp;
                break;
            }
            case 150: {
                value2 = ValueString.get(this.u.getShortName());
                break;
            }
            case 151: 
            case 152: {
                value2 = ValueString.get(session.getUser().getName());
                break;
            }
            case 153: {
                value2 = session.getLastIdentity();
                break;
            }
            case 154: {
                value2 = session.getScopeIdentity();
                break;
            }
            case 155: {
                value2 = ValueBoolean.get(session.getAutoCommit());
                break;
            }
            case 156: {
                value2 = ValueBoolean.get(this.u.isReadOnly());
                break;
            }
            case 157: {
                String string = this.u.getDatabasePath();
                value2 = string == null ? ValueNull.INSTANCE : ValueString.get(string);
                break;
            }
            case 158: {
                value2 = ValueInt.get(session.getLockTimeout());
                break;
            }
            case 202: 
            case 203: {
                value = value.convertTo(this.t);
                Mode mode = this.u.getMode();
                value = value.convertScale(mode.convertOnlyToSmallerScale, this.s);
                value = value.convertPrecision(this.getPrecision());
                value2 = value;
                break;
            }
            case 212: {
                session.getUser().checkAdmin();
                value2 = ValueInt.get(Utils.getMemoryFree());
                break;
            }
            case 213: {
                session.getUser().checkAdmin();
                value2 = ValueInt.get(Utils.getMemoryUsed());
                break;
            }
            case 214: {
                value2 = ValueInt.get(this.u.getLockMode());
                break;
            }
            case 215: {
                value2 = ValueString.get(session.getCurrentSchemaName());
                break;
            }
            case 216: {
                value2 = ValueInt.get(session.getId());
                break;
            }
            case 200: {
                value2 = value == ValueNull.INSTANCE ? expressionArray[1].getValue(session) : value;
                break;
            }
            case 201: {
                Expression expression = value == ValueNull.INSTANCE || value.getBoolean() == false ? expressionArray[2] : expressionArray[1];
                Value value4 = expression.getValue(session);
                value2 = value4.convertTo(this.t);
                break;
            }
            case 204: {
                value2 = value;
                for (int i3 = 0; i3 < expressionArray.length; ++i3) {
                    Value value5;
                    Value value6 = value5 = i3 == 0 ? value : expressionArray[i3].getValue(session);
                    if (value5 == ValueNull.INSTANCE) continue;
                    value2 = value5.convertTo(this.t);
                    break block0;
                }
                break;
            }
            case 219: 
            case 220: {
                value2 = ValueNull.INSTANCE;
                for (int i4 = 0; i4 < expressionArray.length; ++i4) {
                    Value value7;
                    Value value8 = value7 = i4 == 0 ? value : expressionArray[i4].getValue(session);
                    if (value7 == ValueNull.INSTANCE) continue;
                    value7 = value7.convertTo(this.t);
                    if (value2 == ValueNull.INSTANCE) {
                        value2 = value7;
                        continue;
                    }
                    int n3 = this.u.compareTypeSave(value2, value7);
                    if (this.n.type == 219 && n3 < 0) {
                        value2 = value7;
                        continue;
                    }
                    if (this.n.type != 220 || n3 <= 0) continue;
                    value2 = value7;
                }
                break;
            }
            case 206: {
                int n4;
                value2 = null;
                for (n4 = 0; n4 < expressionArray.length; ++n4) {
                    Value value9;
                    if (!Boolean.TRUE.equals(value9 = expressionArray[n4++].getValue(session))) continue;
                    value2 = expressionArray[n4].getValue(session);
                    break;
                }
                if (value2 != null) break;
                value2 = n4 < expressionArray.length ? expressionArray[n4].getValue(session) : ValueNull.INSTANCE;
                break;
            }
            case 209: {
                if (value.getType() == 17) {
                    Value value10 = expressionArray[1].getValue(session);
                    int n5 = value10.getInt();
                    Value[] valueArray = ((ValueArray)value).getList();
                    if (n5 < 1 || n5 > valueArray.length) {
                        value2 = ValueNull.INSTANCE;
                        break;
                    }
                    value2 = valueArray[n5 - 1];
                    break;
                }
                value2 = ValueNull.INSTANCE;
                break;
            }
            case 217: {
                if (value.getType() == 17) {
                    Value[] valueArray = ((ValueArray)value).getList();
                    value2 = ValueInt.get(valueArray.length);
                    break;
                }
                value2 = ValueNull.INSTANCE;
                break;
            }
            case 221: {
                value2 = ValueBoolean.get(this.a(session, value.getInt()));
                break;
            }
            case 226: {
                value2 = session.getTransactionId();
                break;
            }
            default: {
                value2 = null;
            }
        }
        return value2;
    }

    private boolean a(Session session, int n2) {
        Session[] sessionArray;
        session.getUser().checkAdmin();
        for (Session session2 : sessionArray = session.getDatabase().getSessions(false)) {
            if (session2.getId() != n2) continue;
            Command command = session2.getCurrentCommand();
            if (command == null) {
                return false;
            }
            command.cancel();
            return true;
        }
        return false;
    }

    private Value a(Session session, Expression[] expressionArray) {
        Value value;
        Value value2;
        Value value3;
        if (this.n.nullIfParameterIsNull) {
            for (int i2 = 0; i2 < expressionArray.length; ++i2) {
                if (this.a(session, expressionArray, i2) != ValueNull.INSTANCE) continue;
                return ValueNull.INSTANCE;
            }
        }
        if ((value3 = this.a(session, value2 = this.a(session, expressionArray, 0), expressionArray)) != null) {
            return value3;
        }
        Value value4 = this.a(session, expressionArray, 1);
        Value value5 = this.a(session, expressionArray, 2);
        Value value6 = this.a(session, expressionArray, 3);
        Value value7 = this.a(session, expressionArray, 4);
        Value value8 = this.a(session, expressionArray, 5);
        switch (this.n.type) {
            case 4: {
                value = ValueDouble.get(Math.atan2(value2.getDouble(), value4.getDouble()));
                break;
            }
            case 5: {
                value = ValueLong.get(value2.getLong() & value4.getLong());
                break;
            }
            case 6: {
                value = ValueLong.get(value2.getLong() | value4.getLong());
                break;
            }
            case 7: {
                value = ValueLong.get(value2.getLong() ^ value4.getLong());
                break;
            }
            case 16: {
                long l2 = value4.getLong();
                if (l2 == 0L) {
                    throw DbException.get(22012, this.getSQL());
                }
                value = ValueLong.get(value2.getLong() % l2);
                break;
            }
            case 18: {
                value = ValueDouble.get(Math.pow(value2.getDouble(), value4.getDouble()));
                break;
            }
            case 21: {
                double d2 = Math.pow(10.0, value4.getDouble());
                value = ValueDouble.get((double)Math.round(value2.getDouble() * d2) / d2);
                break;
            }
            case 27: {
                double d3 = value2.getDouble();
                int n2 = value4.getInt();
                double d4 = Math.pow(10.0, n2);
                double d5 = d3 * d4;
                value = ValueDouble.get((d3 < 0.0 ? Math.ceil(d5) : Math.floor(d5)) / d4);
                break;
            }
            case 29: {
                value = ValueBytes.getNoCopy(this.a(value2.getString(), value4.getBytesNoCopy(), value5.getInt()));
                break;
            }
            case 30: {
                value = ValueBytes.getNoCopy(this.a(value2.getString(), value4.getBytesNoCopy(), value5.getBytesNoCopy()));
                break;
            }
            case 31: {
                value = ValueBytes.getNoCopy(this.if(value2.getString(), value4.getBytesNoCopy(), value5.getBytesNoCopy()));
                break;
            }
            case 32: {
                String string = null;
                if (value4 != null) {
                    string = value4.getString();
                }
                value = ValueBytes.getNoCopy(CompressTool.getInstance().compress(value2.getBytesNoCopy(), string));
                break;
            }
            case 55: {
                value = ValueInt.get(Function.a(value2.getString(), value4.getString()));
                break;
            }
            case 57: {
                if (value4 == ValueNull.INSTANCE || value5 == ValueNull.INSTANCE) {
                    value = value4;
                    break;
                }
                value = ValueString.get(Function.a(value2.getString(), value4.getInt(), value5.getInt(), value6.getString()));
                break;
            }
            case 60: {
                value = ValueString.get(Function.a(value2.getString(), value4.getInt()));
                break;
            }
            case 62: {
                int n3 = value5 == null ? 0 : value5.getInt();
                value = ValueInt.get(Function.a(value2.getString(), value4.getString(), n3));
                break;
            }
            case 58: {
                int n4 = value5 == null ? 0 : value5.getInt();
                value = ValueInt.get(Function.a(value4.getString(), value2.getString(), n4));
                break;
            }
            case 66: {
                int n5 = Math.max(0, value4.getInt());
                value = ValueString.get(Function.if(value2.getString(), n5));
                break;
            }
            case 67: {
                String string = value2.getString();
                String string2 = value4.getString();
                String string3 = value5 == null ? "" : value5.getString();
                value = ValueString.get(Function.a(string, string2, string3));
                break;
            }
            case 68: {
                value = ValueString.get(Function.do(value2.getString(), value4.getInt()));
                break;
            }
            case 63: {
                value = ValueString.get(StringUtils.trim(value2.getString(), true, false, value4 == null ? " " : value4.getString()));
                break;
            }
            case 78: {
                value = ValueString.get(StringUtils.trim(value2.getString(), true, true, value4 == null ? " " : value4.getString()));
                break;
            }
            case 69: {
                value = ValueString.get(StringUtils.trim(value2.getString(), false, true, value4 == null ? " " : value4.getString()));
                break;
            }
            case 72: 
            case 73: {
                String string = value2.getString();
                int n6 = value5 == null ? string.length() : value5.getInt();
                value = ValueString.get(Function.a(string, value4.getInt(), n6));
                break;
            }
            case 77: {
                value = ValueInt.get(Function.a(value2.getString(), value4.getString(), 0));
                break;
            }
            case 83: {
                value = ValueString.get(StringUtils.xmlAttr(value2.getString(), value4.getString()));
                break;
            }
            case 84: {
                String string;
                String string4 = value4 == null ? null : (string = value4 == ValueNull.INSTANCE ? null : value4.getString());
                String string5 = value5 == null ? null : (value5 == ValueNull.INSTANCE ? null : value5.getString());
                value = ValueString.get(StringUtils.xmlNode(value2.getString(), string, string5));
                break;
            }
            case 89: {
                String string = value4.getString();
                try {
                    value = ValueString.get(value2.getString().replaceAll(string, value5.getString()));
                    break;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DbException.get(22025, patternSyntaxException, string);
                }
            }
            case 90: {
                value = ValueString.get(StringUtils.pad(value2.getString(), value4.getInt(), value5 == null ? null : value5.getString(), true));
                break;
            }
            case 91: {
                value = ValueString.get(StringUtils.pad(value2.getString(), value4.getInt(), value5 == null ? null : value5.getString(), false));
                break;
            }
            case 102: {
                value = ValueTimestamp.getNoCopy(Function.a(value2.getString(), value4.getInt(), value5.getTimestampNoCopy()));
                break;
            }
            case 103: {
                value = ValueLong.get(Function.a(value2.getString(), value4.getTimestampNoCopy(), value5.getTimestampNoCopy()));
                break;
            }
            case 120: {
                int n7 = Function.a(value2.getString());
                value = ValueInt.get(DateTimeUtils.getDatePart(value4.getTimestamp(), n7));
                break;
            }
            case 121: {
                String string;
                if (value2 == ValueNull.INSTANCE || value4 == ValueNull.INSTANCE) {
                    value = ValueNull.INSTANCE;
                    break;
                }
                String string6 = value5 == null ? null : (string = value5 == ValueNull.INSTANCE ? null : value5.getString());
                String string7 = value6 == null ? null : (value6 == ValueNull.INSTANCE ? null : value6.getString());
                value = ValueString.get(DateTimeUtils.formatDateTime(value2.getTimestamp(), value4.getString(), string, string7));
                break;
            }
            case 122: {
                String string;
                if (value2 == ValueNull.INSTANCE || value4 == ValueNull.INSTANCE) {
                    value = ValueNull.INSTANCE;
                    break;
                }
                String string8 = value5 == null ? null : (string = value5 == ValueNull.INSTANCE ? null : value5.getString());
                String string9 = value6 == null ? null : (value6 == ValueNull.INSTANCE ? null : value6.getString());
                java.util.Date date = DateTimeUtils.parseDateTime(value2.getString(), value4.getString(), string, string9);
                value = ValueTimestamp.getNoCopy(new Timestamp(date.getTime()));
                break;
            }
            case 205: {
                value = this.u.areEqual(value2, value4) ? ValueNull.INSTANCE : value2;
                break;
            }
            case 207: {
                Sequence sequence = this.a(session, value2, value4);
                SequenceValue sequenceValue = new SequenceValue(sequence);
                value = sequenceValue.getValue(session);
                break;
            }
            case 208: {
                Sequence sequence = this.a(session, value2, value4);
                value = ValueLong.get(sequence.getCurrentValue());
                break;
            }
            case 210: {
                String string = value2.getString();
                String string10 = value4 == null ? null : value4.getString();
                String string11 = value5 == null ? null : value5.getString();
                String string12 = value6 == null ? null : value6.getString();
                String string13 = value7 == null ? null : value7.getString();
                String string14 = value8 == null ? null : value8.getString();
                Value value9 = this.a(session, expressionArray, 6);
                String string15 = value9 == null ? null : value9.getString();
                Csv csv = Csv.getInstance();
                this.a(csv, string12, string13, string14);
                csv.setNullString(string15);
                char c2 = csv.getFieldSeparatorRead();
                String[] stringArray = StringUtils.arraySplit(string10, c2, true);
                try {
                    ValueResultSet valueResultSet = ValueResultSet.get(csv.read(string, stringArray, string11));
                    value = valueResultSet;
                    break;
                }
                catch (SQLException sQLException) {
                    throw DbException.convert(sQLException);
                }
            }
            case 218: {
                session.getUser().checkAdmin();
                JdbcConnection jdbcConnection = session.createConnection(false);
                ResultSet resultSet = LinkSchema.linkSchema(jdbcConnection, value2.getString(), value4.getString(), value5.getString(), value6.getString(), value7.getString(), value8.getString());
                value = ValueResultSet.get(resultSet);
                break;
            }
            case 211: {
                session.getUser().checkAdmin();
                JdbcConnection jdbcConnection = session.createConnection(false);
                String string = value5 == null ? null : value5.getString();
                String string16 = value6 == null ? null : value6.getString();
                String string17 = value7 == null ? null : value7.getString();
                String string18 = value8 == null ? null : value8.getString();
                Value value10 = this.a(session, expressionArray, 6);
                String string19 = value10 == null ? null : value10.getString();
                Value value11 = this.a(session, expressionArray, 7);
                String string20 = value11 == null ? null : value11.getString();
                Csv csv = Csv.getInstance();
                this.a(csv, string16, string17, string18);
                csv.setNullString(string19);
                if (string20 != null) {
                    csv.setLineSeparator(string20);
                }
                try {
                    int n8 = csv.write(jdbcConnection, value2.getString(), value4.getString(), string);
                    value = ValueInt.get(n8);
                    break;
                }
                catch (SQLException sQLException) {
                    throw DbException.convert(sQLException);
                }
            }
            case 222: {
                Variable variable = (Variable)expressionArray[0];
                session.setVariable(variable.getName(), value4);
                value = value4;
                break;
            }
            case 225: {
                session.getUser().checkAdmin();
                String string = value2.getString();
                boolean bl = expressionArray.length == 1;
                try {
                    AutoCloseInputStream autoCloseInputStream = new AutoCloseInputStream(IOUtils.openFileInputStream(string));
                    if (bl) {
                        value = this.u.getLobStorage().createBlob(autoCloseInputStream, -1L);
                        break;
                    }
                    InputStreamReader inputStreamReader = value4 == ValueNull.INSTANCE ? new InputStreamReader(autoCloseInputStream) : new InputStreamReader((InputStream)autoCloseInputStream, value4.getString());
                    value = this.u.getLobStorage().createClob(inputStreamReader, -1L);
                    break;
                }
                catch (IOException iOException) {
                    throw DbException.convertIOException(iOException, string);
                }
            }
            default: {
                throw DbException.throwInternalError("type=" + this.n.type);
            }
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Sequence a(Session session, Value value, Value value2) {
        String string;
        String string2;
        if (value2 == null) {
            Parser parser = new Parser(session);
            String string3 = value.getString();
            Expression expression = parser.parseExpression(string3);
            if (!(expression instanceof ExpressionColumn)) throw DbException.getSyntaxError(string3, 1);
            ExpressionColumn expressionColumn = (ExpressionColumn)expression;
            string2 = expressionColumn.getOriginalTableAliasName();
            if (string2 == null) {
                string2 = session.getCurrentSchemaName();
            } else if (string2.equals(StringUtils.toLowerEnglish(string2))) {
                string2 = StringUtils.toUpperEnglish(string2);
            }
            string = expressionColumn.getColumnName();
            if (!string.equals(StringUtils.toLowerEnglish(string))) return this.u.getSchema(string2).getSequence(string);
            string = StringUtils.toUpperEnglish(string);
            return this.u.getSchema(string2).getSequence(string);
        } else {
            string2 = value.getString();
            string = value2.getString();
        }
        return this.u.getSchema(string2).getSequence(string);
    }

    private long a(Value value) {
        switch (value.getType()) {
            case 12: 
            case 15: 
            case 16: 
            case 19: {
                return value.getPrecision();
            }
        }
        return value.getString().length();
    }

    private byte[] a(byte[] byArray, int n2) {
        int n3 = MathUtils.roundUpInt(byArray.length, n2);
        byte[] byArray2 = Utils.newBytes(n3);
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    private byte[] if(String string, byte[] byArray, byte[] byArray2) {
        BlockCipher blockCipher = CipherFactory.getBlockCipher(string);
        byte[] byArray3 = this.a(byArray, blockCipher.getKeyLength());
        blockCipher.setKey(byArray3);
        byte[] byArray4 = this.a(byArray2, 16);
        blockCipher.decrypt(byArray4, 0, byArray4.length);
        return byArray4;
    }

    private byte[] a(String string, byte[] byArray, byte[] byArray2) {
        BlockCipher blockCipher = CipherFactory.getBlockCipher(string);
        byte[] byArray3 = this.a(byArray, blockCipher.getKeyLength());
        blockCipher.setKey(byArray3);
        byte[] byArray4 = this.a(byArray2, 16);
        blockCipher.encrypt(byArray4, 0, byArray4.length);
        return byArray4;
    }

    private byte[] a(String string, byte[] byArray, int n2) {
        SHA256 sHA256 = CipherFactory.getHash(string);
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray = sHA256.getHash(byArray, false);
        }
        return byArray;
    }

    public static boolean isDatePart(String string) {
        Integer n2 = (Integer)l.get(StringUtils.toUpperEnglish(string));
        return n2 != null;
    }

    private static int a(String string) {
        Integer n2 = (Integer)l.get(StringUtils.toUpperEnglish(string));
        if (n2 == null) {
            throw DbException.getInvalidValueException("date part", string);
        }
        return n2;
    }

    private static Timestamp a(String string, int n2, Timestamp timestamp) {
        int n3 = Function.a(string);
        Calendar calendar = Calendar.getInstance();
        int n4 = timestamp.getNanos() % 1000000;
        calendar.setTime(timestamp);
        calendar.add(n3, n2);
        long l2 = calendar.getTime().getTime();
        Timestamp timestamp2 = new Timestamp(l2);
        timestamp2.setNanos(timestamp2.getNanos() + n4);
        return timestamp2;
    }

    private static long a(String string, Timestamp timestamp, Timestamp timestamp2) {
        int n2 = Function.a(string);
        Calendar calendar = Calendar.getInstance();
        long l2 = timestamp.getTime();
        long l3 = timestamp2.getTime();
        TimeZone timeZone = calendar.getTimeZone();
        calendar.setTime(timestamp);
        l2 += (long)timeZone.getOffset(calendar.get(0), calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(7), calendar.get(14));
        calendar.setTime(timestamp2);
        l3 += (long)timeZone.getOffset(calendar.get(0), calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(7), calendar.get(14));
        switch (n2) {
            case 14: {
                return l3 - l2;
            }
            case 11: 
            case 12: 
            case 13: {
                long l4 = 3600000L;
                long l5 = Math.min(l2 / l4 * l4, l3 / l4 * l4);
                l2 -= l5;
                l3 -= l5;
                switch (n2) {
                    case 13: {
                        return l3 / 1000L - l2 / 1000L;
                    }
                    case 12: {
                        return l3 / 60000L - l2 / 60000L;
                    }
                    case 11: {
                        return l3 / l4 - l2 / l4;
                    }
                }
                throw DbException.throwInternalError("field:" + n2);
            }
            case 5: {
                return l3 / 86400000L - l2 / 86400000L;
            }
        }
        calendar.setTime(new Timestamp(l2));
        int n3 = calendar.get(1);
        int n4 = calendar.get(2);
        calendar.setTime(new Timestamp(l3));
        int n5 = calendar.get(1);
        int n6 = calendar.get(2);
        int n7 = n5 - n3;
        if (n2 == 2) {
            n7 = 12 * n7 + (n6 - n4);
        }
        return n7;
    }

    private static String a(String string, int n2, int n3) {
        int n4 = string.length();
        if (--n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        int n5 = n2 = n2 > n4 ? n4 : n2;
        if (n2 + n3 > n4) {
            n3 = n4 - n2;
        }
        return string.substring(n2, n2 + n3);
    }

    private static String a(String string, String string2, String string3) {
        int n2;
        if (string == null || string2 == null || string3 == null) {
            return null;
        }
        if (string2.length() == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n3 = 0;
        int n4 = string2.length();
        while ((n2 = string.indexOf(string2, n3)) != -1) {
            stringBuilder.append(string.substring(n3, n2)).append(string3);
            n3 = n2 + n4;
        }
        stringBuilder.append(string.substring(n3));
        return stringBuilder.toString();
    }

    private static String if(String string, int n2) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * n2);
        while (n2-- > 0) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static String for(String string) {
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(4 * n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = Integer.toHexString(string.charAt(i2) & 0xFFFF);
            for (int i3 = string2.length(); i3 < 4; ++i3) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private static int a(String string, String string2, int n2) {
        if (n2 < 0) {
            int n3 = string2.length() + n2;
            return string2.lastIndexOf(string, n3) + 1;
        }
        int n4 = n2 == 0 ? 0 : n2 - 1;
        return string2.indexOf(string, n4) + 1;
    }

    private static String do(String string, int n2) {
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > string.length()) {
            n2 = string.length();
        }
        return string.substring(string.length() - n2);
    }

    private static String a(String string, int n2) {
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > string.length()) {
            n2 = string.length();
        }
        return string.substring(0, n2);
    }

    private static String a(String string, int n2, int n3, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        int n4 = string.length();
        int n5 = string2.length();
        if (--n2 < 0 || n3 <= 0 || n5 == 0 || n2 > n4) {
            return string;
        }
        if (n2 + n3 > n4) {
            n3 = n4 - n2;
        }
        return string.substring(0, n2) + string2 + string.substring(n2 + n3);
    }

    private static String do(String string) {
        int n2 = string.length();
        if (n2 % 4 != 0) {
            throw DbException.get(90021, string);
        }
        StringBuilder stringBuilder = new StringBuilder(n2 / 4);
        for (int i2 = 0; i2 < n2; i2 += 4) {
            try {
                char c2 = (char)Integer.parseInt(string.substring(i2, i2 + 4), 16);
                stringBuilder.append(c2);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw DbException.get(90021, string);
            }
        }
        return stringBuilder.toString();
    }

    private static int a(String string, String string2) {
        string = Function.if(string);
        string2 = Function.if(string2);
        int n2 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            if (string.charAt(i2) != string2.charAt(i2)) continue;
            ++n2;
        }
        return n2;
    }

    private double if(double d2) {
        if (d2 < 1.0E-13 && d2 > -1.0E-13) {
            return 0.0;
        }
        if (d2 > 1.0E12 || d2 < -1.0E12) {
            return d2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(d2);
        if (stringBuilder.toString().indexOf("E") >= 0) {
            return d2;
        }
        int n2 = stringBuilder.length();
        if (n2 < 16) {
            return d2;
        }
        if (stringBuilder.toString().indexOf(".") > n2 - 3) {
            return d2;
        }
        stringBuilder.delete(n2 - 2, n2);
        char c2 = stringBuilder.charAt((n2 -= 2) - 2);
        char c3 = stringBuilder.charAt(n2 - 3);
        char c4 = stringBuilder.charAt(n2 - 4);
        if (c2 == '0' && c3 == '0' && c4 == '0') {
            stringBuilder.setCharAt(n2 - 1, '0');
        } else if (c2 == '9' && c3 == '9' && c4 == '9') {
            stringBuilder.setCharAt(n2 - 1, '9');
            stringBuilder.append('9');
            stringBuilder.append('9');
            stringBuilder.append('9');
        }
        return Double.valueOf(stringBuilder.toString());
    }

    private static String if(String string) {
        int n2 = string.length();
        char[] cArray = new char[]{'0', '0', '0', '0'};
        char c2 = '0';
        int n3 = 0;
        for (int i2 = 0; i2 < n2 && n3 < 4; ++i2) {
            char c3;
            char c4 = string.charAt(i2);
            char c5 = c3 = c4 > o.length ? (char)'\u0000' : o[c4];
            if (c3 == '\u0000') continue;
            if (n3 == 0) {
                cArray[n3++] = c4;
                c2 = c3;
                continue;
            }
            if (c3 <= '6') {
                if (c3 == c2) continue;
                cArray[n3++] = c3;
                c2 = c3;
                continue;
            }
            if (c3 != '7') continue;
            c2 = c3;
        }
        return new String(cArray);
    }

    public int getType() {
        return this.t;
    }

    public void mapColumns(ColumnResolver columnResolver, int n2) {
        for (Expression expression : this.args) {
            expression.mapColumns(columnResolver, n2);
        }
    }

    protected void checkParameterCount(int n2) {
        boolean bl;
        int n3 = 0;
        int n4 = Integer.MAX_VALUE;
        switch (this.n.type) {
            case 204: 
            case 210: 
            case 219: 
            case 220: {
                n3 = 1;
                break;
            }
            case 20: 
            case 112: 
            case 119: {
                n4 = 1;
                break;
            }
            case 32: 
            case 63: 
            case 69: 
            case 78: 
            case 225: {
                n3 = 1;
                n4 = 2;
                break;
            }
            case 58: 
            case 62: 
            case 67: 
            case 72: 
            case 73: 
            case 90: 
            case 91: {
                n3 = 2;
                n4 = 3;
                break;
            }
            case 54: 
            case 206: 
            case 211: {
                n3 = 2;
                break;
            }
            case 84: {
                n3 = 1;
                n4 = 3;
                break;
            }
            case 121: 
            case 122: {
                n3 = 2;
                n4 = 4;
                break;
            }
            case 207: 
            case 208: {
                n3 = 1;
                n4 = 2;
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.n.type);
            }
        }
        boolean bl2 = bl = n2 >= n3 && n2 <= n4;
        if (!bl) {
            throw DbException.get(7001, this.n.name, n3 + ".." + n4);
        }
    }

    public void doneWithParameters() {
        if (this.n.parameterCount == -1) {
            int n2 = this.q.size();
            this.checkParameterCount(n2);
            this.args = new Expression[n2];
            this.q.toArray(this.args);
            this.q = null;
        } else {
            int n3 = this.args.length;
            if (n3 > 0 && this.args[n3 - 1] == null) {
                throw DbException.get(7001, this.n.name, "" + n3);
            }
        }
    }

    public void setDataType(int n2, long l2, int n3, int n4) {
        this.t = n2;
        this.r = l2;
        this.k = n4;
        this.s = n3;
    }

    public void setDataType(Column column) {
        this.t = column.getType();
        this.r = column.getPrecision();
        this.k = column.getDisplaySize();
        this.s = column.getScale();
    }

    public Expression optimize(Session session) {
        int n2;
        long l2;
        int n3;
        int n4;
        boolean bl = this.n.deterministic;
        for (n4 = 0; n4 < this.args.length; ++n4) {
            Expression expression;
            this.args[n4] = expression = this.args[n4].optimize(session);
            if (expression.isConstant()) continue;
            bl = false;
        }
        Expression expression = this.args.length < 1 ? null : this.args[0];
        switch (this.n.type) {
            case 200: 
            case 204: 
            case 205: 
            case 219: 
            case 220: {
                n4 = -1;
                n3 = 0;
                l2 = 0L;
                n2 = 0;
                for (Expression expression2 : this.args) {
                    if (expression2 == ValueExpression.getNull() || expression2.getType() == -1) continue;
                    n4 = Value.getHigherOrder(n4, expression2.getType());
                    n3 = Math.max(n3, expression2.getScale());
                    l2 = Math.max(l2, expression2.getPrecision());
                    n2 = Math.max(n2, expression2.getDisplaySize());
                }
                if (n4 != -1) break;
                n4 = 13;
                n3 = 0;
                l2 = Integer.MAX_VALUE;
                n2 = Integer.MAX_VALUE;
                break;
            }
            case 201: {
                n4 = Value.getHigherOrder(this.args[1].getType(), this.args[2].getType());
                l2 = Math.max(this.args[1].getPrecision(), this.args[2].getPrecision());
                n2 = Math.max(this.args[1].getDisplaySize(), this.args[2].getDisplaySize());
                n3 = Math.max(this.args[1].getScale(), this.args[2].getScale());
                break;
            }
            case 202: 
            case 203: {
                n4 = this.t;
                l2 = this.r;
                n3 = this.s;
                n2 = this.k;
                break;
            }
            case 0: 
            case 13: 
            case 18: 
            case 19: 
            case 21: 
            case 27: {
                n4 = expression.getType();
                n3 = expression.getScale();
                l2 = expression.getPrecision();
                n2 = expression.getDisplaySize();
                if (n4 != 0) break;
                n4 = 4;
                l2 = 10L;
                n2 = 11;
                n3 = 0;
                break;
            }
            case 222: {
                Expression expression3 = this.args[1];
                n4 = expression3.getType();
                l2 = expression3.getPrecision();
                n3 = expression3.getScale();
                n2 = expression3.getDisplaySize();
                if (expression instanceof Variable) break;
                throw DbException.get(90137, expression.getSQL());
            }
            case 225: {
                n4 = this.args.length == 1 ? 15 : 16;
                l2 = Integer.MAX_VALUE;
                n3 = 0;
                n2 = Integer.MAX_VALUE;
                break;
            }
            case 72: 
            case 73: {
                n4 = this.n.dataType;
                l2 = this.args[0].getPrecision();
                n3 = 0;
                if (this.args[1].isConstant()) {
                    l2 -= this.args[1].getValue(session).getLong() - 1L;
                }
                if (this.args.length == 3 && this.args[2].isConstant()) {
                    l2 = Math.min(l2, this.args[2].getValue(session).getLong());
                }
                l2 = Math.max(0L, l2);
                n2 = MathUtils.convertLongToInt(l2);
                break;
            }
            default: {
                n4 = this.n.dataType;
                DataType dataType = DataType.getDataType(n4);
                l2 = -1L;
                n2 = 0;
                n3 = dataType.defaultScale;
            }
        }
        this.t = n4;
        this.r = l2;
        this.s = n3;
        this.k = n2;
        if (bl) {
            Value value = this.getValue(session);
            if (value == ValueNull.INSTANCE && (this.n.type == 203 || this.n.type == 202)) {
                return this;
            }
            return ValueExpression.get(value);
        }
        return this;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        for (Expression expression : this.args) {
            if (expression == null) continue;
            expression.setEvaluatable(tableFilter, bl);
        }
    }

    public int getScale() {
        return this.s;
    }

    public long getPrecision() {
        if (this.r == -1L) {
            this.if();
        }
        return this.r;
    }

    public int getDisplaySize() {
        if (this.r == -1L) {
            this.if();
        }
        return this.k;
    }

    private void if() {
        switch (this.n.type) {
            case 30: 
            case 31: {
                this.r = this.args[2].getPrecision();
                this.k = this.args[2].getDisplaySize();
                break;
            }
            case 32: {
                this.r = this.args[0].getPrecision();
                this.k = this.args[0].getDisplaySize();
                break;
            }
            case 52: {
                this.r = 1L;
                this.k = 1;
                break;
            }
            case 54: {
                this.r = 0L;
                this.k = 0;
                for (Expression expression : this.args) {
                    this.r += expression.getPrecision();
                    this.k = MathUtils.convertLongToInt((long)this.k + (long)expression.getDisplaySize());
                    if (this.r >= 0L) continue;
                    this.r = Long.MAX_VALUE;
                }
                break;
            }
            case 56: {
                this.r = (this.args[0].getPrecision() + 3L) / 4L;
                this.k = MathUtils.convertLongToInt(this.r);
                break;
            }
            case 59: 
            case 63: 
            case 68: 
            case 69: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 80: 
            case 82: {
                this.r = this.args[0].getPrecision();
                this.k = this.args[0].getDisplaySize();
                break;
            }
            case 65: {
                this.r = this.args[0].getPrecision() * 4L;
                this.k = MathUtils.convertLongToInt(this.r);
                break;
            }
            case 70: {
                this.r = 4L;
                this.k = (int)this.r;
                break;
            }
            case 104: 
            case 111: {
                this.r = 20L;
                this.k = (int)this.r;
                break;
            }
            default: {
                DataType dataType = DataType.getDataType(this.t);
                this.r = dataType.defaultPrecision;
                this.k = dataType.defaultDisplaySize;
            }
        }
    }

    public String getSQL() {
        StatementBuilder statementBuilder = new StatementBuilder(this.n.name);
        statementBuilder.append('(');
        switch (this.n.type) {
            case 203: {
                statementBuilder.append(this.args[0].getSQL()).append(" AS ").append(new Column(null, this.t, this.r, this.s, this.k).getCreateSQL());
                break;
            }
            case 202: {
                statementBuilder.append(this.args[0].getSQL()).append(',').append(new Column(null, this.t, this.r, this.s, this.k).getCreateSQL());
                break;
            }
            case 120: {
                ValueString valueString = (ValueString)((ValueExpression)this.args[0]).getValue(null);
                statementBuilder.append(valueString.getString()).append(" FROM ").append(this.args[1].getSQL());
                break;
            }
            default: {
                for (Expression expression : this.args) {
                    statementBuilder.appendExceptFirst(", ");
                    statementBuilder.append(expression.getSQL());
                }
            }
        }
        return statementBuilder.append(')').toString();
    }

    public void updateAggregate(Session session) {
        for (Expression expression : this.args) {
            if (expression == null) continue;
            expression.updateAggregate(session);
        }
    }

    public int getFunctionType() {
        return this.n.type;
    }

    public String getName() {
        return this.n.name;
    }

    public int getParameterCount() {
        return this.args.length;
    }

    public ValueResultSet getValueForColumnList(Session session, Expression[] expressionArray) {
        switch (this.n.type) {
            case 210: {
                ValueResultSet valueResultSet;
                String string = expressionArray[0].getValue(session).getString();
                if (string == null) {
                    throw DbException.get(90012, "fileName");
                }
                String string2 = expressionArray.length < 2 ? null : expressionArray[1].getValue(session).getString();
                String string3 = expressionArray.length < 3 ? null : expressionArray[2].getValue(session).getString();
                String string4 = expressionArray.length < 4 ? null : expressionArray[3].getValue(session).getString();
                String string5 = expressionArray.length < 5 ? null : expressionArray[4].getValue(session).getString();
                String string6 = expressionArray.length < 6 ? null : expressionArray[5].getValue(session).getString();
                Csv csv = Csv.getInstance();
                this.a(csv, string4, string5, string6);
                char c2 = csv.getFieldSeparatorRead();
                String[] stringArray = StringUtils.arraySplit(string2, c2, true);
                ResultSet resultSet = null;
                try {
                    resultSet = csv.read(string, stringArray, string3);
                    valueResultSet = ValueResultSet.getCopy(resultSet, 0);
                }
                catch (SQLException sQLException) {
                    try {
                        throw DbException.convert(sQLException);
                    }
                    catch (Throwable throwable) {
                        JdbcUtils.closeSilently(resultSet);
                        throw throwable;
                    }
                }
                JdbcUtils.closeSilently(resultSet);
                return valueResultSet;
            }
        }
        return (ValueResultSet)this.a(session, expressionArray);
    }

    private void a(Csv csv, String string, String string2, String string3) {
        char c2;
        if (string != null) {
            csv.setFieldSeparatorWrite(string);
            if (string.length() > 0) {
                c2 = string.charAt(0);
                csv.setFieldSeparatorRead(c2);
            }
        }
        if (string2 != null) {
            c2 = string2.length() == 0 ? (char)'\u0000' : string2.charAt(0);
            csv.setFieldDelimiter(c2);
        }
        if (string3 != null) {
            c2 = string3.length() == 0 ? (char)'\u0000' : string3.charAt(0);
            csv.setEscapeCharacter(c2);
        }
    }

    public Expression[] getArgs() {
        return this.args;
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        for (Expression expression : this.args) {
            if (expression == null || expression.isEverything(expressionVisitor)) continue;
            return false;
        }
        switch (expressionVisitor.getType()) {
            case 2: 
            case 5: 
            case 8: {
                return this.n.deterministic;
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    public int getCost() {
        int n2 = 3;
        for (Expression expression : this.args) {
            n2 += expression.getCost();
        }
        return n2;
    }

    public boolean isDeterministic() {
        return this.n.deterministic;
    }

    public boolean isFast() {
        return this.n.fast;
    }

    static {
        l.put("YEAR", 1);
        l.put("YYYY", 1);
        l.put("YY", 1);
        l.put("MONTH", 2);
        l.put("MM", 2);
        l.put("M", 2);
        l.put("WW", 3);
        l.put("WK", 3);
        l.put("DAY", 5);
        l.put("DD", 5);
        l.put("D", 5);
        l.put("DAYOFYEAR", 6);
        l.put("DAY_OF_YEAR", 6);
        l.put("DY", 6);
        l.put("DOY", 6);
        l.put("HOUR", 11);
        l.put("HH", 11);
        l.put("MINUTE", 12);
        l.put("MI", 12);
        l.put("N", 12);
        l.put("SECOND", 13);
        l.put("SS", 13);
        l.put("S", 13);
        l.put("MILLISECOND", 14);
        l.put("MS", 14);
        String string = "7AEIOUY8HW1BFPV2CGJKQSXZ3DT4L5MN6R";
        char c2 = '\u0000';
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c3 = string.charAt(i2);
            if (c3 < '9') {
                c2 = c3;
                continue;
            }
            Function.o[c3] = c2;
            Function.o[Character.toLowerCase((char)c3)] = c2;
        }
        Function.a("ABS", 0, 1, 0);
        Function.a("ACOS", 1, 1, 7);
        Function.a("ASIN", 2, 1, 7);
        Function.a("ATAN", 3, 1, 7);
        Function.a("ATAN2", 4, 2, 7);
        Function.a("BITAND", 5, 2, 5);
        Function.a("BITOR", 6, 2, 5);
        Function.a("BITXOR", 7, 2, 5);
        Function.a("CEILING", 8, 1, 7);
        Function.a("COS", 9, 1, 7);
        Function.a("COT", 10, 1, 7);
        Function.a("DEGREES", 11, 1, 7);
        Function.a("EXP", 12, 1, 7);
        Function.a("FLOOR", 13, 1, 7);
        Function.a("LOG", 14, 1, 7);
        Function.a("LOG10", 15, 1, 7);
        Function.a("MOD", 16, 2, 5);
        Function.a("PI", 17, 0, 7);
        Function.a("POWER", 18, 2, 7);
        Function.a("RADIANS", 19, 1, 7);
        Function.do("RAND", 20, -1, 7);
        Function.a("ROUND", 21, 2, 7);
        Function.a("ROUNDMAGIC", 22, 1, 7);
        Function.a("SIGN", 23, 1, 4);
        Function.a("SIN", 24, 1, 7);
        Function.a("SQRT", 25, 1, 7);
        Function.a("TAN", 26, 1, 7);
        Function.a("TRUNCATE", 27, 2, 7);
        Function.a("HASH", 29, 3, 12);
        Function.a("ENCRYPT", 30, 3, 12);
        Function.a("DECRYPT", 31, 3, 12);
        Function.do("SECURE_RAND", 28, 1, 12);
        Function.a("COMPRESS", 32, -1, 12);
        Function.a("EXPAND", 33, 1, 12);
        Function.a("ZERO", 34, 0, 4);
        Function.do("RANDOM_UUID", 35, 0, 20);
        Function.do("SYS_GUID", 35, 0, 20);
        Function.a("ASCII", 50, 1, 4);
        Function.a("BIT_LENGTH", 51, 1, 5);
        Function.a("CHAR", 52, 1, 13);
        Function.a("CHR", 52, 1, 13);
        Function.a("CHAR_LENGTH", 53, 1, 4);
        Function.a("CHARACTER_LENGTH", 53, 1, 4);
        Function.if("CONCAT", 54, -1, 13);
        Function.a("DIFFERENCE", 55, 2, 4);
        Function.a("HEXTORAW", 56, 1, 13);
        Function.if("INSERT", 57, 4, 13);
        Function.a("LCASE", 59, 1, 13);
        Function.a("LEFT", 60, 2, 13);
        Function.a("LENGTH", 61, 1, 5);
        Function.a("LOCATE", 62, -1, 4);
        Function.a("POSITION", 62, 2, 4);
        Function.a("INSTR", 58, -1, 4);
        Function.a("LTRIM", 63, -1, 13);
        Function.a("OCTET_LENGTH", 64, 1, 5);
        Function.a("RAWTOHEX", 65, 1, 13);
        Function.a("REPEAT", 66, 2, 13);
        Function.a("REPLACE", 67, -1, 13);
        Function.a("RIGHT", 68, 2, 13);
        Function.a("RTRIM", 69, -1, 13);
        Function.a("SOUNDEX", 70, 1, 13);
        Function.a("SPACE", 71, 1, 13);
        Function.a("SUBSTR", 72, -1, 13);
        Function.a("SUBSTRING", 73, -1, 13);
        Function.a("UCASE", 74, 1, 13);
        Function.a("LOWER", 75, 1, 13);
        Function.a("UPPER", 76, 1, 13);
        Function.a("POSITION", 77, 2, 4);
        Function.a("TRIM", 78, -1, 13);
        Function.a("STRINGENCODE", 79, 1, 13);
        Function.a("STRINGDECODE", 80, 1, 13);
        Function.a("STRINGTOUTF8", 81, 1, 12);
        Function.a("UTF8TOSTRING", 82, 1, 13);
        Function.a("XMLATTR", 83, 2, 13);
        Function.if("XMLNODE", 84, -1, 13);
        Function.a("XMLCOMMENT", 85, 1, 13);
        Function.a("XMLCDATA", 86, 1, 13);
        Function.a("XMLSTARTDOC", 87, 0, 13);
        Function.a("XMLTEXT", 88, 1, 13);
        Function.a("REGEXP_REPLACE", 89, 3, 13);
        Function.a("RPAD", 90, -1, 13);
        Function.a("LPAD", 91, -1, 13);
        Function.do("CURRENT_DATE", 117, 0, 10);
        Function.do("CURDATE", 100, 0, 10);
        Function.do("CURRENT_TIME", 118, 0, 9);
        Function.do("CURTIME", 101, 0, 9);
        Function.do("CURRENT_TIMESTAMP", 119, -1, 11);
        Function.do("NOW", 112, -1, 11);
        Function.a("DATEADD", 102, 3, 11);
        Function.a("DATEDIFF", 103, 3, 5);
        Function.a("TIMESTAMPDIFF", 103, 3, 5);
        Function.a("DAYNAME", 104, 1, 13);
        Function.a("DAYNAME", 104, 1, 13);
        Function.a("DAY", 105, 1, 4);
        Function.a("DAY_OF_MONTH", 105, 1, 4);
        Function.a("DAY_OF_WEEK", 106, 1, 4);
        Function.a("DAY_OF_YEAR", 107, 1, 4);
        Function.a("DAYOFMONTH", 105, 1, 4);
        Function.a("DAYOFWEEK", 106, 1, 4);
        Function.a("DAYOFYEAR", 107, 1, 4);
        Function.a("HOUR", 108, 1, 4);
        Function.a("MINUTE", 109, 1, 4);
        Function.a("MONTH", 110, 1, 4);
        Function.a("MONTHNAME", 111, 1, 13);
        Function.a("QUARTER", 113, 1, 4);
        Function.a("SECOND", 114, 1, 4);
        Function.a("WEEK", 115, 1, 4);
        Function.a("YEAR", 116, 1, 4);
        Function.a("EXTRACT", 120, 2, 4);
        Function.if("FORMATDATETIME", 121, -1, 13);
        Function.if("PARSEDATETIME", 122, -1, 11);
        Function.a("ISO_YEAR", 123, 1, 4);
        Function.a("ISO_WEEK", 124, 1, 4);
        Function.a("ISO_DAY_OF_WEEK", 125, 1, 4);
        Function.do("DATABASE", 150, 0, 13);
        Function.do("USER", 151, 0, 13);
        Function.do("CURRENT_USER", 152, 0, 13);
        Function.do("IDENTITY", 153, 0, 5);
        Function.do("SCOPE_IDENTITY", 154, 0, 5);
        Function.do("IDENTITY_VAL_LOCAL", 153, 0, 5);
        Function.do("LAST_INSERT_ID", 153, 0, 5);
        Function.do("LASTVAL", 153, 0, 5);
        Function.do("AUTOCOMMIT", 155, 0, 1);
        Function.do("READONLY", 156, 0, 1);
        Function.a("DATABASE_PATH", 157, 0, 13);
        Function.a("LOCK_TIMEOUT", 158, 0, 4);
        Function.if("IFNULL", 200, 2, 0);
        Function.if("CASEWHEN", 201, 3, 0);
        Function.if("CONVERT", 202, 1, 0);
        Function.if("CAST", 203, 1, 0);
        Function.if("COALESCE", 204, -1, 0);
        Function.if("NVL", 204, -1, 0);
        Function.if("NULLIF", 205, 2, 0);
        Function.if("CASE", 206, -1, 0);
        Function.do("NEXTVAL", 207, -1, 5);
        Function.do("CURRVAL", 208, -1, 5);
        Function.a("ARRAY_GET", 209, 2, 13);
        Function.a("CSVREAD", 210, -1, 18, false, false, true);
        Function.a("CSVWRITE", 211, -1, 4, false, false, false);
        Function.do("MEMORY_FREE", 212, 0, 4);
        Function.do("MEMORY_USED", 213, 0, 4);
        Function.do("LOCK_MODE", 214, 0, 4);
        Function.do("SCHEMA", 215, 0, 13);
        Function.do("SESSION_ID", 216, 0, 4);
        Function.a("ARRAY_LENGTH", 217, 1, 4);
        Function.a("LINK_SCHEMA", 218, 6, 18);
        Function.if("LEAST", 220, -1, 0);
        Function.if("GREATEST", 219, -1, 0);
        Function.a("CANCEL_SESSION", 221, 1, 1);
        Function.a("SET", 222, 2, 0, false, false, false);
        Function.a("FILE_READ", 225, -1, 0, false, true, false);
        Function.do("TRANSACTION_ID", 226, 0, 13);
        Function.if("TABLE", 223, -1, 18);
        Function.if("TABLE_DISTINCT", 224, -1, 18);
    }
}

