/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.h2.api.AggregateFunction;
import org.h2.command.Parser;
import org.h2.command.dml.Select;
import org.h2.engine.Session;
import org.h2.engine.UserAggregate;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.StatementBuilder;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JavaAggregate
extends Expression {
    private final UserAggregate f;
    private final Select goto;
    private AggregateFunction c;
    private Expression[] void;
    private int[] e;
    private int long;
    private Connection b;
    private int d;

    public JavaAggregate(UserAggregate userAggregate, Expression[] expressionArray, Select select) {
        this.f = userAggregate;
        this.void = expressionArray;
        this.goto = select;
    }

    public int getCost() {
        int n2 = 5;
        for (Expression expression : this.void) {
            n2 += expression.getCost();
        }
        return n2;
    }

    public long getPrecision() {
        return Integer.MAX_VALUE;
    }

    public int getDisplaySize() {
        return Integer.MAX_VALUE;
    }

    public int getScale() {
        return DataType.getDataType((int)this.long).defaultScale;
    }

    public String getSQL() {
        StatementBuilder statementBuilder = new StatementBuilder();
        statementBuilder.append(Parser.quoteIdentifier(this.f.getName())).append('(');
        for (Expression expression : this.void) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(expression.getSQL());
        }
        return statementBuilder.append(')').toString();
    }

    public int getType() {
        return this.long;
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 1: 
            case 2: {
                return false;
            }
            case 7: {
                expressionVisitor.addDependency(this.f);
                break;
            }
        }
        for (Expression expression : this.void) {
            if (expression == null || expression.isEverything(expressionVisitor)) continue;
            return false;
        }
        return true;
    }

    public void mapColumns(ColumnResolver columnResolver, int n2) {
        for (Expression expression : this.void) {
            expression.mapColumns(columnResolver, n2);
        }
    }

    public Expression optimize(Session session) {
        this.b = session.createConnection(false);
        int n2 = this.void.length;
        this.e = new int[n2];
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            Expression expression = this.void[i2];
            this.void[i2] = expression.optimize(session);
            this.e[i2] = n3 = expression.getType();
            nArray[i2] = DataType.convertTypeToSQLType(n3);
        }
        try {
            this.c = this.a();
            this.long = DataType.convertSQLTypeToValueType(this.c.getType(nArray));
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
        return this;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        for (Expression expression : this.void) {
            expression.setEvaluatable(tableFilter, bl);
        }
    }

    private AggregateFunction a() throws SQLException {
        AggregateFunction aggregateFunction = this.f.getInstance();
        aggregateFunction.init(this.b);
        return aggregateFunction;
    }

    public Value getValue(Session session) {
        HashMap hashMap = this.goto.getCurrentGroup();
        if (hashMap == null) {
            throw DbException.get(90054, this.getSQL());
        }
        try {
            Object object;
            AggregateFunction aggregateFunction = (AggregateFunction)hashMap.get(this);
            if (aggregateFunction == null) {
                aggregateFunction = this.a();
            }
            if ((object = aggregateFunction.getResult()) == null) {
                return ValueNull.INSTANCE;
            }
            return DataType.convertToValue(session, object, this.long);
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    public void updateAggregate(Session session) {
        HashMap hashMap = this.goto.getCurrentGroup();
        if (hashMap == null) {
            return;
        }
        int n2 = this.goto.getCurrentGroupRowId();
        if (this.d == n2) {
            return;
        }
        this.d = n2;
        AggregateFunction aggregateFunction = (AggregateFunction)hashMap.get(this);
        try {
            if (aggregateFunction == null) {
                aggregateFunction = this.a();
                hashMap.put(this, aggregateFunction);
            }
            Object[] objectArray = new Object[this.void.length];
            Object object = null;
            int n3 = this.void.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                Value value = this.void[i2].getValue(session);
                value = value.convertTo(this.e[i2]);
                objectArray[i2] = object = value.getObject();
            }
            if (this.void.length == 1) {
                aggregateFunction.add(object);
            } else {
                aggregateFunction.add(objectArray);
            }
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }
}

