/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Function;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.MathUtils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Operation
extends Expression {
    public static final int CONCAT = 0;
    public static final int PLUS = 1;
    public static final int MINUS = 2;
    public static final int MULTIPLY = 3;
    public static final int DIVIDE = 4;
    public static final int NEGATE = 5;
    private int A;
    private Expression z;
    private Expression D;
    private int B;
    private boolean C = true;

    public Operation(int n2, Expression expression, Expression expression2) {
        this.A = n2;
        this.z = expression;
        this.D = expression2;
    }

    public String getSQL() {
        String string = this.A == 5 ? "- " + this.z.getSQL() : this.z.getSQL() + " " + this.for() + " " + this.D.getSQL();
        return "(" + string + ")";
    }

    private String for() {
        switch (this.A) {
            case 5: {
                return "-";
            }
            case 0: {
                return "||";
            }
            case 1: {
                return "+";
            }
            case 2: {
                return "-";
            }
            case 3: {
                return "*";
            }
            case 4: {
                return "/";
            }
        }
        throw DbException.throwInternalError("opType=" + this.A);
    }

    public Value getValue(Session session) {
        Value value;
        Value value2 = this.z.getValue(session).convertTo(this.B);
        if (this.D == null) {
            value = null;
        } else {
            value = this.D.getValue(session);
            if (this.C) {
                value = value.convertTo(this.B);
            }
        }
        switch (this.A) {
            case 5: {
                return value2 == ValueNull.INSTANCE ? value2 : value2.negate();
            }
            case 0: {
                Mode mode = session.getDatabase().getMode();
                if (value2 == ValueNull.INSTANCE) {
                    if (mode.nullConcatIsNull) {
                        return ValueNull.INSTANCE;
                    }
                    return value;
                }
                if (value == ValueNull.INSTANCE) {
                    if (mode.nullConcatIsNull) {
                        return ValueNull.INSTANCE;
                    }
                    return value2;
                }
                String string = value2.getString();
                String string2 = value.getString();
                StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length());
                stringBuilder.append(string).append(string2);
                return ValueString.get(stringBuilder.toString());
            }
            case 1: {
                if (value2 == ValueNull.INSTANCE || value == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return value2.add(value);
            }
            case 2: {
                if (value2 == ValueNull.INSTANCE || value == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return value2.subtract(value);
            }
            case 3: {
                if (value2 == ValueNull.INSTANCE || value == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return value2.multiply(value);
            }
            case 4: {
                if (value2 == ValueNull.INSTANCE || value == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return value2.divide(value);
            }
        }
        throw DbException.throwInternalError("type=" + this.A);
    }

    public void mapColumns(ColumnResolver columnResolver, int n2) {
        this.z.mapColumns(columnResolver, n2);
        if (this.D != null) {
            this.D.mapColumns(columnResolver, n2);
        }
    }

    public Expression optimize(Session session) {
        this.z = this.z.optimize(session);
        switch (this.A) {
            case 5: {
                this.B = this.z.getType();
                if (this.B != -1) break;
                this.B = 6;
                break;
            }
            case 0: {
                this.D = this.D.optimize(session);
                this.B = 13;
                if (!this.z.isConstant() || !this.D.isConstant()) break;
                return ValueExpression.get(this.getValue(session));
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.D = this.D.optimize(session);
                int n2 = this.z.getType();
                int n3 = this.D.getType();
                if (n2 == 0 && n3 == 0 || n2 == -1 && n3 == -1) {
                    if (this.A == 1 && session.getDatabase().getMode().allowPlusForStringConcat) {
                        this.B = 13;
                        this.A = 0;
                        break;
                    }
                    this.B = 6;
                    break;
                }
                if (n2 == 10 || n2 == 11 || n2 == 9 || n3 == 10 || n3 == 11 || n3 == 9) {
                    if (this.A == 1) {
                        if (n3 != Value.getHigherOrder(n2, n3)) {
                            this.do();
                            int n4 = n2;
                            n2 = n3;
                            n3 = n4;
                        }
                        if (n2 == 4) {
                            Function function = Function.getFunction(session.getDatabase(), "DATEADD");
                            function.setParameter(0, ValueExpression.get(ValueString.get("DAY")));
                            function.setParameter(1, this.z);
                            function.setParameter(2, this.D);
                            function.doneWithParameters();
                            return function.optimize(session);
                        }
                        if (n2 == 9 && n3 == 9) {
                            this.B = 9;
                            return this;
                        }
                        if (n2 == 9) {
                            this.B = 11;
                            return this;
                        }
                    } else if (this.A == 2) {
                        if ((n2 == 10 || n2 == 11) && n3 == 4) {
                            Function function = Function.getFunction(session.getDatabase(), "DATEADD");
                            function.setParameter(0, ValueExpression.get(ValueString.get("DAY")));
                            this.D = new Operation(5, this.D, null);
                            this.D = this.D.optimize(session);
                            function.setParameter(1, this.D);
                            function.setParameter(2, this.z);
                            function.doneWithParameters();
                            return function.optimize(session);
                        }
                        if (n2 == 10 || n2 == 11) {
                            if (n3 == 9) {
                                this.B = 11;
                                return this;
                            }
                            if (n3 == 10 || n3 == 11) {
                                Function function = Function.getFunction(session.getDatabase(), "DATEDIFF");
                                function.setParameter(0, ValueExpression.get(ValueString.get("DAY")));
                                function.setParameter(1, this.D);
                                function.setParameter(2, this.z);
                                function.doneWithParameters();
                                return function.optimize(session);
                            }
                        } else if (n2 == 9 && n3 == 9) {
                            this.B = 9;
                            return this;
                        }
                    } else if (this.A == 3) {
                        if (n2 == 9) {
                            this.B = 9;
                            this.C = false;
                            return this;
                        }
                        if (n3 == 9) {
                            this.do();
                            this.B = 9;
                            this.C = false;
                            return this;
                        }
                    } else if (this.A == 4 && n2 == 9) {
                        this.B = 9;
                        this.C = false;
                        return this;
                    }
                    throw DbException.getUnsupportedException(DataType.getDataType((int)n2).name + " " + this.for() + " " + DataType.getDataType((int)n3).name);
                }
                this.B = Value.getHigherOrder(n2, n3);
                if (!DataType.isStringType(this.B) || !session.getDatabase().getMode().allowPlusForStringConcat) break;
                this.A = 0;
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.A);
            }
        }
        if (this.z.isConstant() && (this.D == null || this.D.isConstant())) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    private void do() {
        Expression expression = this.z;
        this.z = this.D;
        this.D = expression;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.z.setEvaluatable(tableFilter, bl);
        if (this.D != null) {
            this.D.setEvaluatable(tableFilter, bl);
        }
    }

    public int getType() {
        return this.B;
    }

    public long getPrecision() {
        if (this.D != null) {
            switch (this.A) {
                case 0: {
                    return this.z.getPrecision() + this.D.getPrecision();
                }
            }
            return Math.max(this.z.getPrecision(), this.D.getPrecision());
        }
        return this.z.getPrecision();
    }

    public int getDisplaySize() {
        if (this.D != null) {
            switch (this.A) {
                case 0: {
                    return MathUtils.convertLongToInt((long)this.z.getDisplaySize() + (long)this.D.getDisplaySize());
                }
            }
            return Math.max(this.z.getDisplaySize(), this.D.getDisplaySize());
        }
        return this.z.getDisplaySize();
    }

    public int getScale() {
        if (this.D != null) {
            return Math.max(this.z.getScale(), this.D.getScale());
        }
        return this.z.getScale();
    }

    public void updateAggregate(Session session) {
        this.z.updateAggregate(session);
        if (this.D != null) {
            this.D.updateAggregate(session);
        }
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.z.isEverything(expressionVisitor) && (this.D == null || this.D.isEverything(expressionVisitor));
    }

    public int getCost() {
        return this.z.getCost() + 1 + (this.D == null ? 0 : this.D.getCost());
    }
}

