/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.io.IOException;
import org.h2.expression.ParameterInterface;
import org.h2.message.DbException;
import org.h2.value.Transfer;
import org.h2.value.Value;

public class ParameterRemote
implements ParameterInterface {
    private Value aU;
    private int aT;
    private int aS = -1;
    private long aR;
    private int aV;
    private int aW = 2;

    public ParameterRemote(int n2) {
        this.aT = n2;
    }

    public void setValue(Value value, boolean bl) {
        if (bl && this.aU != null) {
            this.aU.close();
        }
        this.aU = value;
    }

    public Value getParamValue() {
        return this.aU;
    }

    public void checkSet() {
        if (this.aU == null) {
            throw DbException.get(90012, "#" + (this.aT + 1));
        }
    }

    public int getType() {
        return this.aU == null ? this.aS : this.aU.getType();
    }

    public long getPrecision() {
        return this.aU == null ? this.aR : this.aU.getPrecision();
    }

    public int getScale() {
        return this.aU == null ? this.aV : this.aU.getScale();
    }

    public int getNullable() {
        return this.aW;
    }

    public void readMetaData(Transfer transfer) throws IOException {
        this.aS = transfer.readInt();
        this.aR = transfer.readLong();
        this.aV = transfer.readInt();
        this.aW = transfer.readInt();
    }

    public static void writeMetaData(Transfer transfer, ParameterInterface parameterInterface) throws IOException {
        transfer.writeInt(parameterInterface.getType());
        transfer.writeLong(parameterInterface.getPrecision());
        transfer.writeInt(parameterInterface.getScale());
        transfer.writeInt(parameterInterface.getNullable());
    }
}

