/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.index.IndexCondition;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class ValueExpression
extends Expression {
    private static final Object X = new ValueExpression(ValueNull.INSTANCE);
    private static final Object V = new ValueExpression(ValueNull.INSTANCE);
    private final Value W;

    private ValueExpression(Value value) {
        this.W = value;
    }

    public static ValueExpression getNull() {
        return (ValueExpression)X;
    }

    public static ValueExpression getDefault() {
        return (ValueExpression)V;
    }

    public static ValueExpression get(Value value) {
        if (value == ValueNull.INSTANCE) {
            return ValueExpression.getNull();
        }
        return new ValueExpression(value);
    }

    public Value getValue(Session session) {
        return this.W;
    }

    public int getType() {
        return this.W.getType();
    }

    public void createIndexConditions(Session session, TableFilter tableFilter) {
        boolean bl;
        if (this.W.getType() == 1 && !(bl = ((ValueBoolean)this.W).getBoolean().booleanValue())) {
            tableFilter.addIndexCondition(IndexCondition.get(8, null, this));
        }
    }

    public Expression getNotIfPossible(Session session) {
        return new Comparison(session, 0, this, ValueExpression.get(ValueBoolean.get(false)));
    }

    public void mapColumns(ColumnResolver columnResolver, int n2) {
    }

    public Expression optimize(Session session) {
        return this;
    }

    public boolean isConstant() {
        return true;
    }

    public boolean isValueSet() {
        return true;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
    }

    public int getScale() {
        return this.W.getScale();
    }

    public long getPrecision() {
        return this.W.getPrecision();
    }

    public int getDisplaySize() {
        return this.W.getDisplaySize();
    }

    public String getSQL() {
        if (this == V) {
            return "DEFAULT";
        }
        return this.W.getSQL();
    }

    public void updateAggregate(Session session) {
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    public int getCost() {
        return 0;
    }

    public Expression[] getExpressionColumns(Session session) {
        if (this.getType() == 17) {
            return ValueExpression.getExpressionColumns(session, (ValueArray)this.getValue(session));
        }
        return super.getExpressionColumns(session);
    }
}

