/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.schema.SchemaObjectBase;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.util.MathUtils;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public abstract class BaseIndex
extends SchemaObjectBase
implements Index {
    protected IndexColumn[] indexColumns;
    protected Column[] columns;
    protected int[] columnIds;
    protected Table table;
    protected IndexType indexType;
    protected boolean isMultiVersion;

    protected void initBaseIndex(Table table, int n2, String string, IndexColumn[] indexColumnArray, IndexType indexType) {
        this.initSchemaObjectBase(table.getSchema(), n2, string, "index");
        this.indexType = indexType;
        this.table = table;
        if (indexColumnArray != null) {
            this.indexColumns = indexColumnArray;
            this.columns = new Column[indexColumnArray.length];
            int n3 = this.columns.length;
            this.columnIds = new int[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                Column column;
                this.columns[i2] = column = indexColumnArray[i2].column;
                this.columnIds[i2] = column.getColumnId();
            }
        }
    }

    public int getRootPageId() {
        return 0;
    }

    public abstract void close(Session var1);

    public abstract void add(Session var1, Row var2);

    public abstract void remove(Session var1, Row var2);

    public abstract Cursor find(Session var1, SearchRow var2, SearchRow var3);

    public abstract double getCost(Session var1, int[] var2);

    public abstract void remove(Session var1);

    public abstract void truncate(Session var1);

    public abstract boolean canGetFirstOrLast();

    public abstract Cursor findFirstOrLast(Session var1, boolean var2);

    public abstract boolean needRebuild();

    public String getDropSQL() {
        return null;
    }

    public DbException getDuplicateKeyException() {
        String string = this.getName() + " ON " + this.table.getSQL() + "(" + this.getColumnListSQL() + ")";
        return DbException.get(23001, string);
    }

    public String getPlanSQL() {
        return this.getSQL();
    }

    public void removeChildrenAndResources(Session session) {
        this.table.removeIndex(this);
        this.remove(session);
        this.database.removeMeta(session, this.getId());
    }

    public boolean canFindNext() {
        return false;
    }

    public Cursor findNext(Session session, SearchRow searchRow, SearchRow searchRow2) {
        throw DbException.throwInternalError();
    }

    public int getLookupCost(long l2) {
        return 2;
    }

    public long getCostRangeIndex(int[] nArray, long l2) {
        long l3 = l2 += 1000L;
        long l4 = l2;
        int n2 = 0;
        if (nArray == null) {
            return l3;
        }
        int n3 = this.columns.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            long l5;
            Column column = this.columns[i2];
            int n4 = column.getColumnId();
            int n5 = nArray[n4];
            if ((n5 & 1) == 1) {
                if (i2 == this.columns.length - 1 && this.getIndexType().isUnique()) {
                    l3 = this.getLookupCost(l2) + 1;
                    break;
                }
                l5 = l2 * (long)(n2 = 100 - (100 - n2) * (100 - column.getSelectivity()) / 100) / 100L;
                if (l5 <= 0L) {
                    l5 = 1L;
                }
            } else {
                if ((n5 & 6) == 6) {
                    l3 = (long)this.getLookupCost(l2) + l4 / 4L;
                    break;
                }
                if ((n5 & 2) == 2) {
                    l3 = (long)this.getLookupCost(l2) + l4 / 3L;
                    break;
                }
                if ((n5 & 4) != 4) break;
                l3 = l4 / 3L;
                break;
            }
            l4 = Math.max(l2 / l5, 1L);
            l3 = (long)this.getLookupCost(l2) + l4;
        }
        return l3;
    }

    public int compareRows(SearchRow searchRow, SearchRow searchRow2) {
        int n2 = this.indexColumns.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.columnIds[i2];
            Value value = searchRow2.getValue(n3);
            if (value == null) {
                return 0;
            }
            int n4 = this.a(searchRow.getValue(n3), value, this.indexColumns[i2].sortType);
            if (n4 == 0) continue;
            return n4;
        }
        return 0;
    }

    public boolean containsNullAndAllowMultipleNull(SearchRow searchRow) {
        Mode mode = this.database.getMode();
        if (mode.uniqueIndexSingleNull) {
            return false;
        }
        if (mode.uniqueIndexSingleNullExceptAllColumnsAreNull) {
            for (int n2 : this.columnIds) {
                Value value = searchRow.getValue(n2);
                if (value == ValueNull.INSTANCE) continue;
                return false;
            }
            return true;
        }
        for (int n3 : this.columnIds) {
            Value value = searchRow.getValue(n3);
            if (value != ValueNull.INSTANCE) continue;
            return true;
        }
        return false;
    }

    public int compareKeys(SearchRow searchRow, SearchRow searchRow2) {
        long l2;
        long l3 = searchRow.getKey();
        if (l3 == (l2 = searchRow2.getKey())) {
            if (this.isMultiVersion) {
                int n2 = searchRow.getVersion();
                int n3 = searchRow2.getVersion();
                return MathUtils.compareInt(n3, n2);
            }
            return 0;
        }
        return l3 > l2 ? 1 : -1;
    }

    private int a(Value value, Value value2, int n2) {
        boolean bl;
        if (value == value2) {
            return 0;
        }
        boolean bl2 = value == null;
        boolean bl3 = bl = value2 == null;
        if (bl2 || bl) {
            return SortOrder.compareNull(bl2, bl, n2);
        }
        int n3 = this.table.compareTypeSave(value, value2);
        if ((n2 & 1) != 0) {
            n3 = -n3;
        }
        return n3;
    }

    public int getColumnIndex(Column column) {
        int n2 = this.columns.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.columns[i2] != column) continue;
            return i2;
        }
        return -1;
    }

    public String getColumnListSQL() {
        StatementBuilder statementBuilder = new StatementBuilder();
        for (IndexColumn indexColumn : this.indexColumns) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(indexColumn.getSQL());
        }
        return statementBuilder.toString();
    }

    public String getCreateSQLForCopy(Table table, String string) {
        StringBuilder stringBuilder = new StringBuilder("CREATE ");
        stringBuilder.append(this.indexType.getSQL());
        stringBuilder.append(' ');
        if (this.table.isHidden()) {
            stringBuilder.append("IF NOT EXISTS ");
        }
        stringBuilder.append(string);
        stringBuilder.append(" ON ").append(table.getSQL());
        if (this.comment != null) {
            stringBuilder.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        stringBuilder.append('(').append(this.getColumnListSQL()).append(')');
        return stringBuilder.toString();
    }

    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL());
    }

    public IndexColumn[] getIndexColumns() {
        return this.indexColumns;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public int getType() {
        return 1;
    }

    public Table getTable() {
        return this.table;
    }

    public void commit(int n2, Row row) {
    }

    void setMultiVersion(boolean bl) {
        this.isMultiVersion = bl;
    }

    public Row getRow(Session session, long l2) {
        throw DbException.getUnsupportedException(this.toString());
    }

    public boolean isHidden() {
        return this.table.isHidden();
    }
}

