/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.h2.command.dml.Query;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.table.Column;
import org.h2.util.StatementBuilder;
import org.h2.value.CompareMode;
import org.h2.value.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class IndexCondition {
    public static final int EQUALITY = 1;
    public static final int START = 2;
    public static final int END = 4;
    public static final int RANGE = 6;
    public static final int ALWAYS_FALSE = 8;
    private Column do;
    private int for;
    private Expression int;
    private List if;
    private Query a;

    private IndexCondition(int n2, ExpressionColumn expressionColumn, Expression expression) {
        this.for = n2;
        this.do = expressionColumn == null ? null : expressionColumn.getColumn();
        this.int = expression;
    }

    public static IndexCondition get(int n2, ExpressionColumn expressionColumn, Expression expression) {
        return new IndexCondition(n2, expressionColumn, expression);
    }

    public static IndexCondition getInList(ExpressionColumn expressionColumn, List list) {
        IndexCondition indexCondition = new IndexCondition(9, expressionColumn, null);
        indexCondition.if = list;
        return indexCondition;
    }

    public static IndexCondition getInQuery(ExpressionColumn expressionColumn, Query query) {
        IndexCondition indexCondition = new IndexCondition(10, expressionColumn, null);
        indexCondition.a = query;
        return indexCondition;
    }

    public Value getCurrentValue(Session session) {
        return this.int.getValue(session);
    }

    public Value[] getCurrentValueList(Session session) {
        Object object2;
        HashSet<Value> hashSet = new HashSet<Value>();
        for (Object object2 : this.if) {
            Value value = ((Expression)object2).getValue(session);
            value = this.do.convert(value);
            hashSet.add(value);
        }
        Value[] valueArray = new Value[hashSet.size()];
        hashSet.toArray(valueArray);
        object2 = session.getDatabase().getCompareMode();
        Arrays.sort(valueArray, new Comparator((CompareMode)object2){
            final /* synthetic */ CompareMode val$mode;
            {
                this.val$mode = compareMode;
            }

            public int compare(Value value, Value value2) {
                return value.compareTo(value2, this.val$mode);
            }
        });
        return valueArray;
    }

    public ResultInterface getCurrentResult(Session session) {
        return this.a.query(0);
    }

    public String getSQL() {
        if (this.for == 8) {
            return "FALSE";
        }
        StatementBuilder statementBuilder = new StatementBuilder();
        statementBuilder.append(this.do.getSQL());
        switch (this.for) {
            case 0: {
                statementBuilder.append(" = ");
                break;
            }
            case 16: {
                statementBuilder.append(" IS ");
                break;
            }
            case 1: {
                statementBuilder.append(" >= ");
                break;
            }
            case 2: {
                statementBuilder.append(" > ");
                break;
            }
            case 3: {
                statementBuilder.append(" <= ");
                break;
            }
            case 4: {
                statementBuilder.append(" < ");
                break;
            }
            case 9: {
                statementBuilder.append(" IN(");
                for (Expression expression : this.if) {
                    statementBuilder.appendExceptFirst(", ");
                    statementBuilder.append(expression.getSQL());
                }
                statementBuilder.append(')');
                break;
            }
            case 10: {
                statementBuilder.append(" IN(");
                statementBuilder.append(this.a.getPlanSQL());
                statementBuilder.append(')');
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.for);
            }
        }
        if (this.int != null) {
            statementBuilder.append(this.int.getSQL());
        }
        return statementBuilder.toString();
    }

    public int getMask(ArrayList arrayList) {
        switch (this.for) {
            case 8: {
                return 8;
            }
            case 0: 
            case 16: {
                return 1;
            }
            case 9: 
            case 10: {
                if (arrayList.size() > 1 && !this.do.getTable().getTableType().equals("TABLE")) {
                    return 0;
                }
                return 1;
            }
            case 1: 
            case 2: {
                return 2;
            }
            case 3: 
            case 4: {
                return 4;
            }
        }
        throw DbException.throwInternalError("type=" + this.for);
    }

    public boolean isAlwaysFalse() {
        return this.for == 8;
    }

    public boolean isStart() {
        switch (this.for) {
            case 0: 
            case 1: 
            case 2: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public boolean isEnd() {
        switch (this.for) {
            case 0: 
            case 3: 
            case 4: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public int getCompareType() {
        return this.for;
    }

    public Column getColumn() {
        return this.do;
    }

    public boolean isEvaluatable() {
        if (this.int != null) {
            return this.int.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR);
        }
        if (this.if != null) {
            for (Expression expression : this.if) {
                if (expression.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR)) continue;
                return false;
            }
            return true;
        }
        return this.a.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR);
    }
}

