/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.ArrayList;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.MultiVersionCursor;
import org.h2.index.TreeIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.RegularTable;
import org.h2.table.Table;
import org.h2.value.Value;
import org.h2.value.ValueNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MultiVersionIndex
implements Index {
    private final Index do;
    private final TreeIndex int;
    private final RegularTable if;
    private final Object a;
    private final Column for;

    public MultiVersionIndex(Index index, RegularTable regularTable) {
        this.do = index;
        this.if = regularTable;
        IndexType indexType = IndexType.createNonUnique(false);
        this.int = new TreeIndex(regularTable, -1, "DELTA", index.getIndexColumns(), indexType);
        this.int.setMultiVersion(true);
        this.a = index.getDatabase();
        this.for = index.getColumns()[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Session session, Row row) {
        Object object = this.a;
        synchronized (object) {
            this.do.add(session, row);
            if (!this.a(session, row) && row.getSessionId() != 0) {
                this.int.add(session, row);
            }
        }
    }

    public int getRootPageId() {
        return this.do.getRootPageId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Session session) {
        Object object = this.a;
        synchronized (object) {
            this.do.close(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        Object object = this.a;
        synchronized (object) {
            Cursor cursor = this.do.find(session, searchRow, searchRow2);
            Cursor cursor2 = this.int.find(session, searchRow, searchRow2);
            return new MultiVersionCursor(session, this, cursor, cursor2, this.a);
        }
    }

    public Cursor findNext(Session session, SearchRow searchRow, SearchRow searchRow2) {
        throw DbException.throwInternalError();
    }

    public boolean canFindNext() {
        return false;
    }

    public boolean canGetFirstOrLast() {
        return this.do.canGetFirstOrLast() && this.int.canGetFirstOrLast();
    }

    public Cursor findFirstOrLast(Session session, boolean bl) {
        SearchRow searchRow;
        if (bl) {
            Cursor cursor = this.find(session, null, null);
            while (cursor.next()) {
                SearchRow searchRow2 = cursor.getSearchRow();
                Value value = searchRow2.getValue(this.for.getColumnId());
                if (value == ValueNull.INSTANCE) continue;
                return cursor;
            }
            return cursor;
        }
        Cursor cursor = this.do.findFirstOrLast(session, false);
        Cursor cursor2 = this.int.findFirstOrLast(session, false);
        MultiVersionCursor multiVersionCursor = new MultiVersionCursor(session, this, cursor, cursor2, this.a);
        multiVersionCursor.loadCurrent();
        while (multiVersionCursor.previous() && (searchRow = multiVersionCursor.getSearchRow()) != null) {
            Value value = searchRow.getValue(this.for.getColumnId());
            if (value == ValueNull.INSTANCE) continue;
            return multiVersionCursor;
        }
        return multiVersionCursor;
    }

    public double getCost(Session session, int[] nArray) {
        return this.do.getCost(session, nArray);
    }

    public boolean needRebuild() {
        return this.do.needRebuild();
    }

    public boolean isUncommittedFromOtherSession(Session session, Row row) {
        Cursor cursor = this.int.find(session, row, row);
        if (cursor.next()) {
            Row row2 = cursor.get();
            return row2.getSessionId() != session.getId();
        }
        return false;
    }

    private boolean a(Session session, Row row) {
        Cursor cursor = this.int.find(session, row, row);
        while (cursor.next()) {
            Row row2 = cursor.get();
            if (row2.getKey() != row.getKey() || row2.getVersion() != row.getVersion()) continue;
            if (row2 != row && this.if.getScanIndex(session).compareRows(row2, row) != 0) {
                row.setVersion(row2.getVersion() + 1);
                continue;
            }
            this.int.remove(session, row2);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Session session, Row row) {
        Object object = this.a;
        synchronized (object) {
            this.do.remove(session, row);
            if (!this.a(session, row)) {
                this.int.add(session, row);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Session session) {
        Object object = this.a;
        synchronized (object) {
            this.do.remove(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(Session session) {
        Object object = this.a;
        synchronized (object) {
            this.int.truncate(session);
            this.do.truncate(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(int n2, Row row) {
        Object object = this.a;
        synchronized (object) {
            this.a(null, row);
        }
    }

    public int compareKeys(SearchRow searchRow, SearchRow searchRow2) {
        return this.do.compareKeys(searchRow, searchRow2);
    }

    public int compareRows(SearchRow searchRow, SearchRow searchRow2) {
        return this.do.compareRows(searchRow, searchRow2);
    }

    public int getColumnIndex(Column column) {
        return this.do.getColumnIndex(column);
    }

    public String getColumnListSQL() {
        return this.do.getColumnListSQL();
    }

    public Column[] getColumns() {
        return this.do.getColumns();
    }

    public IndexColumn[] getIndexColumns() {
        return this.do.getIndexColumns();
    }

    public long getCostRangeIndex(int[] nArray, long l2) {
        return this.do.getCostRangeIndex(nArray, l2);
    }

    public String getCreateSQL() {
        return this.do.getCreateSQL();
    }

    public String getCreateSQLForCopy(Table table, String string) {
        return this.do.getCreateSQLForCopy(table, string);
    }

    public String getDropSQL() {
        return this.do.getDropSQL();
    }

    public DbException getDuplicateKeyException() {
        return this.do.getDuplicateKeyException();
    }

    public IndexType getIndexType() {
        return this.do.getIndexType();
    }

    public int getLookupCost(long l2) {
        return this.do.getLookupCost(l2);
    }

    public String getPlanSQL() {
        return this.do.getPlanSQL();
    }

    public long getRowCount(Session session) {
        return this.do.getRowCount(session);
    }

    public Table getTable() {
        return this.do.getTable();
    }

    public int getType() {
        return this.do.getType();
    }

    public boolean containsNullAndAllowMultipleNull(SearchRow searchRow) {
        return this.do.containsNullAndAllowMultipleNull(searchRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildrenAndResources(Session session) {
        Object object = this.a;
        synchronized (object) {
            this.if.removeIndex(this);
            this.remove(session);
        }
    }

    public String getSQL() {
        return this.do.getSQL();
    }

    public Schema getSchema() {
        return this.do.getSchema();
    }

    public void checkRename() {
        this.do.checkRename();
    }

    public ArrayList getChildren() {
        return this.do.getChildren();
    }

    public String getComment() {
        return this.do.getComment();
    }

    public Database getDatabase() {
        return this.do.getDatabase();
    }

    public int getId() {
        return this.do.getId();
    }

    public long getModificationId() {
        return this.do.getModificationId();
    }

    public String getName() {
        return this.do.getName();
    }

    public boolean isTemporary() {
        return this.do.isTemporary();
    }

    public void rename(String string) {
        this.do.rename(string);
    }

    public void setComment(String string) {
        this.do.setComment(string);
    }

    public void setModified() {
        this.do.setModified();
    }

    public void setTemporary(boolean bl) {
        this.do.setTemporary(bl);
    }

    public long getRowCountApproximation() {
        return this.do.getRowCountApproximation();
    }

    public Index getBaseIndex() {
        return this.do;
    }

    public Row getRow(Session session, long l2) {
        return this.do.getRow(session, l2);
    }

    public boolean isHidden() {
        return this.do.isHidden();
    }
}

