/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.ArrayList;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.HashIndex;
import org.h2.index.IndexType;
import org.h2.index.NonUniqueHashCursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.IndexColumn;
import org.h2.table.RegularTable;
import org.h2.util.New;
import org.h2.util.ValueHashMap;
import org.h2.value.Value;

public class NonUniqueHashIndex
extends HashIndex {
    private ValueHashMap cC;
    private RegularTable cB;
    private long cA;

    public NonUniqueHashIndex(RegularTable regularTable, int n2, String string, IndexColumn[] indexColumnArray, IndexType indexType) {
        super(regularTable, n2, string, indexColumnArray, indexType);
        this.cB = regularTable;
        this.g();
    }

    private void g() {
        this.cC = ValueHashMap.newInstance();
        this.cA = 0L;
    }

    public void truncate(Session session) {
        this.g();
    }

    public void add(Session session, Row row) {
        Value value = row.getValue(this.indexColumn);
        ArrayList arrayList = (ArrayList)this.cC.get(value);
        if (arrayList == null) {
            arrayList = New.arrayList();
            this.cC.put(value, arrayList);
        }
        arrayList.add(row.getKey());
        ++this.cA;
    }

    public void remove(Session session, Row row) {
        if (this.cA == 1L) {
            this.g();
        } else {
            Value value = row.getValue(this.indexColumn);
            ArrayList arrayList = (ArrayList)this.cC.get(value);
            if (arrayList.size() == 1) {
                this.cC.remove(value);
            } else {
                arrayList.remove(row.getKey());
            }
            --this.cA;
        }
    }

    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        if (searchRow == null || searchRow2 == null) {
            throw DbException.throwInternalError();
        }
        if (searchRow != searchRow2 && this.compareKeys(searchRow, searchRow2) != 0) {
            throw DbException.throwInternalError();
        }
        ArrayList arrayList = (ArrayList)this.cC.get(searchRow.getValue(this.indexColumn));
        return new NonUniqueHashCursor(session, this.cB, arrayList);
    }

    public long getRowCount(Session session) {
        return this.cA;
    }

    public long getRowCountApproximation() {
        return this.cA;
    }
}

