/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import org.h2.index.PageBtreeCursor;
import org.h2.index.PageBtreeIndex;
import org.h2.index.PageBtreeLeaf;
import org.h2.result.SearchRow;
import org.h2.store.Data;
import org.h2.store.Page;

public abstract class PageBtree
extends Page {
    static final int ROOT = 0;
    static final int UNKNOWN_ROWCOUNT = -1;
    protected final PageBtreeIndex index;
    protected int parentPageId;
    protected final Data data;
    protected int[] offsets;
    protected int entryCount;
    protected SearchRow[] rows;
    protected int start;
    protected boolean onlyPosition;
    protected boolean written;
    protected int memoryEstimated;

    PageBtree(PageBtreeIndex pageBtreeIndex, int n2, Data data) {
        this.index = pageBtreeIndex;
        this.data = data;
        this.setPos(n2);
        this.memoryEstimated = pageBtreeIndex.getMemoryPerPage();
    }

    abstract int getRowCount();

    abstract void setRowCountStored(int var1);

    int find(SearchRow searchRow, boolean bl, boolean bl2, boolean bl3) {
        if (searchRow == null) {
            return 0;
        }
        int n2 = 0;
        int n3 = this.entryCount;
        int n4 = 1;
        while (n2 < n3) {
            int n5 = n2 + n3 >>> 1;
            SearchRow searchRow2 = this.getRow(n5);
            n4 = this.index.compareRows(searchRow2, searchRow);
            if (n4 == 0) {
                if (bl2 && this.index.indexType.isUnique() && !this.index.containsNullAndAllowMultipleNull(searchRow)) {
                    throw this.index.getDuplicateKeyException();
                }
                if (bl3 && (n4 = this.index.compareKeys(searchRow2, searchRow)) == 0) {
                    return n5;
                }
            }
            if (n4 > 0 || !bl && n4 == 0) {
                n3 = n5;
                continue;
            }
            n2 = n5 + 1;
        }
        return n2;
    }

    abstract int addRowTry(SearchRow var1);

    abstract void find(PageBtreeCursor var1, SearchRow var2, boolean var3);

    abstract void last(PageBtreeCursor var1);

    SearchRow getRow(int n2) {
        SearchRow searchRow = this.rows[n2];
        if (searchRow == null) {
            this.rows[n2] = searchRow = this.index.readRow(this.data, this.offsets[n2], this.onlyPosition, true);
        } else if (!this.index.hasData(searchRow)) {
            this.rows[n2] = searchRow = this.index.readRow(searchRow.getKey());
        }
        return searchRow;
    }

    abstract PageBtree split(int var1);

    void setPageId(int n2) {
        this.changeCount = this.index.getPageStore().getChangeCount();
        this.written = false;
        this.index.getPageStore().removeRecord(this.getPos());
        this.setPos(n2);
        this.index.getPageStore().logUndo(this, null);
        this.remapChildren();
    }

    abstract PageBtreeLeaf getFirstLeaf();

    abstract PageBtreeLeaf getLastLeaf();

    void setParentPageId(int n2) {
        this.index.getPageStore().logUndo(this, this.data);
        this.changeCount = this.index.getPageStore().getChangeCount();
        this.written = false;
        this.parentPageId = n2;
    }

    abstract void remapChildren();

    abstract SearchRow remove(SearchRow var1);

    abstract void freeRecursive();

    protected void readAllRows() {
        for (int i2 = 0; i2 < this.entryCount; ++i2) {
            SearchRow searchRow = this.rows[i2];
            if (searchRow != null) continue;
            this.rows[i2] = searchRow = this.index.readRow(this.data, this.offsets[i2], this.onlyPosition, false);
        }
    }

    public int getMemory() {
        return this.memoryEstimated;
    }

    public boolean canRemove() {
        return this.changeCount < this.index.getPageStore().getChangeCount();
    }
}

