/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.PageBtree;
import org.h2.index.PageBtreeCursor;
import org.h2.index.PageBtreeLeaf;
import org.h2.index.PageBtreeNode;
import org.h2.index.PageIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.store.Data;
import org.h2.store.Page;
import org.h2.store.PageStore;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.RegularTable;
import org.h2.util.MathUtils;
import org.h2.value.Value;
import org.h2.value.ValueNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PageBtreeIndex
extends PageIndex {
    private PageStore ch;
    private RegularTable ck;
    private boolean cf;
    private long cg;
    private int cj;
    private int ci;

    public PageBtreeIndex(RegularTable regularTable, int n2, String string, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, Session session) {
        this.initBaseIndex(regularTable, n2, string, indexColumnArray, indexType);
        this.ck = regularTable;
        if (!this.database.isPersistent() || n2 < 0) {
            throw DbException.throwInternalError("" + string);
        }
        this.ch = this.database.getPageStore();
        this.ch.addIndex(this);
        if (bl) {
            this.rootPageId = this.ch.allocatePage();
            this.cf = true;
            this.ch.addMeta(this, session);
            PageBtreeLeaf pageBtreeLeaf = PageBtreeLeaf.create(this, this.rootPageId, 0);
            this.ch.logUndo(pageBtreeLeaf, null);
            this.ch.update(pageBtreeLeaf);
        } else {
            this.rootPageId = this.ch.getRootPageId(n2);
            PageBtree pageBtree = this.getPage(this.rootPageId);
            this.cg = pageBtree.getRowCount();
            if (this.cg == 0L && this.ch.isRecoveryRunning()) {
                this.cf = true;
            }
        }
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("opened {0} rows: {1}", this.getName(), this.cg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Session session, Row row) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} add {1}", this.getName(), row);
        }
        SearchRow searchRow = this.if(row);
        try {
            this.a(searchRow);
        }
        finally {
            this.ch.incrementChangeCount();
        }
    }

    private void a(SearchRow searchRow) {
        PageBtree pageBtree;
        int n2;
        while ((n2 = (pageBtree = this.getPage(this.rootPageId)).addRowTry(searchRow)) != -1) {
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("split {0}", n2);
            }
            SearchRow searchRow2 = pageBtree.getRow(n2 - 1);
            this.ch.logUndo(pageBtree, pageBtree.data);
            PageBtree pageBtree2 = pageBtree;
            PageBtree pageBtree3 = pageBtree.split(n2);
            this.ch.logUndo(pageBtree3, null);
            int n3 = this.ch.allocatePage();
            pageBtree2.setPageId(n3);
            pageBtree2.setParentPageId(this.rootPageId);
            pageBtree3.setParentPageId(this.rootPageId);
            PageBtreeNode pageBtreeNode = PageBtreeNode.create(this, this.rootPageId, 0);
            this.ch.logUndo(pageBtreeNode, null);
            pageBtreeNode.init(pageBtree2, searchRow2, pageBtree3);
            this.ch.update(pageBtree2);
            this.ch.update(pageBtree3);
            this.ch.update(pageBtreeNode);
            pageBtree = pageBtreeNode;
        }
        this.d();
        ++this.cg;
    }

    private SearchRow if(Row row) {
        SearchRow searchRow = this.table.getTemplateSimpleRow(this.columns.length == 1);
        searchRow.setKeyAndVersion(row);
        for (Column column : this.columns) {
            int n2 = column.getColumnId();
            searchRow.setValue(n2, row.getValue(n2));
        }
        return searchRow;
    }

    PageBtree getPage(int n2) {
        Page page = this.ch.getPage(n2);
        if (page == null) {
            PageBtreeLeaf pageBtreeLeaf = PageBtreeLeaf.create(this, n2, 0);
            this.ch.logUndo(pageBtreeLeaf, null);
            this.ch.update(pageBtreeLeaf);
            return pageBtreeLeaf;
        }
        if (!(page instanceof PageBtree)) {
            throw DbException.get(90030, "" + page);
        }
        return (PageBtree)page;
    }

    public boolean canGetFirstOrLast() {
        return true;
    }

    public Cursor findNext(Session session, SearchRow searchRow, SearchRow searchRow2) {
        return this.a(session, searchRow, true, searchRow2);
    }

    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        return this.a(session, searchRow, false, searchRow2);
    }

    private Cursor a(Session session, SearchRow searchRow, boolean bl, SearchRow searchRow2) {
        if (SysProperties.CHECK && this.ch == null) {
            throw DbException.get(90007);
        }
        PageBtree pageBtree = this.getPage(this.rootPageId);
        PageBtreeCursor pageBtreeCursor = new PageBtreeCursor(session, this, searchRow2);
        pageBtree.find(pageBtreeCursor, searchRow, bl);
        return pageBtreeCursor;
    }

    public Cursor findFirstOrLast(Session session, boolean bl) {
        SearchRow searchRow;
        if (bl) {
            Cursor cursor = this.a(session, null, false, null);
            while (cursor.next()) {
                SearchRow searchRow2 = cursor.getSearchRow();
                Value value = searchRow2.getValue(this.columnIds[0]);
                if (value == ValueNull.INSTANCE) continue;
                return cursor;
            }
            return cursor;
        }
        PageBtree pageBtree = this.getPage(this.rootPageId);
        PageBtreeCursor pageBtreeCursor = new PageBtreeCursor(session, this, null);
        pageBtree.last(pageBtreeCursor);
        pageBtreeCursor.previous();
        while ((searchRow = pageBtreeCursor.getSearchRow()) != null) {
            Value value = searchRow.getValue(this.columnIds[0]);
            if (value != ValueNull.INSTANCE) {
                return pageBtreeCursor;
            }
            if (pageBtreeCursor.previous()) continue;
        }
        return pageBtreeCursor;
    }

    public double getCost(Session session, int[] nArray) {
        return 10L * this.getCostRangeIndex(nArray, this.ck.getRowCount(session));
    }

    public boolean needRebuild() {
        return this.cf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Session session, Row row) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} remove {1}", this.getName(), row);
        }
        if (this.ck.getContainsLargeObject()) {
            int n2 = row.getColumnCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                Value value = row.getValue(i2);
                if (!value.isLinked()) continue;
                session.unlinkAtCommit(value);
            }
        }
        if (this.cg == 1L) {
            this.e();
        } else {
            try {
                PageBtree pageBtree = this.getPage(this.rootPageId);
                pageBtree.remove(row);
                this.d();
                --this.cg;
            }
            finally {
                this.ch.incrementChangeCount();
            }
        }
    }

    public void remove(Session session) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("remove");
        }
        this.e();
        this.ch.free(this.rootPageId);
        this.ch.removeMeta(this, session);
    }

    public void truncate(Session session) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("truncate");
        }
        this.e();
        if (this.ck.getContainsLargeObject()) {
            this.database.getLobStorage().removeAllForTable(this.table.getId());
        }
        this.ck.setRowCount(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void e() {
        try {
            PageBtree pageBtree = this.getPage(this.rootPageId);
            pageBtree.freeRecursive();
            pageBtree = PageBtreeLeaf.create(this, this.rootPageId, 0);
            this.ch.removeRecord(this.rootPageId);
            this.ch.update(pageBtree);
            this.cg = 0L;
        }
        finally {
            this.ch.incrementChangeCount();
        }
    }

    public void checkRename() {
    }

    public Row getRow(Session session, long l2) {
        return this.ck.getRow(session, l2);
    }

    PageStore getPageStore() {
        return this.ch;
    }

    public long getRowCountApproximation() {
        return this.ck.getRowCountApproximation();
    }

    public long getRowCount(Session session) {
        return this.cg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Session session) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("close");
        }
        try {
            this.writeRowCount();
        }
        finally {
            this.ch.incrementChangeCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SearchRow readRow(Data data, int n2, boolean bl, boolean bl2) {
        Data data2 = data;
        synchronized (data2) {
            data.setPos(n2);
            long l2 = data.readVarLong();
            if (bl) {
                if (bl2) {
                    return this.ck.getRow(null, l2);
                }
                SearchRow searchRow = this.table.getTemplateSimpleRow(true);
                searchRow.setKey(l2);
                return searchRow;
            }
            SearchRow searchRow = this.table.getTemplateSimpleRow(this.columns.length == 1);
            searchRow.setKey(l2);
            for (Column column : this.columns) {
                int n3 = column.getColumnId();
                searchRow.setValue(n3, data.readValue());
            }
            return searchRow;
        }
    }

    SearchRow readRow(long l2) {
        return this.ck.getRow(null, l2);
    }

    void writeRow(Data data, int n2, SearchRow searchRow, boolean bl) {
        data.setPos(n2);
        data.writeVarLong(searchRow.getKey());
        if (!bl) {
            for (Column column : this.columns) {
                int n3 = column.getColumnId();
                data.writeValue(searchRow.getValue(n3));
            }
        }
    }

    int getRowSize(Data data, SearchRow searchRow, boolean bl) {
        int n2 = Data.getVarLongLen(searchRow.getKey());
        if (!bl) {
            for (Column column : this.columns) {
                Value value = searchRow.getValue(column.getColumnId());
                n2 += data.getValueLen(value);
            }
        }
        return n2;
    }

    public boolean canFindNext() {
        return true;
    }

    void setRootPageId(Session session, int n2) {
        this.ch.removeMeta(this, session);
        this.rootPageId = n2;
        this.ch.addMeta(this, session);
        this.ch.addIndex(this);
    }

    private void d() {
        PageBtree pageBtree = this.getPage(this.rootPageId);
        pageBtree.setRowCountStored(-1);
    }

    public void writeRowCount() {
        PageBtree pageBtree = this.getPage(this.rootPageId);
        pageBtree.setRowCountStored(MathUtils.convertLongToInt(this.cg));
    }

    boolean hasData(SearchRow searchRow) {
        return searchRow.getValue(this.columns[0].getColumnId()) != null;
    }

    int getMemoryPerPage() {
        return this.cj;
    }

    void memoryChange(int n2) {
        this.cj = this.ci < 64 ? (this.cj += (n2 - this.cj) / ++this.ci) : (this.cj += (n2 > this.cj ? 1 : -1) + (n2 - this.cj) / 64);
    }
}

