/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.Arrays;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.index.PageBtree;
import org.h2.index.PageBtreeCursor;
import org.h2.index.PageBtreeIndex;
import org.h2.index.PageBtreeNode;
import org.h2.message.DbException;
import org.h2.result.SearchRow;
import org.h2.store.Data;
import org.h2.store.Page;
import org.h2.store.PageStore;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PageBtreeLeaf
extends PageBtree {
    private static final int k = 2;
    private final boolean i;
    private boolean j;

    private PageBtreeLeaf(PageBtreeIndex pageBtreeIndex, int n2, Data data) {
        super(pageBtreeIndex, n2, data);
        this.i = pageBtreeIndex.getDatabase().getSettings().optimizeUpdate;
    }

    public static Page read(PageBtreeIndex pageBtreeIndex, Data data, int n2) {
        PageBtreeLeaf pageBtreeLeaf = new PageBtreeLeaf(pageBtreeIndex, n2, data);
        pageBtreeLeaf.new();
        return pageBtreeLeaf;
    }

    static PageBtreeLeaf create(PageBtreeIndex pageBtreeIndex, int n2, int n3) {
        PageBtreeLeaf pageBtreeLeaf = new PageBtreeLeaf(pageBtreeIndex, n2, pageBtreeIndex.getPageStore().createData());
        pageBtreeIndex.getPageStore().logUndo(pageBtreeLeaf, null);
        pageBtreeLeaf.rows = SearchRow.EMPTY_ARRAY;
        pageBtreeLeaf.parentPageId = n3;
        pageBtreeLeaf.for();
        pageBtreeLeaf.start = pageBtreeLeaf.data.length();
        return pageBtreeLeaf;
    }

    private void new() {
        this.data.reset();
        byte by = this.data.readByte();
        this.data.readShortInt();
        this.parentPageId = this.data.readInt();
        this.onlyPosition = (by & 0x10) == 0;
        int n2 = this.data.readVarInt();
        if (n2 != this.index.getId()) {
            throw DbException.get(90030, "page:" + this.getPos() + " expected index:" + this.index.getId() + "got:" + n2);
        }
        this.entryCount = this.data.readShortInt();
        this.offsets = new int[this.entryCount];
        this.rows = new SearchRow[this.entryCount];
        for (int i2 = 0; i2 < this.entryCount; ++i2) {
            this.offsets[i2] = this.data.readShortInt();
        }
        this.start = this.data.length();
        this.written = true;
        this.j = true;
    }

    int addRowTry(SearchRow searchRow) {
        return this.a(searchRow, true);
    }

    private int a(SearchRow searchRow, boolean bl) {
        int n2;
        int n3;
        int n4;
        int n5 = this.index.getRowSize(this.data, searchRow, this.onlyPosition);
        int n6 = this.index.getPageStore().getPageSize();
        int n7 = n4 = this.entryCount == 0 ? n6 : this.offsets[this.entryCount - 1];
        if (n4 - n5 < this.start + 2) {
            if (bl && this.entryCount > 1) {
                int n8 = this.find(searchRow, false, true, true);
                if (this.entryCount < 5) {
                    return this.entryCount / 2;
                }
                int n9 = this.entryCount / 3;
                return n8 < n9 ? n9 : (n8 >= 2 * n9 ? 2 * n9 : n8);
            }
            this.readAllRows();
            this.onlyPosition = true;
            n3 = n6;
            for (n2 = 0; n2 < this.entryCount; ++n2) {
                this.offsets[n2] = n3 -= this.index.getRowSize(this.data, this.getRow(n2), true);
            }
            n4 = this.entryCount == 0 ? n6 : this.offsets[this.entryCount - 1];
            n5 = this.index.getRowSize(this.data, searchRow, true);
            if (SysProperties.CHECK && n4 - n5 < this.start + 2) {
                throw DbException.throwInternalError();
            }
        }
        this.index.getPageStore().logUndo(this, this.data);
        if (!this.i) {
            this.readAllRows();
        }
        this.changeCount = this.index.getPageStore().getChangeCount();
        this.written = false;
        n3 = this.entryCount == 0 ? 0 : this.find(searchRow, false, true, true);
        this.start += 2;
        n2 = (n3 == 0 ? n6 : this.offsets[n3 - 1]) - n5;
        if (this.i && this.j) {
            if (this.entryCount > 0) {
                byte[] byArray = this.data.getBytes();
                int n10 = this.offsets[this.entryCount - 1];
                int n11 = n2;
                System.arraycopy(byArray, n10, byArray, n10 - n5, n11 - n10 + n5);
            }
            this.index.writeRow(this.data, n2, searchRow, this.onlyPosition);
        }
        this.offsets = PageBtreeLeaf.insert(this.offsets, this.entryCount, n3, n2);
        PageBtreeLeaf.add(this.offsets, n3 + 1, this.entryCount + 1, -n5);
        this.rows = (SearchRow[])PageBtreeLeaf.insert(this.rows, this.entryCount, n3, searchRow);
        ++this.entryCount;
        this.index.getPageStore().update(this);
        this.try();
        return -1;
    }

    private void a(int n2) {
        if (!this.i) {
            this.readAllRows();
        }
        this.index.getPageStore().logUndo(this, this.data);
        --this.entryCount;
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
        if (this.entryCount <= 0) {
            DbException.throwInternalError();
        }
        int n3 = n2 > 0 ? this.offsets[n2 - 1] : this.index.getPageStore().getPageSize();
        int n4 = n3 - this.offsets[n2];
        this.start -= 2;
        if (this.i && this.j) {
            byte[] byArray = this.data.getBytes();
            int n5 = this.offsets[this.entryCount];
            System.arraycopy(byArray, n5, byArray, n5 + n4, this.offsets[n2] - n5);
            Arrays.fill(byArray, n5, n5 + n4, (byte)0);
        }
        this.offsets = PageBtreeLeaf.remove(this.offsets, this.entryCount + 1, n2);
        PageBtreeLeaf.add(this.offsets, n2, this.entryCount, n4);
        this.rows = (SearchRow[])PageBtreeLeaf.remove(this.rows, this.entryCount + 1, n2);
        this.try();
    }

    int getEntryCount() {
        return this.entryCount;
    }

    PageBtree split(int n2) {
        int n3 = this.index.getPageStore().allocatePage();
        PageBtreeLeaf pageBtreeLeaf = PageBtreeLeaf.create(this.index, n3, this.parentPageId);
        int n4 = n2;
        while (n4 < this.entryCount) {
            pageBtreeLeaf.a(this.getRow(n2), false);
            this.a(n2);
        }
        return pageBtreeLeaf;
    }

    PageBtreeLeaf getFirstLeaf() {
        return this;
    }

    PageBtreeLeaf getLastLeaf() {
        return this;
    }

    SearchRow remove(SearchRow searchRow) {
        int n2 = this.find(searchRow, false, false, true);
        SearchRow searchRow2 = this.getRow(n2);
        if (this.index.compareRows(searchRow, searchRow2) != 0 || searchRow2.getKey() != searchRow.getKey()) {
            throw DbException.get(90112, this.index.getSQL() + ": " + searchRow);
        }
        this.index.getPageStore().logUndo(this, this.data);
        if (this.entryCount == 1) {
            return searchRow;
        }
        this.a(n2);
        this.index.getPageStore().update(this);
        if (n2 == this.entryCount) {
            return this.getRow(n2 - 1);
        }
        return null;
    }

    void freeRecursive() {
        this.index.getPageStore().logUndo(this, this.data);
        this.index.getPageStore().free(this.getPos());
    }

    int getRowCount() {
        return this.entryCount;
    }

    void setRowCountStored(int n2) {
    }

    public void write() {
        this.int();
        this.index.getPageStore().writePage(this.getPos(), this.data);
    }

    private void for() {
        this.data.reset();
        this.data.writeByte((byte)(4 | (this.onlyPosition ? 0 : 16)));
        this.data.writeShortInt(0);
        this.data.writeInt(this.parentPageId);
        this.data.writeVarInt(this.index.getId());
        this.data.writeShortInt(this.entryCount);
    }

    private void int() {
        int n2;
        if (this.written) {
            return;
        }
        if (!this.i) {
            this.readAllRows();
        }
        this.for();
        for (n2 = 0; n2 < this.entryCount; ++n2) {
            this.data.writeShortInt(this.offsets[n2]);
        }
        if (!this.j || !this.i) {
            for (n2 = 0; n2 < this.entryCount; ++n2) {
                this.index.writeRow(this.data, this.offsets[n2], this.rows[n2], this.onlyPosition);
            }
            this.j = true;
        }
        this.written = true;
        this.try();
    }

    void find(PageBtreeCursor pageBtreeCursor, SearchRow searchRow, boolean bl) {
        int n2 = this.find(searchRow, bl, false, false);
        if (n2 > this.entryCount) {
            if (this.parentPageId == 0) {
                return;
            }
            PageBtreeNode pageBtreeNode = (PageBtreeNode)this.index.getPage(this.parentPageId);
            pageBtreeNode.find(pageBtreeCursor, searchRow, bl);
            return;
        }
        pageBtreeCursor.setCurrent(this, n2);
    }

    void last(PageBtreeCursor pageBtreeCursor) {
        pageBtreeCursor.setCurrent(this, this.entryCount - 1);
    }

    void remapChildren() {
    }

    void nextPage(PageBtreeCursor pageBtreeCursor) {
        if (this.parentPageId == 0) {
            pageBtreeCursor.setCurrent(null, 0);
            return;
        }
        PageBtreeNode pageBtreeNode = (PageBtreeNode)this.index.getPage(this.parentPageId);
        pageBtreeNode.nextPage(pageBtreeCursor, this.getPos());
    }

    void previousPage(PageBtreeCursor pageBtreeCursor) {
        if (this.parentPageId == 0) {
            pageBtreeCursor.setCurrent(null, 0);
            return;
        }
        PageBtreeNode pageBtreeNode = (PageBtreeNode)this.index.getPage(this.parentPageId);
        pageBtreeNode.previousPage(pageBtreeCursor, this.getPos());
    }

    public String toString() {
        return "page[" + this.getPos() + "] b-tree leaf table:" + this.index.getId() + " entries:" + this.entryCount;
    }

    public void moveTo(Session session, int n2) {
        PageStore pageStore = this.index.getPageStore();
        this.readAllRows();
        PageBtreeLeaf pageBtreeLeaf = PageBtreeLeaf.create(this.index, n2, this.parentPageId);
        pageStore.logUndo(this, this.data);
        pageStore.logUndo(pageBtreeLeaf, null);
        pageBtreeLeaf.rows = this.rows;
        pageBtreeLeaf.entryCount = this.entryCount;
        pageBtreeLeaf.offsets = this.offsets;
        pageBtreeLeaf.onlyPosition = this.onlyPosition;
        pageBtreeLeaf.parentPageId = this.parentPageId;
        pageBtreeLeaf.start = this.start;
        pageStore.update(pageBtreeLeaf);
        if (this.parentPageId == 0) {
            this.index.setRootPageId(session, n2);
        } else {
            PageBtreeNode pageBtreeNode = (PageBtreeNode)pageStore.getPage(this.parentPageId);
            pageBtreeNode.moveChild(this.getPos(), n2);
        }
        pageStore.free(this.getPos());
    }

    private void try() {
        int n2 = 184 + this.index.getPageStore().getPageSize();
        if (this.rows != null) {
            n2 += this.getEntryCount() * 12;
            for (int i2 = 0; i2 < this.entryCount; ++i2) {
                SearchRow searchRow = this.rows[i2];
                if (searchRow == null) continue;
                n2 += searchRow.getMemory();
            }
        }
        this.index.memoryChange(n2 >> 2);
    }
}

