/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.index.PageBtree;
import org.h2.index.PageBtreeCursor;
import org.h2.index.PageBtreeIndex;
import org.h2.index.PageBtreeLeaf;
import org.h2.message.DbException;
import org.h2.result.SearchRow;
import org.h2.store.Data;
import org.h2.store.Page;
import org.h2.store.PageStore;
import org.h2.util.Utils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PageBtreeNode
extends PageBtree {
    private static final int q = 6;
    private static final int o = 10;
    private final boolean n;
    private int[] p;
    private int l = -1;
    private int m = -1;

    private PageBtreeNode(PageBtreeIndex pageBtreeIndex, int n2, Data data) {
        super(pageBtreeIndex, n2, data);
        this.n = pageBtreeIndex.getDatabase().getSettings().pageStoreInternalCount;
    }

    public static Page read(PageBtreeIndex pageBtreeIndex, Data data, int n2) {
        PageBtreeNode pageBtreeNode = new PageBtreeNode(pageBtreeIndex, n2, data);
        pageBtreeNode.else();
        return pageBtreeNode;
    }

    static PageBtreeNode create(PageBtreeIndex pageBtreeIndex, int n2, int n3) {
        PageBtreeNode pageBtreeNode = new PageBtreeNode(pageBtreeIndex, n2, pageBtreeIndex.getPageStore().createData());
        pageBtreeIndex.getPageStore().logUndo(pageBtreeNode, null);
        pageBtreeNode.parentPageId = n3;
        pageBtreeNode.byte();
        pageBtreeNode.start = pageBtreeNode.data.length() + 4;
        pageBtreeNode.rows = SearchRow.EMPTY_ARRAY;
        if (pageBtreeNode.n) {
            pageBtreeNode.m = 0;
        }
        return pageBtreeNode;
    }

    private void else() {
        this.data.reset();
        byte by = this.data.readByte();
        this.data.readShortInt();
        this.parentPageId = this.data.readInt();
        this.onlyPosition = (by & 0x10) == 0;
        int n2 = this.data.readVarInt();
        if (n2 != this.index.getId()) {
            throw DbException.get(90030, "page:" + this.getPos() + " expected index:" + this.index.getId() + "got:" + n2);
        }
        this.m = this.l = this.data.readInt();
        this.entryCount = this.data.readShortInt();
        this.p = new int[this.entryCount + 1];
        this.p[this.entryCount] = this.data.readInt();
        this.rows = this.entryCount == 0 ? SearchRow.EMPTY_ARRAY : new SearchRow[this.entryCount];
        this.offsets = Utils.newIntArray(this.entryCount);
        for (int i2 = 0; i2 < this.entryCount; ++i2) {
            this.p[i2] = this.data.readInt();
            this.offsets[i2] = this.data.readShortInt();
        }
        this.char();
        this.start = this.data.length();
        this.written = true;
    }

    private int a(SearchRow searchRow) {
        int n2;
        if (this.entryCount < 3) {
            return -1;
        }
        if (this.onlyPosition) {
            n2 = this.entryCount + 10;
        } else {
            int n3 = this.index.getRowSize(this.data, searchRow, this.onlyPosition);
            int n4 = this.index.getPageStore().getPageSize();
            int n5 = this.entryCount == 0 ? n4 : this.offsets[this.entryCount - 1];
            n2 = n5 - n3;
        }
        if (n2 < this.start + 6) {
            return this.entryCount / 2;
        }
        return -1;
    }

    private void a(int n2, int n3, SearchRow searchRow) {
        int n4;
        int n5;
        int n6 = this.index.getRowSize(this.data, searchRow, this.onlyPosition);
        int n7 = this.index.getPageStore().getPageSize();
        int n8 = n5 = this.entryCount == 0 ? n7 : this.offsets[this.entryCount - 1];
        if (n5 - n6 < this.start + 6) {
            this.readAllRows();
            this.onlyPosition = true;
            n4 = n7;
            for (int i2 = 0; i2 < this.entryCount; ++i2) {
                this.offsets[i2] = n4 -= this.index.getRowSize(this.data, this.getRow(i2), true);
            }
            n5 = this.entryCount == 0 ? n7 : this.offsets[this.entryCount - 1];
            n6 = this.index.getRowSize(this.data, searchRow, true);
            if (SysProperties.CHECK && n5 - n6 < this.start + 6) {
                throw DbException.throwInternalError();
            }
        }
        n4 = n5 - n6;
        if (this.entryCount > 0 && n2 < this.entryCount) {
            n4 = (n2 == 0 ? n7 : this.offsets[n2 - 1]) - n6;
        }
        this.rows = (SearchRow[])PageBtreeNode.insert(this.rows, this.entryCount, n2, searchRow);
        this.offsets = PageBtreeNode.insert(this.offsets, this.entryCount, n2, n4);
        PageBtreeNode.add(this.offsets, n2 + 1, this.entryCount + 1, -n6);
        this.p = PageBtreeNode.insert(this.p, this.entryCount + 1, n2 + 1, n3);
        this.start += 6;
        if (this.n && this.m != -1) {
            this.m += n4;
        }
        ++this.entryCount;
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
    }

    int addRowTry(SearchRow searchRow) {
        int n2;
        PageBtree pageBtree;
        int n3;
        while ((n3 = (pageBtree = this.index.getPage(this.p[n2 = this.find(searchRow, false, true, true)])).addRowTry(searchRow)) != -1) {
            SearchRow searchRow2 = pageBtree.getRow(n3 - 1);
            this.index.getPageStore().logUndo(this, this.data);
            int n4 = this.a(searchRow2);
            if (n4 != -1) {
                return n4;
            }
            PageBtree pageBtree2 = pageBtree.split(n3);
            this.readAllRows();
            this.a(n2, pageBtree2.getPos(), searchRow2);
            this.index.getPageStore().update(pageBtree);
            this.index.getPageStore().update(pageBtree2);
            this.index.getPageStore().update(this);
        }
        this.if(1);
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
        return -1;
    }

    private void if(int n2) {
        if (this.m != -1) {
            this.m += n2;
        }
        if (this.l != -1) {
            this.l = -1;
            this.index.getPageStore().logUndo(this, this.data);
            if (this.written) {
                this.byte();
            }
            this.index.getPageStore().update(this);
        }
    }

    PageBtree split(int n2) {
        int n3 = this.index.getPageStore().allocatePage();
        PageBtreeNode pageBtreeNode = PageBtreeNode.create(this.index, n3, this.parentPageId);
        this.index.getPageStore().logUndo(this, this.data);
        if (this.onlyPosition) {
            pageBtreeNode.onlyPosition = true;
        }
        int n4 = this.p[n2];
        this.readAllRows();
        int n5 = n2;
        while (n5 < this.entryCount) {
            pageBtreeNode.a(pageBtreeNode.entryCount, this.p[n2 + 1], this.getRow(n2));
            this.do(n2);
        }
        n5 = this.p[n2 - 1];
        this.do(n2 - 1);
        this.p[n2 - 1] = n5;
        if (pageBtreeNode.p == null) {
            pageBtreeNode.p = new int[1];
        }
        pageBtreeNode.p[0] = n4;
        pageBtreeNode.remapChildren();
        return pageBtreeNode;
    }

    protected void remapChildren() {
        for (int i2 = 0; i2 < this.entryCount + 1; ++i2) {
            int n2 = this.p[i2];
            PageBtree pageBtree = this.index.getPage(n2);
            pageBtree.setParentPageId(this.getPos());
            this.index.getPageStore().update(pageBtree);
        }
    }

    void init(PageBtree pageBtree, SearchRow searchRow, PageBtree pageBtree2) {
        this.entryCount = 0;
        this.p = new int[]{pageBtree.getPos()};
        this.rows = SearchRow.EMPTY_ARRAY;
        this.offsets = Utils.EMPTY_INT_ARRAY;
        this.a(0, pageBtree2.getPos(), searchRow);
        if (this.n) {
            this.m = pageBtree.getRowCount() + pageBtree2.getRowCount();
        }
        this.char();
    }

    void find(PageBtreeCursor pageBtreeCursor, SearchRow searchRow, boolean bl) {
        int n2 = this.find(searchRow, bl, false, false);
        if (n2 > this.entryCount) {
            if (this.parentPageId == 0) {
                return;
            }
            PageBtreeNode pageBtreeNode = (PageBtreeNode)this.index.getPage(this.parentPageId);
            pageBtreeNode.find(pageBtreeCursor, searchRow, bl);
            return;
        }
        PageBtree pageBtree = this.index.getPage(this.p[n2]);
        pageBtree.find(pageBtreeCursor, searchRow, bl);
    }

    void last(PageBtreeCursor pageBtreeCursor) {
        int n2 = this.p[this.entryCount];
        this.index.getPage(n2).last(pageBtreeCursor);
    }

    PageBtreeLeaf getFirstLeaf() {
        int n2 = this.p[0];
        return this.index.getPage(n2).getFirstLeaf();
    }

    PageBtreeLeaf getLastLeaf() {
        int n2 = this.p[this.entryCount];
        return this.index.getPage(n2).getLastLeaf();
    }

    SearchRow remove(SearchRow searchRow) {
        int n2 = this.find(searchRow, false, false, true);
        PageBtree pageBtree = this.index.getPage(this.p[n2]);
        SearchRow searchRow2 = pageBtree.remove(searchRow);
        this.index.getPageStore().logUndo(this, this.data);
        this.if(-1);
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
        if (searchRow2 == null) {
            return null;
        }
        if (searchRow2 == searchRow) {
            this.index.getPageStore().free(pageBtree.getPos());
            if (this.entryCount < 1) {
                return searchRow;
            }
            searchRow2 = n2 == this.entryCount ? this.getRow(n2 - 1) : null;
            this.do(n2);
            this.index.getPageStore().update(this);
            return searchRow2;
        }
        if (n2 == this.entryCount) {
            return searchRow2;
        }
        int n3 = this.p[n2];
        this.do(n2);
        this.a(n2, n3, searchRow2);
        int n4 = this.p[n2];
        this.p[n2] = this.p[n2 + 1];
        this.p[n2 + 1] = n4;
        this.index.getPageStore().update(this);
        return null;
    }

    int getRowCount() {
        if (this.m == -1) {
            int n2 = 0;
            for (int i2 = 0; i2 < this.entryCount + 1; ++i2) {
                int n3 = this.p[i2];
                PageBtree pageBtree = this.index.getPage(n3);
                this.index.getDatabase().setProgress(0, this.index.getName(), n2 += pageBtree.getRowCount(), Integer.MAX_VALUE);
            }
            this.m = n2;
        }
        return this.m;
    }

    void setRowCountStored(int n2) {
        if (n2 < 0 && this.n) {
            return;
        }
        this.m = n2;
        if (this.l != n2) {
            this.l = n2;
            this.index.getPageStore().logUndo(this, this.data);
            if (this.written) {
                this.changeCount = this.index.getPageStore().getChangeCount();
                this.byte();
            }
            this.index.getPageStore().update(this);
        }
    }

    private void char() {
        if (SysProperties.CHECK) {
            for (int i2 = 0; i2 < this.entryCount + 1; ++i2) {
                int n2 = this.p[i2];
                if (n2 != 0) continue;
                DbException.throwInternalError();
            }
        }
    }

    public void write() {
        this.char();
        this.case();
        this.index.getPageStore().writePage(this.getPos(), this.data);
    }

    private void byte() {
        this.data.reset();
        this.data.writeByte((byte)(5 | (this.onlyPosition ? 0 : 16)));
        this.data.writeShortInt(0);
        this.data.writeInt(this.parentPageId);
        this.data.writeVarInt(this.index.getId());
        this.data.writeInt(this.l);
        this.data.writeShortInt(this.entryCount);
    }

    private void case() {
        int n2;
        if (this.written) {
            return;
        }
        this.readAllRows();
        this.byte();
        this.data.writeInt(this.p[this.entryCount]);
        for (n2 = 0; n2 < this.entryCount; ++n2) {
            this.data.writeInt(this.p[n2]);
            this.data.writeShortInt(this.offsets[n2]);
        }
        for (n2 = 0; n2 < this.entryCount; ++n2) {
            this.index.writeRow(this.data, this.offsets[n2], this.rows[n2], this.onlyPosition);
        }
        this.written = true;
    }

    void freeRecursive() {
        this.index.getPageStore().logUndo(this, this.data);
        this.index.getPageStore().free(this.getPos());
        for (int i2 = 0; i2 < this.entryCount + 1; ++i2) {
            int n2 = this.p[i2];
            this.index.getPage(n2).freeRecursive();
        }
    }

    private void do(int n2) {
        this.readAllRows();
        --this.entryCount;
        if (this.n) {
            this.if(-this.index.getPage(this.p[n2]).getRowCount());
        }
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
        if (this.entryCount < 0) {
            DbException.throwInternalError();
        }
        if (this.entryCount > n2) {
            int n3 = n2 > 0 ? this.offsets[n2 - 1] : this.index.getPageStore().getPageSize();
            int n4 = n3 - this.offsets[n2];
            PageBtreeNode.add(this.offsets, n2, this.entryCount + 1, n4);
        }
        this.rows = (SearchRow[])PageBtreeNode.remove(this.rows, this.entryCount + 1, n2);
        this.offsets = PageBtreeNode.remove(this.offsets, this.entryCount + 1, n2);
        this.p = PageBtreeNode.remove(this.p, this.entryCount + 2, n2);
        this.start -= 6;
    }

    void nextPage(PageBtreeCursor pageBtreeCursor, int n2) {
        int n3;
        for (n3 = 0; n3 < this.entryCount + 1; ++n3) {
            if (this.p[n3] != n2) continue;
            ++n3;
            break;
        }
        if (n3 > this.entryCount) {
            if (this.parentPageId == 0) {
                pageBtreeCursor.setCurrent(null, 0);
                return;
            }
            PageBtreeNode pageBtreeNode = (PageBtreeNode)this.index.getPage(this.parentPageId);
            pageBtreeNode.nextPage(pageBtreeCursor, this.getPos());
            return;
        }
        PageBtree pageBtree = this.index.getPage(this.p[n3]);
        PageBtreeLeaf pageBtreeLeaf = pageBtree.getFirstLeaf();
        pageBtreeCursor.setCurrent(pageBtreeLeaf, 0);
    }

    void previousPage(PageBtreeCursor pageBtreeCursor, int n2) {
        int n3;
        for (n3 = this.entryCount; n3 >= 0; --n3) {
            if (this.p[n3] != n2) continue;
            --n3;
            break;
        }
        if (n3 < 0) {
            if (this.parentPageId == 0) {
                pageBtreeCursor.setCurrent(null, 0);
                return;
            }
            PageBtreeNode pageBtreeNode = (PageBtreeNode)this.index.getPage(this.parentPageId);
            pageBtreeNode.previousPage(pageBtreeCursor, this.getPos());
            return;
        }
        PageBtree pageBtree = this.index.getPage(this.p[n3]);
        PageBtreeLeaf pageBtreeLeaf = pageBtree.getLastLeaf();
        pageBtreeCursor.setCurrent(pageBtreeLeaf, pageBtreeLeaf.entryCount - 1);
    }

    public String toString() {
        return "page[" + this.getPos() + "] b-tree node table:" + this.index.getId() + " entries:" + this.entryCount;
    }

    public void moveTo(Session session, int n2) {
        PageStore pageStore = this.index.getPageStore();
        pageStore.logUndo(this, this.data);
        PageBtreeNode pageBtreeNode = PageBtreeNode.create(this.index, n2, this.parentPageId);
        this.readAllRows();
        pageBtreeNode.l = this.l;
        pageBtreeNode.m = this.m;
        pageBtreeNode.p = this.p;
        pageBtreeNode.rows = this.rows;
        pageBtreeNode.entryCount = this.entryCount;
        pageBtreeNode.offsets = this.offsets;
        pageBtreeNode.onlyPosition = this.onlyPosition;
        pageBtreeNode.parentPageId = this.parentPageId;
        pageBtreeNode.start = this.start;
        pageStore.update(pageBtreeNode);
        if (this.parentPageId == 0) {
            this.index.setRootPageId(session, n2);
        } else {
            Page page = pageStore.getPage(this.parentPageId);
            if (!(page instanceof PageBtreeNode)) {
                throw DbException.throwInternalError();
            }
            PageBtreeNode pageBtreeNode2 = (PageBtreeNode)page;
            pageBtreeNode2.moveChild(this.getPos(), n2);
        }
        for (int i2 = 0; i2 < this.entryCount + 1; ++i2) {
            int n3 = this.p[i2];
            PageBtree pageBtree = this.index.getPage(n3);
            pageBtree.setParentPageId(n2);
            pageStore.update(pageBtree);
        }
        pageStore.free(this.getPos());
    }

    void moveChild(int n2, int n3) {
        for (int i2 = 0; i2 < this.entryCount + 1; ++i2) {
            if (this.p[i2] != n2) continue;
            this.index.getPageStore().logUndo(this, this.data);
            this.written = false;
            this.changeCount = this.index.getPageStore().getChangeCount();
            this.p[i2] = n3;
            this.index.getPageStore().update(this);
            return;
        }
        throw DbException.throwInternalError();
    }
}

