/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.PageDataIndex;
import org.h2.index.PageDataLeaf;
import org.h2.result.Row;
import org.h2.store.Data;
import org.h2.store.Page;

abstract class PageData
extends Page {
    static final int START_PARENT = 3;
    static final int ROOT = 0;
    static final int UNKNOWN_ROWCOUNT = -1;
    protected final PageDataIndex index;
    protected int parentPageId;
    protected final Data data;
    protected int entryCount;
    protected long[] keys;
    protected boolean written;
    protected int memoryEstimated;

    PageData(PageDataIndex pageDataIndex, int n2, Data data) {
        this.index = pageDataIndex;
        this.data = data;
        this.setPos(n2);
        this.memoryEstimated = pageDataIndex.getMemoryPerPage();
    }

    abstract int getRowCount();

    abstract void setRowCountStored(int var1);

    int find(long l2) {
        int n2 = 0;
        int n3 = this.entryCount;
        while (n2 < n3) {
            int n4 = n2 + n3 >>> 1;
            long l3 = this.keys[n4];
            if (l3 == l2) {
                return n4;
            }
            if (l3 > l2) {
                n3 = n4;
                continue;
            }
            n2 = n4 + 1;
        }
        return n2;
    }

    abstract int addRowTry(Row var1);

    abstract Cursor find(Session var1, long var2, long var4, boolean var6);

    long getKey(int n2) {
        return this.keys[n2];
    }

    abstract PageData split(int var1);

    void setPageId(int n2) {
        int n3 = this.getPos();
        this.index.getPageStore().removeRecord(this.getPos());
        this.setPos(n2);
        this.index.getPageStore().logUndo(this, null);
        this.remapChildren(n3);
    }

    abstract long getLastKey();

    abstract PageDataLeaf getFirstLeaf();

    void setParentPageId(int n2) {
        this.index.getPageStore().logUndo(this, this.data);
        this.parentPageId = n2;
        if (this.written) {
            this.changeCount = this.index.getPageStore().getChangeCount();
            this.data.setInt(3, this.parentPageId);
        }
    }

    abstract void remapChildren(int var1);

    abstract boolean remove(long var1);

    abstract void freeRecursive();

    abstract Row getRowWithKey(long var1);

    public int getMemory() {
        return this.memoryEstimated;
    }

    int getParentPageId() {
        return this.parentPageId;
    }

    public boolean canRemove() {
        return this.changeCount < this.index.getPageStore().getChangeCount();
    }
}

