/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.PageData;
import org.h2.index.PageDataLeaf;
import org.h2.index.PageDataNode;
import org.h2.index.PageDataOverflow;
import org.h2.index.PageIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.store.Data;
import org.h2.store.Page;
import org.h2.store.PageStore;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.RegularTable;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.value.Value;
import org.h2.value.ValueNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PageDataIndex
extends PageIndex {
    private PageStore cc;
    private RegularTable b4;
    private long ce;
    private long b9;
    private HashSet cd;
    private int b3;
    private HashMap b8;
    private int b7 = -1;
    private DbException b5;
    private int cb;
    private int b6;
    private boolean ca;

    public PageDataIndex(RegularTable regularTable, int n2, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, Session session) {
        this.initBaseIndex(regularTable, n2, regularTable.getName() + "_DATA", indexColumnArray, indexType);
        this.ca = this.database.isMultiVersion();
        if (this.ca) {
            this.b8 = New.hashMap();
            this.isMultiVersion = true;
        }
        this.b4 = regularTable;
        this.cc = this.database.getPageStore();
        this.cc.addIndex(this);
        if (!this.database.isPersistent()) {
            throw DbException.throwInternalError(regularTable.getName());
        }
        if (bl) {
            this.rootPageId = this.cc.allocatePage();
            this.cc.addMeta(this, session);
            PageDataLeaf pageDataLeaf = PageDataLeaf.create(this, this.rootPageId, 0);
            this.cc.update(pageDataLeaf);
        } else {
            this.rootPageId = this.cc.getRootPageId(n2);
            PageData pageData = this.getPage(this.rootPageId, 0);
            this.ce = pageData.getLastKey();
            this.b9 = pageData.getRowCount();
        }
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} opened rows: {1}", this, this.b9);
        }
        regularTable.setRowCount(this.b9);
        this.cb = 240 + this.cc.getPageSize() >> 2;
    }

    public DbException getDuplicateKeyException() {
        if (this.b5 == null) {
            this.b5 = super.getDuplicateKeyException();
        }
        return this.b5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Session session, Row row) {
        boolean bl = false;
        if (this.b7 != -1) {
            row.setKey(row.getValue(this.b7).getLong());
        } else if (row.getKey() == 0L) {
            row.setKey((int)(++this.ce));
            bl = true;
        }
        if (this.b4.getContainsLargeObject()) {
            int n2 = row.getColumnCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                Value value = row.getValue(i2);
                Value value2 = value.link(this.database, this.getId());
                if (value2.isLinked()) {
                    session.unlinkAtCommitStop(value2);
                }
                if (value == value2) continue;
                row.setValue(i2, value2);
            }
        }
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} add {1}", this.getName(), row);
        }
        long l2 = 0L;
        while (true) {
            try {
                this.do(session, row);
            }
            catch (DbException dbException) {
                if (dbException != this.b5) {
                    throw dbException;
                }
                if (!bl) {
                    throw this.getNewDuplicateKeyException();
                }
                if (l2 == 0L) {
                    row.setKey((long)((double)row.getKey() + Math.random() * 10000.0));
                } else {
                    row.setKey(row.getKey() + l2);
                }
                ++l2;
                continue;
            }
            finally {
                this.cc.incrementChangeCount();
                continue;
            }
            break;
        }
        this.ce = Math.max(this.ce, row.getKey() + 1L);
    }

    public DbException getNewDuplicateKeyException() {
        String string = "PRIMARY KEY ON " + this.table.getSQL();
        if (this.b7 >= 0 && this.b7 < this.indexColumns.length) {
            string = string + "(" + this.indexColumns[this.b7].getSQL() + ")";
        }
        return DbException.get(23001, string);
    }

    private void do(Session session, Row row) {
        PageData pageData;
        int n2;
        while ((n2 = (pageData = this.getPage(this.rootPageId, 0)).addRowTry(row)) != -1) {
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("{0} split", this);
            }
            long l2 = n2 == 0 ? row.getKey() : pageData.getKey(n2 - 1);
            PageData pageData2 = pageData;
            PageData pageData3 = pageData.split(n2);
            int n3 = this.cc.allocatePage();
            pageData2.setPageId(n3);
            pageData2.setParentPageId(this.rootPageId);
            pageData3.setParentPageId(this.rootPageId);
            PageDataNode pageDataNode = PageDataNode.create(this, this.rootPageId, 0);
            pageDataNode.init(pageData2, l2, pageData3);
            this.cc.update(pageData2);
            this.cc.update(pageData3);
            this.cc.update(pageDataNode);
            pageData = pageDataNode;
        }
        row.setDeleted(false);
        if (this.ca) {
            boolean bl;
            if (this.cd == null) {
                this.cd = New.hashSet();
            }
            if (!(bl = this.cd.remove(row))) {
                this.cd.add(row);
            }
            this.a(session.getId(), 1);
        }
        this.c();
        ++this.b9;
        this.cc.logAddOrRemoveRow(session, this.b4.getId(), row, true);
    }

    PageDataOverflow getPageOverflow(int n2) {
        Page page = this.cc.getPage(n2);
        if (page instanceof PageDataOverflow) {
            return (PageDataOverflow)page;
        }
        throw DbException.get(90030, page == null ? "null" : page.toString());
    }

    PageData getPage(int n2, int n3) {
        Page page = this.cc.getPage(n2);
        if (page == null) {
            PageDataLeaf pageDataLeaf = PageDataLeaf.create(this, n2, n3);
            this.cc.logUndo(pageDataLeaf, null);
            this.cc.update(pageDataLeaf);
            return pageDataLeaf;
        }
        if (!(page instanceof PageData)) {
            throw DbException.get(90030, "" + page);
        }
        PageData pageData = (PageData)page;
        if (n3 != -1 && pageData.getParentPageId() != n3) {
            throw DbException.throwInternalError(pageData + " parent " + pageData.getParentPageId() + " expected " + n3);
        }
        return pageData;
    }

    public boolean canGetFirstOrLast() {
        return false;
    }

    long getKey(SearchRow searchRow, long l2, long l3) {
        if (searchRow == null) {
            return l2;
        }
        Value value = searchRow.getValue(this.b7);
        if (value == null) {
            throw DbException.throwInternalError(searchRow.toString());
        }
        if (value == ValueNull.INSTANCE) {
            return l3;
        }
        return value.getLong();
    }

    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        if (searchRow != null || searchRow2 != null) {
            throw DbException.throwInternalError(this.getSQL() + " " + searchRow + " " + searchRow2);
        }
        PageData pageData = this.getPage(this.rootPageId, 0);
        return pageData.find(session, Long.MIN_VALUE, Long.MAX_VALUE, this.isMultiVersion);
    }

    Cursor find(Session session, long l2, long l3, boolean bl) {
        PageData pageData = this.getPage(this.rootPageId, 0);
        return pageData.find(session, l2, l3, bl);
    }

    public Cursor findFirstOrLast(Session session, boolean bl) {
        throw DbException.throwInternalError();
    }

    long getLastKey() {
        PageData pageData = this.getPage(this.rootPageId, 0);
        return pageData.getLastKey();
    }

    public double getCost(Session session, int[] nArray) {
        long l2 = 10L * (this.b4.getRowCountApproximation() + 1000L);
        return l2;
    }

    public boolean needRebuild() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Session session, Row row) {
        Object object;
        int n2;
        if (this.b4.getContainsLargeObject()) {
            int n3 = row.getColumnCount();
            for (n2 = 0; n2 < n3; ++n2) {
                object = row.getValue(n2);
                if (!((Value)object).isLinked()) continue;
                session.unlinkAtCommit((Value)object);
            }
        }
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} remove {1}", this.getName(), row);
        }
        if (this.b9 == 1L) {
            this.b();
        } else {
            try {
                long l2 = row.getKey();
                object = this.getPage(this.rootPageId, 0);
                ((PageData)object).remove(l2);
                this.c();
                --this.b9;
            }
            finally {
                this.cc.incrementChangeCount();
            }
        }
        if (this.ca) {
            row.setDeleted(true);
            if (this.cd == null) {
                this.cd = New.hashSet();
            }
            if ((n2 = (int)(this.cd.remove(row) ? 1 : 0)) == 0) {
                this.cd.add(row);
            }
            this.a(session.getId(), -1);
        }
        this.cc.logAddOrRemoveRow(session, this.b4.getId(), row, false);
    }

    public void remove(Session session) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} remove", this);
        }
        this.b();
        this.cc.free(this.rootPageId);
        this.cc.removeMeta(this, session);
    }

    public void truncate(Session session) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} truncate", this);
        }
        this.cc.logTruncate(session, this.b4.getId());
        this.b();
        if (this.b4.getContainsLargeObject() && this.b4.isPersistData()) {
            this.database.getLobStorage().removeAllForTable(this.table.getId());
        }
        if (this.ca) {
            this.b8.clear();
        }
        this.b4.setRowCount(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b() {
        try {
            PageData pageData = this.getPage(this.rootPageId, 0);
            pageData.freeRecursive();
            pageData = PageDataLeaf.create(this, this.rootPageId, 0);
            this.cc.removeRecord(this.rootPageId);
            this.cc.update(pageData);
            this.b9 = 0L;
            this.ce = 0L;
        }
        finally {
            this.cc.incrementChangeCount();
        }
    }

    public void checkRename() {
        throw DbException.getUnsupportedException("PAGE");
    }

    public Row getRow(Session session, long l2) {
        return this.getRowWithKey(l2);
    }

    public Row getRowWithKey(long l2) {
        PageData pageData = this.getPage(this.rootPageId, 0);
        return pageData.getRowWithKey(l2);
    }

    PageStore getPageStore() {
        return this.cc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Row readRow(Data data, int n2, int n3) {
        Value[] valueArray = new Value[n3];
        Data data2 = data;
        synchronized (data2) {
            data.setPos(n2);
            for (int i2 = 0; i2 < n3; ++i2) {
                valueArray[i2] = data.readValue();
            }
        }
        return this.b4.createRow(valueArray);
    }

    public long getRowCountApproximation() {
        return this.b9;
    }

    public long getRowCount(Session session) {
        if (this.ca) {
            Integer n2 = (Integer)this.b8.get(session.getId());
            long l2 = n2 == null ? 0L : (long)n2.intValue();
            l2 += this.b9;
            return l2 -= (long)this.b3;
        }
        return this.b9;
    }

    public String getCreateSQL() {
        return null;
    }

    public int getColumnIndex(Column column) {
        return -1;
    }

    public void close(Session session) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} close", this);
        }
        if (this.cd != null) {
            this.cd.clear();
        }
        this.b3 = 0;
        if (this.b8 != null) {
            this.b8.clear();
        }
        this.writeRowCount();
    }

    Iterator getDelta() {
        if (this.cd == null) {
            List list = Collections.emptyList();
            return list.iterator();
        }
        return this.cd.iterator();
    }

    private void a(int n2, int n3) {
        if (this.ca) {
            Integer n4 = n2;
            Integer n5 = (Integer)this.b8.get(n4);
            int n6 = n5 == null ? 0 : n5;
            this.b8.put(n4, n6 + n3);
            this.b3 += n3;
        }
    }

    public void commit(int n2, Row row) {
        if (this.ca) {
            if (this.cd != null) {
                this.cd.remove(row);
            }
            this.a(row.getSessionId(), n2 == 1 ? 1 : -1);
        }
    }

    void setRootPageId(Session session, int n2) {
        this.cc.removeMeta(this, session);
        this.rootPageId = n2;
        this.cc.addMeta(this, session);
        this.cc.addIndex(this);
    }

    public void setMainIndexColumn(int n2) {
        this.b7 = n2;
    }

    public int getMainIndexColumn() {
        return this.b7;
    }

    public String toString() {
        return this.getName();
    }

    private void c() {
        PageData pageData = this.getPage(this.rootPageId, 0);
        pageData.setRowCountStored(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRowCount() {
        try {
            PageData pageData = this.getPage(this.rootPageId, 0);
            pageData.setRowCountStored(MathUtils.convertLongToInt(this.b9));
        }
        finally {
            this.cc.incrementChangeCount();
        }
    }

    public String getPlanSQL() {
        return this.table.getSQL() + ".tableScan";
    }

    int getMemoryPerPage() {
        return this.cb;
    }

    void memoryChange(int n2) {
        this.cb = this.b6 < 64 ? (this.cb += (n2 - this.cb) / ++this.b6) : (this.cb += (n2 > this.cb ? 1 : -1) + (n2 - this.cb) / 64);
    }
}

