/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.lang.ref.SoftReference;
import java.util.Arrays;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.PageData;
import org.h2.index.PageDataCursor;
import org.h2.index.PageDataIndex;
import org.h2.index.PageDataNode;
import org.h2.index.PageDataOverflow;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.store.Data;
import org.h2.store.Page;
import org.h2.store.PageStore;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PageDataLeaf
extends PageData {
    private final boolean J;
    private int[] G;
    private Row[] M;
    private SoftReference I;
    private int L;
    private int D;
    private int E;
    private int K;
    private int F;
    private boolean H;

    private PageDataLeaf(PageDataIndex pageDataIndex, int n2, Data data) {
        super(pageDataIndex, n2, data);
        this.J = pageDataIndex.getDatabase().getSettings().optimizeUpdate;
    }

    static PageDataLeaf create(PageDataIndex pageDataIndex, int n2, int n3) {
        PageDataLeaf pageDataLeaf = new PageDataLeaf(pageDataIndex, n2, pageDataIndex.getPageStore().createData());
        pageDataIndex.getPageStore().logUndo(pageDataLeaf, null);
        pageDataLeaf.M = Row.EMPTY_ARRAY;
        pageDataLeaf.parentPageId = n3;
        pageDataLeaf.K = pageDataIndex.getTable().getColumns().length;
        pageDataLeaf.f();
        pageDataLeaf.D = pageDataLeaf.data.length();
        return pageDataLeaf;
    }

    public static Page read(PageDataIndex pageDataIndex, Data data, int n2) {
        PageDataLeaf pageDataLeaf = new PageDataLeaf(pageDataIndex, n2, data);
        pageDataLeaf.j();
        return pageDataLeaf;
    }

    private void j() {
        this.data.reset();
        byte by = this.data.readByte();
        this.data.readShortInt();
        this.parentPageId = this.data.readInt();
        int n2 = this.data.readVarInt();
        if (n2 != this.index.getId()) {
            throw DbException.get(90030, "page:" + this.getPos() + " expected table:" + this.index.getId() + " got:" + n2 + " type:" + by);
        }
        this.K = this.data.readVarInt();
        this.entryCount = this.data.readShortInt();
        this.G = new int[this.entryCount];
        this.keys = new long[this.entryCount];
        this.M = new Row[this.entryCount];
        if (by == 1) {
            if (this.entryCount != 1) {
                DbException.throwInternalError("entries: " + this.entryCount);
            }
            this.L = this.data.readInt();
        }
        for (int i2 = 0; i2 < this.entryCount; ++i2) {
            this.keys[i2] = this.data.readVarLong();
            this.G[i2] = this.data.readShortInt();
        }
        this.D = this.data.length();
        this.written = true;
        this.H = true;
    }

    private int a(Row row) {
        int n2 = 0;
        for (int i2 = 0; i2 < this.K; ++i2) {
            n2 += this.data.getValueLen(row.getValue(i2));
        }
        return n2;
    }

    private int a(long l2) {
        int n2 = this.find(l2);
        if (n2 < this.entryCount && this.keys[n2] == l2) {
            throw this.index.getDuplicateKeyException();
        }
        return n2;
    }

    int addRowTry(Row row) {
        int n2;
        int n3;
        int n4;
        int n5;
        this.index.getPageStore().logUndo(this, this.data);
        int n6 = this.a(row);
        int n7 = this.index.getPageStore().getPageSize();
        int n8 = this.entryCount == 0 ? n7 : this.G[this.entryCount - 1];
        int n9 = 2 + Data.getVarLongLen(row.getKey());
        if (this.entryCount > 0 && n8 - n6 < this.D + n9) {
            int n10 = this.a(row.getKey());
            if (this.entryCount > 1) {
                if (this.entryCount < 5) {
                    return this.entryCount / 2;
                }
                if (this.index.isSortedInsertMode()) {
                    return n10 < 2 ? 1 : (n10 > this.entryCount - 1 ? this.entryCount - 1 : n10);
                }
                int n11 = this.entryCount / 3;
                return n10 < n11 ? n11 : (n10 >= 2 * n11 ? 2 * n11 : n10);
            }
            return n10;
        }
        this.index.getPageStore().logUndo(this, this.data);
        if (this.entryCount == 0) {
            n5 = 0;
        } else {
            if (!this.J) {
                this.h();
            }
            n5 = this.a(row.getKey());
        }
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
        n8 = n5 == 0 ? n7 : this.G[n5 - 1];
        int n12 = n8 - n6;
        this.D += n9;
        this.G = PageDataLeaf.insert(this.G, this.entryCount, n5, n12);
        PageDataLeaf.add(this.G, n5 + 1, this.entryCount + 1, -n6);
        this.keys = PageDataLeaf.insert(this.keys, this.entryCount, n5, row.getKey());
        this.M = (Row[])PageDataLeaf.insert(this.M, this.entryCount, n5, row);
        ++this.entryCount;
        this.index.getPageStore().update(this);
        if (this.J && this.H && n12 >= this.D) {
            byte[] byArray = this.data.getBytes();
            n4 = this.G[this.entryCount - 1] + n6;
            n3 = this.G[n5];
            System.arraycopy(byArray, n4, byArray, n4 - n6, n3 - n4 + n6);
            this.data.setPos(n3);
            for (n2 = 0; n2 < this.K; ++n2) {
                this.data.writeValue(row.getValue(n2));
            }
        }
        if (n12 < this.D) {
            int n13;
            this.H = false;
            if (this.entryCount > 1) {
                DbException.throwInternalError();
            }
            this.D += 4;
            int n14 = n6 - (n7 - this.D);
            this.G[n5] = n12 = this.D;
            n4 = this.getPos();
            n3 = n7;
            this.L = n2 = this.index.getPageStore().allocatePage();
            this.E = n7 + n6;
            this.g();
            Row row2 = this.M[0];
            this.I = new SoftReference<Row>(row2);
            this.M[0] = null;
            Data data = this.index.getPageStore().createData();
            data.checkCapacity(this.data.length());
            data.write(this.data.getBytes(), 0, this.data.length());
            this.data.truncate(this.index.getPageStore().getPageSize());
            do {
                int n15;
                int n16;
                if (n14 <= n7 - 9) {
                    n16 = 19;
                    n13 = n14;
                    n15 = 0;
                } else {
                    n16 = 3;
                    n13 = n7 - 11;
                    n15 = this.index.getPageStore().allocatePage();
                }
                PageDataOverflow pageDataOverflow = PageDataOverflow.create(this.index.getPageStore(), n2, n16, n4, n15, data, n3, n13);
                this.index.getPageStore().update(pageDataOverflow);
                n3 += n13;
                n4 = n2;
                n2 = n15;
            } while ((n14 -= n13) > 0);
        }
        if (this.I == null) {
            this.a(true, row);
        } else {
            this.a(true, null);
        }
        return -1;
    }

    private void new(int n2) {
        Row row;
        this.index.getPageStore().logUndo(this, this.data);
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
        if (!this.J) {
            this.h();
        }
        if ((row = this.getRowAt(n2)) != null) {
            this.a(false, row);
        }
        --this.entryCount;
        if (this.entryCount < 0) {
            DbException.throwInternalError();
        }
        if (this.L != 0) {
            this.D -= 4;
            this.i();
            this.L = 0;
            this.E = 0;
            this.I = null;
        }
        int n3 = 2 + Data.getVarLongLen(this.keys[n2]);
        int n4 = n2 > 0 ? this.G[n2 - 1] : this.index.getPageStore().getPageSize();
        int n5 = n4 - this.G[n2];
        if (this.J) {
            if (this.H) {
                byte[] byArray = this.data.getBytes();
                int n6 = this.G[this.entryCount];
                System.arraycopy(byArray, n6, byArray, n6 + n5, this.G[n2] - n6);
                Arrays.fill(byArray, n6, n6 + n5, (byte)0);
            }
        } else {
            int n7 = this.G[this.entryCount];
            Arrays.fill(this.data.getBytes(), n7, n7 + n5, (byte)0);
        }
        this.D -= n3;
        this.G = PageDataLeaf.remove(this.G, this.entryCount + 1, n2);
        PageDataLeaf.add(this.G, n2, this.entryCount, n5);
        this.keys = PageDataLeaf.remove(this.keys, this.entryCount + 1, n2);
        this.M = (Row[])PageDataLeaf.remove(this.M, this.entryCount + 1, n2);
    }

    Cursor find(Session session, long l2, long l3, boolean bl) {
        int n2 = this.find(l2);
        return new PageDataCursor(session, this, n2, l3, bl);
    }

    Row getRowAt(int n2) {
        Row row = this.M[n2];
        if (row == null) {
            if (this.L == 0) {
                row = this.index.readRow(this.data, this.G[n2], this.K);
            } else {
                PageDataOverflow pageDataOverflow;
                if (this.I != null && (row = (Row)this.I.get()) != null) {
                    return row;
                }
                PageStore pageStore = this.index.getPageStore();
                Data data = pageStore.createData();
                int n3 = pageStore.getPageSize();
                int n4 = this.G[n2];
                data.write(this.data.getBytes(), n4, n3 - n4);
                int n5 = this.L;
                while ((n5 = (pageDataOverflow = this.index.getPageOverflow(n5)).readInto(data)) != 0) {
                }
                this.E = n3 + data.length();
                row = this.index.readRow(data, 0, this.K);
            }
            row.setKey(this.keys[n2]);
            if (this.L != 0) {
                this.I = new SoftReference<Row>(row);
            } else {
                this.M[n2] = row;
                this.a(true, row);
            }
        }
        return row;
    }

    int getEntryCount() {
        return this.entryCount;
    }

    PageData split(int n2) {
        int n3 = this.index.getPageStore().allocatePage();
        PageDataLeaf pageDataLeaf = PageDataLeaf.create(this.index, n3, this.parentPageId);
        int n4 = n2;
        while (n4 < this.entryCount) {
            int n5 = pageDataLeaf.addRowTry(this.getRowAt(n2));
            if (n5 != -1) {
                DbException.throwInternalError("split " + n5);
            }
            this.new(n2);
        }
        return pageDataLeaf;
    }

    long getLastKey() {
        if (this.entryCount == 0) {
            return 0L;
        }
        return this.getRowAt(this.entryCount - 1).getKey();
    }

    PageDataLeaf getNextPage() {
        if (this.parentPageId == 0) {
            return null;
        }
        PageDataNode pageDataNode = (PageDataNode)this.index.getPage(this.parentPageId, -1);
        return pageDataNode.getNextPage(this.keys[this.entryCount - 1]);
    }

    PageDataLeaf getFirstLeaf() {
        return this;
    }

    protected void remapChildren(int n2) {
        if (this.L == 0) {
            return;
        }
        PageDataOverflow pageDataOverflow = this.index.getPageOverflow(this.L);
        pageDataOverflow.setParentPageId(this.getPos());
        this.index.getPageStore().update(pageDataOverflow);
    }

    boolean remove(long l2) {
        int n2 = this.find(l2);
        if (this.keys[n2] != l2) {
            throw DbException.get(90112, this.index.getSQL() + ": " + l2 + " " + this.keys[n2]);
        }
        this.index.getPageStore().logUndo(this, this.data);
        if (this.entryCount == 1) {
            this.freeRecursive();
            return true;
        }
        this.new(n2);
        this.index.getPageStore().update(this);
        return false;
    }

    void freeRecursive() {
        this.index.getPageStore().logUndo(this, this.data);
        this.index.getPageStore().free(this.getPos());
        this.i();
    }

    private void i() {
        if (this.L != 0) {
            PageDataOverflow pageDataOverflow;
            int n2 = this.L;
            do {
                pageDataOverflow = this.index.getPageOverflow(n2);
                pageDataOverflow.free();
            } while ((n2 = pageDataOverflow.getNextOverflow()) != 0);
        }
    }

    Row getRowWithKey(long l2) {
        int n2 = this.find(l2);
        return this.getRowAt(n2);
    }

    int getRowCount() {
        return this.entryCount;
    }

    void setRowCountStored(int n2) {
    }

    public void write() {
        this.g();
        this.index.getPageStore().writePage(this.getPos(), this.data);
        this.data.truncate(this.index.getPageStore().getPageSize());
    }

    private void h() {
        for (int i2 = 0; i2 < this.entryCount; ++i2) {
            this.getRowAt(i2);
        }
    }

    private void f() {
        this.data.reset();
        int n2 = this.L == 0 ? 17 : 1;
        this.data.writeByte((byte)n2);
        this.data.writeShortInt(0);
        if (SysProperties.CHECK2 && this.data.length() != 3) {
            DbException.throwInternalError();
        }
        this.data.writeInt(this.parentPageId);
        this.data.writeVarInt(this.index.getId());
        this.data.writeVarInt(this.K);
        this.data.writeShortInt(this.entryCount);
    }

    private void g() {
        int n2;
        if (this.written) {
            return;
        }
        if (!this.J) {
            this.h();
        }
        this.f();
        if (this.L != 0) {
            this.data.writeInt(this.L);
            this.data.checkCapacity(this.E);
        }
        for (n2 = 0; n2 < this.entryCount; ++n2) {
            this.data.writeVarLong(this.keys[n2]);
            this.data.writeShortInt(this.G[n2]);
        }
        if (!this.H || !this.J) {
            for (n2 = 0; n2 < this.entryCount; ++n2) {
                this.data.setPos(this.G[n2]);
                Row row = this.getRowAt(n2);
                for (int i2 = 0; i2 < this.K; ++i2) {
                    this.data.writeValue(row.getValue(i2));
                }
            }
            this.H = true;
        }
        this.written = true;
    }

    public String toString() {
        return "page[" + this.getPos() + "] data leaf table:" + this.index.getId() + " entries:" + this.entryCount + " parent:" + this.parentPageId + (this.L == 0 ? "" : " overflow:" + this.L) + " keys:" + Arrays.toString(this.keys) + " offsets:" + Arrays.toString(this.G);
    }

    public void moveTo(Session session, int n2) {
        PageStore pageStore = this.index.getPageStore();
        if (this.parentPageId != 0) {
            pageStore.getPage(this.parentPageId);
        }
        pageStore.logUndo(this, this.data);
        PageDataLeaf pageDataLeaf = PageDataLeaf.create(this.index, n2, this.parentPageId);
        this.h();
        pageDataLeaf.keys = this.keys;
        pageDataLeaf.E = this.E;
        pageDataLeaf.L = this.L;
        pageDataLeaf.I = this.I;
        pageDataLeaf.M = this.M;
        if (this.L != 0) {
            pageDataLeaf.M[0] = this.getRowAt(0);
        }
        pageDataLeaf.entryCount = this.entryCount;
        pageDataLeaf.G = this.G;
        pageDataLeaf.D = this.D;
        pageDataLeaf.remapChildren(this.getPos());
        pageDataLeaf.g();
        pageDataLeaf.data.truncate(this.index.getPageStore().getPageSize());
        pageStore.update(pageDataLeaf);
        if (this.parentPageId == 0) {
            this.index.setRootPageId(session, n2);
        } else {
            PageDataNode pageDataNode = (PageDataNode)pageStore.getPage(this.parentPageId);
            pageDataNode.moveChild(this.getPos(), n2);
        }
        pageStore.free(this.getPos());
    }

    void setOverflow(int n2, int n3) {
        if (SysProperties.CHECK && n2 != this.L) {
            DbException.throwInternalError("move " + this + " " + this.L);
        }
        this.index.getPageStore().logUndo(this, this.data);
        this.L = n3;
        if (this.written) {
            this.changeCount = this.index.getPageStore().getChangeCount();
            this.f();
            this.data.writeInt(this.L);
        }
        this.index.getPageStore().update(this);
    }

    private void a(boolean bl, Row row) {
        int n2 = row == null ? 0 : 20 + row.getMemory();
        this.F += bl ? n2 : -n2;
        this.index.memoryChange(240 + this.F + this.index.getPageStore().getPageSize() >> 2);
    }
}

