/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.Arrays;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.PageData;
import org.h2.index.PageDataIndex;
import org.h2.index.PageDataLeaf;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.store.Data;
import org.h2.store.Page;
import org.h2.store.PageStore;
import org.h2.util.Utils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PageDataNode
extends PageData {
    private int[] C;
    private int z = -1;
    private int A = -1;
    private int B;

    private PageDataNode(PageDataIndex pageDataIndex, int n2, Data data) {
        super(pageDataIndex, n2, data);
    }

    static PageDataNode create(PageDataIndex pageDataIndex, int n2, int n3) {
        PageDataNode pageDataNode = new PageDataNode(pageDataIndex, n2, pageDataIndex.getPageStore().createData());
        pageDataIndex.getPageStore().logUndo(pageDataNode, null);
        pageDataNode.parentPageId = n3;
        pageDataNode.b();
        pageDataNode.B = pageDataNode.data.length() + 4;
        return pageDataNode;
    }

    public static Page read(PageDataIndex pageDataIndex, Data data, int n2) {
        PageDataNode pageDataNode = new PageDataNode(pageDataIndex, n2, data);
        pageDataNode.e();
        return pageDataNode;
    }

    private void e() {
        this.data.reset();
        this.data.readByte();
        this.data.readShortInt();
        this.parentPageId = this.data.readInt();
        int n2 = this.data.readVarInt();
        if (n2 != this.index.getId()) {
            throw DbException.get(90030, "page:" + this.getPos() + " expected index:" + this.index.getId() + "got:" + n2);
        }
        this.A = this.z = this.data.readInt();
        this.entryCount = this.data.readShortInt();
        this.C = new int[this.entryCount + 1];
        this.C[this.entryCount] = this.data.readInt();
        this.keys = Utils.newLongArray(this.entryCount);
        for (int i2 = 0; i2 < this.entryCount; ++i2) {
            this.C[i2] = this.data.readInt();
            this.keys[i2] = this.data.readVarLong();
        }
        this.B = this.data.length();
        this.d();
        this.written = true;
    }

    private void a(int n2, int n3, long l2) {
        this.index.getPageStore().logUndo(this, this.data);
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
        this.C = PageDataNode.insert(this.C, this.entryCount + 1, n2 + 1, n3);
        this.keys = PageDataNode.insert(this.keys, this.entryCount, n2, l2);
        ++this.entryCount;
        this.B += 4 + Data.getVarLongLen(l2);
    }

    int addRowTry(Row row) {
        int n2;
        PageData pageData;
        int n3;
        this.index.getPageStore().logUndo(this, this.data);
        int n4 = 4 + Data.getVarLongLen(row.getKey());
        while ((n3 = (pageData = this.index.getPage(this.C[n2 = this.find(row.getKey())], this.getPos())).addRowTry(row)) != -1) {
            if (this.B + n4 > this.index.getPageStore().getPageSize()) {
                return this.entryCount / 2;
            }
            long l2 = n3 == 0 ? row.getKey() : pageData.getKey(n3 - 1);
            PageData pageData2 = pageData.split(n3);
            this.index.getPageStore().update(pageData);
            this.index.getPageStore().update(pageData2);
            this.a(n2, pageData2.getPos(), l2);
            this.index.getPageStore().update(this);
        }
        this.for(1);
        return -1;
    }

    private void for(int n2) {
        if (this.A != -1) {
            this.A += n2;
        }
        if (this.z != -1) {
            this.z = -1;
            this.index.getPageStore().logUndo(this, this.data);
            if (this.written) {
                this.b();
            }
            this.index.getPageStore().update(this);
        }
    }

    Cursor find(Session session, long l2, long l3, boolean bl) {
        int n2 = this.find(l2);
        int n3 = this.C[n2];
        return this.index.getPage(n3, this.getPos()).find(session, l2, l3, bl);
    }

    PageData split(int n2) {
        int n3 = this.index.getPageStore().allocatePage();
        PageDataNode pageDataNode = PageDataNode.create(this.index, n3, this.parentPageId);
        int n4 = this.C[n2];
        int n5 = n2;
        while (n5 < this.entryCount) {
            pageDataNode.a(pageDataNode.entryCount, this.C[n2 + 1], this.keys[n2]);
            this.int(n2);
        }
        n5 = this.C[n2 - 1];
        this.int(n2 - 1);
        this.C[n2 - 1] = n5;
        pageDataNode.C[0] = n4;
        pageDataNode.remapChildren(this.getPos());
        return pageDataNode;
    }

    protected void remapChildren(int n2) {
        for (int i2 = 0; i2 < this.entryCount + 1; ++i2) {
            int n3 = this.C[i2];
            PageData pageData = this.index.getPage(n3, n2);
            pageData.setParentPageId(this.getPos());
            this.index.getPageStore().update(pageData);
        }
    }

    void init(PageData pageData, long l2, PageData pageData2) {
        this.entryCount = 1;
        this.C = new int[]{pageData.getPos(), pageData2.getPos()};
        this.keys = new long[]{l2};
        this.B += 4 + Data.getVarLongLen(l2);
        this.d();
    }

    long getLastKey() {
        return this.index.getPage(this.C[this.entryCount], this.getPos()).getLastKey();
    }

    PageDataLeaf getNextPage(long l2) {
        int n2 = this.find(l2) + 1;
        if (n2 > this.entryCount) {
            if (this.parentPageId == 0) {
                return null;
            }
            PageDataNode pageDataNode = (PageDataNode)this.index.getPage(this.parentPageId, -1);
            return pageDataNode.getNextPage(l2);
        }
        PageData pageData = this.index.getPage(this.C[n2], this.getPos());
        return pageData.getFirstLeaf();
    }

    PageDataLeaf getFirstLeaf() {
        int n2 = this.C[0];
        return this.index.getPage(n2, this.getPos()).getFirstLeaf();
    }

    boolean remove(long l2) {
        int n2 = this.find(l2);
        PageData pageData = this.index.getPage(this.C[n2], this.getPos());
        boolean bl = pageData.remove(l2);
        this.index.getPageStore().logUndo(this, this.data);
        this.for(-1);
        if (!bl) {
            return false;
        }
        this.index.getPageStore().free(pageData.getPos());
        if (this.entryCount < 1) {
            return true;
        }
        this.int(n2);
        this.index.getPageStore().update(this);
        return false;
    }

    void freeRecursive() {
        this.index.getPageStore().logUndo(this, this.data);
        this.index.getPageStore().free(this.getPos());
        for (int i2 = 0; i2 < this.entryCount + 1; ++i2) {
            int n2 = this.C[i2];
            this.index.getPage(n2, this.getPos()).freeRecursive();
        }
    }

    Row getRowWithKey(long l2) {
        int n2 = this.find(l2);
        PageData pageData = this.index.getPage(this.C[n2], this.getPos());
        return pageData.getRowWithKey(l2);
    }

    int getRowCount() {
        if (this.A == -1) {
            int n2 = 0;
            for (int i2 = 0; i2 < this.entryCount + 1; ++i2) {
                int n3 = this.C[i2];
                PageData pageData = this.index.getPage(n3, this.getPos());
                if (this.getPos() == pageData.getPos()) {
                    throw DbException.throwInternalError("Page it its own child: " + this.getPos());
                }
                this.index.getDatabase().setProgress(0, this.index.getTable() + "." + this.index.getName(), n2 += pageData.getRowCount(), Integer.MAX_VALUE);
            }
            this.A = n2;
        }
        return this.A;
    }

    void setRowCountStored(int n2) {
        this.A = n2;
        if (this.z != n2) {
            this.z = n2;
            this.index.getPageStore().logUndo(this, this.data);
            if (this.written) {
                this.changeCount = this.index.getPageStore().getChangeCount();
                this.b();
            }
            this.index.getPageStore().update(this);
        }
    }

    private void d() {
        if (SysProperties.CHECK) {
            for (int i2 = 0; i2 < this.entryCount + 1; ++i2) {
                int n2 = this.C[i2];
                if (n2 != 0) continue;
                DbException.throwInternalError();
            }
        }
    }

    public void write() {
        this.c();
        this.index.getPageStore().writePage(this.getPos(), this.data);
    }

    private void b() {
        this.data.reset();
        this.data.writeByte((byte)2);
        this.data.writeShortInt(0);
        if (SysProperties.CHECK2 && this.data.length() != 3) {
            DbException.throwInternalError();
        }
        this.data.writeInt(this.parentPageId);
        this.data.writeVarInt(this.index.getId());
        this.data.writeInt(this.z);
        this.data.writeShortInt(this.entryCount);
    }

    private void c() {
        if (this.written) {
            return;
        }
        this.d();
        this.b();
        this.data.writeInt(this.C[this.entryCount]);
        for (int i2 = 0; i2 < this.entryCount; ++i2) {
            this.data.writeInt(this.C[i2]);
            this.data.writeVarLong(this.keys[i2]);
        }
        if (this.B != this.data.length()) {
            DbException.throwInternalError("expected pos: " + this.B + " got: " + this.data.length());
        }
        this.written = true;
    }

    private void int(int n2) {
        this.index.getPageStore().logUndo(this, this.data);
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
        int n3 = n2 < this.entryCount ? n2 : n2 - 1;
        --this.entryCount;
        this.B -= 4 + Data.getVarLongLen(this.keys[n3]);
        if (this.entryCount < 0) {
            DbException.throwInternalError();
        }
        this.keys = PageDataNode.remove(this.keys, this.entryCount + 1, n3);
        this.C = PageDataNode.remove(this.C, this.entryCount + 2, n2);
    }

    public String toString() {
        return "page[" + this.getPos() + "] data node table:" + this.index.getId() + " entries:" + this.entryCount + " " + Arrays.toString(this.C);
    }

    public void moveTo(Session session, int n2) {
        PageStore pageStore = this.index.getPageStore();
        for (int i2 = 0; i2 < this.entryCount + 1; ++i2) {
            int n3 = this.C[i2];
            pageStore.getPage(n3);
        }
        if (this.parentPageId != 0) {
            pageStore.getPage(this.parentPageId);
        }
        pageStore.logUndo(this, this.data);
        PageDataNode pageDataNode = PageDataNode.create(this.index, n2, this.parentPageId);
        pageDataNode.z = this.z;
        pageDataNode.A = this.A;
        pageDataNode.C = this.C;
        pageDataNode.keys = this.keys;
        pageDataNode.entryCount = this.entryCount;
        pageDataNode.B = this.B;
        pageStore.update(pageDataNode);
        if (this.parentPageId == 0) {
            this.index.setRootPageId(session, n2);
        } else {
            PageDataNode pageDataNode2 = (PageDataNode)pageStore.getPage(this.parentPageId);
            pageDataNode2.moveChild(this.getPos(), n2);
        }
        for (int i3 = 0; i3 < this.entryCount + 1; ++i3) {
            int n4 = this.C[i3];
            PageData pageData = (PageData)pageStore.getPage(n4);
            pageData.setParentPageId(n2);
            pageStore.update(pageData);
        }
        pageStore.free(this.getPos());
    }

    void moveChild(int n2, int n3) {
        for (int i2 = 0; i2 < this.entryCount + 1; ++i2) {
            if (this.C[i2] != n2) continue;
            this.index.getPageStore().logUndo(this, this.data);
            this.written = false;
            this.changeCount = this.index.getPageStore().getChangeCount();
            this.C[i2] = n3;
            this.index.getPageStore().update(this);
            return;
        }
        throw DbException.throwInternalError();
    }
}

