/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.RangeCursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.IndexColumn;
import org.h2.table.RangeTable;

public class RangeIndex
extends BaseIndex {
    private RangeTable cD;

    public RangeIndex(RangeTable rangeTable, IndexColumn[] indexColumnArray) {
        this.initBaseIndex(rangeTable, 0, "RANGE_INDEX", indexColumnArray, IndexType.createNonUnique(true));
        this.cD = rangeTable;
    }

    public void close(Session session) {
    }

    public void add(Session session, Row row) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    public void remove(Session session, Row row) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        long l2;
        long l3;
        long l4 = l3 = this.cD.getMin(session);
        long l5 = l2 = this.cD.getMax(session);
        try {
            l4 = Math.max(l3, searchRow == null ? l3 : searchRow.getValue(0).getLong());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            l5 = Math.min(l2, searchRow2 == null ? l2 : searchRow2.getValue(0).getLong());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new RangeCursor(l4, l5);
    }

    public double getCost(Session session, int[] nArray) {
        return 1.0;
    }

    public String getCreateSQL() {
        return null;
    }

    public void remove(Session session) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    public void truncate(Session session) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    public boolean needRebuild() {
        return false;
    }

    public void checkRename() {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    public boolean canGetFirstOrLast() {
        return true;
    }

    public Cursor findFirstOrLast(Session session, boolean bl) {
        long l2 = bl ? this.cD.getMin(session) : this.cD.getMax(session);
        return new RangeCursor(l2, l2);
    }

    public long getRowCount(Session session) {
        return this.cD.getRowCountApproximation();
    }

    public long getRowCountApproximation() {
        return this.cD.getRowCountApproximation();
    }
}

