/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.ScanCursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.RegularTable;
import org.h2.util.New;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ScanIndex
extends BaseIndex {
    private long cr = -1L;
    private ArrayList cv = New.arrayList();
    private RegularTable cu;
    private int cs;
    private HashMap cw;
    private HashSet cx;
    private long ct;

    public ScanIndex(RegularTable regularTable, int n2, IndexColumn[] indexColumnArray, IndexType indexType) {
        this.initBaseIndex(regularTable, n2, regularTable.getName() + "_DATA", indexColumnArray, indexType);
        if (this.database.isMultiVersion()) {
            this.cw = New.hashMap();
        }
        this.cu = regularTable;
    }

    public void remove(Session session) {
        this.truncate(session);
    }

    public void truncate(Session session) {
        this.cv = New.arrayList();
        this.cr = -1L;
        if (this.cu.getContainsLargeObject() && this.cu.isPersistData()) {
            this.database.getLobStorage().removeAllForTable(this.table.getId());
        }
        this.cu.setRowCount(0L);
        this.ct = 0L;
        this.cs = 0;
        if (this.database.isMultiVersion()) {
            this.cw.clear();
        }
    }

    public String getCreateSQL() {
        return null;
    }

    public void close(Session session) {
    }

    public Row getRow(Session session, long l2) {
        return (Row)this.cv.get((int)l2);
    }

    public void add(Session session, Row row) {
        int n2;
        if (this.cr == -1L) {
            n2 = this.cv.size();
            row.setKey(n2);
            this.cv.add(row);
        } else {
            long l2 = this.cr;
            Row row2 = (Row)this.cv.get((int)l2);
            this.cr = row2.getKey();
            row.setKey(l2);
            this.cv.set((int)l2, row);
        }
        row.setDeleted(false);
        if (this.database.isMultiVersion()) {
            if (this.cx == null) {
                this.cx = New.hashSet();
            }
            if ((n2 = (int)(this.cx.remove(row) ? 1 : 0)) == 0) {
                this.cx.add(row);
            }
            this.if(session.getId(), 1);
        }
        ++this.ct;
    }

    public void commit(int n2, Row row) {
        if (this.database.isMultiVersion()) {
            if (this.cx != null) {
                this.cx.remove(row);
            }
            this.if(row.getSessionId(), n2 == 1 ? 1 : -1);
        }
    }

    private void if(int n2, int n3) {
        if (this.database.isMultiVersion()) {
            Integer n4 = n2;
            Integer n5 = (Integer)this.cw.get(n4);
            int n6 = n5 == null ? 0 : n5;
            this.cw.put(n4, n6 + n3);
            this.cs += n3;
        }
    }

    public void remove(Session session, Row row) {
        if (!this.database.isMultiVersion() && this.ct == 1L) {
            this.cv = New.arrayList();
            this.cr = -1L;
        } else {
            Row row2 = new Row(null, 1);
            row2.setKey(this.cr);
            long l2 = row.getKey();
            this.cv.set((int)l2, row2);
            this.cr = l2;
        }
        if (this.database.isMultiVersion()) {
            boolean bl;
            row.setDeleted(true);
            if (this.cx == null) {
                this.cx = New.hashSet();
            }
            if (!(bl = this.cx.remove(row))) {
                this.cx.add(row);
            }
            this.if(session.getId(), -1);
        }
        --this.ct;
    }

    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        return new ScanCursor(session, this, this.database.isMultiVersion());
    }

    public double getCost(Session session, int[] nArray) {
        return this.cu.getRowCountApproximation() + 1000L;
    }

    public long getRowCount(Session session) {
        if (this.database.isMultiVersion()) {
            Integer n2 = (Integer)this.cw.get(session.getId());
            long l2 = n2 == null ? 0L : (long)n2.intValue();
            l2 += this.ct;
            return l2 -= (long)this.cs;
        }
        return this.ct;
    }

    Row getNextRow(Session session, Row row) {
        long l2 = row == null ? -1L : row.getKey();
        do {
            if (++l2 < (long)this.cv.size()) continue;
            return null;
        } while ((row = (Row)this.cv.get((int)l2)).isEmpty());
        return row;
    }

    public int getColumnIndex(Column column) {
        return -1;
    }

    public void checkRename() {
        throw DbException.getUnsupportedException("SCAN");
    }

    public boolean needRebuild() {
        return false;
    }

    public boolean canGetFirstOrLast() {
        return false;
    }

    public Cursor findFirstOrLast(Session session, boolean bl) {
        throw DbException.getUnsupportedException("SCAN");
    }

    Iterator getDelta() {
        if (this.cx == null) {
            List list = Collections.emptyList();
            return list.iterator();
        }
        return this.cx.iterator();
    }

    public long getRowCountApproximation() {
        return this.ct;
    }

    public String getPlanSQL() {
        return this.table.getSQL() + ".tableScan";
    }
}

