/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.TreeCursor;
import org.h2.index.TreeNode;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.IndexColumn;
import org.h2.table.RegularTable;
import org.h2.value.Value;
import org.h2.value.ValueNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TreeIndex
extends BaseIndex {
    private TreeNode cl;
    private RegularTable cn;
    private long cm;

    public TreeIndex(RegularTable regularTable, int n2, String string, IndexColumn[] indexColumnArray, IndexType indexType) {
        this.initBaseIndex(regularTable, n2, string, indexColumnArray, indexType);
        this.cn = regularTable;
    }

    public void close(Session session) {
        this.cl = null;
    }

    public void add(Session session, Row row) {
        TreeNode treeNode;
        TreeNode treeNode2 = new TreeNode(row);
        TreeNode treeNode3 = treeNode = this.cl;
        boolean bl = true;
        while (true) {
            if (treeNode == null) {
                if (treeNode3 == null) {
                    this.cl = treeNode2;
                    ++this.cm;
                    return;
                }
                break;
            }
            Row row2 = treeNode.row;
            int n2 = this.compareRows(row, row2);
            if (n2 == 0) {
                if (this.indexType.isUnique() && !this.containsNullAndAllowMultipleNull(row)) {
                    throw this.getDuplicateKeyException();
                }
                n2 = this.compareKeys(row, row2);
            }
            bl = n2 < 0;
            treeNode3 = treeNode;
            treeNode = this.a(treeNode3, bl);
        }
        this.a(treeNode3, bl, treeNode2);
        this.if(treeNode3, bl);
        ++this.cm;
    }

    private void if(TreeNode treeNode, boolean bl) {
        while (true) {
            int n2 = bl ? 1 : -1;
            switch (treeNode.balance * n2) {
                case 1: {
                    treeNode.balance = 0;
                    return;
                }
                case 0: {
                    treeNode.balance = -n2;
                    break;
                }
                case -1: {
                    TreeNode treeNode2 = this.a(treeNode, bl);
                    if (treeNode2.balance == -n2) {
                        this.a(treeNode, treeNode2);
                        this.a(treeNode, bl, this.a(treeNode2, !bl));
                        this.a(treeNode2, !bl, treeNode);
                        treeNode.balance = 0;
                        treeNode2.balance = 0;
                    } else {
                        TreeNode treeNode3 = this.a(treeNode2, !bl);
                        this.a(treeNode, treeNode3);
                        this.a(treeNode2, !bl, this.a(treeNode3, bl));
                        this.a(treeNode3, bl, treeNode2);
                        this.a(treeNode, bl, this.a(treeNode3, !bl));
                        this.a(treeNode3, !bl, treeNode);
                        int n3 = treeNode3.balance;
                        treeNode.balance = n3 == -n2 ? n2 : 0;
                        treeNode2.balance = n3 == n2 ? -n2 : 0;
                        treeNode3.balance = 0;
                    }
                    return;
                }
                default: {
                    DbException.throwInternalError("b:" + treeNode.balance * n2);
                }
            }
            if (treeNode == this.cl) {
                return;
            }
            bl = treeNode.isFromLeft();
            treeNode = treeNode.parent;
        }
    }

    private TreeNode a(TreeNode treeNode, boolean bl) {
        return bl ? treeNode.left : treeNode.right;
    }

    private void a(TreeNode treeNode, TreeNode treeNode2) {
        if (treeNode == this.cl) {
            this.cl = treeNode2;
            if (treeNode2 != null) {
                treeNode2.parent = null;
            }
        } else {
            this.a(treeNode.parent, treeNode.isFromLeft(), treeNode2);
        }
    }

    private void a(TreeNode treeNode, boolean bl, TreeNode treeNode2) {
        if (bl) {
            treeNode.left = treeNode2;
        } else {
            treeNode.right = treeNode2;
        }
        if (treeNode2 != null) {
            treeNode2.parent = treeNode;
        }
    }

    public void remove(Session session, Row row) {
        TreeNode treeNode;
        int n2;
        TreeNode treeNode2;
        TreeNode treeNode3 = this.a(row, true);
        if (treeNode3 == null) {
            throw DbException.throwInternalError("not found!");
        }
        if (treeNode3.left == null) {
            treeNode2 = treeNode3.right;
        } else if (treeNode3.right == null) {
            treeNode2 = treeNode3.left;
        } else {
            TreeNode treeNode4 = treeNode3;
            TreeNode treeNode5 = treeNode3 = treeNode3.left;
            while ((treeNode5 = treeNode5.right) != null) {
                treeNode3 = treeNode5;
            }
            treeNode2 = treeNode3.left;
            n2 = treeNode3.balance;
            treeNode3.balance = treeNode4.balance;
            treeNode4.balance = n2;
            treeNode = treeNode3.parent;
            TreeNode treeNode6 = treeNode4.parent;
            if (treeNode4 == this.cl) {
                this.cl = treeNode3;
            }
            treeNode3.parent = treeNode6;
            if (treeNode6 != null) {
                if (treeNode6.right == treeNode4) {
                    treeNode6.right = treeNode3;
                } else {
                    treeNode6.left = treeNode3;
                }
            }
            if (treeNode == treeNode4) {
                treeNode4.parent = treeNode3;
                if (treeNode4.left == treeNode3) {
                    treeNode3.left = treeNode4;
                    treeNode3.right = treeNode4.right;
                } else {
                    treeNode3.right = treeNode4;
                    treeNode3.left = treeNode4.left;
                }
            } else {
                treeNode4.parent = treeNode;
                treeNode.right = treeNode4;
                treeNode3.right = treeNode4.right;
                treeNode3.left = treeNode4.left;
            }
            if (SysProperties.CHECK && treeNode3.right == null) {
                DbException.throwInternalError("tree corrupted");
            }
            treeNode3.right.parent = treeNode3;
            treeNode3.left.parent = treeNode3;
            treeNode4.left = treeNode2;
            if (treeNode2 != null) {
                treeNode2.parent = treeNode4;
            }
            treeNode4.right = null;
            treeNode3 = treeNode4;
        }
        --this.cm;
        boolean bl = treeNode3.isFromLeft();
        this.a(treeNode3, treeNode2);
        treeNode2 = treeNode3.parent;
        while (treeNode2 != null) {
            treeNode3 = treeNode2;
            n2 = bl ? 1 : -1;
            switch (treeNode3.balance * n2) {
                case -1: {
                    treeNode3.balance = 0;
                    break;
                }
                case 0: {
                    treeNode3.balance = n2;
                    return;
                }
                case 1: {
                    treeNode = this.a(treeNode3, !bl);
                    int n3 = treeNode.balance;
                    if (n3 * n2 >= 0) {
                        this.a(treeNode3, treeNode);
                        this.a(treeNode3, !bl, this.a(treeNode, bl));
                        this.a(treeNode, bl, treeNode3);
                        if (n3 == 0) {
                            treeNode3.balance = n2;
                            treeNode.balance = -n2;
                            return;
                        }
                        treeNode3.balance = 0;
                        treeNode.balance = 0;
                        treeNode3 = treeNode;
                        break;
                    }
                    TreeNode treeNode7 = this.a(treeNode, bl);
                    this.a(treeNode3, treeNode7);
                    n3 = treeNode7.balance;
                    this.a(treeNode, bl, this.a(treeNode7, !bl));
                    this.a(treeNode7, !bl, treeNode);
                    this.a(treeNode3, !bl, this.a(treeNode7, bl));
                    this.a(treeNode7, bl, treeNode3);
                    treeNode3.balance = n3 == n2 ? -n2 : 0;
                    treeNode.balance = n3 == -n2 ? n2 : 0;
                    treeNode7.balance = 0;
                    treeNode3 = treeNode7;
                    break;
                }
                default: {
                    DbException.throwInternalError("b: " + treeNode3.balance * n2);
                }
            }
            bl = treeNode3.isFromLeft();
            treeNode2 = treeNode3.parent;
        }
    }

    private TreeNode a(SearchRow searchRow, boolean bl) {
        TreeNode treeNode;
        TreeNode treeNode2 = treeNode = this.cl;
        while (treeNode != null) {
            treeNode2 = treeNode;
            int n2 = this.compareRows(treeNode.row, searchRow);
            if (n2 == 0 && bl) {
                n2 = this.compareKeys(treeNode.row, searchRow);
            }
            if (n2 == 0) {
                if (bl) {
                    return treeNode;
                }
                treeNode = treeNode.left;
                continue;
            }
            if (n2 > 0) {
                treeNode = treeNode.left;
                continue;
            }
            treeNode = treeNode.right;
        }
        return treeNode2;
    }

    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        if (searchRow == null) {
            TreeNode treeNode;
            TreeNode treeNode2 = this.cl;
            while (treeNode2 != null && (treeNode = treeNode2.left) != null) {
                treeNode2 = treeNode;
            }
            return new TreeCursor(this, treeNode2, null, searchRow2);
        }
        TreeNode treeNode = this.a(searchRow, false);
        return new TreeCursor(this, treeNode, searchRow, searchRow2);
    }

    public double getCost(Session session, int[] nArray) {
        return this.getCostRangeIndex(nArray, this.cn.getRowCountApproximation());
    }

    public void remove(Session session) {
        this.truncate(session);
    }

    public void truncate(Session session) {
        this.cl = null;
        this.cm = 0L;
    }

    TreeNode next(TreeNode treeNode) {
        if (treeNode == null) {
            return null;
        }
        TreeNode treeNode2 = treeNode.right;
        if (treeNode2 != null) {
            treeNode = treeNode2;
            TreeNode treeNode3 = treeNode.left;
            while (treeNode3 != null) {
                treeNode = treeNode3;
                treeNode3 = treeNode.left;
            }
            return treeNode;
        }
        TreeNode treeNode4 = treeNode;
        treeNode = treeNode.parent;
        while (treeNode != null && treeNode4 == treeNode.right) {
            treeNode4 = treeNode;
            treeNode = treeNode.parent;
        }
        return treeNode;
    }

    TreeNode previous(TreeNode treeNode) {
        if (treeNode == null) {
            return null;
        }
        TreeNode treeNode2 = treeNode.left;
        if (treeNode2 != null) {
            treeNode = treeNode2;
            TreeNode treeNode3 = treeNode.right;
            while (treeNode3 != null) {
                treeNode = treeNode3;
                treeNode3 = treeNode.right;
            }
            return treeNode;
        }
        TreeNode treeNode4 = treeNode;
        treeNode = treeNode.parent;
        while (treeNode != null && treeNode4 == treeNode.left) {
            treeNode4 = treeNode;
            treeNode = treeNode.parent;
        }
        return treeNode;
    }

    public void checkRename() {
    }

    public boolean needRebuild() {
        return true;
    }

    public boolean canGetFirstOrLast() {
        return true;
    }

    public Cursor findFirstOrLast(Session session, boolean bl) {
        SearchRow searchRow;
        TreeNode treeNode;
        if (bl) {
            Cursor cursor = this.find(session, null, null);
            while (cursor.next()) {
                SearchRow searchRow2 = cursor.getSearchRow();
                Value value = searchRow2.getValue(this.columnIds[0]);
                if (value == ValueNull.INSTANCE) continue;
                return cursor;
            }
            return cursor;
        }
        TreeNode treeNode2 = this.cl;
        while (treeNode2 != null && (treeNode = treeNode2.right) != null) {
            treeNode2 = treeNode;
        }
        TreeCursor treeCursor = new TreeCursor(this, treeNode2, null, null);
        if (treeNode2 == null) {
            return treeCursor;
        }
        while ((searchRow = treeCursor.getSearchRow()) != null) {
            Value value = searchRow.getValue(this.columnIds[0]);
            if (value != ValueNull.INSTANCE) {
                return treeCursor;
            }
            if (treeCursor.previous()) continue;
        }
        return treeCursor;
    }

    public long getRowCount(Session session) {
        return this.cm;
    }

    public long getRowCountApproximation() {
        return this.cm;
    }
}

