/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.tools.SimpleResultSet;
import org.h2.value.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JdbcArray
extends TraceObject
implements Array {
    private Value C;
    private JdbcConnection B;

    JdbcArray(JdbcConnection jdbcConnection, Value value, int n2) {
        this.setTrace(jdbcConnection.getSession().getTrace(), 15, n2);
        this.B = jdbcConnection;
        this.C = value;
    }

    public Object getArray() throws SQLException {
        try {
            this.debugCodeCall("getArray");
            this.goto();
            return this.else();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Object getArray(Map map) throws SQLException {
        try {
            this.debugCode("getArray(" + this.quoteMap(map) + ");");
            this.if(map);
            this.goto();
            return this.else();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Object getArray(long l2, int n2) throws SQLException {
        try {
            this.debugCode("getArray(" + l2 + ", " + n2 + ");");
            this.goto();
            return this.a(l2, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Object getArray(long l2, int n2, Map map) throws SQLException {
        try {
            this.debugCode("getArray(" + l2 + ", " + n2 + ", " + this.quoteMap(map) + ");");
            this.goto();
            this.if(map);
            return this.a(l2, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getBaseType() throws SQLException {
        try {
            this.debugCodeCall("getBaseType");
            this.goto();
            return 0;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public String getBaseTypeName() throws SQLException {
        try {
            this.debugCodeCall("getBaseTypeName");
            this.goto();
            return "NULL";
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public ResultSet getResultSet() throws SQLException {
        try {
            this.debugCodeCall("getResultSet");
            this.goto();
            return this.a(this.else(), 0L);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public ResultSet getResultSet(Map map) throws SQLException {
        try {
            this.debugCode("getResultSet(" + this.quoteMap(map) + ");");
            this.goto();
            this.if(map);
            return this.a(this.else(), 0L);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public ResultSet getResultSet(long l2, int n2) throws SQLException {
        try {
            this.debugCode("getResultSet(" + l2 + ", " + n2 + ");");
            this.goto();
            return this.a(this.a(l2, n2), l2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public ResultSet getResultSet(long l2, int n2, Map map) throws SQLException {
        try {
            this.debugCode("getResultSet(" + l2 + ", " + n2 + ", " + this.quoteMap(map) + ");");
            this.goto();
            this.if(map);
            return this.a(this.a(l2, n2), l2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void free() {
        this.debugCodeCall("free");
        this.C = null;
    }

    private ResultSet a(Object[] objectArray, long l2) {
        SimpleResultSet simpleResultSet = new SimpleResultSet();
        simpleResultSet.addColumn("INDEX", -5, 0, 0);
        simpleResultSet.addColumn("VALUE", 0, 0, 0);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            simpleResultSet.addRow(l2 + (long)i2 + 1L, objectArray[i2]);
        }
        return simpleResultSet;
    }

    private void goto() throws SQLException {
        this.B.checkClosed();
        if (this.C == null) {
            throw DbException.get(90007);
        }
    }

    private Object[] else() {
        return (Object[])this.C.convertTo(17).getObject();
    }

    private Object[] a(long l2, int n2) {
        Object[] objectArray = this.else();
        if (n2 < 0 || n2 > objectArray.length) {
            throw DbException.getInvalidValueException("count (1.." + objectArray.length + ")", n2);
        }
        if (l2 < 1L || l2 > (long)objectArray.length) {
            throw DbException.getInvalidValueException("index (1.." + objectArray.length + ")", l2);
        }
        Object[] objectArray2 = new Object[n2];
        System.arraycopy(objectArray, (int)(l2 - 1L), objectArray2, 0, n2);
        return objectArray2;
    }

    private void if(Map map) {
        if (map != null && map.size() > 0) {
            throw DbException.getUnsupportedException("map.size > 0");
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": " + this.C.getTraceSQL();
    }
}

