/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.util.IOUtils;
import org.h2.util.Task;
import org.h2.value.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JdbcBlob
extends TraceObject
implements Blob {
    Value value;
    private JdbcConnection A;

    public JdbcBlob(JdbcConnection jdbcConnection, Value value, int n2) {
        this.setTrace(jdbcConnection.getSession().getTrace(), 9, n2);
        this.A = jdbcConnection;
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() throws SQLException {
        try {
            long l2;
            this.debugCodeCall("length");
            this.char();
            if (this.value.getType() == 15 && (l2 = this.value.getPrecision()) > 0L) {
                return l2;
            }
            l2 = 0L;
            InputStream inputStream = this.value.getInputStream();
            try {
                int n2;
                byte[] byArray = new byte[4096];
                while ((n2 = inputStream.read(byArray, 0, 4096)) > 0) {
                    l2 += (long)n2;
                }
            }
            finally {
                inputStream.close();
            }
            return l2;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void truncate(long l2) throws SQLException {
        throw this.unsupported("LOB update");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(long l2, int n2) throws SQLException {
        try {
            this.debugCode("getBytes(" + l2 + ", " + n2 + ");");
            this.char();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            InputStream inputStream = this.value.getInputStream();
            try {
                IOUtils.skipFully(inputStream, l2 - 1L);
                while (n2 > 0) {
                    int n3 = inputStream.read();
                    if (n3 < 0) {
                        break;
                    }
                    byteArrayOutputStream.write(n3);
                    --n2;
                }
            }
            finally {
                inputStream.close();
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int setBytes(long l2, byte[] byArray) throws SQLException {
        try {
            if (l2 != 1L) {
                throw DbException.getInvalidValueException("pos", l2);
            }
            this.value = this.A.createBlob(new ByteArrayInputStream(byArray), -1L);
            return byArray.length;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int setBytes(long l2, byte[] byArray, int n2, int n3) throws SQLException {
        throw this.unsupported("LOB update");
    }

    public InputStream getBinaryStream() throws SQLException {
        try {
            this.debugCodeCall("getBinaryStream");
            this.char();
            return this.value.getInputStream();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public OutputStream setBinaryStream(long l2) throws SQLException {
        try {
            if (l2 != 1L) {
                throw DbException.getInvalidValueException("pos", l2);
            }
            if (this.value.getPrecision() != 0L) {
                throw DbException.getInvalidValueException("length", this.value.getPrecision());
            }
            final JdbcConnection jdbcConnection = this.A;
            final PipedInputStream pipedInputStream = new PipedInputStream();
            final Task task = new Task(){

                public void call() {
                    JdbcBlob.this.value = jdbcConnection.createBlob(pipedInputStream, -1L);
                }
            };
            PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream){

                public void close() throws IOException {
                    super.close();
                    try {
                        task.get();
                    }
                    catch (Exception exception) {
                        throw DbException.convertToIOException(exception);
                    }
                }
            };
            task.execute();
            return new BufferedOutputStream(pipedOutputStream);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public long position(byte[] byArray, long l2) throws SQLException {
        this.debugCode("position(pattern, " + l2 + ");");
        throw this.unsupported("LOB search");
    }

    public long position(Blob blob, long l2) throws SQLException {
        this.debugCode("position(blobPattern, " + l2 + ");");
        throw this.unsupported("LOB subset");
    }

    public void free() {
        this.debugCodeCall("free");
        this.value = null;
    }

    public InputStream getBinaryStream(long l2, long l3) throws SQLException {
        throw this.unsupported("LOB update");
    }

    private void char() throws SQLException {
        this.A.checkClosed();
        if (this.value == null) {
            throw DbException.get(90007);
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": " + this.value.getTraceSQL();
    }
}

