/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.h2.expression.ParameterInterface;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.jdbc.JdbcResultSet;
import org.h2.message.DbException;
import org.h2.util.BitField;
import org.h2.util.New;
import org.h2.value.ValueNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JdbcCallableStatement
extends JdbcPreparedStatement
implements CallableStatement {
    private BitField L;
    private int M;
    private HashMap K;

    JdbcCallableStatement(JdbcConnection jdbcConnection, String string, int n2, int n3, int n4) {
        super(jdbcConnection, string, n2, n3, n4, false);
        this.setTrace(this.session.getTrace(), 0, n2);
    }

    public boolean execute() throws SQLException {
        try {
            this.checkClosed();
            if (this.command.isQuery()) {
                super.executeQuery().next();
                return true;
            }
            super.executeUpdate();
            return false;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int executeUpdate() throws SQLException {
        try {
            this.checkClosed();
            if (this.command.isQuery()) {
                super.executeQuery().next();
                return 0;
            }
            return super.executeUpdate();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void registerOutParameter(int n2, int n3) throws SQLException {
        this.for(n2);
    }

    public void registerOutParameter(int n2, int n3, String string) throws SQLException {
        this.for(n2);
    }

    public void registerOutParameter(int n2, int n3, int n4) throws SQLException {
        this.for(n2);
    }

    public void registerOutParameter(String string, int n2, String string2) throws SQLException {
        this.registerOutParameter(this.byte(string), n2, string2);
    }

    public void registerOutParameter(String string, int n2, int n3) throws SQLException {
        this.registerOutParameter(this.byte(string), n2, n3);
    }

    public void registerOutParameter(String string, int n2) throws SQLException {
        this.registerOutParameter(this.byte(string), n2);
    }

    public boolean wasNull() throws SQLException {
        return this.void().wasNull();
    }

    public URL getURL(int n2) throws SQLException {
        throw this.unsupported("url");
    }

    public String getString(int n2) throws SQLException {
        this.new(n2);
        return this.void().getString(n2);
    }

    public boolean getBoolean(int n2) throws SQLException {
        this.new(n2);
        return this.void().getBoolean(n2);
    }

    public byte getByte(int n2) throws SQLException {
        this.new(n2);
        return this.void().getByte(n2);
    }

    public short getShort(int n2) throws SQLException {
        this.new(n2);
        return this.void().getShort(n2);
    }

    public int getInt(int n2) throws SQLException {
        this.new(n2);
        return this.void().getInt(n2);
    }

    public long getLong(int n2) throws SQLException {
        this.new(n2);
        return this.void().getLong(n2);
    }

    public float getFloat(int n2) throws SQLException {
        this.new(n2);
        return this.void().getFloat(n2);
    }

    public double getDouble(int n2) throws SQLException {
        this.new(n2);
        return this.void().getDouble(n2);
    }

    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        this.new(n2);
        return this.void().getBigDecimal(n2, n3);
    }

    public byte[] getBytes(int n2) throws SQLException {
        this.new(n2);
        return this.void().getBytes(n2);
    }

    public Date getDate(int n2) throws SQLException {
        this.new(n2);
        return this.void().getDate(n2);
    }

    public Time getTime(int n2) throws SQLException {
        this.new(n2);
        return this.void().getTime(n2);
    }

    public Timestamp getTimestamp(int n2) throws SQLException {
        this.new(n2);
        return this.void().getTimestamp(n2);
    }

    public Object getObject(int n2) throws SQLException {
        this.new(n2);
        return this.void().getObject(n2);
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        this.new(n2);
        return this.void().getBigDecimal(n2);
    }

    public Object getObject(int n2, Map map) throws SQLException {
        throw this.unsupported("map");
    }

    public Ref getRef(int n2) throws SQLException {
        throw this.unsupported("ref");
    }

    public Blob getBlob(int n2) throws SQLException {
        this.new(n2);
        return this.void().getBlob(n2);
    }

    public Clob getClob(int n2) throws SQLException {
        this.new(n2);
        return this.void().getClob(n2);
    }

    public Array getArray(int n2) throws SQLException {
        this.new(n2);
        return this.void().getArray(n2);
    }

    public Date getDate(int n2, Calendar calendar) throws SQLException {
        this.new(n2);
        return this.void().getDate(n2, calendar);
    }

    public Time getTime(int n2, Calendar calendar) throws SQLException {
        this.new(n2);
        return this.void().getTime(n2, calendar);
    }

    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        this.new(n2);
        return this.void().getTimestamp(n2, calendar);
    }

    public URL getURL(String string) throws SQLException {
        throw this.unsupported("url");
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.byte(string), calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.byte(string), calendar);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.byte(string), calendar);
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.byte(string));
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.byte(string));
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.byte(string));
    }

    public Ref getRef(String string) throws SQLException {
        throw this.unsupported("ref");
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw this.unsupported("map");
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.byte(string));
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.byte(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.byte(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.byte(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.byte(string));
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.byte(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.byte(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.byte(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.byte(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.byte(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.byte(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.byte(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.byte(string));
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.byte(string));
    }

    public void setNull(String string, int n2, String string2) throws SQLException {
        this.setNull(this.byte(string), n2, string2);
    }

    public void setNull(String string, int n2) throws SQLException {
        this.setNull(this.byte(string), n2);
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(this.byte(string), timestamp, calendar);
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        this.setTime(this.byte(string), time, calendar);
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        this.setDate(this.byte(string), date, calendar);
    }

    public void setCharacterStream(String string, Reader reader, int n2) throws SQLException {
        this.setCharacterStream(this.byte(string), reader, n2);
    }

    public void setObject(String string, Object object) throws SQLException {
        this.setObject(this.byte(string), object);
    }

    public void setObject(String string, Object object, int n2) throws SQLException {
        this.setObject(this.byte(string), object, n2);
    }

    public void setObject(String string, Object object, int n2, int n3) throws SQLException {
        this.setObject(this.byte(string), object, n2, n3);
    }

    public void setBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.setBinaryStream(this.byte(string), inputStream, n2);
    }

    public void setAsciiStream(String string, InputStream inputStream, long l2) throws SQLException {
        this.setAsciiStream(this.byte(string), inputStream, l2);
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.setTimestamp(this.byte(string), timestamp);
    }

    public void setTime(String string, Time time) throws SQLException {
        this.setTime(this.byte(string), time);
    }

    public void setDate(String string, Date date) throws SQLException {
        this.setDate(this.byte(string), date);
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        this.setBytes(this.byte(string), byArray);
    }

    public void setString(String string, String string2) throws SQLException {
        this.setString(this.byte(string), string2);
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.setBigDecimal(this.byte(string), bigDecimal);
    }

    public void setDouble(String string, double d2) throws SQLException {
        this.setDouble(this.byte(string), d2);
    }

    public void setFloat(String string, float f2) throws SQLException {
        this.setFloat(this.byte(string), f2);
    }

    public void setLong(String string, long l2) throws SQLException {
        this.setLong(this.byte(string), l2);
    }

    public void setInt(String string, int n2) throws SQLException {
        this.setInt(this.byte(string), n2);
    }

    public void setShort(String string, short s) throws SQLException {
        this.setShort(this.byte(string), s);
    }

    public void setByte(String string, byte by) throws SQLException {
        this.setByte(this.byte(string), by);
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        this.setBoolean(this.byte(string), bl);
    }

    public void setURL(String string, URL uRL) throws SQLException {
        throw this.unsupported("url");
    }

    public void setAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.setAsciiStream(this.byte(string), inputStream, n2);
    }

    private ResultSetMetaData b() throws SQLException {
        ResultSetMetaData resultSetMetaData = this.getMetaData();
        if (resultSetMetaData == null) {
            throw DbException.getUnsupportedException("Supported only for calling stored procedures");
        }
        return resultSetMetaData;
    }

    private void int(int n2) throws SQLException {
        this.checkClosed();
        if (n2 < 1 || n2 > this.M) {
            throw DbException.getInvalidValueException("parameterIndex", n2);
        }
    }

    private void for(int n2) throws SQLException {
        try {
            this.checkClosed();
            if (this.L == null) {
                this.M = Math.min(this.getParameterMetaData().getParameterCount(), this.b().getColumnCount());
                this.L = new BitField();
            }
            this.int(n2);
            ParameterInterface parameterInterface = (ParameterInterface)this.command.getParameters().get(--n2);
            if (parameterInterface.getParamValue() == null) {
                parameterInterface.setValue(ValueNull.INSTANCE, false);
            }
            this.L.set(n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private void new(int n2) throws SQLException {
        try {
            this.int(n2);
            if (!this.L.get(n2 - 1)) {
                throw DbException.getInvalidValueException("parameterIndex", n2);
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private int byte(String string) throws SQLException {
        try {
            Object object;
            this.checkClosed();
            if (this.K == null) {
                object = this.b();
                int n2 = object.getColumnCount();
                HashMap hashMap = New.hashMap(n2);
                for (int i2 = 1; i2 <= n2; ++i2) {
                    hashMap.put(object.getColumnLabel(i2), i2);
                }
                this.K = hashMap;
            }
            if ((object = (Integer)this.K.get(string)) == null) {
                throw DbException.getInvalidValueException("parameterName", string);
            }
            return (Integer)object;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private JdbcResultSet void() throws SQLException {
        try {
            this.checkClosed();
            if (this.resultSet == null) {
                throw DbException.get(2000);
            }
            return this.resultSet;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }
}

