/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.util.IOUtils;
import org.h2.util.Task;
import org.h2.value.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JdbcClob
extends TraceObject
implements Clob {
    Value value;
    private JdbcConnection s;

    public JdbcClob(JdbcConnection jdbcConnection, Value value, int n2) {
        this.setTrace(jdbcConnection.getSession().getTrace(), 10, n2);
        this.s = jdbcConnection;
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() throws SQLException {
        long l2;
        long l3;
        this.debugCodeCall("length");
        this.try();
        if (this.value.getType() == 16 && (l3 = this.value.getPrecision()) > 0L) {
            return l3;
        }
        Reader reader = this.value.getReader();
        try {
            int n2;
            long l4 = 0L;
            char[] cArray = new char[4096];
            while ((n2 = reader.read(cArray, 0, 4096)) > 0) {
                l4 += (long)n2;
            }
            l2 = l4;
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (Exception exception) {
                throw this.logAndConvert(exception);
            }
        }
        reader.close();
        return l2;
    }

    public void truncate(long l2) throws SQLException {
        throw this.unsupported("LOB update");
    }

    public InputStream getAsciiStream() throws SQLException {
        try {
            this.debugCodeCall("getAsciiStream");
            this.try();
            String string = this.value.getString();
            return IOUtils.getInputStream(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public OutputStream setAsciiStream(long l2) throws SQLException {
        throw this.unsupported("LOB update");
    }

    public Reader getCharacterStream() throws SQLException {
        try {
            this.debugCodeCall("getCharacterStream");
            this.try();
            return this.value.getReader();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Writer setCharacterStream(long l2) throws SQLException {
        try {
            if (l2 != 1L) {
                throw DbException.getInvalidValueException("pos", l2);
            }
            if (this.value.getPrecision() != 0L) {
                throw DbException.getInvalidValueException("length", this.value.getPrecision());
            }
            final JdbcConnection jdbcConnection = this.s;
            final PipedInputStream pipedInputStream = new PipedInputStream();
            final Task task = new Task(){

                public void call() {
                    JdbcClob.this.value = jdbcConnection.createClob(IOUtils.getReader(pipedInputStream), -1L);
                }
            };
            PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream){

                public void close() throws IOException {
                    super.close();
                    try {
                        task.get();
                    }
                    catch (Exception exception) {
                        throw DbException.convertToIOException(exception);
                    }
                }
            };
            task.execute();
            return IOUtils.getBufferedWriter(pipedOutputStream);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSubString(long l2, int n2) throws SQLException {
        try {
            this.debugCode("getSubString(" + l2 + ", " + n2 + ");");
            this.try();
            if (l2 < 1L) {
                throw DbException.getInvalidValueException("pos", l2);
            }
            if (n2 < 0) {
                throw DbException.getInvalidValueException("length", n2);
            }
            StringBuilder stringBuilder = new StringBuilder(Math.min(4096, n2));
            Reader reader = this.value.getReader();
            try {
                IOUtils.skipFully(reader, l2 - 1L);
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n3 = reader.read();
                    if (n3 < 0) {
                        break;
                    }
                    stringBuilder.append((char)n3);
                }
            }
            finally {
                reader.close();
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int setString(long l2, String string) throws SQLException {
        try {
            if (l2 != 1L) {
                throw DbException.getInvalidValueException("pos", l2);
            }
            this.value = this.s.createClob(new StringReader(string), -1L);
            return string.length();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int setString(long l2, String string, int n2, int n3) throws SQLException {
        throw this.unsupported("LOB update");
    }

    public long position(String string, long l2) throws SQLException {
        throw this.unsupported("LOB search");
    }

    public long position(Clob clob, long l2) throws SQLException {
        throw this.unsupported("LOB search");
    }

    public void free() {
        this.debugCodeCall("free");
        this.value = null;
    }

    private void try() throws SQLException {
        this.s.checkClosed();
        if (this.value == null) {
            throw DbException.get(90007);
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": " + this.value.getTraceSQL();
    }
}

