/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import org.h2.command.CommandInterface;
import org.h2.constant.SysProperties;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.SessionInterface;
import org.h2.engine.SessionRemote;
import org.h2.expression.ParameterInterface;
import org.h2.jdbc.JdbcBlob;
import org.h2.jdbc.JdbcCallableStatement;
import org.h2.jdbc.JdbcClob;
import org.h2.jdbc.JdbcDatabaseMetaData;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.jdbc.JdbcResultSet;
import org.h2.jdbc.JdbcSavepoint;
import org.h2.jdbc.JdbcStatement;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceObject;
import org.h2.result.ResultInterface;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueInt;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JdbcConnection
extends TraceObject
implements Connection {
    protected Exception openStackTrace;
    private String c;
    private String q;
    private int i = 1;
    private SessionInterface long;
    private CommandInterface j;
    private CommandInterface g;
    private CommandInterface m;
    private CommandInterface void;
    private CommandInterface f;
    private CommandInterface b;
    private CommandInterface k;
    private CommandInterface e;
    private int h;
    private Trace o;
    private boolean n;
    private String d;
    private Statement p;
    private CompareMode l = CompareMode.getInstance(null, 0);

    public JdbcConnection(String string, Properties properties) throws SQLException {
        this(new ConnectionInfo(string, properties), true);
    }

    public JdbcConnection(ConnectionInfo connectionInfo, boolean bl) throws SQLException {
        try {
            String string;
            if (bl && (string = SysProperties.getBaseDir()) != null) {
                connectionInfo.setBaseDir(string);
            }
            this.new();
            this.long = new SessionRemote(connectionInfo).createSession(connectionInfo);
            this.o = this.long.getTrace();
            int n2 = this.getNextId(1);
            this.setTrace(this.o, 1, n2);
            this.q = connectionInfo.getUserName();
            if (this.isInfoEnabled()) {
                this.o.infoCode("Connection " + this.getTraceObjectName() + " = DriverManager.getConnection(" + this.quote(connectionInfo.getOriginalURL()) + ", " + this.quote(this.q) + ", \"\");");
            }
            this.c = connectionInfo.getURL();
            this.openStackTrace = new Exception("Stack Trace");
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public JdbcConnection(JdbcConnection jdbcConnection) {
        this.long = jdbcConnection.long;
        this.o = this.long.getTrace();
        int n2 = this.getNextId(1);
        this.setTrace(this.o, 1, n2);
        this.q = jdbcConnection.q;
        this.c = jdbcConnection.c;
    }

    public JdbcConnection(SessionInterface sessionInterface, String string, String string2) {
        this.n = true;
        this.long = sessionInterface;
        this.o = sessionInterface.getTrace();
        int n2 = this.getNextId(1);
        this.setTrace(this.o, 1, n2);
        this.q = string;
        this.c = string2;
    }

    public Statement createStatement() throws SQLException {
        try {
            int n2 = this.getNextId(8);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Statement", 8, n2, "createStatement()");
            }
            this.checkClosed();
            return new JdbcStatement(this, n2, 1003, 1007, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Statement createStatement(int n2, int n3) throws SQLException {
        try {
            int n4 = this.getNextId(8);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Statement", 8, n4, "createStatement(" + n2 + ", " + n3 + ")");
            }
            this.a(n2, n3);
            this.checkClosed();
            return new JdbcStatement(this, n4, n2, n3, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Statement createStatement(int n2, int n3, int n4) throws SQLException {
        try {
            int n5 = this.getNextId(8);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Statement", 8, n5, "createStatement(" + n2 + ", " + n3 + ", " + n4 + ")");
            }
            this.a(n2, n3);
            this.if(n4);
            this.checkClosed();
            return new JdbcStatement(this, n5, n2, n3, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        try {
            int n2 = this.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, n2, "prepareStatement(" + this.quote(string) + ")");
            }
            this.checkClosed();
            string = this.int(string);
            return new JdbcPreparedStatement(this, string, n2, 1003, 1007, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    PreparedStatement prepareAutoCloseStatement(String string) throws SQLException {
        try {
            int n2 = this.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, n2, "prepareStatement(" + this.quote(string) + ")");
            }
            this.checkClosed();
            string = this.int(string);
            return new JdbcPreparedStatement(this, string, n2, 1003, 1007, true);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            int n2 = this.getNextId(2);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("DatabaseMetaData", 2, n2, "getMetaData()");
            }
            this.checkClosed();
            return new JdbcDatabaseMetaData(this, this.o, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public SessionInterface getSession() {
        return this.long;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        try {
            this.debugCodeCall("close");
            this.openStackTrace = null;
            if (this.long == null) {
                return;
            }
            this.long.cancel();
            if (this.p != null) {
                try {
                    this.p.cancel();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            SessionInterface sessionInterface = this.long;
            synchronized (sessionInterface) {
                block16: {
                    try {
                        if (this.long.isClosed()) break block16;
                        try {
                            if (!this.long.isReconnectNeeded(true)) {
                                this.int();
                                this.long.afterWriting();
                            }
                            this.do();
                        }
                        finally {
                            this.long.close();
                        }
                    }
                    finally {
                        this.long = null;
                    }
                }
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private void do() {
        this.j = this.a(this.j);
        this.g = this.a(this.g);
        this.m = this.a(this.m);
        this.void = this.a(this.void);
        this.b = this.a(this.b);
        this.f = this.a(this.f);
        this.e = this.a(this.e);
        this.k = this.a(this.k);
    }

    private CommandInterface a(CommandInterface commandInterface) {
        if (commandInterface != null) {
            commandInterface.close();
        }
        return null;
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setAutoCommit(" + bl + ");");
            }
            this.checkClosed();
            this.long.setAutoCommit(bl);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public synchronized boolean getAutoCommit() throws SQLException {
        try {
            this.checkClosed();
            this.debugCodeCall("getAutoCommit");
            return this.long.getAutoCommit();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit() throws SQLException {
        try {
            this.debugCodeCall("commit");
            this.for();
            try {
                this.j = this.a("COMMIT", this.j);
                this.j.executeUpdate();
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback() throws SQLException {
        try {
            this.debugCodeCall("rollback");
            this.for();
            try {
                this.int();
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean isClosed() throws SQLException {
        try {
            this.debugCodeCall("isClosed");
            return this.long == null || this.long.isClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public String nativeSQL(String string) throws SQLException {
        try {
            this.debugCodeCall("nativeSQL", string);
            this.checkClosed();
            return this.int(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setReadOnly(boolean bl) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setReadOnly(" + bl + ");");
            }
            this.checkClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean isReadOnly() throws SQLException {
        try {
            this.debugCodeCall("isReadOnly");
            this.checkClosed();
            this.m = this.a("CALL READONLY()", this.m);
            ResultInterface resultInterface = this.m.executeQuery(0, false);
            resultInterface.next();
            boolean bl = resultInterface.currentRow()[0].getBoolean();
            return bl;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setCatalog(String string) throws SQLException {
        try {
            this.debugCodeCall("setCatalog", string);
            this.checkClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public String getCatalog() throws SQLException {
        try {
            this.debugCodeCall("getCatalog");
            this.checkClosed();
            if (this.d == null) {
                CommandInterface commandInterface = this.prepareCommand("CALL DATABASE()", Integer.MAX_VALUE);
                ResultInterface resultInterface = commandInterface.executeQuery(0, false);
                resultInterface.next();
                this.d = resultInterface.currentRow()[0].getString();
                commandInterface.close();
            }
            return this.d;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            this.debugCodeCall("getWarnings");
            this.checkClosed();
            return null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.debugCodeCall("clearWarnings");
            this.checkClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public PreparedStatement prepareStatement(String string, int n2, int n3) throws SQLException {
        try {
            int n4 = this.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, n4, "prepareStatement(" + this.quote(string) + ", " + n2 + ", " + n3 + ")");
            }
            this.a(n2, n3);
            this.checkClosed();
            string = this.int(string);
            return new JdbcPreparedStatement(this, string, n4, n2, n3, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setTransactionIsolation(int n2) throws SQLException {
        try {
            int n3;
            this.debugCodeCall("setTransactionIsolation", n2);
            this.checkClosed();
            switch (n2) {
                case 1: {
                    n3 = 0;
                    break;
                }
                case 2: {
                    n3 = 3;
                    break;
                }
                case 4: 
                case 8: {
                    n3 = 1;
                    break;
                }
                default: {
                    throw DbException.getInvalidValueException("level", n2);
                }
            }
            this.commit();
            this.f = this.a("SET LOCK_MODE ?", this.f);
            ((ParameterInterface)this.f.getParameters().get(0)).setValue(ValueInt.get(n3), false);
            this.f.executeUpdate();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setQueryTimeout(int n2) throws SQLException {
        try {
            this.debugCodeCall("setQueryTimeout", n2);
            this.checkClosed();
            this.k = this.a("SET QUERY_TIMEOUT ?", this.k);
            ((ParameterInterface)this.k.getParameters().get(0)).setValue(ValueInt.get(n2 * 1000), false);
            this.k.executeUpdate();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getQueryTimeout() throws SQLException {
        try {
            this.debugCodeCall("getQueryTimeout");
            this.checkClosed();
            this.e = this.a("SELECT VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE NAME=?", this.e);
            ((ParameterInterface)this.e.getParameters().get(0)).setValue(ValueString.get("QUERY_TIMEOUT"), false);
            ResultInterface resultInterface = this.e.executeQuery(0, false);
            resultInterface.next();
            int n2 = resultInterface.currentRow()[0].getInt();
            resultInterface.close();
            if (n2 == 0) {
                return 0;
            }
            return (n2 + 999) / 1000;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getTransactionIsolation() throws SQLException {
        try {
            int n2;
            this.debugCodeCall("getTransactionIsolation");
            this.checkClosed();
            this.b = this.a("CALL LOCK_MODE()", this.b);
            ResultInterface resultInterface = this.b.executeQuery(0, false);
            resultInterface.next();
            int n3 = resultInterface.currentRow()[0].getInt();
            resultInterface.close();
            switch (n3) {
                case 0: {
                    n2 = 1;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 8;
                    break;
                }
                default: {
                    throw DbException.throwInternalError("lockMode:" + n3);
                }
            }
            return n2;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setHoldability(int n2) throws SQLException {
        try {
            this.debugCodeCall("setHoldability", n2);
            this.checkClosed();
            this.if(n2);
            this.i = n2;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getHoldability() throws SQLException {
        try {
            this.debugCodeCall("getHoldability");
            this.checkClosed();
            return this.i;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Map getTypeMap() throws SQLException {
        try {
            this.debugCodeCall("getTypeMap");
            this.checkClosed();
            return null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        try {
            this.debugCode("setTypeMap(" + this.quoteMap(map) + ");");
            this.a(map);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        try {
            int n2 = this.getNextId(0);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("CallableStatement", 0, n2, "prepareCall(" + this.quote(string) + ")");
            }
            this.checkClosed();
            string = this.int(string);
            return new JdbcCallableStatement(this, string, n2, 1003, 1007);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public CallableStatement prepareCall(String string, int n2, int n3) throws SQLException {
        try {
            int n4 = this.getNextId(0);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("CallableStatement", 0, n4, "prepareCall(" + this.quote(string) + ", " + n2 + ", " + n3 + ")");
            }
            this.a(n2, n3);
            this.checkClosed();
            string = this.int(string);
            return new JdbcCallableStatement(this, string, n4, n2, n3);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public CallableStatement prepareCall(String string, int n2, int n3, int n4) throws SQLException {
        try {
            int n5 = this.getNextId(0);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("CallableStatement", 0, n5, "prepareCall(" + this.quote(string) + ", " + n2 + ", " + n3 + ", " + n4 + ")");
            }
            this.a(n2, n3);
            this.if(n4);
            this.checkClosed();
            string = this.int(string);
            return new JdbcCallableStatement(this, string, n5, n2, n3);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        try {
            int n2 = this.getNextId(6);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Savepoint", 6, n2, "setSavepoint()");
            }
            this.checkClosed();
            CommandInterface commandInterface = this.prepareCommand("SAVEPOINT " + JdbcSavepoint.getName(null, this.h), Integer.MAX_VALUE);
            commandInterface.executeUpdate();
            JdbcSavepoint jdbcSavepoint = new JdbcSavepoint(this, this.h, null, this.o, n2);
            ++this.h;
            return jdbcSavepoint;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        try {
            int n2 = this.getNextId(6);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Savepoint", 6, n2, "setSavepoint(" + this.quote(string) + ")");
            }
            this.checkClosed();
            CommandInterface commandInterface = this.prepareCommand("SAVEPOINT " + JdbcSavepoint.getName(string, 0), Integer.MAX_VALUE);
            commandInterface.executeUpdate();
            JdbcSavepoint jdbcSavepoint = new JdbcSavepoint(this, 0, string, this.o, n2);
            return jdbcSavepoint;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            JdbcSavepoint jdbcSavepoint = this.a(savepoint);
            this.debugCode("rollback(" + jdbcSavepoint.getTraceObjectName() + ");");
            this.for();
            try {
                jdbcSavepoint.rollback();
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.debugCode("releaseSavepoint(savepoint);");
            this.checkClosed();
            this.a(savepoint).release();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private JdbcSavepoint a(Savepoint savepoint) {
        if (!(savepoint instanceof JdbcSavepoint)) {
            throw DbException.get(90063, "" + savepoint);
        }
        return (JdbcSavepoint)savepoint;
    }

    public PreparedStatement prepareStatement(String string, int n2, int n3, int n4) throws SQLException {
        try {
            int n5 = this.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, n5, "prepareStatement(" + this.quote(string) + ", " + n2 + ", " + n3 + ", " + n4 + ")");
            }
            this.a(n2, n3);
            this.if(n4);
            this.checkClosed();
            string = this.int(string);
            return new JdbcPreparedStatement(this, string, n5, n2, n3, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public PreparedStatement prepareStatement(String string, int n2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("prepareStatement(" + this.quote(string) + ", " + n2 + ");");
            }
            return this.prepareStatement(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("prepareStatement(" + this.quote(string) + ", " + this.quoteIntArray(nArray) + ");");
            }
            return this.prepareStatement(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("prepareStatement(" + this.quote(string) + ", " + this.quoteArray(stringArray) + ");");
            }
            return this.prepareStatement(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private void new() {
        try {
            Class<Savepoint> clazz = Savepoint.class;
            clazz.getClass();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw DbException.get(90092);
        }
    }

    CommandInterface prepareCommand(String string, int n2) {
        return this.long.prepareCommand(string, n2);
    }

    private CommandInterface a(String string, CommandInterface commandInterface) {
        return commandInterface == null ? this.long.prepareCommand(string, Integer.MAX_VALUE) : commandInterface;
    }

    private int a(String string, int n2, char c2) {
        int n3 = string.length();
        switch (c2) {
            case '$': {
                if (n2 < n3 - 1 && string.charAt(n2 + 1) == '$' && (n2 == 0 || string.charAt(n2 - 1) <= ' ')) {
                    int n4 = string.indexOf("$$", n2 + 2);
                    if (n4 < 0) {
                        throw DbException.getSyntaxError(string, n2);
                    }
                    return n4 + 1;
                }
                return n2;
            }
            case '\'': {
                int n5 = string.indexOf(39, n2 + 1);
                if (n5 < 0) {
                    throw DbException.getSyntaxError(string, n2);
                }
                return n5;
            }
            case '\"': {
                int n6 = string.indexOf(34, n2 + 1);
                if (n6 < 0) {
                    throw DbException.getSyntaxError(string, n2);
                }
                return n6;
            }
            case '/': {
                this.a(n2 + 1, n3, string);
                if (string.charAt(n2 + 1) == '*') {
                    int n7 = string.indexOf("*/", n2 + 2);
                    if (n7 < 0) {
                        throw DbException.getSyntaxError(string, n2);
                    }
                    n2 = n7 + 1;
                } else if (string.charAt(n2 + 1) == '/') {
                    n2 += 2;
                    while (n2 < n3 && (c2 = string.charAt(n2)) != '\r' && c2 != '\n') {
                        ++n2;
                    }
                }
                return n2;
            }
            case '-': {
                this.a(n2 + 1, n3, string);
                if (string.charAt(n2 + 1) == '-') {
                    n2 += 2;
                    while (n2 < n3 && (c2 = string.charAt(n2)) != '\r' && c2 != '\n') {
                        ++n2;
                    }
                }
                return n2;
            }
        }
        throw DbException.throwInternalError("c=" + c2);
    }

    private String int(String string) {
        return this.translateSQL(string, true);
    }

    String translateSQL(String string, boolean bl) {
        if (string == null) {
            throw DbException.getInvalidValueException("SQL", null);
        }
        if (!bl) {
            return string;
        }
        if (string.indexOf(123) < 0) {
            return string;
        }
        int n2 = string.length();
        char[] cArray = null;
        int n3 = 0;
        block9: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\"': 
                case '\'': 
                case '-': 
                case '/': {
                    i2 = this.a(string, i2, c2);
                    continue block9;
                }
                case '{': {
                    ++n3;
                    if (cArray == null) {
                        cArray = string.toCharArray();
                    }
                    cArray[i2] = 32;
                    while (Character.isSpaceChar(cArray[i2])) {
                        this.a(++i2, n2, string);
                    }
                    int n4 = i2;
                    if (cArray[i2] >= '0' && cArray[i2] <= '9') {
                        cArray[i2 - 1] = 123;
                        while (true) {
                            this.a(i2, n2, string);
                            c2 = cArray[i2];
                            if (c2 == '}') break;
                            switch (c2) {
                                case '\"': 
                                case '\'': 
                                case '-': 
                                case '/': {
                                    i2 = this.a(string, i2, c2);
                                    break;
                                }
                            }
                            ++i2;
                        }
                        --n3;
                        continue block9;
                    }
                    if (cArray[i2] == '?') {
                        this.a(++i2, n2, string);
                        while (Character.isSpaceChar(cArray[i2])) {
                            this.a(++i2, n2, string);
                        }
                        if (string.charAt(i2) != '=') {
                            throw DbException.getSyntaxError(string, i2, "=");
                        }
                        this.a(++i2, n2, string);
                        while (Character.isSpaceChar(cArray[i2])) {
                            this.a(++i2, n2, string);
                        }
                    }
                    while (!Character.isSpaceChar(cArray[i2])) {
                        this.a(++i2, n2, string);
                    }
                    int n5 = 0;
                    if (this.a(string, n4, "fn")) {
                        n5 = 2;
                    } else {
                        if (this.a(string, n4, "escape") || this.a(string, n4, "call")) continue block9;
                        if (this.a(string, n4, "oj")) {
                            n5 = 2;
                        } else if (this.a(string, n4, "ts")) {
                            n5 = 2;
                        } else if (this.a(string, n4, "t")) {
                            n5 = 1;
                        } else if (this.a(string, n4, "d")) {
                            n5 = 1;
                        } else if (this.a(string, n4, "params")) {
                            n5 = "params".length();
                        }
                    }
                    i2 = n4;
                    while (n5 > 0) {
                        cArray[i2] = 32;
                        ++i2;
                        --n5;
                    }
                    continue block9;
                }
                case '}': {
                    if (--n3 < 0) {
                        throw DbException.getSyntaxError(string, i2);
                    }
                    cArray[i2] = 32;
                    continue block9;
                }
                case '$': {
                    i2 = this.a(string, i2, c2);
                    continue block9;
                }
            }
        }
        if (n3 != 0) {
            throw DbException.getSyntaxError(string, string.length() - 1);
        }
        if (cArray != null) {
            string = new String(cArray);
        }
        return string;
    }

    private void a(int n2, int n3, String string) {
        if (n2 >= n3) {
            throw DbException.getSyntaxError(string, n2);
        }
    }

    private boolean a(String string, int n2, String string2) {
        return string.regionMatches(true, n2, string2, 0, string2.length());
    }

    private void a(int n2, int n3) {
        switch (n2) {
            case 1003: 
            case 1004: 
            case 1005: {
                break;
            }
            default: {
                throw DbException.getInvalidValueException("resultSetType", n2);
            }
        }
        switch (n3) {
            case 1007: 
            case 1008: {
                break;
            }
            default: {
                throw DbException.getInvalidValueException("resultSetConcurrency", n3);
            }
        }
    }

    private void if(int n2) {
        if (n2 != 1 && n2 != 2) {
            throw DbException.getInvalidValueException("resultSetHoldability", n2);
        }
    }

    protected void checkClosed() throws SQLException {
        this.checkClosed(false);
    }

    private void for() throws SQLException {
        this.checkClosed(true);
    }

    protected void checkClosed(boolean bl) throws SQLException {
        if (this.long == null) {
            throw DbException.get(90007);
        }
        if (this.long.isClosed()) {
            throw DbException.get(90121);
        }
        if (this.long.isReconnectNeeded(bl)) {
            this.o.debug("reconnect");
            this.do();
            this.long = this.long.reconnect(bl);
            this.setTrace(this.long.getTrace());
        }
    }

    protected void afterWriting() {
        if (this.long != null) {
            this.long.afterWriting();
        }
    }

    String getURL() throws SQLException {
        this.checkClosed();
        return this.c;
    }

    String getUser() throws SQLException {
        this.checkClosed();
        return this.q;
    }

    protected void finalize() {
        if (!SysProperties.runFinalize) {
            return;
        }
        if (this.n) {
            return;
        }
        if (this.long != null && this.openStackTrace != null) {
            this.o.error(this.openStackTrace, "connection not closed");
            try {
                this.close();
            }
            catch (SQLException sQLException) {
                this.o.debug(sQLException, "finalize");
            }
        }
    }

    private void int() {
        this.g = this.a("ROLLBACK", this.g);
        this.g.executeUpdate();
    }

    public int getPowerOffCount() {
        return this.long == null || this.long.isClosed() ? 0 : this.long.getPowerOffCount();
    }

    public void setPowerOffCount(int n2) {
        if (this.long != null) {
            this.long.setPowerOffCount(n2);
        }
    }

    public void setExecutingStatement(Statement statement) {
        this.p = statement;
    }

    ResultSet getGeneratedKeys(JdbcStatement jdbcStatement, int n2) {
        this.void = this.a("CALL SCOPE_IDENTITY()", this.void);
        ResultInterface resultInterface = this.void.executeQuery(0, false);
        JdbcResultSet jdbcResultSet = new JdbcResultSet(this, jdbcStatement, resultInterface, n2, false, true, false);
        return jdbcResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob createClob() throws SQLException {
        int n2 = this.getNextId(10);
        this.debugCodeAssign("Clob", 10, n2, "createClob()");
        this.for();
        try {
            Value value = this.long.getDataHandler().getLobStorage().createClob(new InputStreamReader(new ByteArrayInputStream(Utils.EMPTY_BYTES)), 0L);
            JdbcClob jdbcClob = new JdbcClob(this, value, n2);
            this.afterWriting();
            return jdbcClob;
        }
        catch (Throwable throwable) {
            try {
                this.afterWriting();
                throw throwable;
            }
            catch (Exception exception) {
                throw this.logAndConvert(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob createBlob() throws SQLException {
        int n2 = this.getNextId(9);
        this.debugCodeAssign("Blob", 9, n2, "createClob()");
        this.for();
        try {
            Value value = this.long.getDataHandler().getLobStorage().createBlob(new ByteArrayInputStream(Utils.EMPTY_BYTES), 0L);
            JdbcBlob jdbcBlob = new JdbcBlob(this, value, n2);
            this.afterWriting();
            return jdbcBlob;
        }
        catch (Throwable throwable) {
            try {
                this.afterWriting();
                throw throwable;
            }
            catch (Exception exception) {
                throw this.logAndConvert(exception);
            }
        }
    }

    public synchronized boolean isValid(int n2) {
        try {
            this.debugCodeCall("isValid", n2);
            if (this.long == null || this.long.isClosed()) {
                return false;
            }
            this.getTransactionIsolation();
            return true;
        }
        catch (Exception exception) {
            this.logAndConvert(exception);
            return false;
        }
    }

    public Value createClob(Reader reader, long l2) {
        if (reader == null) {
            return ValueNull.INSTANCE;
        }
        if (l2 <= 0L) {
            l2 = -1L;
        }
        Value value = this.long.getDataHandler().getLobStorage().createClob(reader, l2);
        return value;
    }

    public Value createBlob(InputStream inputStream, long l2) {
        if (inputStream == null) {
            return ValueNull.INSTANCE;
        }
        if (l2 <= 0L) {
            l2 = -1L;
        }
        Value value = this.long.getDataHandler().getLobStorage().createBlob(inputStream, l2);
        return value;
    }

    private void a(Map map) {
        if (map != null && map.size() > 0) {
            throw DbException.getUnsupportedException("map.size > 0");
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": url=" + this.c + " user=" + this.q;
    }

    Object convertToDefaultObject(Value value) {
        Object object;
        switch (value.getType()) {
            case 16: {
                if (SysProperties.RETURN_LOB_OBJECTS) {
                    int n2 = this.getNextId(10);
                    object = new JdbcClob(this, value, n2);
                    break;
                }
                object = value.getObject();
                break;
            }
            case 15: {
                if (SysProperties.RETURN_LOB_OBJECTS) {
                    int n3 = this.getNextId(9);
                    object = new JdbcBlob(this, value, n3);
                    break;
                }
                object = value.getObject();
                break;
            }
            case 19: {
                object = Utils.deserialize(value.getBytesNoCopy());
                break;
            }
            default: {
                object = value.getObject();
            }
        }
        return object;
    }

    CompareMode getCompareMode() {
        return this.l;
    }

    public void setTraceLevel(int n2) {
        this.o.setLevel(n2);
    }
}

