/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.command.CommandInterface;
import org.h2.expression.ParameterInterface;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceObject;
import org.h2.util.MathUtils;
import org.h2.value.DataType;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JdbcParameterMetaData
extends TraceObject
implements ParameterMetaData {
    private JdbcPreparedStatement x;
    private int z;
    private ArrayList y;

    JdbcParameterMetaData(Trace trace, JdbcPreparedStatement jdbcPreparedStatement, CommandInterface commandInterface, int n2) {
        this.setTrace(trace, 11, n2);
        this.x = jdbcPreparedStatement;
        this.y = commandInterface.getParameters();
        this.z = this.y.size();
    }

    public int getParameterCount() throws SQLException {
        try {
            this.debugCodeCall("getParameterCount");
            this.case();
            return this.z;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getParameterMode(int n2) throws SQLException {
        try {
            this.debugCodeCall("getParameterMode", n2);
            this.do(n2);
            return 1;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getParameterType(int n2) throws SQLException {
        try {
            this.debugCodeCall("getParameterType", n2);
            ParameterInterface parameterInterface = this.do(n2);
            int n3 = parameterInterface.getType();
            if (n3 == -1) {
                n3 = 13;
            }
            return DataType.getDataType((int)n3).sqlType;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getPrecision(int n2) throws SQLException {
        try {
            this.debugCodeCall("getPrecision", n2);
            ParameterInterface parameterInterface = this.do(n2);
            return MathUtils.convertLongToInt(parameterInterface.getPrecision());
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getScale(int n2) throws SQLException {
        try {
            this.debugCodeCall("getScale", n2);
            ParameterInterface parameterInterface = this.do(n2);
            return parameterInterface.getScale();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int isNullable(int n2) throws SQLException {
        try {
            this.debugCodeCall("isNullable", n2);
            return this.do(n2).getNullable();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean isSigned(int n2) throws SQLException {
        try {
            this.debugCodeCall("isSigned", n2);
            this.do(n2);
            return true;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public String getParameterClassName(int n2) throws SQLException {
        try {
            this.debugCodeCall("getParameterClassName", n2);
            ParameterInterface parameterInterface = this.do(n2);
            int n3 = parameterInterface.getType();
            if (n3 == -1) {
                n3 = 13;
            }
            return DataType.getTypeClassName(n3);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public String getParameterTypeName(int n2) throws SQLException {
        try {
            this.debugCodeCall("getParameterTypeName", n2);
            ParameterInterface parameterInterface = this.do(n2);
            int n3 = parameterInterface.getType();
            if (n3 == -1) {
                n3 = 13;
            }
            return DataType.getDataType((int)n3).name;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private ParameterInterface do(int n2) throws SQLException {
        this.case();
        if (n2 < 1 || n2 > this.z) {
            throw DbException.getInvalidValueException("param", n2);
        }
        return (ParameterInterface)this.y.get(n2 - 1);
    }

    private void case() throws SQLException {
        this.x.checkClosed();
    }

    public String toString() {
        return this.getTraceObjectName() + ": parameterCount=" + this.z;
    }
}

