/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import jstels.jdbc.common.h2.sql.f;
import org.h2.command.CommandInterface;
import org.h2.engine.SessionInterface;
import org.h2.expression.ParameterInterface;
import org.h2.jdbc.JdbcBatchUpdateException;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcParameterMetaData;
import org.h2.jdbc.JdbcResultSet;
import org.h2.jdbc.JdbcResultSetMetaData;
import org.h2.jdbc.JdbcStatement;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.util.DateTimeUtils;
import org.h2.util.IOUtils;
import org.h2.util.New;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JdbcPreparedStatement
extends JdbcStatement
implements PreparedStatement {
    protected CommandInterface command;
    private final String J;
    private ArrayList H;
    private f I = null;

    JdbcPreparedStatement(JdbcConnection jdbcConnection, String string, int n2, int n3, int n4, boolean bl) {
        super(jdbcConnection, n2, n3, n4, bl);
        this.setTrace(this.session.getTrace(), 3, n2);
        this.J = string;
        this.command = jdbcConnection.prepareCommand(string, this.fetchSize);
    }

    public void setListener(f f2) {
        this.I = f2;
    }

    public f getListener() {
        return this.I;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery() throws SQLException {
        try {
            int n2 = this.getNextId(4);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ResultSet", 4, n2, "executeQuery()");
            }
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                ResultInterface resultInterface;
                this.checkClosed();
                this.closeOldResultSet();
                boolean bl = this.resultSetType != 1003;
                boolean bl2 = this.resultSetConcurrency == 1008;
                try {
                    this.setExecutingStatement(this.command);
                    resultInterface = this.command.executeQuery(this.maxRows, bl);
                }
                finally {
                    this.setExecutingStatement(null);
                }
                this.resultSet = new JdbcResultSet(this.conn, this, resultInterface, n2, this.closedByResultSet, bl, bl2);
            }
            return this.resultSet;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws SQLException {
        int n2;
        this.debugCodeCall("executeUpdate");
        this.checkClosedForWrite();
        try {
            n2 = this.long();
        }
        catch (Throwable throwable) {
            try {
                this.afterWriting();
                throw throwable;
            }
            catch (Exception exception) {
                throw this.logAndConvert(exception);
            }
        }
        this.afterWriting();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int long() throws SQLException {
        this.closeOldResultSet();
        SessionInterface sessionInterface = this.session;
        synchronized (sessionInterface) {
            if (this.I != null) {
                this.I.a();
            }
            try {
                this.setExecutingStatement(this.command);
                this.updateCount = this.command.executeUpdate();
            }
            finally {
                this.setExecutingStatement(null);
            }
            if (this.I != null) {
                this.I.a(this.updateCount);
            }
        }
        return this.updateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        boolean bl;
        int n2 = this.getNextId(4);
        if (this.isDebugEnabled()) {
            this.debugCodeCall("execute");
        }
        this.checkClosedForWrite();
        try {
            boolean bl2;
            SessionInterface sessionInterface = this.conn.getSession();
            synchronized (sessionInterface) {
                this.closeOldResultSet();
                try {
                    this.setExecutingStatement(this.command);
                    if (this.command.isQuery()) {
                        bl2 = true;
                        boolean bl3 = this.resultSetType != 1003;
                        boolean bl4 = this.resultSetConcurrency == 1008;
                        ResultInterface resultInterface = this.command.executeQuery(this.maxRows, bl3);
                        this.resultSet = new JdbcResultSet(this.conn, this, resultInterface, n2, this.closedByResultSet, bl3, bl4);
                    } else {
                        bl2 = false;
                        this.updateCount = this.command.executeUpdate();
                    }
                }
                finally {
                    this.setExecutingStatement(null);
                }
            }
            bl = bl2;
        }
        catch (Throwable throwable) {
            try {
                this.afterWriting();
                throw throwable;
            }
            catch (Exception exception) {
                throw this.logAndConvert(exception);
            }
        }
        this.afterWriting();
        return bl;
    }

    public void clearParameters() throws SQLException {
        try {
            this.debugCodeCall("clearParameters");
            this.checkClosed();
            ArrayList arrayList = this.command.getParameters();
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ParameterInterface parameterInterface = (ParameterInterface)arrayList.get(i2);
                parameterInterface.setValue(null, this.H == null);
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public ResultSet executeQuery(String string) throws SQLException {
        try {
            this.debugCodeCall("executeQuery", string);
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void addBatch(String string) throws SQLException {
        try {
            this.debugCodeCall("addBatch", string);
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int executeUpdate(String string) throws SQLException {
        try {
            this.debugCodeCall("executeUpdate", string);
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean execute(String string) throws SQLException {
        try {
            this.debugCodeCall("execute", string);
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setNull(int n2, int n3) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNull(" + n2 + ", " + n3 + ");");
            }
            this.a(n2, ValueNull.INSTANCE);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setInt(int n2, int n3) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setInt(" + n2 + ", " + n3 + ");");
            }
            this.a(n2, ValueInt.get(n3));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setString(int n2, String string) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setString(" + n2 + ", " + this.quote(string) + ");");
            }
            Value value = string == null ? ValueNull.INSTANCE : ValueString.get(string);
            this.a(n2, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBigDecimal(" + n2 + ", " + this.quoteBigDecimal(bigDecimal) + ");");
            }
            Value value = bigDecimal == null ? ValueNull.INSTANCE : ValueDecimal.get(bigDecimal);
            this.a(n2, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setDate(int n2, Date date) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setDate(" + n2 + ", " + this.quoteDate(date) + ");");
            }
            Value value = date == null ? ValueNull.INSTANCE : ValueDate.get(date);
            this.a(n2, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setTime(int n2, Time time) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTime(" + n2 + ", " + this.quoteTime(time) + ");");
            }
            Value value = time == null ? ValueNull.INSTANCE : ValueTime.get(time);
            this.a(n2, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTimestamp(" + n2 + ", " + this.quoteTimestamp(timestamp) + ");");
            }
            Value value = timestamp == null ? ValueNull.INSTANCE : ValueTimestamp.get(timestamp);
            this.a(n2, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setObject(int n2, Object object) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setObject(" + n2 + ", x);");
            }
            if (object == null) {
                this.a(n2, ValueNull.INSTANCE);
            } else {
                this.a(n2, DataType.convertToValue(this.session, object, -1));
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setObject(int n2, Object object, int n3) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setObject(" + n2 + ", x, " + n3 + ");");
            }
            int n4 = DataType.convertSQLTypeToValueType(n3);
            if (object == null) {
                this.a(n2, ValueNull.INSTANCE);
            } else {
                Value value = DataType.convertToValue(this.conn.getSession(), object, n4);
                this.a(n2, value.convertTo(n4));
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setObject(int n2, Object object, int n3, int n4) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setObject(" + n2 + ", x, " + n3 + ", " + n4 + ");");
            }
            this.setObject(n2, object, n3);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setBoolean(int n2, boolean bl) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBoolean(" + n2 + ", " + bl + ");");
            }
            this.a(n2, ValueBoolean.get(bl));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setByte(int n2, byte by) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setByte(" + n2 + ", " + by + ");");
            }
            this.a(n2, ValueByte.get(by));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setShort(int n2, short s) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setShort(" + n2 + ", (short) " + s + ");");
            }
            this.a(n2, ValueShort.get(s));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setLong(int n2, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setLong(" + n2 + ", " + l2 + "L);");
            }
            this.a(n2, ValueLong.get(l2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setFloat(int n2, float f2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setFloat(" + n2 + ", " + f2 + "f);");
            }
            this.a(n2, ValueFloat.get(f2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setDouble(int n2, double d2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setDouble(" + n2 + ", " + d2 + "d);");
            }
            this.a(n2, ValueDouble.get(d2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setRef(int n2, Ref ref) throws SQLException {
        throw this.unsupported("ref");
    }

    public void setDate(int n2, Date date, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setDate(" + n2 + ", " + this.quoteDate(date) + ", calendar);");
            }
            if (date == null) {
                this.a(n2, ValueNull.INSTANCE);
            } else {
                this.a(n2, DateTimeUtils.convertDateToUniversal(date, calendar));
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTime(" + n2 + ", " + this.quoteTime(time) + ", calendar);");
            }
            if (time == null) {
                this.a(n2, ValueNull.INSTANCE);
            } else {
                this.a(n2, DateTimeUtils.convertTimeToUniversal(time, calendar));
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTimestamp(" + n2 + ", " + this.quoteTimestamp(timestamp) + ", calendar);");
            }
            if (timestamp == null) {
                this.a(n2, ValueNull.INSTANCE);
            } else {
                this.a(n2, DateTimeUtils.convertTimestampToUniversal(timestamp, calendar));
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setUnicodeStream(int n2, InputStream inputStream, int n3) throws SQLException {
        throw this.unsupported("unicodeStream");
    }

    public void setNull(int n2, int n3, String string) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNull(" + n2 + ", " + n3 + ", " + this.quote(string) + ");");
            }
            this.setNull(n2, n3);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlob(int n2, Blob blob) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBlob(" + n2 + ", x);");
            }
            this.checkClosedForWrite();
            try {
                Value value = blob == null ? ValueNull.INSTANCE : this.conn.createBlob(blob.getBinaryStream(), -1L);
                this.a(n2, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlob(int n2, InputStream inputStream) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBlob(" + n2 + ", x);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createBlob(inputStream, -1L);
                this.a(n2, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClob(int n2, Clob clob) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setClob(" + n2 + ", x);");
            }
            this.checkClosedForWrite();
            try {
                Value value = clob == null ? ValueNull.INSTANCE : this.conn.createClob(clob.getCharacterStream(), -1L);
                this.a(n2, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClob(int n2, Reader reader) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setClob(" + n2 + ", x);");
            }
            this.checkClosedForWrite();
            try {
                Value value = reader == null ? ValueNull.INSTANCE : this.conn.createClob(reader, -1L);
                this.a(n2, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setArray(int n2, Array array) throws SQLException {
        throw this.unsupported("setArray");
    }

    public void setBytes(int n2, byte[] byArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBytes(" + n2 + ", " + this.quoteBytes(byArray) + ");");
            }
            Value value = byArray == null ? ValueNull.INSTANCE : ValueBytes.get(byArray);
            this.a(n2, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryStream(int n2, InputStream inputStream, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBinaryStream(" + n2 + ", x, " + l2 + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createBlob(inputStream, l2);
                this.a(n2, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.setBinaryStream(n2, inputStream, (long)n3);
    }

    public void setBinaryStream(int n2, InputStream inputStream) throws SQLException {
        this.setBinaryStream(n2, inputStream, -1);
    }

    public void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.setAsciiStream(n2, inputStream, (long)n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsciiStream(int n2, InputStream inputStream, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setAsciiStream(" + n2 + ", x, " + l2 + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createClob(IOUtils.getAsciiReader(inputStream), l2);
                this.a(n2, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setAsciiStream(int n2, InputStream inputStream) throws SQLException {
        this.setAsciiStream(n2, inputStream, -1);
    }

    public void setCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.setCharacterStream(n2, reader, (long)n3);
    }

    public void setCharacterStream(int n2, Reader reader) throws SQLException {
        this.setCharacterStream(n2, reader, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setCharacterStream(" + n2 + ", x, " + l2 + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createClob(reader, l2);
                this.a(n2, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setURL(int n2, URL uRL) throws SQLException {
        throw this.unsupported("url");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            this.debugCodeCall("getMetaData");
            this.checkClosed();
            ResultInterface resultInterface = this.command.getMetaData();
            if (resultInterface == null) {
                return null;
            }
            int n2 = this.getNextId(5);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ResultSetMetaData", 5, n2, "getMetaData()");
            }
            String string = this.conn.getCatalog();
            JdbcResultSetMetaData jdbcResultSetMetaData = new JdbcResultSetMetaData(null, this, resultInterface, string, this.session.getTrace(), n2);
            return jdbcResultSetMetaData;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void clearBatch() throws SQLException {
        try {
            this.debugCodeCall("clearBatch");
            this.checkClosed();
            this.H = null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void close() throws SQLException {
        try {
            super.close();
            this.H = null;
            if (this.command != null) {
                this.command.close();
                this.command = null;
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        int[] nArray;
        this.debugCodeCall("executeBatch");
        if (this.H == null) {
            this.H = New.arrayList();
        }
        int n2 = this.H.size();
        int[] nArray2 = new int[n2];
        boolean bl = false;
        Object object = null;
        this.checkClosedForWrite();
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object2;
                Value[] valueArray = (Value[])this.H.get(i2);
                ArrayList arrayList = this.command.getParameters();
                for (int i3 = 0; i3 < valueArray.length; ++i3) {
                    object2 = valueArray[i3];
                    ParameterInterface parameterInterface = (ParameterInterface)arrayList.get(i3);
                    parameterInterface.setValue((Value)object2, false);
                }
                try {
                    nArray2[i2] = this.long();
                    continue;
                }
                catch (Exception exception) {
                    object2 = DbException.toSQLException(exception);
                    if (object == null) {
                        object = object2;
                    } else {
                        ((SQLException)object2).setNextException((SQLException)object);
                        object = object2;
                    }
                    this.logAndConvert((Exception)object2);
                    nArray2[i2] = -3;
                    bl = true;
                }
            }
            this.H = null;
            if (bl) {
                JdbcBatchUpdateException jdbcBatchUpdateException = new JdbcBatchUpdateException((SQLException)object, nArray2);
                jdbcBatchUpdateException.setNextException((SQLException)object);
                throw jdbcBatchUpdateException;
            }
            nArray = nArray2;
        }
        catch (Throwable throwable) {
            try {
                this.afterWriting();
                throw throwable;
            }
            catch (Exception exception) {
                throw this.logAndConvert(exception);
            }
        }
        this.afterWriting();
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatch() throws SQLException {
        try {
            this.debugCodeCall("addBatch");
            this.checkClosedForWrite();
            try {
                ArrayList arrayList = this.command.getParameters();
                int n2 = arrayList.size();
                Value[] valueArray = new Value[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    Value value;
                    ParameterInterface parameterInterface = (ParameterInterface)arrayList.get(i2);
                    valueArray[i2] = value = parameterInterface.getParamValue();
                }
                if (this.H == null) {
                    this.H = New.arrayList();
                }
                this.H.add(valueArray);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int executeUpdate(String string, int n2) throws SQLException {
        try {
            this.debugCode("executeUpdate(" + this.quote(string) + ", " + n2 + ");");
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        try {
            this.debugCode("executeUpdate(" + this.quote(string) + ", " + this.quoteIntArray(nArray) + ");");
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            this.debugCode("executeUpdate(" + this.quote(string) + ", " + this.quoteArray(stringArray) + ");");
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean execute(String string, int n2) throws SQLException {
        try {
            this.debugCode("execute(" + this.quote(string) + ", " + n2 + ");");
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        try {
            this.debugCode("execute(" + this.quote(string) + ", " + this.quoteIntArray(nArray) + ");");
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        try {
            this.debugCode("execute(" + this.quote(string) + ", " + this.quoteArray(stringArray) + ");");
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            int n2 = this.getNextId(11);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ParameterMetaData", 11, n2, "getParameterMetaData()");
            }
            this.checkClosed();
            JdbcParameterMetaData jdbcParameterMetaData = new JdbcParameterMetaData(this.session.getTrace(), this, this.command, n2);
            return jdbcParameterMetaData;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private void a(int n2, Value value) throws SQLException {
        this.checkClosed();
        ArrayList arrayList = this.command.getParameters();
        if (--n2 < 0 || n2 >= arrayList.size()) {
            throw DbException.getInvalidValueException("parameterIndex", n2 + 1);
        }
        ParameterInterface parameterInterface = (ParameterInterface)arrayList.get(n2);
        parameterInterface.setValue(value, this.H == null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClob(int n2, Reader reader, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setClob(" + n2 + ", x, " + l2 + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createClob(reader, l2);
                this.a(n2, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlob(int n2, InputStream inputStream, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBlob(" + n2 + ", x, " + l2 + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createBlob(inputStream, l2);
                this.a(n2, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": " + this.command;
    }

    protected boolean checkClosed(boolean bl) throws SQLException {
        if (super.checkClosed(bl)) {
            ArrayList arrayList = this.command.getParameters();
            this.command = this.conn.prepareCommand(this.J, this.fetchSize);
            ArrayList arrayList2 = this.command.getParameters();
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ParameterInterface parameterInterface = (ParameterInterface)arrayList.get(i2);
                Value value = parameterInterface.getParamValue();
                if (value == null) continue;
                ParameterInterface parameterInterface2 = (ParameterInterface)arrayList2.get(i2);
                parameterInterface2.setValue(value, false);
            }
            return true;
        }
        return false;
    }
}

