/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.h2.constant.SysProperties;
import org.h2.jdbc.JdbcArray;
import org.h2.jdbc.JdbcBlob;
import org.h2.jdbc.JdbcClob;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcResultSetMetaData;
import org.h2.jdbc.JdbcStatement;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.result.ResultInterface;
import org.h2.result.UpdatableRow;
import org.h2.util.DateTimeUtils;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JdbcResultSet
extends TraceObject
implements ResultSet {
    private final boolean ap;
    private final boolean aq;
    private final boolean an;
    private ResultInterface at;
    private JdbcConnection al;
    private JdbcStatement am;
    private int ao;
    private boolean aj;
    private Value[] ar;
    private Value[] ak;
    private HashMap ai;
    private HashMap as;

    JdbcResultSet(JdbcConnection jdbcConnection, JdbcStatement jdbcStatement, ResultInterface resultInterface, int n2, boolean bl, boolean bl2, boolean bl3) {
        this.setTrace(jdbcConnection.getSession().getTrace(), 4, n2);
        this.al = jdbcConnection;
        this.am = jdbcStatement;
        this.at = resultInterface;
        this.ao = resultInterface.getVisibleColumnCount();
        this.ap = bl;
        this.aq = bl2;
        this.an = bl3;
    }

    public boolean next() throws SQLException {
        try {
            this.debugCodeCall("next");
            this.checkClosed();
            return this.e();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            int n2 = this.getNextId(5);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ResultSetMetaData", 5, n2, "getMetaData()");
            }
            this.checkClosed();
            String string = this.al.getCatalog();
            JdbcResultSetMetaData jdbcResultSetMetaData = new JdbcResultSetMetaData(this, null, this.at, string, this.al.getSession().getTrace(), n2);
            return jdbcResultSetMetaData;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean wasNull() throws SQLException {
        try {
            this.debugCodeCall("wasNull");
            this.checkClosed();
            return this.aj;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int findColumn(String string) throws SQLException {
        try {
            this.debugCodeCall("findColumn", string);
            return this.char(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void close() throws SQLException {
        try {
            this.debugCodeCall("close");
            this.closeInternal();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeInternal() throws SQLException {
        if (this.at != null) {
            try {
                this.at.close();
                if (this.ap && this.am != null) {
                    this.am.close();
                }
            }
            finally {
                this.ao = 0;
                this.at = null;
                this.am = null;
                this.al = null;
                this.ar = null;
                this.ak = null;
            }
        }
    }

    public Statement getStatement() throws SQLException {
        try {
            this.debugCodeCall("getStatement");
            this.checkClosed();
            if (this.ap) {
                return null;
            }
            return this.am;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            this.debugCodeCall("getWarnings");
            this.checkClosed();
            return null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.debugCodeCall("clearWarnings");
            this.checkClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public String getString(int n2) throws SQLException {
        try {
            this.debugCodeCall("getString", n2);
            return this.byte(n2).getString();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public String getString(String string) throws SQLException {
        try {
            this.debugCodeCall("getString", string);
            return this.else(string).getString();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getInt(int n2) throws SQLException {
        try {
            this.debugCodeCall("getInt", n2);
            return this.byte(n2).getInt();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getInt(String string) throws SQLException {
        try {
            this.debugCodeCall("getInt", string);
            return this.else(string).getInt();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        try {
            this.debugCodeCall("getBigDecimal", n2);
            return this.byte(n2).getBigDecimal();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Date getDate(int n2) throws SQLException {
        try {
            this.debugCodeCall("getDate", n2);
            return this.byte(n2).getDate();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Time getTime(int n2) throws SQLException {
        try {
            this.debugCodeCall("getTime", n2);
            return this.byte(n2).getTime();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Timestamp getTimestamp(int n2) throws SQLException {
        try {
            this.debugCodeCall("getTimestamp", n2);
            return this.byte(n2).getTimestamp();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        try {
            this.debugCodeCall("getBigDecimal", string);
            return this.else(string).getBigDecimal();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Date getDate(String string) throws SQLException {
        try {
            this.debugCodeCall("getDate", string);
            return this.else(string).getDate();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Time getTime(String string) throws SQLException {
        try {
            this.debugCodeCall("getTime", string);
            return this.else(string).getTime();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        try {
            this.debugCodeCall("getTimestamp", string);
            return this.else(string).getTimestamp();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Object getObject(int n2) throws SQLException {
        try {
            this.debugCodeCall("getObject", n2);
            Value value = this.byte(n2);
            return this.al.convertToDefaultObject(value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Object getObject(String string) throws SQLException {
        try {
            this.debugCodeCall("getObject", string);
            Value value = this.else(string);
            return this.al.convertToDefaultObject(value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean getBoolean(int n2) throws SQLException {
        try {
            this.debugCodeCall("getBoolean", n2);
            Boolean bl = this.byte(n2).getBoolean();
            return bl == null ? false : bl;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean getBoolean(String string) throws SQLException {
        try {
            this.debugCodeCall("getBoolean", string);
            Boolean bl = this.else(string).getBoolean();
            return bl == null ? false : bl;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public byte getByte(int n2) throws SQLException {
        try {
            this.debugCodeCall("getByte", n2);
            return this.byte(n2).getByte();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public byte getByte(String string) throws SQLException {
        try {
            this.debugCodeCall("getByte", string);
            return this.else(string).getByte();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public short getShort(int n2) throws SQLException {
        try {
            this.debugCodeCall("getShort", n2);
            return this.byte(n2).getShort();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public short getShort(String string) throws SQLException {
        try {
            this.debugCodeCall("getShort", string);
            return this.else(string).getShort();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public long getLong(int n2) throws SQLException {
        try {
            this.debugCodeCall("getLong", n2);
            return this.byte(n2).getLong();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public long getLong(String string) throws SQLException {
        try {
            this.debugCodeCall("getLong", string);
            return this.else(string).getLong();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public float getFloat(int n2) throws SQLException {
        try {
            this.debugCodeCall("getFloat", n2);
            return this.byte(n2).getFloat();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public float getFloat(String string) throws SQLException {
        try {
            this.debugCodeCall("getFloat", string);
            return this.else(string).getFloat();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public double getDouble(int n2) throws SQLException {
        try {
            this.debugCodeCall("getDouble", n2);
            return this.byte(n2).getDouble();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public double getDouble(String string) throws SQLException {
        try {
            this.debugCodeCall("getDouble", string);
            return this.else(string).getDouble();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getBigDecimal(" + StringUtils.quoteJavaString(string) + ", " + n2 + ");");
            }
            if (n2 < 0) {
                throw DbException.getInvalidValueException("scale", n2);
            }
            BigDecimal bigDecimal = this.else(string).getBigDecimal();
            return bigDecimal == null ? null : MathUtils.setScale(bigDecimal, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getBigDecimal(" + n2 + ", " + n3 + ");");
            }
            if (n3 < 0) {
                throw DbException.getInvalidValueException("scale", n3);
            }
            BigDecimal bigDecimal = this.byte(n2).getBigDecimal();
            return bigDecimal == null ? null : MathUtils.setScale(bigDecimal, n3);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public InputStream getUnicodeStream(int n2) throws SQLException {
        throw this.unsupported("unicodeStream");
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        throw this.unsupported("unicodeStream");
    }

    public Object getObject(int n2, Map map) throws SQLException {
        throw this.unsupported("map");
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw this.unsupported("map");
    }

    public Ref getRef(int n2) throws SQLException {
        throw this.unsupported("ref");
    }

    public Ref getRef(String string) throws SQLException {
        throw this.unsupported("ref");
    }

    public Date getDate(int n2, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getDate(" + n2 + ", calendar)");
            }
            Date date = this.byte(n2).getDate();
            return DateTimeUtils.convertDateToCalendar(date, calendar);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getDate(" + StringUtils.quoteJavaString(string) + ", calendar)");
            }
            Date date = this.else(string).getDate();
            return DateTimeUtils.convertDateToCalendar(date, calendar);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Time getTime(int n2, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getTime(" + n2 + ", calendar)");
            }
            Time time = this.byte(n2).getTime();
            return DateTimeUtils.convertTimeToCalendar(time, calendar);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getTime(" + StringUtils.quoteJavaString(string) + ", calendar)");
            }
            Time time = this.else(string).getTime();
            return DateTimeUtils.convertTimeToCalendar(time, calendar);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getTimestamp(" + n2 + ", calendar)");
            }
            Timestamp timestamp = this.byte(n2).getTimestamp();
            return DateTimeUtils.convertTimestampToCalendar(timestamp, calendar);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getTimestamp(" + StringUtils.quoteJavaString(string) + ", calendar)");
            }
            Timestamp timestamp = this.else(string).getTimestamp();
            return DateTimeUtils.convertTimestampToCalendar(timestamp, calendar);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Blob getBlob(int n2) throws SQLException {
        try {
            int n3 = this.getNextId(9);
            this.debugCodeAssign("Blob", 9, n3, "getBlob(" + n2 + ")");
            Value value = this.byte(n2);
            return value == ValueNull.INSTANCE ? null : new JdbcBlob(this.al, value, n3);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Blob getBlob(String string) throws SQLException {
        try {
            int n2 = this.getNextId(9);
            this.debugCodeAssign("Blob", 9, n2, "getBlob(" + this.quote(string) + ")");
            Value value = this.else(string);
            return value == ValueNull.INSTANCE ? null : new JdbcBlob(this.al, value, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public byte[] getBytes(int n2) throws SQLException {
        try {
            this.debugCodeCall("getBytes", n2);
            return this.byte(n2).getBytes();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public byte[] getBytes(String string) throws SQLException {
        try {
            this.debugCodeCall("getBytes", string);
            return this.else(string).getBytes();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public InputStream getBinaryStream(int n2) throws SQLException {
        try {
            this.debugCodeCall("getBinaryStream", n2);
            return this.byte(n2).getInputStream();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        try {
            this.debugCodeCall("getBinaryStream", string);
            return this.else(string).getInputStream();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Clob getClob(int n2) throws SQLException {
        try {
            int n3 = this.getNextId(10);
            this.debugCodeAssign("Clob", 10, n3, "getClob(" + n2 + ")");
            Value value = this.byte(n2);
            return value == ValueNull.INSTANCE ? null : new JdbcClob(this.al, value, n3);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Clob getClob(String string) throws SQLException {
        try {
            int n2 = this.getNextId(10);
            this.debugCodeAssign("Clob", 10, n2, "getClob(" + this.quote(string) + ")");
            Value value = this.else(string);
            return value == ValueNull.INSTANCE ? null : new JdbcClob(this.al, value, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Array getArray(int n2) throws SQLException {
        try {
            int n3 = this.getNextId(15);
            this.debugCodeAssign("Clob", 15, n3, "getArray(" + n2 + ")");
            Value value = this.byte(n2);
            return value == ValueNull.INSTANCE ? null : new JdbcArray(this.al, value, n3);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Array getArray(String string) throws SQLException {
        try {
            int n2 = this.getNextId(15);
            this.debugCodeAssign("Clob", 15, n2, "getArray(" + this.quote(string) + ")");
            Value value = this.else(string);
            return value == ValueNull.INSTANCE ? null : new JdbcArray(this.al, value, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public InputStream getAsciiStream(int n2) throws SQLException {
        try {
            this.debugCodeCall("getAsciiStream", n2);
            String string = this.byte(n2).getString();
            return string == null ? null : IOUtils.getInputStream(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        try {
            this.debugCodeCall("getAsciiStream", string);
            String string2 = this.else(string).getString();
            return IOUtils.getInputStream(string2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Reader getCharacterStream(int n2) throws SQLException {
        try {
            this.debugCodeCall("getCharacterStream", n2);
            return this.byte(n2).getReader();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Reader getCharacterStream(String string) throws SQLException {
        try {
            this.debugCodeCall("getCharacterStream", string);
            return this.else(string).getReader();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public URL getURL(int n2) throws SQLException {
        throw this.unsupported("url");
    }

    public URL getURL(String string) throws SQLException {
        throw this.unsupported("url");
    }

    public void updateNull(int n2) throws SQLException {
        try {
            this.debugCodeCall("updateNull", n2);
            this.if(n2, ValueNull.INSTANCE);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateNull(String string) throws SQLException {
        try {
            this.debugCodeCall("updateNull", string);
            this.a(string, ValueNull.INSTANCE);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateBoolean(int n2, boolean bl) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBoolean(" + n2 + ", " + bl + ");");
            }
            this.if(n2, ValueBoolean.get(bl));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBoolean(" + this.quote(string) + ", " + bl + ");");
            }
            this.a(string, ValueBoolean.get(bl));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateByte(int n2, byte by) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateByte(" + n2 + ", " + by + ");");
            }
            this.if(n2, ValueByte.get(by));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateByte(String string, byte by) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateByte(" + string + ", " + by + ");");
            }
            this.a(string, ValueByte.get(by));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBytes(" + n2 + ", x);");
            }
            this.if(n2, byArray == null ? ValueNull.INSTANCE : ValueBytes.get(byArray));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBytes(" + this.quote(string) + ", x);");
            }
            this.a(string, byArray == null ? ValueNull.INSTANCE : ValueBytes.get(byArray));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateShort(int n2, short s) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateShort(" + n2 + ", (short) " + s + ");");
            }
            this.if(n2, ValueShort.get(s));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateShort(String string, short s) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateShort(" + this.quote(string) + ", (short) " + s + ");");
            }
            this.a(string, ValueShort.get(s));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateInt(int n2, int n3) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateInt(" + n2 + ", " + n3 + ");");
            }
            this.if(n2, ValueInt.get(n3));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateInt(String string, int n2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateInt(" + this.quote(string) + ", " + n2 + ");");
            }
            this.a(string, ValueInt.get(n2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateLong(int n2, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateLong(" + n2 + ", " + l2 + "L);");
            }
            this.if(n2, ValueLong.get(l2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateLong(String string, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateLong(" + this.quote(string) + ", " + l2 + "L);");
            }
            this.a(string, ValueLong.get(l2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateFloat(int n2, float f2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateFloat(" + n2 + ", " + f2 + "f);");
            }
            this.if(n2, ValueFloat.get(f2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateFloat(String string, float f2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateFloat(" + this.quote(string) + ", " + f2 + "f);");
            }
            this.a(string, ValueFloat.get(f2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateDouble(int n2, double d2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateDouble(" + n2 + ", " + d2 + "d);");
            }
            this.if(n2, ValueDouble.get(d2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateDouble(String string, double d2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateDouble(" + this.quote(string) + ", " + d2 + "d);");
            }
            this.a(string, ValueDouble.get(d2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBigDecimal(" + n2 + ", " + this.quoteBigDecimal(bigDecimal) + ");");
            }
            this.if(n2, bigDecimal == null ? ValueNull.INSTANCE : ValueDecimal.get(bigDecimal));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBigDecimal(" + this.quote(string) + ", " + this.quoteBigDecimal(bigDecimal) + ");");
            }
            this.a(string, bigDecimal == null ? ValueNull.INSTANCE : ValueDecimal.get(bigDecimal));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateString(int n2, String string) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateString(" + n2 + ", " + this.quote(string) + ");");
            }
            this.if(n2, string == null ? ValueNull.INSTANCE : ValueString.get(string));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateString(String string, String string2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateString(" + this.quote(string) + ", " + this.quote(string2) + ");");
            }
            this.a(string, string2 == null ? ValueNull.INSTANCE : ValueString.get(string2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateDate(int n2, Date date) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateDate(" + n2 + ", x);");
            }
            this.if(n2, date == null ? ValueNull.INSTANCE : ValueDate.get(date));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateDate(String string, Date date) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateDate(" + this.quote(string) + ", x);");
            }
            this.a(string, date == null ? ValueNull.INSTANCE : ValueDate.get(date));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateTime(int n2, Time time) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateTime(" + n2 + ", x);");
            }
            this.if(n2, time == null ? ValueNull.INSTANCE : ValueTime.get(time));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateTime(String string, Time time) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateTime(" + this.quote(string) + ", x);");
            }
            this.a(string, time == null ? ValueNull.INSTANCE : ValueTime.get(time));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateTimestamp(" + n2 + ", x);");
            }
            this.if(n2, timestamp == null ? ValueNull.INSTANCE : ValueTimestamp.get(timestamp));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateTimestamp(" + this.quote(string) + ", x);");
            }
            this.a(string, timestamp == null ? ValueNull.INSTANCE : ValueTimestamp.get(timestamp));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.updateAsciiStream(n2, inputStream, (long)n3);
    }

    public void updateAsciiStream(int n2, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(n2, inputStream, -1);
    }

    public void updateAsciiStream(int n2, InputStream inputStream, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateAsciiStream(" + n2 + ", x, " + l2 + "L);");
            }
            this.checkClosed();
            Value value = this.al.createClob(IOUtils.getAsciiReader(inputStream), l2);
            this.if(n2, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.updateAsciiStream(string, inputStream, (long)n2);
    }

    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(string, inputStream, -1);
    }

    public void updateAsciiStream(String string, InputStream inputStream, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateAsciiStream(" + this.quote(string) + ", x, " + l2 + "L);");
            }
            this.checkClosed();
            Value value = this.al.createClob(IOUtils.getAsciiReader(inputStream), l2);
            this.a(string, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.updateBinaryStream(n2, inputStream, (long)n3);
    }

    public void updateBinaryStream(int n2, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(n2, inputStream, -1);
    }

    public void updateBinaryStream(int n2, InputStream inputStream, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBinaryStream(" + n2 + ", x, " + l2 + "L);");
            }
            this.checkClosed();
            Value value = this.al.createBlob(inputStream, l2);
            this.if(n2, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(string, inputStream, -1);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.updateBinaryStream(string, inputStream, (long)n2);
    }

    public void updateBinaryStream(String string, InputStream inputStream, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBinaryStream(" + this.quote(string) + ", x, " + l2 + "L);");
            }
            this.checkClosed();
            Value value = this.al.createBlob(inputStream, l2);
            this.a(string, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateCharacterStream(" + n2 + ", x, " + l2 + "L);");
            }
            this.checkClosed();
            Value value = this.al.createClob(reader, l2);
            this.if(n2, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.updateCharacterStream(n2, reader, (long)n3);
    }

    public void updateCharacterStream(int n2, Reader reader) throws SQLException {
        this.updateCharacterStream(n2, reader, -1);
    }

    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        this.updateCharacterStream(string, reader, (long)n2);
    }

    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        this.updateCharacterStream(string, reader, -1);
    }

    public void updateCharacterStream(String string, Reader reader, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateCharacterStream(" + this.quote(string) + ", x, " + l2 + "L);");
            }
            this.checkClosed();
            Value value = this.al.createClob(reader, l2);
            this.a(string, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateObject(int n2, Object object, int n3) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateObject(" + n2 + ", x, " + n3 + ");");
            }
            this.if(n2, this.a(object));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateObject(String string, Object object, int n2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateObject(" + this.quote(string) + ", x, " + n2 + ");");
            }
            this.a(string, this.a(object));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateObject(int n2, Object object) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateObject(" + n2 + ", x);");
            }
            this.if(n2, this.a(object));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateObject(String string, Object object) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateObject(" + this.quote(string) + ", x);");
            }
            this.a(string, this.a(object));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateRef(int n2, Ref ref) throws SQLException {
        throw this.unsupported("ref");
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        throw this.unsupported("ref");
    }

    public void updateBlob(int n2, InputStream inputStream) throws SQLException {
        this.updateBlob(n2, inputStream, -1L);
    }

    public void updateBlob(int n2, InputStream inputStream, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBlob(" + n2 + ", x, " + l2 + "L);");
            }
            this.checkClosed();
            Value value = this.al.createBlob(inputStream, l2);
            this.if(n2, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateBlob(int n2, Blob blob) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBlob(" + n2 + ", x);");
            }
            this.checkClosed();
            Value value = blob == null ? ValueNull.INSTANCE : this.al.createBlob(blob.getBinaryStream(), -1L);
            this.if(n2, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBlob(" + this.quote(string) + ", x);");
            }
            this.checkClosed();
            Value value = blob == null ? ValueNull.INSTANCE : this.al.createBlob(blob.getBinaryStream(), -1L);
            this.a(string, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        this.updateBlob(string, inputStream, -1L);
    }

    public void updateBlob(String string, InputStream inputStream, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBlob(" + this.quote(string) + ", x, " + l2 + "L);");
            }
            this.checkClosed();
            Value value = this.al.createBlob(inputStream, -1L);
            this.a(string, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateClob(int n2, Clob clob) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateClob(" + n2 + ", x);");
            }
            this.checkClosed();
            Value value = clob == null ? ValueNull.INSTANCE : this.al.createClob(clob.getCharacterStream(), -1L);
            this.if(n2, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateClob(int n2, Reader reader) throws SQLException {
        this.updateClob(n2, reader, -1L);
    }

    public void updateClob(int n2, Reader reader, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateClob(" + n2 + ", x, " + l2 + "L);");
            }
            this.checkClosed();
            Value value = this.al.createClob(reader, l2);
            this.if(n2, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateClob(" + this.quote(string) + ", x);");
            }
            this.checkClosed();
            Value value = clob == null ? ValueNull.INSTANCE : this.al.createClob(clob.getCharacterStream(), -1L);
            this.a(string, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateClob(String string, Reader reader) throws SQLException {
        this.updateClob(string, reader, -1L);
    }

    public void updateClob(String string, Reader reader, long l2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateClob(" + this.quote(string) + ", x, " + l2 + "L);");
            }
            this.checkClosed();
            Value value = this.al.createClob(reader, l2);
            this.a(string, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateArray(int n2, Array array) throws SQLException {
        throw this.unsupported("setArray");
    }

    public void updateArray(String string, Array array) throws SQLException {
        throw this.unsupported("setArray");
    }

    public String getCursorName() throws SQLException {
        throw this.unsupported("cursorName");
    }

    public int getRow() throws SQLException {
        try {
            this.debugCodeCall("getRow");
            this.checkClosed();
            int n2 = this.at.getRowId();
            if (n2 >= this.at.getRowCount()) {
                return 0;
            }
            return n2 + 1;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getConcurrency() throws SQLException {
        try {
            this.debugCodeCall("getConcurrency");
            this.checkClosed();
            if (!this.an) {
                return 1007;
            }
            UpdatableRow updatableRow = new UpdatableRow(this.al, this.at);
            return updatableRow.isUpdatable() ? 1008 : 1007;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getFetchDirection() throws SQLException {
        try {
            this.debugCodeCall("getFetchDirection");
            this.checkClosed();
            return 1000;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getFetchSize() throws SQLException {
        try {
            this.debugCodeCall("getFetchSize");
            this.checkClosed();
            return this.at.getFetchSize();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setFetchSize(int n2) throws SQLException {
        try {
            this.debugCodeCall("setFetchSize", n2);
            this.checkClosed();
            if (n2 < 0) {
                throw DbException.getInvalidValueException("rows", n2);
            }
            if (n2 > 0) {
                int n3;
                if (this.am != null && (n3 = this.am.getMaxRows()) > 0 && n2 > n3) {
                    throw DbException.getInvalidValueException("rows", n2);
                }
            } else {
                n2 = SysProperties.SERVER_RESULT_SET_FETCH_SIZE;
            }
            this.at.setFetchSize(n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setFetchDirection(int n2) throws SQLException {
        throw this.unsupported("setFetchDirection");
    }

    public int getType() throws SQLException {
        try {
            this.debugCodeCall("getType");
            this.checkClosed();
            return this.am == null ? 1003 : this.am.resultSetType;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean isBeforeFirst() throws SQLException {
        try {
            this.debugCodeCall("isBeforeFirst");
            this.checkClosed();
            int n2 = this.at.getRowId();
            int n3 = this.at.getRowCount();
            return n3 > 0 && n2 < 0;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean isAfterLast() throws SQLException {
        try {
            this.debugCodeCall("isAfterLast");
            this.checkClosed();
            int n2 = this.at.getRowId();
            int n3 = this.at.getRowCount();
            return n3 > 0 && n2 >= n3;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean isFirst() throws SQLException {
        try {
            this.debugCodeCall("isFirst");
            this.checkClosed();
            int n2 = this.at.getRowId();
            return n2 == 0 && n2 < this.at.getRowCount();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean isLast() throws SQLException {
        try {
            this.debugCodeCall("isLast");
            this.checkClosed();
            int n2 = this.at.getRowId();
            return n2 >= 0 && n2 == this.at.getRowCount() - 1;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void beforeFirst() throws SQLException {
        try {
            this.debugCodeCall("beforeFirst");
            this.checkClosed();
            if (this.at.getRowId() >= 0) {
                this.f();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void afterLast() throws SQLException {
        try {
            this.debugCodeCall("afterLast");
            this.checkClosed();
            while (this.e()) {
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean first() throws SQLException {
        try {
            this.debugCodeCall("first");
            this.checkClosed();
            if (this.at.getRowId() < 0) {
                return this.e();
            }
            this.f();
            return this.e();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean last() throws SQLException {
        try {
            this.debugCodeCall("last");
            this.checkClosed();
            return this.absolute(-1);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean absolute(int n2) throws SQLException {
        try {
            this.debugCodeCall("absolute", n2);
            this.checkClosed();
            if (n2 < 0) {
                n2 = this.at.getRowCount() + n2 + 1;
            } else if (n2 > this.at.getRowCount() + 1) {
                n2 = this.at.getRowCount() + 1;
            }
            if (n2 <= this.at.getRowId()) {
                this.f();
            }
            while (this.at.getRowId() + 1 < n2) {
                this.e();
            }
            int n3 = this.at.getRowId();
            return n3 >= 0 && n3 < this.at.getRowCount();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean relative(int n2) throws SQLException {
        try {
            this.debugCodeCall("relative", n2);
            this.checkClosed();
            int n3 = this.at.getRowId() + 1 + n2;
            if (n3 < 0) {
                n3 = 0;
            } else if (n3 > this.at.getRowCount()) {
                n3 = this.at.getRowCount() + 1;
            }
            return this.absolute(n3);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean previous() throws SQLException {
        try {
            this.debugCodeCall("previous");
            this.checkClosed();
            return this.relative(-1);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void moveToInsertRow() throws SQLException {
        try {
            this.debugCodeCall("moveToInsertRow");
            this.i();
            this.ar = new Value[this.ao];
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void moveToCurrentRow() throws SQLException {
        try {
            this.debugCodeCall("moveToCurrentRow");
            this.i();
            this.ar = null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean rowUpdated() throws SQLException {
        try {
            this.debugCodeCall("rowUpdated");
            return false;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean rowInserted() throws SQLException {
        try {
            this.debugCodeCall("rowInserted");
            return false;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean rowDeleted() throws SQLException {
        try {
            this.debugCodeCall("rowDeleted");
            return false;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void insertRow() throws SQLException {
        try {
            this.debugCodeCall("insertRow");
            this.i();
            if (this.ar == null) {
                throw DbException.get(90029);
            }
            this.g().insertRow(this.ar);
            this.ar = null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void updateRow() throws SQLException {
        try {
            this.debugCodeCall("updateRow");
            this.i();
            if (this.ar != null) {
                throw DbException.get(90029);
            }
            this.h();
            if (this.ak != null) {
                int n2;
                UpdatableRow updatableRow = this.g();
                Value[] valueArray = new Value[this.ao];
                for (n2 = 0; n2 < this.ak.length; ++n2) {
                    valueArray[n2] = this.byte(n2 + 1);
                }
                updatableRow.updateRow(valueArray, this.ak);
                for (n2 = 0; n2 < this.ak.length; ++n2) {
                    if (this.ak[n2] != null) continue;
                    this.ak[n2] = valueArray[n2];
                }
                Value[] valueArray2 = updatableRow.readRow(this.ak);
                this.a(valueArray2);
                this.ak = null;
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void deleteRow() throws SQLException {
        try {
            this.debugCodeCall("deleteRow");
            this.i();
            if (this.ar != null) {
                throw DbException.get(90029);
            }
            this.h();
            this.g().deleteRow(this.at.currentRow());
            this.ak = null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void refreshRow() throws SQLException {
        try {
            this.debugCodeCall("refreshRow");
            this.checkClosed();
            if (this.ar != null) {
                throw DbException.get(2000);
            }
            this.h();
            this.a(this.g().readRow(this.at.currentRow()));
            this.ak = null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void cancelRowUpdates() throws SQLException {
        try {
            this.debugCodeCall("cancelRowUpdates");
            this.checkClosed();
            if (this.ar != null) {
                throw DbException.get(2000);
            }
            this.ak = null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private UpdatableRow g() throws SQLException {
        UpdatableRow updatableRow = new UpdatableRow(this.al, this.at);
        if (!updatableRow.isUpdatable()) {
            throw DbException.get(90127);
        }
        return updatableRow;
    }

    private int char(String string) throws SQLException {
        int n2;
        this.checkClosed();
        if (string == null) {
            throw DbException.getInvalidValueException("columnLabel", null);
        }
        if (this.ao >= SysProperties.MIN_COLUMN_NAME_MAP) {
            Serializable serializable;
            if (this.ai == null) {
                String string2;
                int n3;
                serializable = New.hashMap(this.ao);
                for (n3 = 0; n3 < this.ao; ++n3) {
                    string2 = this.at.getColumnName(n3);
                    if (string2 == null) continue;
                    string2 = StringUtils.toUpperEnglish(string2);
                    ((HashMap)serializable).put(string2, n3);
                    String string3 = this.at.getTableName(n3);
                    if (string3 == null) continue;
                    string2 = StringUtils.toUpperEnglish(string3) + "." + string2;
                    ((HashMap)serializable).put(string2, n3);
                }
                for (n3 = 0; n3 < this.ao; ++n3) {
                    string2 = StringUtils.toUpperEnglish(this.at.getAlias(n3));
                    ((HashMap)serializable).put(string2, n3);
                }
                this.ai = serializable;
            }
            if ((serializable = (Integer)this.ai.get(StringUtils.toUpperEnglish(string))) == null) {
                throw DbException.get(42122, string);
            }
            return (Integer)serializable + 1;
        }
        for (n2 = 0; n2 < this.ao; ++n2) {
            if (!string.equalsIgnoreCase(this.at.getAlias(n2))) continue;
            return n2 + 1;
        }
        n2 = string.indexOf(46);
        if (n2 > 0) {
            String string4 = string.substring(0, n2);
            String string5 = string.substring(n2 + 1);
            for (int i2 = 0; i2 < this.ao; ++i2) {
                if (!string4.equalsIgnoreCase(this.at.getTableName(i2)) || !string5.equalsIgnoreCase(this.at.getColumnName(i2))) continue;
                return i2 + 1;
            }
        } else {
            for (int i3 = 0; i3 < this.ao; ++i3) {
                if (!string.equalsIgnoreCase(this.at.getColumnName(i3))) continue;
                return i3 + 1;
            }
        }
        throw DbException.get(42122, string);
    }

    private void case(int n2) throws SQLException {
        this.checkClosed();
        if (n2 < 1 || n2 > this.ao) {
            throw DbException.getInvalidValueException("columnIndex", n2);
        }
    }

    void checkClosed() throws SQLException {
        if (this.at == null) {
            throw DbException.get(90007);
        }
        if (this.am != null) {
            this.am.checkClosed();
        }
        if (this.al != null) {
            this.al.checkClosed();
        }
    }

    private void h() {
        if (this.at.getRowId() < 0 || this.at.getRowId() >= this.at.getRowCount()) {
            throw DbException.get(2000);
        }
    }

    private Value byte(int n2) throws SQLException {
        Value[] valueArray;
        this.case(n2);
        this.h();
        if (this.as == null) {
            valueArray = this.at.currentRow();
        } else {
            valueArray = (Value[])this.as.get(this.at.getRowId());
            if (valueArray == null) {
                valueArray = this.at.currentRow();
            }
        }
        Value value = valueArray[n2 - 1];
        this.aj = value == ValueNull.INSTANCE;
        return value;
    }

    private Value else(String string) throws SQLException {
        int n2 = this.char(string);
        return this.byte(n2);
    }

    private void a(String string, Value value) throws SQLException {
        int n2 = this.char(string);
        this.if(n2, value);
    }

    private void if(int n2, Value value) throws SQLException {
        this.i();
        this.case(n2);
        if (this.ar != null) {
            this.ar[n2 - 1] = value;
        } else {
            if (this.ak == null) {
                this.ak = new Value[this.ao];
            }
            this.ak[n2 - 1] = value;
        }
    }

    private boolean e() {
        boolean bl = this.at.next();
        if (!bl && !this.aq) {
            this.at.close();
        }
        return bl;
    }

    private void f() {
        if (!this.aq) {
            throw DbException.get(90128);
        }
        this.at.reset();
    }

    public int getHoldability() throws SQLException {
        try {
            this.debugCodeCall("getHoldability");
            this.checkClosed();
            return this.al.getHoldability();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean isClosed() throws SQLException {
        try {
            this.debugCodeCall("isClosed");
            return this.at == null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": " + this.at;
    }

    private void a(Value[] valueArray) {
        boolean bl = false;
        Value[] valueArray2 = this.at.currentRow();
        CompareMode compareMode = this.al.getCompareMode();
        for (int i2 = 0; i2 < valueArray.length; ++i2) {
            if (valueArray[i2].compareTo(valueArray2[i2], compareMode) == 0) continue;
            bl = true;
            break;
        }
        if (this.as == null) {
            this.as = New.hashMap();
        }
        Integer n2 = this.at.getRowId();
        if (!bl) {
            this.as.remove(n2);
        } else {
            this.as.put(n2, valueArray);
        }
    }

    private Value a(Object object) throws SQLException {
        this.checkClosed();
        return DataType.convertToValue(this.al.getSession(), object, -1);
    }

    private void i() throws SQLException {
        this.checkClosed();
        if (!this.an) {
            throw DbException.get(90140);
        }
    }
}

