/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.jdbc.JdbcResultSet;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceObject;
import org.h2.result.ResultInterface;
import org.h2.util.MathUtils;
import org.h2.value.DataType;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JdbcResultSetMetaData
extends TraceObject
implements ResultSetMetaData {
    private final String case;
    private final JdbcResultSet char;
    private final JdbcPreparedStatement byte;
    private final ResultInterface try;
    private final int else;

    JdbcResultSetMetaData(JdbcResultSet jdbcResultSet, JdbcPreparedStatement jdbcPreparedStatement, ResultInterface resultInterface, String string, Trace trace, int n2) {
        this.setTrace(trace, 5, n2);
        this.case = string;
        this.char = jdbcResultSet;
        this.byte = jdbcPreparedStatement;
        this.try = resultInterface;
        this.else = resultInterface.getVisibleColumnCount();
    }

    public int getColumnCount() throws SQLException {
        try {
            this.debugCodeCall("getColumnCount");
            this.a();
            return this.else;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public String getColumnLabel(int n2) throws SQLException {
        try {
            this.debugCodeCall("getColumnLabel", n2);
            this.a(n2);
            return this.try.getAlias(--n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public String getColumnName(int n2) throws SQLException {
        try {
            this.debugCodeCall("getColumnName", n2);
            this.a(n2);
            return this.try.getColumnName(--n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getColumnType(int n2) throws SQLException {
        try {
            this.debugCodeCall("getColumnType", n2);
            this.a(n2);
            int n3 = this.try.getColumnType(--n2);
            return DataType.convertTypeToSQLType(n3);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public String getColumnTypeName(int n2) throws SQLException {
        try {
            this.debugCodeCall("getColumnTypeName", n2);
            this.a(n2);
            int n3 = this.try.getColumnType(--n2);
            return DataType.getDataType((int)n3).name;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public String getSchemaName(int n2) throws SQLException {
        try {
            this.debugCodeCall("getSchemaName", n2);
            this.a(n2);
            return this.try.getSchemaName(--n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public String getTableName(int n2) throws SQLException {
        try {
            this.debugCodeCall("getTableName", n2);
            this.a(n2);
            return this.try.getTableName(--n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public String getCatalogName(int n2) throws SQLException {
        try {
            this.debugCodeCall("getCatalogName", n2);
            this.a(n2);
            return this.case;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean isAutoIncrement(int n2) throws SQLException {
        try {
            this.debugCodeCall("isAutoIncrement", n2);
            this.a(n2);
            return this.try.isAutoIncrement(--n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean isCaseSensitive(int n2) throws SQLException {
        try {
            this.debugCodeCall("isCaseSensitive", n2);
            this.a(n2);
            return true;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean isSearchable(int n2) throws SQLException {
        try {
            this.debugCodeCall("isSearchable", n2);
            this.a(n2);
            return true;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean isCurrency(int n2) throws SQLException {
        try {
            this.debugCodeCall("isCurrency", n2);
            this.a(n2);
            return false;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int isNullable(int n2) throws SQLException {
        try {
            this.debugCodeCall("isNullable", n2);
            this.a(n2);
            return this.try.getNullable(--n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean isSigned(int n2) throws SQLException {
        try {
            this.debugCodeCall("isSigned", n2);
            this.a(n2);
            return true;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean isReadOnly(int n2) throws SQLException {
        try {
            this.debugCodeCall("isReadOnly", n2);
            this.a(n2);
            return false;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean isWritable(int n2) throws SQLException {
        try {
            this.debugCodeCall("isWritable", n2);
            this.a(n2);
            return true;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean isDefinitelyWritable(int n2) throws SQLException {
        try {
            this.debugCodeCall("isDefinitelyWritable", n2);
            this.a(n2);
            return false;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public String getColumnClassName(int n2) throws SQLException {
        try {
            this.debugCodeCall("getColumnClassName", n2);
            this.a(n2);
            int n3 = this.try.getColumnType(--n2);
            return DataType.getTypeClassName(n3);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getPrecision(int n2) throws SQLException {
        try {
            this.debugCodeCall("getPrecision", n2);
            this.a(n2);
            long l2 = this.try.getColumnPrecision(--n2);
            return MathUtils.convertLongToInt(l2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getScale(int n2) throws SQLException {
        try {
            this.debugCodeCall("getScale", n2);
            this.a(n2);
            return this.try.getColumnScale(--n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getColumnDisplaySize(int n2) throws SQLException {
        try {
            this.debugCodeCall("getColumnDisplaySize", n2);
            this.a(n2);
            return this.try.getDisplaySize(--n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private void a() throws SQLException {
        if (this.char != null) {
            this.char.checkClosed();
        }
        if (this.byte != null) {
            this.byte.checkClosed();
        }
    }

    private void a(int n2) throws SQLException {
        this.a();
        if (n2 < 1 || n2 > this.else) {
            throw DbException.getInvalidValueException("columnIndex", n2);
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": columns=" + this.else;
    }
}

