/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.sql.SQLException;
import java.sql.Savepoint;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceObject;
import org.h2.util.StringUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JdbcSavepoint
extends TraceObject
implements Savepoint {
    private static final String w = "SYSTEM_SAVEPOINT_";
    private int u;
    private String t;
    private JdbcConnection v;

    JdbcSavepoint(JdbcConnection jdbcConnection, int n2, String string, Trace trace, int n3) {
        this.setTrace(trace, 6, n3);
        this.v = jdbcConnection;
        this.u = n2;
        this.t = string;
    }

    void release() {
        this.v = null;
    }

    static String getName(String string, int n2) {
        if (string != null) {
            return StringUtils.quoteJavaString(string);
        }
        return w + n2;
    }

    void rollback() {
        this.byte();
        this.v.prepareCommand("ROLLBACK TO SAVEPOINT " + JdbcSavepoint.getName(this.t, this.u), Integer.MAX_VALUE).executeUpdate();
    }

    private void byte() {
        if (this.v == null) {
            throw DbException.get(90063, JdbcSavepoint.getName(this.t, this.u));
        }
    }

    public int getSavepointId() throws SQLException {
        try {
            this.debugCodeCall("getSavepointId");
            this.byte();
            if (this.t != null) {
                throw DbException.get(90065);
            }
            return this.u;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public String getSavepointName() throws SQLException {
        try {
            this.debugCodeCall("getSavepointName");
            this.byte();
            if (this.t == null) {
                throw DbException.get(90064);
            }
            return this.t;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": id=" + this.u + " name=" + this.t;
    }
}

