/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbcx;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Stack;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import org.h2.jdbcx.JdbcDataSource;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JdbcConnectionPool
implements DataSource,
ConnectionEventListener {
    private static final int case = 30;
    private static final int do = 10;
    private final ConnectionPoolDataSource a;
    private final Stack try = new Stack();
    private PrintWriter if;
    private int for = 10;
    private int byte = 30;
    private int int;
    private boolean new;

    private JdbcConnectionPool(ConnectionPoolDataSource connectionPoolDataSource) {
        this.a = connectionPoolDataSource;
        try {
            this.if = connectionPoolDataSource.getLogWriter();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static JdbcConnectionPool create(ConnectionPoolDataSource connectionPoolDataSource) {
        return new JdbcConnectionPool(connectionPoolDataSource);
    }

    public static JdbcConnectionPool create(String string, String string2, String string3) {
        JdbcDataSource jdbcDataSource = new JdbcDataSource();
        jdbcDataSource.setURL(string);
        jdbcDataSource.setUser(string2);
        jdbcDataSource.setPassword(string3);
        return new JdbcConnectionPool(jdbcDataSource);
    }

    public synchronized void setMaxConnections(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("Invalid maxConnections value: " + n2);
        }
        this.for = n2;
        this.notifyAll();
    }

    public synchronized int getMaxConnections() {
        return this.for;
    }

    public synchronized int getLoginTimeout() {
        return this.byte;
    }

    public synchronized void setLoginTimeout(int n2) {
        if (n2 == 0) {
            n2 = 30;
        }
        this.byte = n2;
    }

    public synchronized void dispose() throws SQLException {
        if (this.new) {
            return;
        }
        this.new = true;
        SQLException sQLException = null;
        while (!this.try.isEmpty()) {
            PooledConnection pooledConnection = (PooledConnection)this.try.pop();
            try {
                pooledConnection.close();
            }
            catch (SQLException sQLException2) {
                if (sQLException != null) continue;
                sQLException = sQLException2;
            }
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        long l2 = System.currentTimeMillis() + (long)(this.byte * 1000);
        while (System.currentTimeMillis() <= l2) {
            JdbcConnectionPool jdbcConnectionPool = this;
            synchronized (jdbcConnectionPool) {
                if (this.int < this.for) {
                    return this.a();
                }
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        throw new SQLException("Login timeout", "08001", 8001);
    }

    private Connection a() throws SQLException {
        if (this.new) {
            throw new IllegalStateException("Connection pool has been disposed.");
        }
        PooledConnection pooledConnection = !this.try.empty() ? (PooledConnection)this.try.pop() : this.a.getPooledConnection();
        Connection connection = pooledConnection.getConnection();
        ++this.int;
        pooledConnection.addConnectionEventListener(this);
        return connection;
    }

    synchronized void recycleConnection(PooledConnection pooledConnection) {
        if (this.new) {
            this.disposeConnection(pooledConnection);
            return;
        }
        if (this.int <= 0) {
            throw new AssertionError();
        }
        --this.int;
        if (this.int < this.for) {
            this.try.push(pooledConnection);
        } else {
            this.a(pooledConnection);
        }
        this.notifyAll();
    }

    private void a(PooledConnection pooledConnection) {
        try {
            pooledConnection.close();
        }
        catch (SQLException sQLException) {
            this.a("Error while closing database connection: " + sQLException.toString());
        }
    }

    synchronized void disposeConnection(PooledConnection pooledConnection) {
        if (this.int <= 0) {
            throw new AssertionError();
        }
        --this.int;
        this.notifyAll();
        this.a(pooledConnection);
    }

    private void a(String string) {
        String string2 = this.getClass().getName() + ": " + string;
        try {
            if (this.if == null) {
                System.err.println(string2);
            } else {
                this.if.println(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        pooledConnection.removeConnectionEventListener(this);
        this.recycleConnection(pooledConnection);
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        pooledConnection.removeConnectionEventListener(this);
        this.disposeConnection(pooledConnection);
    }

    public synchronized int getActiveConnections() {
        return this.int;
    }

    public Connection getConnection(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    public PrintWriter getLogWriter() {
        return this.if;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.if = printWriter;
    }
}

