/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbcx;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.h2.Driver;
import org.h2.constant.SysProperties;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbcx.JdbcDataSourceFactory;
import org.h2.jdbcx.JdbcXid;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceObject;
import org.h2.util.JdbcUtils;
import org.h2.util.New;
import org.h2.util.StringUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JdbcXAConnection
extends TraceObject
implements XAConnection,
XAResource {
    private static int Y;
    private JdbcDataSourceFactory ab;
    private String W;
    private String aa;
    private JdbcConnection X;
    private volatile PooledJdbcConnection V;
    private ArrayList ac = New.arrayList();
    private Xid ad;
    private int Z;

    JdbcXAConnection(JdbcDataSourceFactory jdbcDataSourceFactory, int n2, String string, String string2, char[] cArray) throws SQLException {
        this.ab = jdbcDataSourceFactory;
        this.setTrace(jdbcDataSourceFactory.getTrace(), 13, n2);
        this.W = string;
        this.aa = string2;
        Properties properties = new Properties();
        properties.setProperty("user", string2);
        properties.put("password", StringUtils.cloneCharArray(cArray));
        this.X = (JdbcConnection)Driver.load().connect(string, properties);
    }

    public XAResource getXAResource() {
        this.debugCodeCall("getXAResource");
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        this.debugCodeCall("close");
        PooledJdbcConnection pooledJdbcConnection = this.V;
        if (pooledJdbcConnection != null) {
            this.ac.clear();
            pooledJdbcConnection.close();
        }
        if (this.X != null) {
            try {
                this.X.close();
            }
            finally {
                this.X = null;
            }
        }
    }

    public Connection getConnection() throws SQLException {
        this.debugCodeCall("getConnection");
        PooledJdbcConnection pooledJdbcConnection = this.V;
        if (pooledJdbcConnection != null) {
            pooledJdbcConnection.close();
        }
        this.V = new PooledJdbcConnection(this.X);
        return this.V;
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.debugCode("addConnectionEventListener(listener);");
        this.ac.add(connectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.debugCode("removeConnectionEventListener(listener);");
        this.ac.remove(connectionEventListener);
    }

    void closedHandle() {
        this.debugCode("closedHandle();");
        for (ConnectionEventListener connectionEventListener : New.arrayList(this.ac)) {
            ConnectionEvent connectionEvent = new ConnectionEvent(this);
            connectionEventListener.connectionClosed(connectionEvent);
        }
        this.V = null;
    }

    public int getTransactionTimeout() {
        this.debugCodeCall("getTransactionTimeout");
        return 0;
    }

    public boolean setTransactionTimeout(int n2) {
        this.debugCodeCall("setTransactionTimeout", n2);
        return false;
    }

    public boolean isSameRM(XAResource xAResource) {
        this.debugCode("isSameRM(xares);");
        return xAResource == this;
    }

    public Xid[] recover(int n2) throws XAException {
        this.debugCodeCall("recover", this.try(n2));
        this.d();
        Statement statement = null;
        try {
            Xid[] xidArray;
            statement = this.X.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT * FROM INFORMATION_SCHEMA.IN_DOUBT ORDER BY TRANSACTION");
            ArrayList arrayList = New.arrayList();
            while (resultSet.next()) {
                xidArray = resultSet.getString("TRANSACTION");
                int n3 = this.getNextId(14);
                JdbcXid jdbcXid = new JdbcXid(this.ab, n3, (String)xidArray);
                arrayList.add(jdbcXid);
            }
            resultSet.close();
            xidArray = new Xid[arrayList.size()];
            arrayList.toArray(xidArray);
            Xid[] xidArray2 = xidArray;
            return xidArray2;
        }
        catch (SQLException sQLException) {
            XAException xAException = new XAException(-3);
            xAException.initCause(sQLException);
            throw xAException;
        }
        finally {
            JdbcUtils.closeSilently(statement);
        }
    }

    public int prepare(Xid xid) throws XAException {
        if (this.isDebugEnabled()) {
            this.debugCode("prepare(" + this.a(xid) + ");");
        }
        this.d();
        if (!this.ad.equals(xid)) {
            throw new XAException(-5);
        }
        Statement statement = null;
        try {
            statement = this.X.createStatement();
            this.Z = Y++;
            statement.execute("PREPARE COMMIT TX_" + this.Z);
        }
        catch (SQLException sQLException) {
            throw this.a(sQLException);
        }
        finally {
            JdbcUtils.closeSilently(statement);
        }
        return 0;
    }

    public void forget(Xid xid) {
        if (this.isDebugEnabled()) {
            this.debugCode("forget(" + this.a(xid) + ");");
        }
    }

    public void rollback(Xid xid) throws XAException {
        if (this.isDebugEnabled()) {
            this.debugCode("rollback(" + this.a(xid) + ");");
        }
        try {
            this.X.rollback();
            this.X.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            throw this.a(sQLException);
        }
        this.ad = null;
    }

    public void end(Xid xid, int n2) throws XAException {
        if (this.isDebugEnabled()) {
            this.debugCode("end(" + this.a(xid) + ", " + this.try(n2) + ");");
        }
        if (n2 == 0x2000000) {
            return;
        }
        if (!this.ad.equals(xid)) {
            throw new XAException(-9);
        }
    }

    public void start(Xid xid, int n2) throws XAException {
        if (this.isDebugEnabled()) {
            this.debugCode("start(" + this.a(xid) + ", " + this.try(n2) + ");");
        }
        if (n2 == 0x8000000) {
            return;
        }
        if (n2 == 0x200000) {
            if (this.ad != null && !this.ad.equals(xid)) {
                throw new XAException(-3);
            }
        } else if (this.ad != null) {
            throw new XAException(-4);
        }
        try {
            this.X.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            throw this.a(sQLException);
        }
        this.ad = xid;
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        if (this.isDebugEnabled()) {
            this.debugCode("commit(" + this.a(xid) + ", " + bl + ");");
        }
        Statement statement = null;
        try {
            if (bl) {
                this.X.commit();
            } else {
                statement = this.X.createStatement();
                statement.execute("COMMIT TRANSACTION TX_" + this.Z);
            }
            this.X.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            try {
                throw this.a(sQLException);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeSilently(statement);
                throw throwable;
            }
        }
        JdbcUtils.closeSilently(statement);
        this.ad = null;
    }

    public String toString() {
        return this.getTraceObjectName() + ": url=" + this.W + " user=" + this.aa;
    }

    private XAException a(SQLException sQLException) {
        XAException xAException = new XAException(sQLException.getMessage());
        xAException.initCause(sQLException);
        return xAException;
    }

    private String a(Xid xid) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\"f:").append(xid.getFormatId()).append(",bq:").append(StringUtils.convertBytesToString(xid.getBranchQualifier())).append(",gx:").append(StringUtils.convertBytesToString(xid.getGlobalTransactionId())).append(",c:").append(xid.getClass().getName()).append("\"");
        return stringBuilder.toString();
    }

    private String try(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        if ((n2 & 0x800000) != 0) {
            stringBuilder.append("|XAResource.TMENDRSCAN");
        }
        if ((n2 & 0x20000000) != 0) {
            stringBuilder.append("|XAResource.TMFAIL");
        }
        if ((n2 & 0x200000) != 0) {
            stringBuilder.append("|XAResource.TMJOIN");
        }
        if ((n2 & 0x40000000) != 0) {
            stringBuilder.append("|XAResource.TMONEPHASE");
        }
        if ((n2 & 0x8000000) != 0) {
            stringBuilder.append("|XAResource.TMRESUME");
        }
        if ((n2 & 0x1000000) != 0) {
            stringBuilder.append("|XAResource.TMSTARTRSCAN");
        }
        if ((n2 & 0x4000000) != 0) {
            stringBuilder.append("|XAResource.TMSUCCESS");
        }
        if ((n2 & 0x2000000) != 0) {
            stringBuilder.append("|XAResource.TMSUSPEND");
        }
        if ((n2 & 3) != 0) {
            stringBuilder.append("|XAResource.XA_RDONLY");
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append("|XAResource.TMNOFLAGS");
        }
        return stringBuilder.toString().substring(1);
    }

    private void d() throws XAException {
        if (this.X == null) {
            throw new XAException(-3);
        }
    }

    static {
        Driver.load();
    }

    class PooledJdbcConnection
    extends JdbcConnection {
        private boolean r;

        public PooledJdbcConnection(JdbcConnection jdbcConnection) {
            super(jdbcConnection);
            this.openStackTrace = new Exception("Stack Trace");
        }

        public synchronized void close() throws SQLException {
            if (!this.r) {
                this.rollback();
                this.setAutoCommit(true);
                JdbcXAConnection.this.closedHandle();
                this.r = true;
            }
        }

        public synchronized boolean isClosed() throws SQLException {
            return this.r || super.isClosed();
        }

        protected synchronized void checkClosed(boolean bl) throws SQLException {
            if (this.r) {
                throw DbException.get(90007);
            }
            super.checkClosed(bl);
        }

        protected void finalize() {
            if (!SysProperties.runFinalize) {
                return;
            }
            Trace trace = this.getTrace();
            try {
                if (!this.isClosed()) {
                    trace.error(this.openStackTrace, "pooled connection not closed");
                    JdbcXAConnection.this.close();
                }
            }
            catch (SQLException sQLException) {
                trace.debug(sQLException, "finalize");
            }
        }
    }
}

