/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbcx;

import java.util.StringTokenizer;
import javax.transaction.xa.Xid;
import org.h2.jdbcx.JdbcDataSourceFactory;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.util.StringUtils;

public class JdbcXid
extends TraceObject
implements Xid {
    private static final String ae = "XID";
    private int ah;
    private byte[] af;
    private byte[] ag;

    JdbcXid(JdbcDataSourceFactory jdbcDataSourceFactory, int n2, String string) {
        this.setTrace(jdbcDataSourceFactory.getTrace(), 14, n2);
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
            String string2 = stringTokenizer.nextToken();
            if (!ae.equals(string2)) {
                throw DbException.get(90101, string);
            }
            this.ah = Integer.parseInt(stringTokenizer.nextToken());
            this.af = StringUtils.convertStringToBytes(stringTokenizer.nextToken());
            this.ag = StringUtils.convertStringToBytes(stringTokenizer.nextToken());
        }
        catch (RuntimeException runtimeException) {
            throw DbException.get(90101, string);
        }
    }

    public String getAsString() {
        StringBuilder stringBuilder = new StringBuilder(ae);
        stringBuilder.append('_').append(this.ah).append('_').append(StringUtils.convertBytesToString(this.af)).append('_').append(StringUtils.convertBytesToString(this.ag));
        return stringBuilder.toString();
    }

    public int getFormatId() {
        this.debugCodeCall("getFormatId");
        return this.ah;
    }

    public byte[] getBranchQualifier() {
        this.debugCodeCall("getBranchQualifier");
        return this.af;
    }

    public byte[] getGlobalTransactionId() {
        this.debugCodeCall("getGlobalTransactionId");
        return this.ag;
    }

    public String toString() {
        return this.getTraceObjectName() + ": " + this.getAsString();
    }
}

