/*
 * Decompiled with CFR 0.152.
 */
package org.h2.message;

import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import org.h2.constant.SysProperties;
import org.h2.expression.ParameterInterface;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.util.IOUtils;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TraceObject {
    protected static final int CALLABLE_STATEMENT = 0;
    protected static final int CONNECTION = 1;
    protected static final int DATABASE_META_DATA = 2;
    protected static final int PREPARED_STATEMENT = 3;
    protected static final int RESULT_SET = 4;
    protected static final int RESULT_SET_META_DATA = 5;
    protected static final int SAVEPOINT = 6;
    protected static final int SQL_EXCEPTION = 7;
    protected static final int STATEMENT = 8;
    protected static final int BLOB = 9;
    protected static final int CLOB = 10;
    protected static final int PARAMETER_META_DATA = 11;
    protected static final int DATA_SOURCE = 12;
    protected static final int XA_DATA_SOURCE = 13;
    protected static final int XID = 14;
    protected static final int ARRAY = 15;
    private static final int for = 16;
    private static final int[] if = new int[16];
    private static final String[] a = new String[]{"call", "conn", "dbMeta", "prep", "rs", "rsMeta", "sp", "ex", "stat", "blob", "clob", "pMeta", "ds", "xads", "xid", "ar"};
    private Trace int;
    private int new;
    private int do;

    protected void setTrace(Trace trace, int n2, int n3) {
        this.int = trace;
        this.new = n2;
        this.do = n3;
    }

    protected void setTrace(Trace trace) {
        this.int = trace;
    }

    protected Trace getTrace() {
        return this.int;
    }

    public int getTraceId() {
        return this.do;
    }

    public String getTraceObjectName() {
        return a[this.new] + this.do;
    }

    protected int getNextId(int n2) {
        int n3 = n2;
        int n4 = if[n3];
        if[n3] = n4 + 1;
        return n4;
    }

    protected boolean isDebugEnabled() {
        return this.int.isDebugEnabled();
    }

    protected boolean isInfoEnabled() {
        return this.int.isInfoEnabled();
    }

    protected void debugCodeAssign(String string, int n2, int n3, String string2) {
        if (this.int.isDebugEnabled()) {
            this.int.debugCode(string + " " + a[n2] + n3 + " = " + this.getTraceObjectName() + "." + string2 + ";");
        }
    }

    protected void debugCodeCall(String string) {
        if (this.int.isDebugEnabled()) {
            this.int.debugCode(this.getTraceObjectName() + "." + string + "();");
        }
    }

    protected void debugCodeCall(String string, long l2) {
        if (this.int.isDebugEnabled()) {
            this.int.debugCode(this.getTraceObjectName() + "." + string + "(" + l2 + ");");
        }
    }

    protected void debugCodeCall(String string, String string2) {
        if (this.int.isDebugEnabled()) {
            this.int.debugCode(this.getTraceObjectName() + "." + string + "(" + this.quote(string2) + ");");
        }
    }

    protected void debugCode(String string) {
        if (this.int.isDebugEnabled()) {
            this.int.debugCode(this.getTraceObjectName() + "." + string);
        }
    }

    protected String quote(String string) {
        return StringUtils.quoteJavaString(string);
    }

    protected String quoteTime(Time time) {
        if (time == null) {
            return "null";
        }
        return "Time.valueOf(\"" + time.toString() + "\")";
    }

    protected String quoteTimestamp(Timestamp timestamp) {
        if (timestamp == null) {
            return "null";
        }
        return "Timestamp.valueOf(\"" + timestamp.toString() + "\")";
    }

    protected String quoteDate(Date date) {
        if (date == null) {
            return "null";
        }
        return "Date.valueOf(\"" + date.toString() + "\")";
    }

    protected String quoteBigDecimal(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return "null";
        }
        return "new BigDecimal(\"" + bigDecimal.toString() + "\")";
    }

    protected String quoteBytes(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        return "org.h2.util.StringUtils.convertStringToBytes(\"" + StringUtils.convertBytesToString(byArray) + "\")";
    }

    protected String quoteArray(String[] stringArray) {
        return StringUtils.quoteJavaStringArray(stringArray);
    }

    protected String quoteIntArray(int[] nArray) {
        return StringUtils.quoteJavaIntArray(nArray);
    }

    protected String quoteMap(Map map) {
        if (map == null) {
            return "null";
        }
        if (map.size() == 0) {
            return "new Map()";
        }
        StringBuilder stringBuilder = new StringBuilder("new Map() /* ");
        try {
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                Class clazz = (Class)entry.getValue();
                stringBuilder.append(string).append(':').append(clazz.getName());
            }
        }
        catch (Exception exception) {
            stringBuilder.append(exception.toString()).append(": ").append(map.toString());
        }
        stringBuilder.append("*/");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected SQLException logAndConvert(Exception exception) {
        SQLException sQLException = DbException.toSQLException(exception);
        if (SysProperties.LOG_ALL_ERRORS) {
            Class<TraceObject> clazz = TraceObject.class;
            // MONITORENTER : org.h2.message.TraceObject.class
            try {
                Writer writer = IOUtils.getBufferedWriter(IOUtils.openFileOutputStream(SysProperties.LOG_ALL_ERRORS_FILE, true));
                PrintWriter printWriter = new PrintWriter(writer);
                sQLException.printStackTrace(printWriter);
                printWriter.close();
                writer.close();
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
        if (this.int == null) {
            TraceSystem.traceThrowable(sQLException);
            return sQLException;
        }
        int n2 = sQLException.getErrorCode();
        if (n2 >= 23000 && n2 < 24000) {
            this.int.info(sQLException, "exception");
            return sQLException;
        }
        this.int.error(sQLException, "exception");
        return sQLException;
    }

    protected SQLException unsupported(String string) throws SQLException {
        try {
            throw DbException.getUnsupportedException(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public static String toString(String string, ArrayList arrayList) {
        StatementBuilder statementBuilder = new StatementBuilder(string);
        if (arrayList != null && arrayList.size() > 0) {
            statementBuilder.append(" {");
            int n2 = 0;
            for (ParameterInterface parameterInterface : arrayList) {
                ++n2;
                try {
                    statementBuilder.appendExceptFirst(", ");
                    statementBuilder.append(n2).append(": ");
                    if (parameterInterface == null || parameterInterface.getParamValue() == null) {
                        statementBuilder.append('-');
                        continue;
                    }
                    statementBuilder.append(parameterInterface.getParamValue().getSQL());
                }
                catch (Exception exception) {
                    statementBuilder.append("/* ").append(n2).append(": ").append(exception.toString()).append("*/ ");
                }
            }
            statementBuilder.append("};");
        }
        return statementBuilder.toString();
    }
}

