/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.result.ResultDiskBuffer;
import org.h2.result.ResultExternal;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.result.ResultTempTable;
import org.h2.result.SortOrder;
import org.h2.util.New;
import org.h2.util.ValueHashMap;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LocalResult
implements ResultInterface,
ResultTarget {
    private int aI;
    private Session aM;
    private int aD;
    private Expression[] aJ;
    private int aC;
    private int aN;
    private ArrayList aP;
    private SortOrder aH;
    private ValueHashMap aA;
    private Value[] aO;
    private int aG;
    private int aF;
    private ResultExternal aB;
    private int aL;
    private boolean aE;
    private boolean aK;

    public LocalResult() {
    }

    public LocalResult(Session session, Expression[] expressionArray, int n2) {
        this.aM = session;
        this.aI = session == null ? Integer.MAX_VALUE : session.getDatabase().getMaxMemoryRows();
        this.aP = New.arrayList();
        this.aD = n2;
        this.aC = -1;
        this.aJ = expressionArray;
    }

    public static LocalResult read(Session session, ResultSet resultSet, int n2) {
        Expression[] expressionArray = Expression.getExpressionColumns(session, resultSet);
        int n3 = expressionArray.length;
        LocalResult localResult = new LocalResult(session, expressionArray, n3);
        try {
            for (int i2 = 0; (n2 == 0 || i2 < n2) && resultSet.next(); ++i2) {
                Value[] valueArray = new Value[n3];
                for (int i3 = 0; i3 < n3; ++i3) {
                    int n4 = localResult.getColumnType(i3);
                    valueArray[i3] = DataType.readValue(session, resultSet, i3 + 1, n4);
                }
                localResult.addRow(valueArray);
            }
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
        localResult.done();
        return localResult;
    }

    public LocalResult createShallowCopy(Session session) {
        if (this.aB == null && (this.aP == null || this.aP.size() < this.aN)) {
            return null;
        }
        LocalResult localResult = new LocalResult();
        localResult.aI = this.aI;
        localResult.aM = session;
        localResult.aD = this.aD;
        localResult.aJ = this.aJ;
        localResult.aC = -1;
        localResult.aN = this.aN;
        localResult.aP = this.aP;
        localResult.aH = this.aH;
        localResult.aA = this.aA;
        localResult.aE = this.aE;
        localResult.aO = null;
        localResult.aG = 0;
        localResult.aF = 0;
        localResult.aB = this.aB;
        localResult.aL = this.aL;
        return localResult;
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.aH = sortOrder;
    }

    public void setDistinct() {
        this.aE = true;
        this.aA = ValueHashMap.newInstance();
    }

    public void removeDistinct(Value[] valueArray) {
        if (!this.aE) {
            DbException.throwInternalError();
        }
        if (this.aA != null) {
            ValueArray valueArray2 = ValueArray.get(valueArray);
            this.aA.remove(valueArray2);
            this.aN = this.aA.size();
        } else {
            this.aN = this.aB.removeRow(valueArray);
        }
    }

    public boolean containsDistinct(Value[] valueArray) {
        if (!this.aE) {
            DbException.throwInternalError();
        }
        if (this.aA != null) {
            ValueArray valueArray2 = ValueArray.get(valueArray);
            return this.aA.get(valueArray2) != null;
        }
        return this.aB.contains(valueArray);
    }

    public void reset() {
        this.aC = -1;
        if (this.aB != null) {
            this.aB.reset();
            if (this.aL > 0) {
                for (int i2 = 0; i2 < this.aL; ++i2) {
                    this.aB.next();
                }
            }
        }
    }

    public Value[] currentRow() {
        return this.aO;
    }

    public boolean next() {
        if (this.aC < this.aN) {
            ++this.aC;
            if (this.aC < this.aN) {
                this.aO = this.aB != null ? this.aB.next() : (Value[])this.aP.get(this.aC);
                return true;
            }
            this.aO = null;
        }
        return false;
    }

    public int getRowId() {
        return this.aC;
    }

    public void addRow(Value[] valueArray) {
        if (this.aE) {
            if (this.aA != null) {
                ValueArray valueArray2 = ValueArray.get(valueArray);
                this.aA.put(valueArray2, valueArray);
                this.aN = this.aA.size();
                Database database = this.aM.getDatabase();
                if (this.aN > database.getSettings().maxMemoryRowsDistinct && database.isPersistent()) {
                    this.aB = new ResultTempTable(this.aM, this.aH);
                    this.aB.addRows(this.aA.values());
                    this.aA = null;
                }
            } else {
                this.aN = this.aB.addRow(valueArray);
            }
            return;
        }
        this.aP.add(valueArray);
        ++this.aN;
        if (this.aP.size() > this.aI && this.aM.getDatabase().isPersistent()) {
            if (this.aB == null) {
                this.aB = new ResultDiskBuffer(this.aM, this.aH, valueArray.length);
            }
            this.goto();
        }
    }

    private void goto() {
        this.aB.addRows(this.aP);
        this.aP.clear();
    }

    public int getVisibleColumnCount() {
        return this.aD;
    }

    public void done() {
        if (this.aE) {
            if (this.aA != null) {
                this.aP = this.aA.values();
                this.aA = null;
            } else if (this.aB != null && this.aH != null) {
                Value[] valueArray;
                ResultExternal resultExternal = this.aB;
                this.aB = null;
                resultExternal.reset();
                this.aP = New.arrayList();
                while ((valueArray = resultExternal.next()) != null) {
                    if (this.aB == null) {
                        this.aB = new ResultDiskBuffer(this.aM, this.aH, valueArray.length);
                    }
                    this.aP.add(valueArray);
                    if (this.aP.size() <= this.aI) continue;
                    this.aB.addRows(this.aP);
                    this.aP.clear();
                }
                resultExternal.close();
            }
        }
        if (this.aB != null) {
            this.goto();
            this.aB.done();
        } else if (this.aH != null) {
            this.aH.sort(this.aP);
        }
        this.else();
        this.long();
        this.reset();
    }

    public int getRowCount() {
        return this.aN;
    }

    public void setLimit(int n2) {
        this.aF = n2;
    }

    private void long() {
        if (this.aF <= 0) {
            return;
        }
        if (this.aB == null) {
            if (this.aP.size() > this.aF) {
                this.aP = New.arrayList(this.aP.subList(0, this.aF));
                this.aN = this.aF;
            }
        } else if (this.aF < this.aN) {
            this.aN = this.aF;
        }
    }

    public boolean needToClose() {
        return this.aB != null;
    }

    public void close() {
        if (this.aB != null) {
            this.aB.close();
            this.aB = null;
            this.aK = true;
        }
    }

    public String getAlias(int n2) {
        return this.aJ[n2].getAlias();
    }

    public String getTableName(int n2) {
        return this.aJ[n2].getTableName();
    }

    public String getSchemaName(int n2) {
        return this.aJ[n2].getSchemaName();
    }

    public int getDisplaySize(int n2) {
        return this.aJ[n2].getDisplaySize();
    }

    public String getColumnName(int n2) {
        return this.aJ[n2].getColumnName();
    }

    public int getColumnType(int n2) {
        return this.aJ[n2].getType();
    }

    public long getColumnPrecision(int n2) {
        return this.aJ[n2].getPrecision();
    }

    public int getNullable(int n2) {
        return this.aJ[n2].getNullable();
    }

    public boolean isAutoIncrement(int n2) {
        return this.aJ[n2].isAutoIncrement();
    }

    public int getColumnScale(int n2) {
        return this.aJ[n2].getScale();
    }

    public void setOffset(int n2) {
        this.aG = n2;
    }

    private void else() {
        if (this.aG <= 0) {
            return;
        }
        if (this.aB == null) {
            if (this.aG >= this.aP.size()) {
                this.aP.clear();
                this.aN = 0;
            } else {
                int n2 = Math.min(this.aG, this.aP.size());
                this.aP = New.arrayList(this.aP.subList(n2, this.aP.size()));
                this.aN -= n2;
            }
        } else if (this.aG >= this.aN) {
            this.aN = 0;
        } else {
            this.aL = this.aG;
            this.aN -= this.aG;
        }
    }

    public String toString() {
        return "columns: " + this.aD + " rows: " + this.aN + " pos: " + this.aC;
    }

    public boolean isClosed() {
        return this.aK;
    }

    public int getFetchSize() {
        return 0;
    }

    public void setFetchSize(int n2) {
    }
}

