/*
 * Decompiled with CFR 0.152.
 */
package org.h2.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.h2.api.TableEngine;
import org.h2.command.ddl.CreateTableData;
import org.h2.constant.SysProperties;
import org.h2.constraint.Constraint;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.DbObjectBase;
import org.h2.engine.FunctionAlias;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.schema.Constant;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.table.RegularTable;
import org.h2.table.Table;
import org.h2.table.TableLink;
import org.h2.util.New;
import org.h2.util.Utils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Schema
extends DbObjectBase {
    private User else;
    private boolean char;
    private HashMap c = New.hashMap();
    private HashMap void = New.hashMap();
    private HashMap d = New.hashMap();
    private HashMap b = New.hashMap();
    private HashMap goto = New.hashMap();
    private HashMap f = New.hashMap();
    private HashMap long = New.hashMap();
    private HashSet e = New.hashSet();

    public Schema(Database database, int n2, String string, User user, boolean bl) {
        this.initDbObjectBase(database, n2, string, "schema");
        this.else = user;
        this.char = bl;
    }

    public boolean canDrop() {
        return !this.char;
    }

    public String getCreateSQLForCopy(Table table, String string) {
        throw DbException.throwInternalError();
    }

    public String getDropSQL() {
        return null;
    }

    public String getCreateSQL() {
        if (this.char) {
            return null;
        }
        return "CREATE SCHEMA IF NOT EXISTS " + this.getSQL() + " AUTHORIZATION " + this.else.getSQL();
    }

    public int getType() {
        return 10;
    }

    public void removeChildrenAndResources(Session session) {
        SchemaObject schemaObject;
        while (this.b != null && this.b.size() > 0) {
            schemaObject = (TriggerObject)this.b.values().toArray()[0];
            this.database.removeSchemaObject(session, schemaObject);
        }
        while (this.goto != null && this.goto.size() > 0) {
            schemaObject = (Constraint)this.goto.values().toArray()[0];
            this.database.removeSchemaObject(session, schemaObject);
        }
        while (this.c != null && this.c.size() > 0) {
            schemaObject = (Table)this.c.values().toArray()[0];
            this.database.removeSchemaObject(session, schemaObject);
        }
        while (this.void != null && this.void.size() > 0) {
            schemaObject = (Index)this.void.values().toArray()[0];
            this.database.removeSchemaObject(session, schemaObject);
        }
        while (this.d != null && this.d.size() > 0) {
            schemaObject = (Sequence)this.d.values().toArray()[0];
            this.database.removeSchemaObject(session, schemaObject);
        }
        while (this.f != null && this.f.size() > 0) {
            schemaObject = (Constant)this.f.values().toArray()[0];
            this.database.removeSchemaObject(session, schemaObject);
        }
        while (this.long != null && this.long.size() > 0) {
            schemaObject = (FunctionAlias)this.long.values().toArray()[0];
            this.database.removeSchemaObject(session, schemaObject);
        }
        this.database.removeMeta(session, this.getId());
        this.else = null;
        this.invalidate();
    }

    public void checkRename() {
    }

    public User getOwner() {
        return this.else;
    }

    private HashMap a(int n2) {
        HashMap hashMap;
        switch (n2) {
            case 0: {
                hashMap = this.c;
                break;
            }
            case 3: {
                hashMap = this.d;
                break;
            }
            case 1: {
                hashMap = this.void;
                break;
            }
            case 4: {
                hashMap = this.b;
                break;
            }
            case 5: {
                hashMap = this.goto;
                break;
            }
            case 11: {
                hashMap = this.f;
                break;
            }
            case 9: {
                hashMap = this.long;
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + n2);
            }
        }
        return hashMap;
    }

    public void add(SchemaObject schemaObject) {
        if (SysProperties.CHECK && schemaObject.getSchema() != this) {
            DbException.throwInternalError("wrong schema");
        }
        String string = schemaObject.getName();
        HashMap hashMap = this.a(schemaObject.getType());
        if (SysProperties.CHECK && hashMap.get(string) != null) {
            DbException.throwInternalError("object already exists: " + string);
        }
        hashMap.put(string, schemaObject);
        this.freeUniqueName(string);
    }

    public void rename(SchemaObject schemaObject, String string) {
        int n2 = schemaObject.getType();
        HashMap hashMap = this.a(n2);
        if (SysProperties.CHECK) {
            if (!hashMap.containsKey(schemaObject.getName())) {
                DbException.throwInternalError("not found: " + schemaObject.getName());
            }
            if (schemaObject.getName().equals(string) || hashMap.containsKey(string)) {
                DbException.throwInternalError("object already exists: " + string);
            }
        }
        schemaObject.checkRename();
        hashMap.remove(schemaObject.getName());
        this.freeUniqueName(schemaObject.getName());
        schemaObject.rename(string);
        hashMap.put(string, schemaObject);
        this.freeUniqueName(string);
    }

    public Table findTableOrView(Session session, String string) {
        Table table = (Table)this.c.get(string);
        if (table == null && session != null) {
            table = session.findLocalTempTable(string);
        }
        return table;
    }

    public Index findIndex(Session session, String string) {
        Index index = (Index)this.void.get(string);
        if (index == null) {
            index = session.findLocalTempTableIndex(string);
        }
        return index;
    }

    public TriggerObject findTrigger(String string) {
        return (TriggerObject)this.b.get(string);
    }

    public Sequence findSequence(String string) {
        return (Sequence)this.d.get(string);
    }

    public Constraint findConstraint(Session session, String string) {
        Constraint constraint = (Constraint)this.goto.get(string);
        if (constraint == null) {
            constraint = session.findLocalTempTableConstraint(string);
        }
        return constraint;
    }

    public Constant findConstant(String string) {
        return (Constant)this.f.get(string);
    }

    public FunctionAlias findFunction(String string) {
        return (FunctionAlias)this.long.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeUniqueName(String string) {
        if (string != null) {
            HashSet hashSet = this.e;
            synchronized (hashSet) {
                this.e.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String a(DbObject dbObject, HashMap hashMap, String string) {
        String string2 = Integer.toHexString(dbObject.getName().hashCode()).toUpperCase();
        String string3 = null;
        HashSet hashSet = this.e;
        synchronized (hashSet) {
            int n2;
            int n3 = string2.length();
            for (n2 = 1; n2 < n3 && (hashMap.containsKey(string3 = string + string2.substring(0, n2)) || this.e.contains(string3)); ++n2) {
                string3 = null;
            }
            if (string3 == null) {
                string = string + string2 + "_";
                n2 = 0;
                while (hashMap.containsKey(string3 = string + n2) || this.e.contains(string3)) {
                    ++n2;
                }
            }
            this.e.add(string3);
        }
        return string3;
    }

    public String getUniqueConstraintName(Session session, Table table) {
        HashMap hashMap = table.isTemporary() && !table.isGlobalTemporary() ? session.getLocalTempTableConstraints() : this.goto;
        return this.a(table, hashMap, "CONSTRAINT_");
    }

    public String getUniqueIndexName(Session session, Table table, String string) {
        HashMap hashMap = table.isTemporary() && !table.isGlobalTemporary() ? session.getLocalTempTableIndexes() : this.void;
        return this.a(table, hashMap, string);
    }

    public Table getTableOrView(Session session, String string) {
        Table table = (Table)this.c.get(string);
        if (table == null) {
            if (session != null) {
                table = session.findLocalTempTable(string);
            }
            if (table == null) {
                throw DbException.get(42102, string);
            }
        }
        return table;
    }

    public Index getIndex(String string) {
        Index index = (Index)this.void.get(string);
        if (index == null) {
            throw DbException.get(42112, string);
        }
        return index;
    }

    public Constraint getConstraint(String string) {
        Constraint constraint = (Constraint)this.goto.get(string);
        if (constraint == null) {
            throw DbException.get(90057, string);
        }
        return constraint;
    }

    public Constant getConstant(String string) {
        Constant constant = (Constant)this.f.get(string);
        if (constant == null) {
            throw DbException.get(90115, string);
        }
        return constant;
    }

    public Sequence getSequence(String string) {
        Sequence sequence = (Sequence)this.d.get(string);
        if (sequence == null) {
            throw DbException.get(90036, string);
        }
        return sequence;
    }

    public ArrayList getAll() {
        ArrayList arrayList = New.arrayList();
        arrayList.addAll(this.a(0).values());
        arrayList.addAll(this.a(3).values());
        arrayList.addAll(this.a(1).values());
        arrayList.addAll(this.a(4).values());
        arrayList.addAll(this.a(5).values());
        arrayList.addAll(this.a(11).values());
        arrayList.addAll(this.a(9).values());
        return arrayList;
    }

    public ArrayList getAll(int n2) {
        HashMap hashMap = this.a(n2);
        return New.arrayList(hashMap.values());
    }

    public ArrayList getAllTablesAndViews() {
        return New.arrayList(this.c.values());
    }

    public ArrayList getAllFunctionAliases() {
        return New.arrayList(this.long.values());
    }

    public void remove(SchemaObject schemaObject) {
        String string = schemaObject.getName();
        HashMap hashMap = this.a(schemaObject.getType());
        if (SysProperties.CHECK && !hashMap.containsKey(string)) {
            DbException.throwInternalError("not found: " + string);
        }
        hashMap.remove(string);
        this.freeUniqueName(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table createTable(CreateTableData createTableData) {
        Database database = this.database;
        synchronized (database) {
            createTableData.schema = this;
            if (createTableData.tableEngine != null) {
                TableEngine tableEngine;
                try {
                    tableEngine = (TableEngine)Utils.loadUserClass(createTableData.tableEngine).newInstance();
                }
                catch (Exception exception) {
                    throw DbException.convert(exception);
                }
                return tableEngine.createTable(createTableData);
            }
            return new RegularTable(createTableData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableLink createTableLink(int n2, String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, boolean bl2) {
        Database database = this.database;
        synchronized (database) {
            return new TableLink(this, n2, string, string2, string3, string4, string5, string6, string7, bl, bl2);
        }
    }
}

