/*
 * Decompiled with CFR 0.152.
 */
package org.h2.schema;

import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObjectBase;
import org.h2.table.Table;

public class Sequence
extends SchemaObjectBase {
    public static final int DEFAULT_CACHE_SIZE = 32;
    private long ae = 1L;
    private long ag;
    private long ac = 1L;
    private long af = 32L;
    private boolean ad;

    public Sequence(Schema schema, int n2, String string, boolean bl) {
        this.initSchemaObjectBase(schema, n2, string, "sequence");
        this.ad = bl;
    }

    public synchronized void setStartValue(long l2) {
        this.ae = l2;
        this.ag = l2;
    }

    public boolean getBelongsToTable() {
        return this.ad;
    }

    public long getIncrement() {
        return this.ac;
    }

    public void setIncrement(long l2) {
        if (l2 == 0L) {
            throw DbException.getInvalidValueException("INCREMENT", 0);
        }
        this.ac = l2;
    }

    public String getDropSQL() {
        if (this.getBelongsToTable()) {
            return null;
        }
        return "DROP SEQUENCE IF EXISTS " + this.getSQL();
    }

    public String getCreateSQLForCopy(Table table, String string) {
        throw DbException.throwInternalError();
    }

    public synchronized String getCreateSQL() {
        StringBuilder stringBuilder = new StringBuilder("CREATE SEQUENCE ");
        stringBuilder.append(this.getSQL()).append(" START WITH ").append(this.ae);
        if (this.ac != 1L) {
            stringBuilder.append(" INCREMENT BY ").append(this.ac);
        }
        if (this.af != 32L) {
            stringBuilder.append(" CACHE ").append(this.af);
        }
        if (this.ad) {
            stringBuilder.append(" BELONGS_TO_TABLE");
        }
        return stringBuilder.toString();
    }

    public synchronized long getNext(Session session) {
        if (this.ac > 0L && this.ae >= this.ag || this.ac < 0L && this.ae <= this.ag) {
            this.ag += this.ac * this.af;
            this.flush(session);
        }
        long l2 = this.ae;
        this.ae += this.ac;
        return l2;
    }

    public void flushWithoutMargin() {
        if (this.ag != this.ae) {
            this.ag = this.ae;
            this.flush(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flush(Session session) {
        Session session2 = this.database.getSystemSession();
        if (session == null || !this.database.isSysTableLocked()) {
            session = session2;
        }
        Session session3 = session;
        synchronized (session3) {
            long l2 = this.ae;
            try {
                this.ae = this.ag;
                this.database.update(session, this);
            }
            finally {
                this.ae = l2;
            }
            if (session == session2) {
                session2.commit(false);
            }
        }
    }

    public void close() {
        this.flushWithoutMargin();
    }

    public int getType() {
        return 3;
    }

    public void removeChildrenAndResources(Session session) {
        this.database.removeMeta(session, this.getId());
        this.invalidate();
    }

    public void checkRename() {
    }

    public synchronized long getCurrentValue() {
        return this.ae - this.ac;
    }

    public void setBelongsToTable(boolean bl) {
        this.ad = bl;
    }

    public void setCacheSize(long l2) {
        this.af = l2;
    }

    public long getCacheSize() {
        return this.af;
    }
}

