/*
 * Decompiled with CFR 0.152.
 */
package org.h2.schema;

import java.sql.SQLException;
import org.h2.api.Trigger;
import org.h2.command.Parser;
import org.h2.engine.Session;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObjectBase;
import org.h2.table.Table;
import org.h2.util.StatementBuilder;
import org.h2.util.Utils;
import org.h2.value.DataType;
import org.h2.value.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TriggerObject
extends SchemaObjectBase {
    public static final int DEFAULT_QUEUE_SIZE = 1024;
    private boolean V;
    private boolean X;
    private int W;
    private boolean Y;
    private boolean ab;
    private int T = 1024;
    private boolean Z;
    private Table aa;
    private String U;
    private Trigger S;

    public TriggerObject(Schema schema, int n2, String string, Table table) {
        this.initSchemaObjectBase(schema, n2, string, "trigger");
        this.aa = table;
        this.setTemporary(table.isTemporary());
    }

    public void setBefore(boolean bl) {
        this.X = bl;
    }

    public void setInsteadOf(boolean bl) {
        this.V = bl;
    }

    private synchronized void do(Session session) {
        if (this.S != null) {
            return;
        }
        try {
            JdbcConnection jdbcConnection = session.createConnection(false);
            Object t = Utils.loadUserClass(this.U).newInstance();
            this.S = (Trigger)t;
            this.S.init(jdbcConnection, this.getSchema().getName(), this.getName(), this.aa.getName(), this.X, this.W);
        }
        catch (Throwable throwable) {
            this.S = null;
            throw DbException.get(90043, throwable, this.getName(), this.U, throwable.toString());
        }
    }

    public void setTriggerClassName(Session session, String string, boolean bl) {
        block2: {
            this.U = string;
            try {
                this.do(session);
            }
            catch (DbException dbException) {
                if (bl) break block2;
                throw dbException;
            }
        }
    }

    public void fire(Session session, int n2, boolean bl) {
        if (this.Y || this.X != bl || (this.W & n2) == 0) {
            return;
        }
        this.do(session);
        JdbcConnection jdbcConnection = session.createConnection(false);
        boolean bl2 = false;
        if (n2 != 8) {
            bl2 = session.setCommitOrRollbackDisabled(true);
        }
        Value value = session.getScopeIdentity();
        try {
            this.S.fire(jdbcConnection, null, null);
        }
        catch (Throwable throwable) {
            throw DbException.get(90044, throwable, this.getName(), this.U, throwable.toString());
        }
        finally {
            session.setScopeIdentity(value);
            if (n2 != 8) {
                session.setCommitOrRollbackDisabled(bl2);
            }
        }
    }

    private Object[] a(Row row) {
        if (row == null) {
            return null;
        }
        int n2 = row.getColumnCount();
        Object[] objectArray = new Object[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray[i2] = row.getValue(i2).getObject();
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fireRow(Session session, Row row, Row row2, boolean bl, boolean bl2) {
        block17: {
            Object[] objectArray;
            if (!this.Y || this.X != bl) {
                return false;
            }
            if (bl2 && !this.ab) {
                return false;
            }
            this.do(session);
            boolean bl3 = false;
            if ((this.W & 1) != 0 && row == null && row2 != null) {
                bl3 = true;
            }
            if ((this.W & 2) != 0 && row != null && row2 != null) {
                bl3 = true;
            }
            if ((this.W & 4) != 0 && row != null && row2 == null) {
                bl3 = true;
            }
            if (!bl3) {
                return false;
            }
            Object[] objectArray2 = this.a(row);
            Object[] objectArray3 = this.a(row2);
            if (this.X && objectArray3 != null) {
                objectArray = new Object[objectArray3.length];
                for (int i2 = 0; i2 < objectArray3.length; ++i2) {
                    objectArray[i2] = objectArray3[i2];
                }
            } else {
                objectArray = null;
            }
            JdbcConnection jdbcConnection = session.createConnection(false);
            boolean bl4 = session.getAutoCommit();
            boolean bl5 = session.setCommitOrRollbackDisabled(true);
            Value value = session.getScopeIdentity();
            try {
                session.setAutoCommit(false);
                this.S.fire(jdbcConnection, objectArray2, objectArray3);
                if (objectArray != null) {
                    for (int i3 = 0; i3 < objectArray3.length; ++i3) {
                        Object object = objectArray3[i3];
                        if (object == objectArray[i3]) continue;
                        Value value2 = DataType.convertToValue(session, object, -1);
                        row2.setValue(i3, value2);
                    }
                }
            }
            catch (Exception exception) {
                if (this.ab) {
                    break block17;
                }
                throw DbException.convert(exception);
            }
            finally {
                session.setScopeIdentity(value);
                session.setCommitOrRollbackDisabled(bl5);
                session.setAutoCommit(bl4);
            }
        }
        return this.V;
    }

    public void setTypeMask(int n2) {
        this.W = n2;
    }

    public void setRowBased(boolean bl) {
        this.Y = bl;
    }

    public void setQueueSize(int n2) {
        this.T = n2;
    }

    public int getQueueSize() {
        return this.T;
    }

    public void setNoWait(boolean bl) {
        this.Z = bl;
    }

    public boolean isNoWait() {
        return this.Z;
    }

    public void setOnRollback(boolean bl) {
        this.ab = bl;
    }

    public String getDropSQL() {
        return null;
    }

    public String getCreateSQLForCopy(Table table, String string) {
        StringBuilder stringBuilder = new StringBuilder("CREATE FORCE TRIGGER ");
        stringBuilder.append(string);
        if (this.V) {
            stringBuilder.append(" INSTEAD OF ");
        } else if (this.X) {
            stringBuilder.append(" BEFORE ");
        } else {
            stringBuilder.append(" AFTER ");
        }
        stringBuilder.append(this.getTypeNameList());
        stringBuilder.append(" ON ").append(table.getSQL());
        if (this.Y) {
            stringBuilder.append(" FOR EACH ROW");
        }
        if (this.Z) {
            stringBuilder.append(" NOWAIT");
        } else {
            stringBuilder.append(" QUEUE ").append(this.T);
        }
        stringBuilder.append(" CALL ").append(Parser.quoteIdentifier(this.U));
        return stringBuilder.toString();
    }

    public String getTypeNameList() {
        StatementBuilder statementBuilder = new StatementBuilder();
        if ((this.W & 1) != 0) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append("INSERT");
        }
        if ((this.W & 2) != 0) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append("UPDATE");
        }
        if ((this.W & 4) != 0) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append("DELETE");
        }
        if ((this.W & 8) != 0) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append("SELECT");
        }
        if (this.ab) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append("ROLLBACK");
        }
        return statementBuilder.toString();
    }

    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.aa, this.getSQL());
    }

    public int getType() {
        return 4;
    }

    public void removeChildrenAndResources(Session session) {
        this.aa.removeTrigger(this);
        this.database.removeMeta(session, this.getId());
        if (this.S != null) {
            try {
                this.S.remove();
            }
            catch (SQLException sQLException) {
                throw DbException.convert(sQLException);
            }
        }
        this.aa = null;
        this.U = null;
        this.S = null;
        this.invalidate();
    }

    public void checkRename() {
    }

    public Table getTable() {
        return this.aa;
    }

    public boolean isBefore() {
        return this.X;
    }

    public String getTriggerClassName() {
        return this.U;
    }

    public void close() throws SQLException {
        if (this.S != null) {
            this.S.close();
        }
    }

    public boolean isSelectTrigger() {
        return (this.W & 8) != 0;
    }
}

