/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.h2.Driver;
import org.h2.message.DbException;
import org.h2.message.TraceSystem;
import org.h2.server.Service;
import org.h2.server.TcpServerThread;
import org.h2.util.JdbcUtils;
import org.h2.util.NetUtils;
import org.h2.util.New;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TcpServer
implements Service {
    private static final int G = 0;
    private static final int H = 1;
    private static final String B = "management_db_";
    private static final Map x = Collections.synchronizedMap(new HashMap());
    private int q;
    private boolean C;
    private boolean t;
    private boolean z;
    private ServerSocket n;
    private Set o = Collections.synchronizedSet(new HashSet());
    private String r;
    private boolean F;
    private boolean p;
    private boolean s;
    private Connection D;
    private PreparedStatement E;
    private PreparedStatement v;
    private String w = "";
    private Thread y;
    private int A;
    private String I;
    private String u;

    public static String getManagementDbName(int n2) {
        return "mem:management_db_" + n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void if() throws SQLException {
        Connection connection;
        Properties properties = new Properties();
        properties.setProperty("user", "");
        properties.setProperty("password", this.w);
        this.D = connection = Driver.load().connect("jdbc:h2:" + TcpServer.getManagementDbName(this.q), properties);
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.execute("CREATE ALIAS IF NOT EXISTS STOP_SERVER FOR \"" + TcpServer.class.getName() + ".stopServer\"");
            statement.execute("CREATE TABLE IF NOT EXISTS SESSIONS(ID INT PRIMARY KEY, URL VARCHAR, USER VARCHAR, CONNECTED TIMESTAMP)");
            this.E = connection.prepareStatement("INSERT INTO SESSIONS VALUES(?, ?, ?, NOW())");
            this.v = connection.prepareStatement("DELETE FROM SESSIONS WHERE ID=?");
        }
        finally {
            JdbcUtils.closeSilently(statement);
        }
        x.put(this.q, this);
    }

    synchronized void addConnection(int n2, String string, String string2) {
        try {
            this.E.setInt(1, n2);
            this.E.setString(2, string);
            this.E.setString(3, string2);
            this.E.execute();
        }
        catch (SQLException sQLException) {
            TraceSystem.traceThrowable(sQLException);
        }
    }

    synchronized void removeConnection(int n2) {
        try {
            this.v.setInt(1, n2);
            this.v.execute();
        }
        catch (SQLException sQLException) {
            TraceSystem.traceThrowable(sQLException);
        }
    }

    private synchronized void a() {
        if (this.D != null) {
            try {
                this.D.close();
            }
            catch (SQLException sQLException) {
                TraceSystem.traceThrowable(sQLException);
            }
            this.D = null;
        }
    }

    public void init(String ... stringArray) {
        this.q = 9092;
        for (int i2 = 0; stringArray != null && i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            if ("-trace".equals(string)) {
                this.C = true;
                continue;
            }
            if ("-tcpSSL".equals(string)) {
                this.t = true;
                continue;
            }
            if ("-tcpPort".equals(string)) {
                this.q = Integer.decode(stringArray[++i2]);
                continue;
            }
            if ("-tcpPassword".equals(string)) {
                this.w = stringArray[++i2];
                continue;
            }
            if ("-baseDir".equals(string)) {
                this.r = stringArray[++i2];
                continue;
            }
            if ("-key".equals(string)) {
                this.I = stringArray[++i2];
                this.u = stringArray[++i2];
                continue;
            }
            if ("-tcpAllowOthers".equals(string)) {
                this.F = true;
                continue;
            }
            if ("-tcpDaemon".equals(string)) {
                this.p = true;
                continue;
            }
            if (!"-ifExists".equals(string)) continue;
            this.s = true;
        }
        Driver.load();
    }

    public String getURL() {
        return (this.t ? "ssl" : "tcp") + "://" + NetUtils.getLocalAddress() + ":" + this.q;
    }

    public int getPort() {
        return this.q;
    }

    boolean allow(Socket socket) {
        if (this.F) {
            return true;
        }
        try {
            return NetUtils.isLocalAddress(socket);
        }
        catch (UnknownHostException unknownHostException) {
            this.traceError(unknownHostException);
            return false;
        }
    }

    public synchronized void start() throws SQLException {
        this.z = false;
        this.n = NetUtils.createServerSocket(this.q, this.t);
        this.q = this.n.getLocalPort();
        this.if();
    }

    public void listen() {
        block3: {
            this.y = Thread.currentThread();
            String string = this.y.getName();
            try {
                while (!this.z) {
                    Socket socket = this.n.accept();
                    TcpServerThread tcpServerThread = new TcpServerThread(socket, this, this.A++);
                    this.o.add(tcpServerThread);
                    Thread thread = new Thread(tcpServerThread);
                    thread.setDaemon(this.p);
                    thread.setName(string + " thread");
                    tcpServerThread.setThread(thread);
                    thread.start();
                }
                this.n = NetUtils.closeSilently(this.n);
            }
            catch (Exception exception) {
                if (this.z) break block3;
                TraceSystem.traceThrowable(exception);
            }
        }
        this.a();
    }

    public synchronized boolean isRunning(boolean bl) {
        if (this.n == null) {
            return false;
        }
        try {
            Socket socket = NetUtils.createLoopbackSocket(this.q, this.t);
            socket.close();
            return true;
        }
        catch (Exception exception) {
            if (bl) {
                this.traceError(exception);
            }
            return false;
        }
    }

    public void stop() {
        x.remove(this.q);
        if (!this.z) {
            this.a();
            this.z = true;
            if (this.n != null) {
                try {
                    this.n.close();
                }
                catch (IOException iOException) {
                    TraceSystem.traceThrowable(iOException);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.n = null;
            }
            if (this.y != null) {
                try {
                    this.y.join(1000L);
                }
                catch (InterruptedException interruptedException) {
                    TraceSystem.traceThrowable(interruptedException);
                }
            }
        }
        for (TcpServerThread tcpServerThread : New.arrayList(this.o)) {
            if (tcpServerThread == null) continue;
            tcpServerThread.close();
            try {
                tcpServerThread.getThread().join(100L);
            }
            catch (Exception exception) {
                TraceSystem.traceThrowable(exception);
            }
        }
    }

    public static void stopServer(int n2, String string, int n3) {
        if (n2 == 0) {
            Integer[] integerArray = x.keySet().toArray(new Integer[0]);
            int n4 = integerArray.length;
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5 = integerArray[i2];
                if (n5 == 0) continue;
                TcpServer.stopServer(n5, string, n3);
            }
            return;
        }
        TcpServer tcpServer = (TcpServer)x.get(n2);
        if (tcpServer == null) {
            return;
        }
        if (!tcpServer.w.equals(string)) {
            return;
        }
        if (n3 == 0) {
            tcpServer.a();
            tcpServer.z = true;
            try {
                Socket socket = NetUtils.createLoopbackSocket(n2, false);
                socket.close();
            }
            catch (Exception exception) {}
        } else if (n3 == 1) {
            tcpServer.stop();
        }
    }

    void remove(TcpServerThread tcpServerThread) {
        this.o.remove(tcpServerThread);
    }

    String getBaseDir() {
        return this.r;
    }

    void trace(String string) {
        if (this.C) {
            System.out.println(string);
        }
    }

    void traceError(Throwable throwable) {
        if (this.C) {
            throwable.printStackTrace();
        }
    }

    public boolean getAllowOthers() {
        return this.F;
    }

    public String getType() {
        return "TCP";
    }

    public String getName() {
        return "H2 TCP Server";
    }

    boolean getIfExists() {
        return this.s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void shutdown(String string, String string2, boolean bl, boolean bl2) throws SQLException {
        try {
            String string3;
            int n2 = 9092;
            int n3 = string.indexOf(58, "jdbc:h2:".length());
            if (n3 >= 0) {
                string3 = string.substring(n3 + 1);
                if ((n3 = string3.indexOf(47)) >= 0) {
                    string3 = string3.substring(0, n3);
                }
                n2 = Integer.decode(string3);
            }
            string3 = TcpServer.getManagementDbName(n2);
            try {
                Driver.load();
            }
            catch (Throwable throwable) {
                throw DbException.convert(throwable);
            }
            for (int i2 = 0; i2 < 2; ++i2) {
                Connection connection = null;
                PreparedStatement preparedStatement = null;
                try {
                    block14: {
                        connection = DriverManager.getConnection("jdbc:h2:" + string + "/" + string3, "", string2);
                        preparedStatement = connection.prepareStatement("CALL STOP_SERVER(?, ?, ?)");
                        preparedStatement.setInt(1, bl2 ? 0 : n2);
                        preparedStatement.setString(2, string2);
                        preparedStatement.setInt(3, bl ? 1 : 0);
                        try {
                            preparedStatement.execute();
                        }
                        catch (SQLException sQLException) {
                            if (bl) break block14;
                            throw sQLException;
                        }
                    }
                    JdbcUtils.closeSilently(preparedStatement);
                }
                catch (SQLException sQLException) {
                    if (i2 != 1) continue;
                    throw sQLException;
                }
                finally {
                    JdbcUtils.closeSilently(preparedStatement);
                    JdbcUtils.closeSilently(connection);
                }
                JdbcUtils.closeSilently(connection);
                break;
            }
        }
        catch (Exception exception) {
            throw DbException.toSQLException(exception);
        }
    }

    void cancelStatement(String string, int n2) throws SQLException {
        for (TcpServerThread tcpServerThread : New.arrayList(this.o)) {
            if (tcpServerThread == null) continue;
            tcpServerThread.cancelStatement(string, n2);
        }
    }

    public String checkKeyAndGetDatabaseName(String string) throws SQLException {
        if (this.I == null) {
            return string;
        }
        if (this.I.equals(string)) {
            return this.u;
        }
        throw DbException.get(8004);
    }

    public boolean isDaemon() {
        return this.p;
    }
}

