/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.pg;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.h2.Driver;
import org.h2.engine.Constants;
import org.h2.server.Service;
import org.h2.server.pg.PgServerThread;
import org.h2.util.NetUtils;
import org.h2.util.New;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PgServer
implements Service {
    public static final int DEFAULT_PORT = 5435;
    public static final int PG_TYPE_VARCHAR = 1043;
    public static final int PG_TYPE_INT2VECTOR = 22;
    private static final int if = 16;
    private static final int char = 17;
    private static final int try = 1042;
    private static final int h = 20;
    private static final int k = 21;
    private static final int j = 23;
    private static final int int = 25;
    private static final int do = 26;
    private static final int case = 700;
    private static final int new = 701;
    private static final int long = 705;
    private static final int else = 1009;
    private static final int e = 1082;
    private static final int l = 1083;
    private static final int byte = 1114;
    private static final int f = 1700;
    private HashSet void = New.hashSet();
    private int b = 5435;
    private boolean g;
    private boolean i;
    private ServerSocket a;
    private Set for = Collections.synchronizedSet(new HashSet());
    private String d;
    private boolean m;
    private boolean goto;
    private boolean c;

    public void init(String ... stringArray) {
        this.b = 5435;
        for (int i2 = 0; stringArray != null && i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            if ("-trace".equals(string)) {
                this.i = true;
                continue;
            }
            if ("-pgPort".equals(string)) {
                this.b = Integer.decode(stringArray[++i2]);
                continue;
            }
            if ("-baseDir".equals(string)) {
                this.d = stringArray[++i2];
                continue;
            }
            if ("-pgAllowOthers".equals(string)) {
                this.m = true;
                continue;
            }
            if ("-pgDaemon".equals(string)) {
                this.goto = true;
                continue;
            }
            if (!"-ifExists".equals(string)) continue;
            this.c = true;
        }
        Driver.load();
    }

    boolean getTrace() {
        return this.i;
    }

    void trace(String string) {
        if (this.i) {
            System.out.println(string);
        }
    }

    synchronized void remove(PgServerThread pgServerThread) {
        this.for.remove(pgServerThread);
    }

    void traceError(Exception exception) {
        if (this.i) {
            exception.printStackTrace();
        }
    }

    public String getURL() {
        return "pg://" + NetUtils.getLocalAddress() + ":" + this.b;
    }

    public int getPort() {
        return this.b;
    }

    private boolean a(Socket socket) {
        if (this.m) {
            return true;
        }
        try {
            return NetUtils.isLocalAddress(socket);
        }
        catch (UnknownHostException unknownHostException) {
            this.traceError(unknownHostException);
            return false;
        }
    }

    public void start() {
        this.a = NetUtils.createServerSocket(this.b, false);
    }

    public void listen() {
        block4: {
            String string = Thread.currentThread().getName();
            try {
                while (!this.g) {
                    Socket socket = this.a.accept();
                    if (!this.a(socket)) {
                        this.trace("Connection not allowed");
                        socket.close();
                        continue;
                    }
                    PgServerThread pgServerThread = new PgServerThread(socket, this);
                    this.for.add(pgServerThread);
                    pgServerThread.setProcessId(this.for.size());
                    Thread thread = new Thread(pgServerThread);
                    thread.setDaemon(this.goto);
                    thread.setName(string + " thread");
                    pgServerThread.setThread(thread);
                    thread.start();
                }
            }
            catch (Exception exception) {
                if (this.g) break block4;
                exception.printStackTrace();
            }
        }
    }

    public void stop() {
        if (!this.g) {
            this.g = true;
            if (this.a != null) {
                try {
                    this.a.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.a = null;
            }
        }
        for (PgServerThread pgServerThread : New.arrayList(this.for)) {
            pgServerThread.close();
            try {
                Thread thread = pgServerThread.getThread();
                if (thread == null) continue;
                thread.join(100L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean isRunning(boolean bl) {
        if (this.a == null) {
            return false;
        }
        try {
            Socket socket = NetUtils.createLoopbackSocket(this.a.getLocalPort(), false);
            socket.close();
            return true;
        }
        catch (Exception exception) {
            if (bl) {
                this.traceError(exception);
            }
            return false;
        }
    }

    String getBaseDir() {
        return this.d;
    }

    public boolean getAllowOthers() {
        return this.m;
    }

    public String getType() {
        return "PG";
    }

    public String getName() {
        return "H2 PG Server";
    }

    boolean getIfExists() {
        return this.c;
    }

    public static String getIndexColumn(Connection connection, int n2, Integer n3, Boolean bl) throws SQLException {
        if (n3 == null || n3 == 0) {
            PreparedStatement preparedStatement = connection.prepareStatement("select sql from information_schema.indexes where id=?");
            preparedStatement.setInt(1, n2);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                return resultSet.getString(1);
            }
            return "";
        }
        PreparedStatement preparedStatement = connection.prepareStatement("select column_name from information_schema.indexes where id=? and ordinal_position=?");
        preparedStatement.setInt(1, n2);
        preparedStatement.setInt(2, n3);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            return resultSet.getString(1);
        }
        return "";
    }

    public static String getCurrentSchema(Connection connection) throws SQLException {
        ResultSet resultSet = connection.createStatement().executeQuery("call schema()");
        resultSet.next();
        return resultSet.getString(1);
    }

    public static int getOid(Connection connection, String string) throws SQLException {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        PreparedStatement preparedStatement = connection.prepareStatement("select oid from pg_class where relName = ?");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (!resultSet.next()) {
            return 0;
        }
        return resultSet.getInt(1);
    }

    public static String getEncodingName(int n2) {
        switch (n2) {
            case 0: {
                return "SQL_ASCII";
            }
            case 6: {
                return "UTF8";
            }
            case 8: {
                return "LATIN1";
            }
        }
        return n2 < 40 ? "UTF8" : "";
    }

    public static String getVersion() {
        return "PostgreSQL 8.1.4  server protocol using H2 " + Constants.getFullVersion();
    }

    public static Timestamp getStartTime() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static String getUserById(Connection connection, int n2) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT NAME FROM INFORMATION_SCHEMA.USERS WHERE ID=?");
        preparedStatement.setInt(1, n2);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            return resultSet.getString(1);
        }
        return null;
    }

    public static boolean hasDatabasePrivilege(int n2, String string) {
        return true;
    }

    public static boolean hasTablePrivilege(String string, String string2) {
        return true;
    }

    public static int getCurrentTid(String string, String string2) {
        return 1;
    }

    public static int convertType(int n2) {
        switch (n2) {
            case 16: {
                return 16;
            }
            case 12: {
                return 1043;
            }
            case 2005: {
                return 25;
            }
            case 1: {
                return 1042;
            }
            case 5: {
                return 21;
            }
            case 4: {
                return 23;
            }
            case -5: {
                return 20;
            }
            case 3: {
                return 1700;
            }
            case 7: {
                return 700;
            }
            case 8: {
                return 701;
            }
            case 92: {
                return 1083;
            }
            case 91: {
                return 1082;
            }
            case 93: {
                return 1114;
            }
            case -3: {
                return 17;
            }
            case 2004: {
                return 26;
            }
            case 2003: {
                return 1009;
            }
        }
        return 705;
    }

    HashSet getTypeSet() {
        return this.void;
    }

    void checkType(int n2) {
        if (!this.void.contains(n2)) {
            this.trace("Unsupported type: " + n2);
        }
    }

    public boolean isDaemon() {
        return this.goto;
    }
}

