/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.command.Parser;
import org.h2.server.web.DbSchema;
import org.h2.util.New;
import org.h2.util.StringUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DbContents {
    DbSchema[] schemas;
    DbSchema defaultSchema;
    boolean isOracle;
    boolean isH2;
    boolean isH2ModeMySQL;
    boolean isPostgreSQL;
    boolean isMySQL;
    boolean isDerby;
    boolean isFirebird;
    boolean isSQLite;
    boolean storedUpperCaseIdentifiers;

    static int findColumn(ResultSet resultSet, String string, int n2) {
        try {
            return resultSet.findColumn(string);
        }
        catch (SQLException sQLException) {
            return n2;
        }
    }

    void readContents(DatabaseMetaData databaseMetaData) throws SQLException {
        Object object;
        Object object2;
        String string = StringUtils.toLowerEnglish(databaseMetaData.getDatabaseProductName());
        this.isSQLite = string.indexOf("sqlite") >= 0;
        String string2 = databaseMetaData.getURL();
        if (string2 != null) {
            this.isH2 = string2.startsWith("jdbc:h2:");
            if (this.isH2) {
                object2 = databaseMetaData.getConnection().createStatement();
                object = object2.executeQuery("SELECT UPPER(VALUE) FROM INFORMATION_SCHEMA.SETTINGS WHERE NAME='MODE'");
                object.next();
                if ("MYSQL".equals(object.getString(1))) {
                    this.isH2ModeMySQL = true;
                }
                object.close();
                object2.close();
            }
            this.isOracle = string2.startsWith("jdbc:oracle:");
            this.isPostgreSQL = string2.startsWith("jdbc:postgresql:");
            this.isMySQL = string2.startsWith("jdbc:mysql:");
            this.isDerby = string2.startsWith("jdbc:derby:");
            this.isFirebird = string2.startsWith("jdbc:firebirdsql:");
        }
        this.storedUpperCaseIdentifiers = databaseMetaData.storesUpperCaseIdentifiers();
        object2 = this.a(databaseMetaData);
        object = this.if(databaseMetaData);
        this.schemas = new DbSchema[((String[])object).length];
        for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            DbSchema[] dbSchemaArray = object[i2];
            int n2 = object2 == null || ((String)object2).equals(dbSchemaArray) ? 1 : 0;
            DbSchema dbSchema = new DbSchema(this, (String)dbSchemaArray, n2 != 0);
            if (dbSchema.isDefault) {
                this.defaultSchema = dbSchema;
            }
            this.schemas[i2] = dbSchema;
            String[] stringArray = new String[]{"TABLE", "SYSTEM TABLE", "VIEW", "SYSTEM VIEW", "TABLE LINK", "SYNONYM"};
            dbSchema.readTables(databaseMetaData, stringArray);
        }
        if (this.defaultSchema == null) {
            String string3 = null;
            for (DbSchema dbSchema : this.schemas) {
                if ("dbo".equals(dbSchema.name)) {
                    this.defaultSchema = dbSchema;
                    break;
                }
                if (this.defaultSchema != null && string3 != null && dbSchema.name.length() >= string3.length()) continue;
                string3 = dbSchema.name;
                this.defaultSchema = dbSchema;
            }
        }
    }

    private String[] if(DatabaseMetaData databaseMetaData) throws SQLException {
        String[] stringArray;
        if (this.isMySQL) {
            return new String[]{""};
        }
        if (this.isFirebird) {
            return new String[]{null};
        }
        ResultSet resultSet = databaseMetaData.getSchemas();
        ArrayList arrayList = New.arrayList();
        while (resultSet.next()) {
            stringArray = resultSet.getString(DbContents.findColumn(resultSet, "TABLE_SCHEM", 1));
            if (this.isOracle) {
                for (String string : new String[]{"CTXSYS", "DIP", "DBSNMP", "DMSYS", "EXFSYS", "MDDATA", "MDSYS", "MGMT_VIEW", "OLAPSYS", "ORDSYS", "ORDPLUGINS", "OUTLN", "SI_INFORMTN_SCHEMA", "SYS", "SYSMAN", "SYSTEM", "TSMSYS", "WMSYS", "XDB"}) {
                    if (!string.equals(stringArray)) continue;
                    stringArray = null;
                    break;
                }
            }
            if (stringArray == null) continue;
            arrayList.add(stringArray);
        }
        resultSet.close();
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private String a(DatabaseMetaData databaseMetaData) {
        String string = "";
        try {
            if (this.isOracle) {
                return databaseMetaData.getUserName();
            }
            if (this.isPostgreSQL) {
                return "public";
            }
            if (this.isMySQL) {
                return "";
            }
            if (this.isDerby) {
                return StringUtils.toUpperEnglish(databaseMetaData.getUserName());
            }
            if (this.isFirebird) {
                return null;
            }
            ResultSet resultSet = databaseMetaData.getSchemas();
            int n2 = resultSet.findColumn("IS_DEFAULT");
            while (resultSet.next()) {
                if (!resultSet.getBoolean(n2)) continue;
                string = resultSet.getString("TABLE_SCHEM");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return string;
    }

    String quoteIdentifier(String string) {
        if (string == null) {
            return null;
        }
        if (this.isH2 && !this.isH2ModeMySQL) {
            return Parser.quoteIdentifier(string);
        }
        return StringUtils.toUpperEnglish(string);
    }

    boolean needsQuotes(String string) {
        return !(this.storedUpperCaseIdentifiers ? string.equals(string.toUpperCase()) : string.equals(string.toLowerCase()));
    }
}

