/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.h2.bnf.Bnf;
import org.h2.constant.SysProperties;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.DbException;
import org.h2.security.SHA256;
import org.h2.server.web.ConnectionInfo;
import org.h2.server.web.DbColumn;
import org.h2.server.web.DbContents;
import org.h2.server.web.DbSchema;
import org.h2.server.web.DbTableOrView;
import org.h2.server.web.PageParser;
import org.h2.server.web.WebServer;
import org.h2.server.web.WebSession;
import org.h2.tools.Backup;
import org.h2.tools.ChangeFileEncryption;
import org.h2.tools.ConvertTraceFile;
import org.h2.tools.CreateCluster;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Recover;
import org.h2.tools.Restore;
import org.h2.tools.RunScript;
import org.h2.tools.Script;
import org.h2.tools.SimpleResultSet;
import org.h2.util.JdbcUtils;
import org.h2.util.New;
import org.h2.util.Profiler;
import org.h2.util.ScriptReader;
import org.h2.util.SortedProperties;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.Tool;
import org.h2.util.Utils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WebApp {
    protected WebServer server;
    protected WebSession session;
    protected Properties attributes;
    protected String mimeType;
    protected boolean cache;
    protected boolean stop;
    protected String headerLanguage;
    private Profiler a;

    WebApp(WebServer webServer) {
        this.server = webServer;
    }

    void setSession(WebSession webSession, Properties properties) {
        this.session = webSession;
        this.attributes = properties;
    }

    String processRequest(String string, String string2) {
        int n2 = string.lastIndexOf(46);
        String string3 = n2 >= 0 ? string.substring(n2 + 1) : "";
        if ("ico".equals(string3)) {
            this.mimeType = "image/x-icon";
            this.cache = true;
        } else if ("gif".equals(string3)) {
            this.mimeType = "image/gif";
            this.cache = true;
        } else if ("css".equals(string3)) {
            this.cache = true;
            this.mimeType = "text/css";
        } else if ("html".equals(string3) || "do".equals(string3) || "jsp".equals(string3)) {
            this.cache = false;
            this.mimeType = "text/html";
            if (this.session == null && !string.startsWith("transfer")) {
                this.session = this.server.createNewSession(string2);
                if (!"notAllowed.jsp".equals(string)) {
                    string = "index.do";
                }
            }
        } else if ("js".equals(string3)) {
            this.cache = true;
            this.mimeType = "text/javascript";
        } else {
            this.cache = true;
            this.mimeType = "application/octet-stream";
        }
        this.for("mimeType=" + this.mimeType);
        this.for(string);
        if (string.endsWith(".do")) {
            string = this.if(string);
        }
        return string;
    }

    private String a(String[] stringArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray) {
            stringBuilder.append("<option value=\"").append(PageParser.escapeHtmlData(string2)).append("\"");
            if (string2.equals(string)) {
                stringBuilder.append(" selected");
            }
            stringBuilder.append('>').append(PageParser.escapeHtml(string2)).append("</option>");
        }
        return stringBuilder.toString();
    }

    private String a(String[][] stringArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String[] stringArray2 : stringArray) {
            stringBuilder.append("<option value=\"").append(PageParser.escapeHtmlData(stringArray2[0])).append("\"");
            if (stringArray2[0].equals(string)) {
                stringBuilder.append(" selected");
            }
            stringBuilder.append('>').append(PageParser.escapeHtml(stringArray2[1])).append("</option>");
        }
        return stringBuilder.toString();
    }

    private String if(String string) {
        this.for("process " + string);
        while (string.endsWith(".do")) {
            if ("login.do".equals(string)) {
                string = this.try();
                continue;
            }
            if ("index.do".equals(string)) {
                string = this.c();
                continue;
            }
            if ("logout.do".equals(string)) {
                string = this.byte();
                continue;
            }
            if ("settingRemove.do".equals(string)) {
                string = this.case();
                continue;
            }
            if ("settingSave.do".equals(string)) {
                string = this.settingSave();
                continue;
            }
            if ("test.do".equals(string)) {
                string = this.do();
                continue;
            }
            if ("query.do".equals(string)) {
                string = this.void();
                continue;
            }
            if ("tables.do".equals(string)) {
                string = this.goto();
                continue;
            }
            if ("editResult.do".equals(string)) {
                string = this.int();
                continue;
            }
            if ("getHistory.do".equals(string)) {
                string = this.long();
                continue;
            }
            if ("admin.do".equals(string)) {
                string = this.else();
                continue;
            }
            if ("adminSave.do".equals(string)) {
                string = this.for();
                continue;
            }
            if ("adminStartTranslate.do".equals(string)) {
                string = this.b();
                continue;
            }
            if ("adminShutdown.do".equals(string)) {
                string = this.adminShutdown();
                continue;
            }
            if ("autoCompleteList.do".equals(string)) {
                string = this.a();
                continue;
            }
            if ("tools.do".equals(string)) {
                string = this.if();
                continue;
            }
            if ("transfer.do".equals(string)) {
                string = "transfer.jsp";
                continue;
            }
            string = "error.jsp";
        }
        this.for("return " + string);
        return string;
    }

    private String a() {
        String string = (String)this.attributes.get("query");
        boolean bl = false;
        if (string.trim().length() > 0 && Character.isLowerCase(string.trim().charAt(0))) {
            bl = true;
        }
        try {
            String string2;
            String string3 = string;
            if (string3.endsWith(";")) {
                string3 = string3 + " ";
            }
            ScriptReader scriptReader = new ScriptReader(new StringReader(string3));
            scriptReader.setSkipRemarks(true);
            String string4 = "";
            while ((string2 = scriptReader.readStatement()) != null) {
                string4 = string2;
            }
            string2 = "";
            if (scriptReader.isInsideRemark()) {
                string2 = scriptReader.isBlockRemark() ? "1#(End Remark)# */\n" + string2 : "1#(Newline)#\n" + string2;
            } else {
                char c2;
                Bnf bnf;
                string3 = string4;
                while (string3.length() > 0 && string3.charAt(0) <= ' ') {
                    string3 = string3.substring(1);
                }
                if (string3.trim().length() > 0 && Character.isLowerCase(string3.trim().charAt(0))) {
                    bl = true;
                }
                if ((bnf = this.session.getBnf()) == null) {
                    return "autoCompleteList.jsp";
                }
                HashMap hashMap = bnf.getNextTokenList(string3);
                String string5 = "";
                if (string3.length() > 0 && !Character.isWhitespace(c2 = string3.charAt(string3.length() - 1)) && c2 != '.' && c2 >= ' ' && c2 != '\'' && c2 != '\"') {
                    string5 = " ";
                }
                ArrayList arrayList = New.arrayList(hashMap.size());
                for (Map.Entry object : hashMap.entrySet()) {
                    String string6 = (String)object.getKey();
                    String string7 = (String)object.getValue();
                    String string8 = "" + string6.charAt(0);
                    if (Character.isLetter((string6 = string6.substring(2)).charAt(0)) && bl) {
                        string6 = StringUtils.toLowerEnglish(string6);
                        string7 = StringUtils.toLowerEnglish(string7);
                    }
                    if (string6.equals(string7) && !".".equals(string7)) {
                        string7 = string5 + string7;
                    }
                    string6 = StringUtils.urlEncode(string6);
                    string6 = StringUtils.replaceAll(string6, "+", " ");
                    string7 = StringUtils.urlEncode(string7);
                    string7 = StringUtils.replaceAll(string7, "+", " ");
                    arrayList.add(string8 + "#" + string6 + "#" + string7);
                }
                Collections.sort(arrayList);
                if (string.endsWith("\n") || string.trim().endsWith(";")) {
                    arrayList.add(0, "1#(Newline)#\n");
                }
                StatementBuilder statementBuilder = new StatementBuilder();
                for (String string6 : arrayList) {
                    statementBuilder.appendExceptFirst("|");
                    statementBuilder.append(string6);
                }
                string2 = statementBuilder.toString();
            }
            this.session.put("autoCompleteList", string2);
        }
        catch (Throwable throwable) {
            this.server.traceError(throwable);
        }
        return "autoCompleteList.jsp";
    }

    private String else() {
        this.session.put("port", "" + this.server.getPort());
        this.session.put("allowOthers", "" + this.server.getAllowOthers());
        this.session.put("ssl", String.valueOf(this.server.getSSL()));
        this.session.put("sessions", this.server.getSessions());
        return "admin.jsp";
    }

    private String for() {
        try {
            SortedProperties sortedProperties = new SortedProperties();
            int n2 = Integer.decode((String)this.attributes.get("port"));
            sortedProperties.setProperty("webPort", String.valueOf(n2));
            this.server.setPort(n2);
            boolean bl = Boolean.valueOf((String)this.attributes.get("allowOthers"));
            sortedProperties.setProperty("webAllowOthers", String.valueOf(bl));
            this.server.setAllowOthers(bl);
            boolean bl2 = Boolean.valueOf((String)this.attributes.get("ssl"));
            sortedProperties.setProperty("webSSL", String.valueOf(bl2));
            this.server.setSSL(bl2);
            this.server.saveProperties(sortedProperties);
        }
        catch (Exception exception) {
            this.for(exception.toString());
        }
        return this.else();
    }

    private String if() {
        try {
            String string = (String)this.attributes.get("tool");
            this.session.put("tool", string);
            String string2 = (String)this.attributes.get("args");
            String[] stringArray = StringUtils.arraySplit(string2, ',', false);
            Tool tool = null;
            if ("Backup".equals(string)) {
                tool = new Backup();
            } else if ("Restore".equals(string)) {
                tool = new Restore();
            } else if ("Recover".equals(string)) {
                tool = new Recover();
            } else if ("DeleteDbFiles".equals(string)) {
                tool = new DeleteDbFiles();
            } else if ("ChangeFileEncryption".equals(string)) {
                tool = new ChangeFileEncryption();
            } else if ("Script".equals(string)) {
                tool = new Script();
            } else if ("RunScript".equals(string)) {
                tool = new RunScript();
            } else if ("ConvertTraceFile".equals(string)) {
                tool = new ConvertTraceFile();
            } else if ("CreateCluster".equals(string)) {
                tool = new CreateCluster();
            } else {
                throw DbException.throwInternalError(string);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream((OutputStream)byteArrayOutputStream, false, "UTF-8");
            tool.setOut(printStream);
            try {
                tool.runTool(stringArray);
                printStream.flush();
                String string3 = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
                String string4 = PageParser.escapeHtml(string3);
                this.session.put("toolResult", string4);
            }
            catch (Exception exception) {
                this.session.put("toolResult", this.a(0, exception, true));
            }
        }
        catch (Exception exception) {
            this.server.traceError(exception);
        }
        return "tools.jsp";
    }

    private String b() {
        Map map = (Map)this.session.map.get("text");
        String string = this.server.startTranslate(map);
        this.session.put("translationFile", string);
        return "helpTranslate.jsp";
    }

    protected String adminShutdown() {
        this.server.shutdown();
        return "admin.jsp";
    }

    private String c() {
        String[][] stringArray = this.server.getLanguageArray();
        String string = (String)this.attributes.get("language");
        Locale locale = this.session.locale;
        if (string != null) {
            if (locale == null || !StringUtils.toLowerEnglish(locale.getLanguage()).equals(string)) {
                locale = new Locale(string, "");
                this.server.readTranslations(this.session, locale.getLanguage());
                this.session.put("language", string);
                this.session.locale = locale;
            }
        } else {
            string = (String)this.session.get("language");
        }
        if (string == null) {
            string = this.headerLanguage;
        }
        this.session.put("languageCombo", this.a(stringArray, string));
        String[] stringArray2 = this.server.getSettingNames();
        String string2 = this.attributes.getProperty("setting");
        if (string2 == null && stringArray2.length > 0) {
            string2 = stringArray2[0];
        }
        String string3 = this.a(stringArray2, string2);
        this.session.put("settingsList", string3);
        ConnectionInfo connectionInfo = this.server.getSetting(string2);
        if (connectionInfo == null) {
            connectionInfo = new ConnectionInfo();
        }
        this.session.put("setting", PageParser.escapeHtmlData(string2));
        this.session.put("name", PageParser.escapeHtmlData(string2));
        this.session.put("driver", PageParser.escapeHtmlData(connectionInfo.driver));
        this.session.put("url", PageParser.escapeHtmlData(connectionInfo.url));
        this.session.put("user", PageParser.escapeHtmlData(connectionInfo.user));
        return "index.jsp";
    }

    private String long() {
        int n2 = Integer.parseInt(this.attributes.getProperty("id"));
        String string = this.session.getCommand(n2);
        this.session.put("query", PageParser.escapeHtmlData(string));
        return "query.jsp";
    }

    private int a(boolean bl, DbTableOrView dbTableOrView, StringBuilder stringBuilder, int n2, boolean bl2, StringBuilder stringBuilder2) {
        DbColumn[] dbColumnArray = dbTableOrView.columns;
        for (int i2 = 0; dbColumnArray != null && i2 < dbColumnArray.length; ++i2) {
            DbColumn dbColumn = dbColumnArray[i2];
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append(' ');
            }
            stringBuilder2.append(dbColumn.name);
            String string = StringUtils.urlEncode(PageParser.escapeJavaScript(dbColumn.name));
            String string2 = bl ? ", 1, 1" : ", 2, 2";
            stringBuilder.append("setNode(" + n2 + string2 + ", 'column', '" + PageParser.escapeJavaScript(dbColumn.name) + "', 'javascript:ins(\\'" + string + "\\')');\n");
            ++n2;
            if (!bl || !bl2) continue;
            stringBuilder.append("setNode(" + n2 + ", 2, 2, 'type', '" + PageParser.escapeJavaScript(dbColumn.dataType) + "', null);\n");
            ++n2;
        }
        return n2;
    }

    private int a(boolean bl, DatabaseMetaData databaseMetaData, String string, String string2, StringBuilder stringBuilder, int n2) throws SQLException {
        Object object;
        String string3;
        ResultSet resultSet = databaseMetaData.getIndexInfo(null, string2, string, false, true);
        HashMap hashMap = New.hashMap();
        while (resultSet.next()) {
            string3 = resultSet.getString("INDEX_NAME");
            object = (IndexInfo)hashMap.get(string3);
            if (object == null) {
                int n3 = resultSet.getInt("TYPE");
                Object object2 = n3 == 1 ? "" : (n3 == 2 ? " (${text.tree.hashed})" : (n3 == 3 ? "" : null));
                if (string3 == null || object2 == null) continue;
                object = new IndexInfo();
                ((IndexInfo)object).name = string3;
                ((IndexInfo)object).type = object2 = (resultSet.getBoolean("NON_UNIQUE") ? "${text.tree.nonUnique}" : "${text.tree.unique}") + (String)object2;
                ((IndexInfo)object).columns = resultSet.getString("COLUMN_NAME");
                hashMap.put(string3, object);
                continue;
            }
            ((IndexInfo)object).columns = ((IndexInfo)object).columns + ", " + resultSet.getString("COLUMN_NAME");
        }
        resultSet.close();
        if (hashMap.size() > 0) {
            string3 = bl ? ", 1, 1" : ", 2, 1";
            object = bl ? ", 2, 1" : ", 3, 1";
            String string4 = bl ? ", 3, 2" : ", 4, 2";
            stringBuilder.append("setNode(" + n2 + string3 + ", 'index_az', '${text.tree.indexes}', null);\n");
            ++n2;
            for (IndexInfo indexInfo : hashMap.values()) {
                stringBuilder.append("setNode(" + n2 + (String)object + ", 'index', '" + PageParser.escapeJavaScript(indexInfo.name) + "', null);\n");
                stringBuilder.append("setNode(" + ++n2 + string4 + ", 'type', '" + indexInfo.type + "', null);\n");
                stringBuilder.append("setNode(" + ++n2 + string4 + ", 'type', '" + PageParser.escapeJavaScript(indexInfo.columns) + "', null);\n");
                ++n2;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int a(DbSchema dbSchema, boolean bl, StringBuilder stringBuilder, int n2) throws SQLException {
        StringBuilder stringBuilder2;
        String string;
        int n3;
        if (dbSchema == null) {
            return n2;
        }
        Connection connection = this.session.getConnection();
        DatabaseMetaData databaseMetaData = this.session.getMetaData();
        int n4 = bl ? 0 : 1;
        boolean bl2 = bl || !dbSchema.isSystem;
        String string2 = ", " + n4 + ", " + (bl2 ? "1" : "2") + ", ";
        String string3 = ", " + (n4 + 1) + ", 2, ";
        DbTableOrView[] dbTableOrViewArray = dbSchema.tables;
        if (dbTableOrViewArray == null) {
            return n2;
        }
        boolean bl3 = dbSchema.contents.isOracle;
        boolean bl4 = dbTableOrViewArray.length < 100;
        for (DbTableOrView dbTableOrView : dbTableOrViewArray) {
            if (dbTableOrView.isView) continue;
            n3 = n2;
            string = dbTableOrView.quotedName;
            if (!bl) {
                string = dbSchema.quotedName + "." + string;
            }
            string = StringUtils.urlEncode(PageParser.escapeJavaScript(string));
            stringBuilder.append("setNode(" + n2 + string2 + " 'table', '" + PageParser.escapeJavaScript(dbTableOrView.name) + "', 'javascript:ins(\\'" + string + "\\',true)');\n");
            ++n2;
            if (!bl && !bl2) continue;
            stringBuilder2 = new StringBuilder();
            n2 = this.a(bl, dbTableOrView, stringBuilder, n2, bl4, stringBuilder2);
            if (!bl3 && bl4) {
                n2 = this.a(bl, databaseMetaData, dbTableOrView.name, dbSchema.name, stringBuilder, n2);
            }
            stringBuilder.append("addTable('" + PageParser.escapeJavaScript(dbTableOrView.name) + "', '" + PageParser.escapeJavaScript(stringBuilder2.toString()) + "', " + n3 + ");\n");
        }
        for (DbTableOrView dbTableOrView : dbTableOrViewArray = dbSchema.tables) {
            if (!dbTableOrView.isView) continue;
            n3 = n2;
            string = dbTableOrView.quotedName;
            if (!bl) {
                string = dbTableOrView.schema.quotedName + "." + string;
            }
            string = StringUtils.urlEncode(PageParser.escapeJavaScript(string));
            stringBuilder.append("setNode(" + n2 + string2 + " 'view', '" + PageParser.escapeJavaScript(dbTableOrView.name) + "', 'javascript:ins(\\'" + string + "\\',true)');\n");
            ++n2;
            if (!bl) continue;
            stringBuilder2 = new StringBuilder();
            n2 = this.a(bl, dbTableOrView, stringBuilder, n2, bl4, stringBuilder2);
            if (dbSchema.contents.isH2) {
                PreparedStatement preparedStatement = null;
                try {
                    preparedStatement = connection.prepareStatement("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME=?");
                    preparedStatement.setString(1, dbTableOrView.name);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        String string4 = resultSet.getString("SQL");
                        stringBuilder.append("setNode(" + n2 + string3 + " 'type', '" + PageParser.escapeJavaScript(string4) + "', null);\n");
                        ++n2;
                    }
                    resultSet.close();
                }
                finally {
                    JdbcUtils.closeSilently(preparedStatement);
                }
            }
            stringBuilder.append("addTable('" + PageParser.escapeJavaScript(dbTableOrView.name) + "', '" + PageParser.escapeJavaScript(stringBuilder2.toString()) + "', " + n3 + ");\n");
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String goto() {
        DbContents dbContents = this.session.getContents();
        boolean bl = false;
        try {
            Object object;
            dbContents.readContents(this.session.getMetaData());
            this.session.loadBnf();
            Connection connection = this.session.getConnection();
            DatabaseMetaData databaseMetaData = this.session.getMetaData();
            bl = dbContents.isH2;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("setNode(0, 0, 0, 'database', '" + PageParser.escapeJavaScript((String)this.session.get("url")) + "', null);\n");
            int n2 = 1;
            DbSchema dbSchema = dbContents.defaultSchema;
            n2 = this.a(dbSchema, true, stringBuilder, n2);
            DbSchema[] dbSchemaArray = dbContents.schemas;
            for (DbSchema object2 : dbSchemaArray) {
                if (object2 == dbSchema || object2 == null) continue;
                stringBuilder.append("setNode(" + n2 + ", 0, 1, 'folder', '" + PageParser.escapeJavaScript(object2.name) + "', null);\n");
                ++n2;
                n2 = this.a(object2, false, stringBuilder, n2);
            }
            if (bl) {
                object = null;
                try {
                    String string;
                    object = connection.createStatement();
                    ResultSet resultSet = object.executeQuery("SELECT * FROM INFORMATION_SCHEMA.SEQUENCES ORDER BY SEQUENCE_NAME");
                    int n3 = 0;
                    while (resultSet.next()) {
                        if (n3 == 0) {
                            stringBuilder.append("setNode(" + n2 + ", 0, 1, 'sequences', '${text.tree.sequences}', null);\n");
                            ++n2;
                        }
                        String string2 = resultSet.getString("SEQUENCE_NAME");
                        string = resultSet.getString("CURRENT_VALUE");
                        String string3 = resultSet.getString("INCREMENT");
                        stringBuilder.append("setNode(" + n2 + ", 1, 1, 'sequence', '" + PageParser.escapeJavaScript(string2) + "', null);\n");
                        stringBuilder.append("setNode(" + ++n2 + ", 2, 2, 'type', '${text.tree.current}: " + PageParser.escapeJavaScript(string) + "', null);\n");
                        ++n2;
                        if (!"1".equals(string3)) {
                            stringBuilder.append("setNode(" + n2 + ", 2, 2, 'type', '${text.tree.increment}: " + PageParser.escapeJavaScript(string3) + "', null);\n");
                            ++n2;
                        }
                        ++n3;
                    }
                    resultSet.close();
                    resultSet = object.executeQuery("SELECT * FROM INFORMATION_SCHEMA.USERS ORDER BY NAME");
                    n3 = 0;
                    while (resultSet.next()) {
                        if (n3 == 0) {
                            stringBuilder.append("setNode(" + n2 + ", 0, 1, 'users', '${text.tree.users}', null);\n");
                            ++n2;
                        }
                        String string4 = resultSet.getString("NAME");
                        string = resultSet.getString("ADMIN");
                        stringBuilder.append("setNode(" + n2 + ", 1, 1, 'user', '" + PageParser.escapeJavaScript(string4) + "', null);\n");
                        ++n2;
                        if (string.equalsIgnoreCase("TRUE")) {
                            stringBuilder.append("setNode(" + n2 + ", 2, 2, 'type', '${text.tree.admin}', null);\n");
                            ++n2;
                        }
                        ++n3;
                    }
                    resultSet.close();
                }
                finally {
                    JdbcUtils.closeSilently((Statement)object);
                }
            }
            object = databaseMetaData.getDatabaseProductName() + " " + databaseMetaData.getDatabaseProductVersion();
            stringBuilder.append("setNode(" + n2 + ", 0, 0, 'info', '" + PageParser.escapeJavaScript((String)object) + "', null);\n");
            stringBuilder.append("refreshQueryTables();");
            this.session.put("tree", stringBuilder.toString());
        }
        catch (Exception exception) {
            this.session.put("tree", "");
            this.session.put("error", this.a(0, exception, bl));
        }
        return "tables.jsp";
    }

    private String a(int n2, Throwable throwable, boolean bl) {
        try {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            String string = stringWriter.toString();
            string = PageParser.escapeHtml(string);
            if (bl) {
                string = this.a(string);
            }
            string = StringUtils.replaceAll(string, "\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
            String string2 = PageParser.escapeHtml(throwable.getMessage());
            String string3 = "<a class=\"error\" href=\"#\" onclick=\"var x=document.getElementById('st" + n2 + "').style;x.display=x.display==''?'none':'';\">" + string2 + "</a>";
            if (throwable instanceof SQLException) {
                SQLException sQLException = (SQLException)throwable;
                string3 = string3 + " " + sQLException.getSQLState() + "/" + sQLException.getErrorCode();
                if (bl) {
                    int n3 = sQLException.getErrorCode();
                    string3 = string3 + " <a href=\"http://h2database.com/javadoc/org/h2/constant/ErrorCode.html#c" + n3 + "\">(${text.a.help})</a>";
                }
            }
            string3 = string3 + "<span style=\"display: none;\" id=\"st" + n2 + "\"><br />" + string + "</span>";
            string3 = this.do(string3);
            return string3;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.server.traceError(throwable);
            return throwable.toString();
        }
    }

    private String a(String string) {
        try {
            StringBuilder stringBuilder = new StringBuilder(string.length());
            int n2 = string.indexOf("<br />");
            stringBuilder.append(string.substring(0, n2));
            while (true) {
                int n3;
                if ((n3 = string.indexOf("org.h2.", n2)) < 0) {
                    stringBuilder.append(string.substring(n2));
                    break;
                }
                stringBuilder.append(string.substring(n2, n3));
                int n4 = string.indexOf(41, n3);
                if (n4 < 0) {
                    stringBuilder.append(string.substring(n2));
                    break;
                }
                String string2 = string.substring(n3, n4);
                int n5 = string2.lastIndexOf(40);
                int n6 = string2.lastIndexOf(46, n5 - 1);
                int n7 = string2.lastIndexOf(46, n6 - 1);
                String string3 = string2.substring(0, n7);
                int n8 = string2.lastIndexOf(58);
                String string4 = string2.substring(n5 + 1, n8);
                String string5 = string2.substring(n8 + 1, string2.length());
                String string6 = string3.replace('.', '/') + "/" + string4;
                stringBuilder.append("<a href=\"http://h2database.com/html/source.html?file=");
                stringBuilder.append(string6);
                stringBuilder.append("&line=");
                stringBuilder.append(string5);
                stringBuilder.append("&build=");
                stringBuilder.append(147);
                stringBuilder.append("\">");
                stringBuilder.append(string2);
                stringBuilder.append("</a>");
                n2 = n4;
            }
            return stringBuilder.toString();
        }
        catch (Throwable throwable) {
            return string;
        }
    }

    private String do(String string) {
        return "<div class=\"error\">" + string + "</div>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String do() {
        String string = this.attributes.getProperty("driver", "");
        String string2 = this.attributes.getProperty("url", "");
        String string3 = this.attributes.getProperty("user", "");
        String string4 = this.attributes.getProperty("password", "");
        this.session.put("driver", string);
        this.session.put("url", string2);
        this.session.put("user", string3);
        boolean bl = string2.startsWith("jdbc:h2:");
        try {
            Connection connection;
            long l2 = System.currentTimeMillis();
            String string5 = "";
            String string6 = "";
            Profiler profiler = new Profiler();
            profiler.startCollecting();
            try {
                connection = this.server.getConnection(string, string2, string3, string4);
            }
            finally {
                profiler.stopCollecting();
                string5 = profiler.getTop(3);
            }
            profiler = new Profiler();
            profiler.startCollecting();
            try {
                JdbcUtils.closeSilently(connection);
            }
            finally {
                profiler.stopCollecting();
                string6 = profiler.getTop(3);
            }
            long l3 = System.currentTimeMillis() - l2;
            String string7 = l3 > 1000L ? "<a class=\"error\" href=\"#\" onclick=\"var x=document.getElementById('prof').style;x.display=x.display==''?'none':'';\">${text.login.testSuccessful}</a><span style=\"display: none;\" id=\"prof\"><br />" + PageParser.escapeHtml(string5) + "<br />" + PageParser.escapeHtml(string6) + "</span>" : "${text.login.testSuccessful}";
            this.session.put("error", string7);
            return "login.jsp";
        }
        catch (Exception exception) {
            this.session.put("error", this.getLoginError(exception, bl));
            return "login.jsp";
        }
    }

    String getLoginError(Exception exception, boolean bl) {
        if (exception instanceof JdbcSQLException && ((JdbcSQLException)exception).getErrorCode() == 90086) {
            return "${text.login.driverNotFound}<br />" + this.a(0, exception, bl);
        }
        return this.a(0, exception, bl);
    }

    private String try() {
        String string = this.attributes.getProperty("driver", "");
        String string2 = this.attributes.getProperty("url", "");
        String string3 = this.attributes.getProperty("user", "");
        String string4 = this.attributes.getProperty("password", "");
        this.session.put("autoCommit", "checked");
        this.session.put("autoComplete", "1");
        this.session.put("maxrows", "1000");
        if (this.loginAsync(string, string2, string3, string4)) {
            return "";
        }
        boolean bl = string2.startsWith("jdbc:h2:");
        try {
            Connection connection = this.server.getConnection(string, string2, string3, string4);
            this.session.setConnection(connection);
            this.session.put("url", string2);
            this.session.put("user", string3);
            this.session.remove("error");
            this.settingSave();
            return "frame.jsp";
        }
        catch (Exception exception) {
            this.session.put("error", this.getLoginError(exception, bl));
            return "login.jsp";
        }
    }

    protected boolean loginAsync(String string, String string2, String string3, String string4) {
        return false;
    }

    private String byte() {
        try {
            Connection connection = this.session.getConnection();
            this.session.setConnection(null);
            this.session.remove("conn");
            this.session.remove("result");
            this.session.remove("tables");
            this.session.remove("user");
            this.session.remove("tool");
            if (connection != null) {
                if (this.session.getShutdownServerOnDisconnect()) {
                    this.server.shutdown();
                } else {
                    connection.close();
                }
            }
        }
        catch (Exception exception) {
            this.for(exception.toString());
        }
        return "index.do";
    }

    private String void() {
        String string = this.attributes.getProperty("sql").trim();
        try {
            Object object;
            ScriptReader scriptReader = new ScriptReader(new StringReader(string));
            final ArrayList arrayList = New.arrayList();
            while ((object = scriptReader.readStatement()) != null) {
                arrayList.add(object);
            }
            object = this.session.getConnection();
            if (SysProperties.CONSOLE_STREAM && this.server.getAllowChunked()) {
                String string2 = StringUtils.utf8Decode(this.server.getFile("result.jsp"));
                int n2 = string2.indexOf("${result}");
                arrayList.add(0, string2.substring(0, n2));
                arrayList.add(string2.substring(n2 + "${result}".length()));
                this.session.put("chunks", new Iterator((Connection)object){
                    private int a;
                    final /* synthetic */ Connection val$conn;
                    {
                        this.val$conn = connection;
                    }

                    public boolean hasNext() {
                        return this.a < arrayList.size();
                    }

                    public String next() {
                        String string = (String)arrayList.get(this.a++);
                        if (this.a == 1 || this.a == arrayList.size()) {
                            return string;
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        WebApp.this.query(this.val$conn, string, this.a - 1, arrayList.size() - 2, stringBuilder);
                        return stringBuilder.toString();
                    }

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                });
                return "result.jsp";
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                String string3 = (String)arrayList.get(i2);
                this.query((Connection)object, string3, i2, arrayList.size(), stringBuilder);
            }
            String string4 = stringBuilder.toString();
            this.session.put("result", string4);
        }
        catch (Throwable throwable) {
            this.session.put("result", this.a(0, throwable, this.session.getContents().isH2));
        }
        return "result.jsp";
    }

    protected void query(Connection connection, String string, int n2, int n3, StringBuilder stringBuilder) {
        if (!string.startsWith("@") || !string.endsWith(".")) {
            stringBuilder.append(PageParser.escapeHtml(string + ";")).append("<br />");
        }
        boolean bl = string.startsWith("@edit");
        stringBuilder.append(this.a(connection, n2 + 1, string, n3 == 1, bl)).append("<br />");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String int() {
        String string;
        String string2;
        block11: {
            ResultSet resultSet = this.session.result;
            int n2 = Integer.parseInt(this.attributes.getProperty("row"));
            int n3 = Integer.parseInt(this.attributes.getProperty("op"));
            string2 = "";
            string = "";
            try {
                if (n3 == 1) {
                    boolean bl;
                    boolean bl2 = bl = n2 < 0;
                    if (bl) {
                        resultSet.moveToInsertRow();
                    } else {
                        resultSet.absolute(n2);
                    }
                    for (int i2 = 0; i2 < resultSet.getMetaData().getColumnCount(); ++i2) {
                        String string3 = this.attributes.getProperty("r" + n2 + "c" + (i2 + 1));
                        this.a(string3, resultSet, i2 + 1);
                    }
                    if (bl) {
                        resultSet.insertRow();
                        break block11;
                    } else {
                        resultSet.updateRow();
                    }
                    break block11;
                }
                if (n3 == 2) {
                    resultSet.absolute(n2);
                    resultSet.deleteRow();
                } else if (n3 != 3) {
                    // empty if block
                }
            }
            catch (Throwable throwable) {
                string2 = "<br />" + this.a(0, throwable, this.session.getContents().isH2);
                string = this.do(throwable.getMessage());
            }
        }
        String string4 = "@edit " + (String)this.session.get("resultSetSQL");
        Connection connection = this.session.getConnection();
        string2 = string + this.a(connection, -1, string4, true, true) + string2;
        this.session.put("result", string2);
        return "result.jsp";
    }

    private ResultSet a(Connection connection, String string) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        if (this.a(string, "@best_row_identifier")) {
            String[] stringArray = this.int(string);
            int n2 = stringArray[4] == null ? 0 : Integer.parseInt(stringArray[4]);
            boolean bl = stringArray[5] == null ? false : Boolean.valueOf(stringArray[5]);
            return databaseMetaData.getBestRowIdentifier(stringArray[1], stringArray[2], stringArray[3], n2, bl);
        }
        if (this.a(string, "@catalogs")) {
            return databaseMetaData.getCatalogs();
        }
        if (this.a(string, "@columns")) {
            String[] stringArray = this.int(string);
            return databaseMetaData.getColumns(stringArray[1], stringArray[2], stringArray[3], stringArray[4]);
        }
        if (this.a(string, "@column_privileges")) {
            String[] stringArray = this.int(string);
            return databaseMetaData.getColumnPrivileges(stringArray[1], stringArray[2], stringArray[3], stringArray[4]);
        }
        if (this.a(string, "@cross_references")) {
            String[] stringArray = this.int(string);
            return databaseMetaData.getCrossReference(stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], stringArray[6]);
        }
        if (this.a(string, "@exported_keys")) {
            String[] stringArray = this.int(string);
            return databaseMetaData.getExportedKeys(stringArray[1], stringArray[2], stringArray[3]);
        }
        if (this.a(string, "@imported_keys")) {
            String[] stringArray = this.int(string);
            return databaseMetaData.getImportedKeys(stringArray[1], stringArray[2], stringArray[3]);
        }
        if (this.a(string, "@index_info")) {
            String[] stringArray = this.int(string);
            boolean bl = stringArray[4] == null ? false : Boolean.valueOf(stringArray[4]);
            boolean bl2 = stringArray[5] == null ? false : Boolean.valueOf(stringArray[5]);
            return databaseMetaData.getIndexInfo(stringArray[1], stringArray[2], stringArray[3], bl, bl2);
        }
        if (this.a(string, "@primary_keys")) {
            String[] stringArray = this.int(string);
            return databaseMetaData.getPrimaryKeys(stringArray[1], stringArray[2], stringArray[3]);
        }
        if (this.a(string, "@procedures")) {
            String[] stringArray = this.int(string);
            return databaseMetaData.getProcedures(stringArray[1], stringArray[2], stringArray[3]);
        }
        if (this.a(string, "@procedure_columns")) {
            String[] stringArray = this.int(string);
            return databaseMetaData.getProcedureColumns(stringArray[1], stringArray[2], stringArray[3], stringArray[4]);
        }
        if (this.a(string, "@schemas")) {
            return databaseMetaData.getSchemas();
        }
        if (this.a(string, "@tables")) {
            String[] stringArray = this.int(string);
            String[] stringArray2 = stringArray[4] == null ? null : StringUtils.arraySplit(stringArray[4], ',', false);
            return databaseMetaData.getTables(stringArray[1], stringArray[2], stringArray[3], stringArray2);
        }
        if (this.a(string, "@table_privileges")) {
            String[] stringArray = this.int(string);
            return databaseMetaData.getTablePrivileges(stringArray[1], stringArray[2], stringArray[3]);
        }
        if (this.a(string, "@table_types")) {
            return databaseMetaData.getTableTypes();
        }
        if (this.a(string, "@type_info")) {
            return databaseMetaData.getTypeInfo();
        }
        if (this.a(string, "@udts")) {
            int[] nArray;
            String[] stringArray = this.int(string);
            if (stringArray[4] == null) {
                nArray = null;
            } else {
                String[] stringArray3 = StringUtils.arraySplit(stringArray[4], ',', false);
                nArray = new int[stringArray3.length];
                for (int i2 = 0; i2 < stringArray3.length; ++i2) {
                    nArray[i2] = Integer.parseInt(stringArray3[i2]);
                }
            }
            return databaseMetaData.getUDTs(stringArray[1], stringArray[2], stringArray[3], nArray);
        }
        if (this.a(string, "@version_columns")) {
            String[] stringArray = this.int(string);
            return databaseMetaData.getVersionColumns(stringArray[1], stringArray[2], stringArray[3]);
        }
        if (this.a(string, "@memory")) {
            SimpleResultSet simpleResultSet = new SimpleResultSet();
            simpleResultSet.addColumn("Type", 12, 0, 0);
            simpleResultSet.addColumn("KB", 12, 0, 0);
            simpleResultSet.addRow("Used Memory", "" + Utils.getMemoryUsed());
            simpleResultSet.addRow("Free Memory", "" + Utils.getMemoryFree());
            return simpleResultSet;
        }
        if (this.a(string, "@info")) {
            String string2;
            SimpleResultSet simpleResultSet = new SimpleResultSet();
            simpleResultSet.addColumn("KEY", 12, 0, 0);
            simpleResultSet.addColumn("VALUE", 12, 0, 0);
            simpleResultSet.addRow("conn.getCatalog", connection.getCatalog());
            simpleResultSet.addRow("conn.getAutoCommit", "" + connection.getAutoCommit());
            simpleResultSet.addRow("conn.getTransactionIsolation", "" + connection.getTransactionIsolation());
            simpleResultSet.addRow("conn.getWarnings", "" + connection.getWarnings());
            try {
                string2 = "" + connection.getTypeMap();
            }
            catch (SQLException sQLException) {
                string2 = sQLException.toString();
            }
            simpleResultSet.addRow("conn.getTypeMap", "" + string2);
            simpleResultSet.addRow("conn.isReadOnly", "" + connection.isReadOnly());
            simpleResultSet.addRow("conn.getHoldability", "" + connection.getHoldability());
            this.a(simpleResultSet, databaseMetaData);
            return simpleResultSet;
        }
        if (this.a(string, "@attributes")) {
            String[] stringArray = this.int(string);
            return databaseMetaData.getAttributes(stringArray[1], stringArray[2], stringArray[3], stringArray[4]);
        }
        if (this.a(string, "@super_tables")) {
            String[] stringArray = this.int(string);
            return databaseMetaData.getSuperTables(stringArray[1], stringArray[2], stringArray[3]);
        }
        if (this.a(string, "@super_types")) {
            String[] stringArray = this.int(string);
            return databaseMetaData.getSuperTypes(stringArray[1], stringArray[2], stringArray[3]);
        }
        if (this.a(string, "@prof_stop") && this.a != null) {
            this.a.stopCollecting();
            SimpleResultSet simpleResultSet = new SimpleResultSet();
            simpleResultSet.addColumn("Top Stack Trace(s)", 12, 0, 0);
            simpleResultSet.addRow(this.a.getTop(3));
            this.a = null;
            return simpleResultSet;
        }
        return null;
    }

    private void a(SimpleResultSet simpleResultSet, DatabaseMetaData databaseMetaData) {
        Method[] methodArray = DatabaseMetaData.class.getDeclaredMethods();
        Arrays.sort(methodArray, new Comparator(){

            public int compare(Method method, Method method2) {
                return method.toString().compareTo(method2.toString());
            }
        });
        for (Method method : methodArray) {
            if (method.getParameterTypes().length != 0) continue;
            try {
                Object object = method.invoke((Object)databaseMetaData, new Object[0]);
                simpleResultSet.addRow("meta." + method.getName(), "" + object);
            }
            catch (InvocationTargetException invocationTargetException) {
                simpleResultSet.addRow("meta." + method.getName(), invocationTargetException.getTargetException().toString());
            }
            catch (Exception exception) {
                simpleResultSet.addRow("meta." + method.getName(), exception.toString());
            }
        }
    }

    private String[] int(String string) {
        String[] stringArray = new String[10];
        String[] stringArray2 = StringUtils.arraySplit(string, ' ', true);
        System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!"null".equals(stringArray[i2])) continue;
            stringArray[i2] = null;
        }
        return stringArray;
    }

    private int char() {
        String string = (String)this.session.get("maxrows");
        int n2 = string == null ? 0 : Integer.parseInt(string);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String a(Connection connection, int n2, String string, boolean bl, boolean bl2) {
        String string2;
        try {
            ResultSet resultSet;
            int n3;
            String string3;
            Object object;
            string = string.trim();
            StringBuilder stringBuilder = new StringBuilder();
            string2 = StringUtils.toUpperEnglish(string);
            if (string2.indexOf("CREATE") >= 0 || string2.indexOf("DROP") >= 0 || string2.indexOf("ALTER") >= 0 || string2.indexOf("RUNSCRIPT") >= 0) {
                object = this.attributes.getProperty("jsessionid");
                stringBuilder.append("<script type=\"text/javascript\">top['h2menu'].location='tables.do?jsessionid=" + (String)object + "';</script>");
            }
            DbContents dbContents = this.session.getContents();
            object = bl2 || bl && dbContents.isH2 ? connection.createStatement(1004, 1008) : connection.createStatement();
            long l2 = System.currentTimeMillis();
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            if (this.a(string, "@autocommit_true")) {
                connection.setAutoCommit(true);
                String string4 = "${text.result.autoCommitOn}";
                return string4;
            }
            if (this.a(string, "@autocommit_false")) {
                connection.setAutoCommit(false);
                String string5 = "${text.result.autoCommitOff}";
                return string5;
            }
            if (this.a(string, "@cancel")) {
                object = this.session.executingStatement;
                if (object != null) {
                    object.cancel();
                    stringBuilder.append("${text.result.statementWasCanceled}");
                } else {
                    stringBuilder.append("${text.result.noRunningStatement}");
                }
                String string6 = stringBuilder.toString();
                return string6;
            }
            if (this.a(string, "@edit")) {
                bl5 = true;
                string = string.substring("@edit".length()).trim();
                this.session.put("resultSetSQL", string);
            } else if (this.a(string, "@generated")) {
                bl4 = true;
                string = string.substring("@generated".length()).trim();
            } else {
                if (this.a(string, "@history")) {
                    stringBuilder.append(this.new());
                    String string7 = stringBuilder.toString();
                    return string7;
                }
                if (this.a(string, "@list")) {
                    bl6 = true;
                    string = string.substring("@list".length()).trim();
                } else {
                    if (this.a(string, "@loop")) {
                        string = string.substring("@loop".length()).trim();
                        int n4 = string.indexOf(32);
                        int n5 = Integer.decode(string.substring(0, n4));
                        string = string.substring(n4).trim();
                        String string8 = this.a(connection, n5, string);
                        return string8;
                    }
                    if (this.a(string, "@maxrows")) {
                        int n6 = (int)Double.parseDouble(string.substring("@maxrows".length()).trim());
                        this.session.put("maxrows", "" + n6);
                        String string9 = "${text.result.maxrowsSet}";
                        return string9;
                    }
                    if (this.a(string, "@meta")) {
                        bl3 = true;
                        string = string.substring("@meta".length()).trim();
                    } else {
                        if (this.a(string, "@parameter_meta")) {
                            string = string.substring("@parameter_meta".length()).trim();
                            PreparedStatement preparedStatement = connection.prepareStatement(string);
                            stringBuilder.append(this.a(preparedStatement.getParameterMetaData()));
                            String string10 = stringBuilder.toString();
                            return string10;
                        }
                        if (this.a(string, "@password_hash")) {
                            string = string.substring("@password_hash".length()).trim();
                            String[] stringArray = this.int(string);
                            SHA256 sHA256 = new SHA256();
                            String string11 = StringUtils.convertBytesToString(sHA256.getKeyPasswordHash(stringArray[0], stringArray[1].toCharArray()));
                            return string11;
                        }
                        if (this.a(string, "@prof_start")) {
                            if (this.a != null) {
                                this.a.stopCollecting();
                            }
                            this.a = new Profiler();
                            this.a.startCollecting();
                            String string12 = "Ok";
                            return string12;
                        }
                        if (this.a(string, "@sleep")) {
                            String string13 = string.substring("@sleep".length()).trim();
                            int n7 = 1;
                            if (string13.length() > 0) {
                                n7 = Integer.parseInt(string13);
                            }
                            Thread.sleep(n7 * 1000);
                            String string14 = "Ok";
                            return string14;
                        }
                        if (this.a(string, "@transaction_isolation")) {
                            string3 = string.substring("@transaction_isolation".length()).trim();
                            if (string3.length() > 0) {
                                n3 = Integer.parseInt(string3);
                                connection.setTransactionIsolation(n3);
                            }
                            stringBuilder.append("Transaction Isolation: " + connection.getTransactionIsolation() + "<br />");
                            stringBuilder.append("1: read_uncommitted<br />");
                            stringBuilder.append("2: read_committed<br />");
                            stringBuilder.append("4: repeatable_read<br />");
                            stringBuilder.append("8: serializable");
                        }
                    }
                }
            }
            if (string.startsWith("@")) {
                resultSet = this.a(connection, string);
                if (resultSet == null) {
                    stringBuilder.append("?: " + string);
                    string3 = stringBuilder.toString();
                    return string3;
                }
            } else {
                int n8 = this.char();
                object.setMaxRows(n8);
                this.session.executingStatement = object;
                n3 = object.execute(string);
                this.session.addCommand(string);
                if (bl4) {
                    resultSet = null;
                    resultSet = object.getGeneratedKeys();
                } else {
                    if (n3 == 0) {
                        stringBuilder.append("${text.result.updateCount}: " + object.getUpdateCount());
                        l2 = System.currentTimeMillis() - l2;
                        stringBuilder.append("<br />(").append(l2).append(" ms)");
                        object.close();
                        String string15 = stringBuilder.toString();
                        return string15;
                    }
                    resultSet = object.getResultSet();
                }
            }
            l2 = System.currentTimeMillis() - l2;
            stringBuilder.append(this.a(string, resultSet, bl3, bl6, bl5, l2, bl));
            if (!bl5) {
                object.close();
            }
            String string16 = stringBuilder.toString();
            return string16;
        }
        catch (Throwable throwable) {
            string2 = this.a(n2, throwable, this.session.getContents().isH2);
            return string2;
        }
        finally {
            this.session.executingStatement = null;
        }
    }

    private boolean a(String string, String string2) {
        return StringUtils.startsWithIgnoreCase(string, string2);
    }

    private String a(Connection connection, int n2, String string) throws SQLException {
        Object object;
        int n3;
        Object object2;
        boolean bl;
        ArrayList arrayList = New.arrayList();
        int n4 = 0;
        while (!this.stop && (n4 = string.indexOf(63, n4)) >= 0) {
            if (this.a(string.substring(n4), "?/*rnd*/")) {
                arrayList.add(1);
                string = string.substring(0, n4) + "?" + string.substring(n4 + "/*rnd*/".length() + 1);
            } else {
                arrayList.add(0);
            }
            ++n4;
        }
        int n5 = 0;
        Random random = new Random(1L);
        long l2 = System.currentTimeMillis();
        if (this.a(string, "@statement")) {
            string = string.substring("@statement".length()).trim();
            bl = false;
            object2 = connection.createStatement();
            for (n3 = 0; !this.stop && n3 < n2; ++n3) {
                String string2 = string;
                for (Integer n6 : arrayList) {
                    n4 = string2.indexOf(63);
                    if (n6 == 1) {
                        string2 = string2.substring(0, n4) + random.nextInt(n2) + string2.substring(n4 + 1);
                        continue;
                    }
                    string2 = string2.substring(0, n4) + n3 + string2.substring(n4 + 1);
                }
                if (!object2.execute(string2)) continue;
                object = object2.getResultSet();
                while (!this.stop && object.next()) {
                    ++n5;
                }
                object.close();
            }
        } else {
            bl = true;
            object2 = connection.prepareStatement(string);
            for (n3 = 0; !this.stop && n3 < n2; ++n3) {
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    object = (Integer)arrayList.get(i2);
                    if ((Integer)object == 1) {
                        object2.setInt(i2 + 1, random.nextInt(n2));
                        continue;
                    }
                    object2.setInt(i2 + 1, n3);
                }
                if (this.session.getContents().isSQLite) {
                    object2.executeUpdate();
                    continue;
                }
                if (!object2.execute()) continue;
                ResultSet resultSet = object2.getResultSet();
                while (!this.stop && resultSet.next()) {
                    ++n5;
                }
                resultSet.close();
            }
        }
        l2 = System.currentTimeMillis() - l2;
        object2 = new StatementBuilder();
        ((StatementBuilder)object2).append(l2).append(" ms: ").append(n2).append(" * ");
        if (bl) {
            ((StatementBuilder)object2).append("(Prepared) ");
        } else {
            ((StatementBuilder)object2).append("(Statement) ");
        }
        ((StatementBuilder)object2).append('(');
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n7 = (Integer)iterator.next();
            ((StatementBuilder)object2).appendExceptFirst(", ");
            ((StatementBuilder)object2).append(n7 == 0 ? "i" : "rnd");
        }
        return ((StatementBuilder)object2).append(") ").append(string).toString();
    }

    private String new() {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList arrayList = this.session.getCommands();
        stringBuilder.append("<table cellspacing=0 cellpadding=0><tr><th></th><th>Command</th></tr>");
        for (int i2 = arrayList.size() - 1; i2 >= 0; --i2) {
            String string = (String)arrayList.get(i2);
            stringBuilder.append("<tr><td><a href=\"getHistory.do?id=").append(i2).append("&jsessionid=${sessionId}\" target=\"h2query\" >").append("<img width=16 height=16 src=\"ico_write.gif\" onmouseover = \"this.className ='icon_hover'\" ").append("onmouseout = \"this.className ='icon'\" class=\"icon\" alt=\"${text.resultEdit.edit}\" ").append("title=\"${text.resultEdit.edit}\" border=\"1\"/></a>").append("</td><td>").append(PageParser.escapeHtml(string)).append("</td></tr>");
        }
        stringBuilder.append("</table>");
        return stringBuilder.toString();
    }

    private String a(ParameterMetaData parameterMetaData) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder();
        if (parameterMetaData == null) {
            return "No parameter meta data";
        }
        stringBuilder.append("<table cellspacing=0 cellpadding=0>").append("<tr><th>className</th><th>mode</th><th>type</th>").append("<th>typeName</th><th>precision</th><th>scale</th></tr>");
        for (int i2 = 0; i2 < parameterMetaData.getParameterCount(); ++i2) {
            stringBuilder.append("</tr><td>").append(parameterMetaData.getParameterClassName(i2 + 1)).append("</td><td>").append(parameterMetaData.getParameterMode(i2 + 1)).append("</td><td>").append(parameterMetaData.getParameterType(i2 + 1)).append("</td><td>").append(parameterMetaData.getParameterTypeName(i2 + 1)).append("</td><td>").append(parameterMetaData.getPrecision(i2 + 1)).append("</td><td>").append(parameterMetaData.getScale(i2 + 1)).append("</td></tr>");
        }
        stringBuilder.append("</table>");
        return stringBuilder.toString();
    }

    private String a(String string, ResultSet resultSet, boolean bl, boolean bl2, boolean bl3, long l2, boolean bl4) throws SQLException {
        int n2;
        int n3 = this.char();
        l2 = System.currentTimeMillis() - l2;
        StringBuilder stringBuilder = new StringBuilder();
        if (bl3) {
            stringBuilder.append("<form id=\"editing\" name=\"editing\" method=\"post\" action=\"editResult.do?jsessionid=${sessionId}\" id=\"mainForm\" target=\"h2result\"><input type=\"hidden\" name=\"op\" value=\"1\" /><input type=\"hidden\" name=\"row\" value=\"\" /><table cellspacing=0 cellpadding=0 id=\"editTable\">");
        } else {
            stringBuilder.append("<table cellspacing=0 cellpadding=0>");
        }
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n4 = resultSetMetaData.getColumnCount();
        int n5 = 0;
        if (bl) {
            stringBuilder.append("<tr><th>i</th><th>label</th><th>cat</th><th>schem</th><th>tab</th><th>col</th><th>type</th><th>typeName</th><th>class</th><th>prec</th><th>scale</th><th>size</th><th>autoInc</th><th>case</th><th>currency</th><th>null</th><th>ro</th><th>search</th><th>sig</th><th>w</th><th>defW</th></tr>");
            for (n2 = 1; n2 <= n4; ++n2) {
                stringBuilder.append("<tr>").append("<td>").append(n2).append("</td>").append("<td>").append(PageParser.escapeHtml(resultSetMetaData.getColumnLabel(n2))).append("</td>").append("<td>").append(PageParser.escapeHtml(resultSetMetaData.getCatalogName(n2))).append("</td>").append("<td>").append(PageParser.escapeHtml(resultSetMetaData.getSchemaName(n2))).append("</td>").append("<td>").append(PageParser.escapeHtml(resultSetMetaData.getTableName(n2))).append("</td>").append("<td>").append(PageParser.escapeHtml(resultSetMetaData.getColumnName(n2))).append("</td>").append("<td>").append(resultSetMetaData.getColumnType(n2)).append("</td>").append("<td>").append(PageParser.escapeHtml(resultSetMetaData.getColumnTypeName(n2))).append("</td>").append("<td>").append(PageParser.escapeHtml(resultSetMetaData.getColumnClassName(n2))).append("</td>").append("<td>").append(resultSetMetaData.getPrecision(n2)).append("</td>").append("<td>").append(resultSetMetaData.getScale(n2)).append("</td>").append("<td>").append(resultSetMetaData.getColumnDisplaySize(n2)).append("</td>").append("<td>").append(resultSetMetaData.isAutoIncrement(n2)).append("</td>").append("<td>").append(resultSetMetaData.isCaseSensitive(n2)).append("</td>").append("<td>").append(resultSetMetaData.isCurrency(n2)).append("</td>").append("<td>").append(resultSetMetaData.isNullable(n2)).append("</td>").append("<td>").append(resultSetMetaData.isReadOnly(n2)).append("</td>").append("<td>").append(resultSetMetaData.isSearchable(n2)).append("</td>").append("<td>").append(resultSetMetaData.isSigned(n2)).append("</td>").append("<td>").append(resultSetMetaData.isWritable(n2)).append("</td>").append("<td>").append(resultSetMetaData.isDefinitelyWritable(n2)).append("</td>").append("</tr>");
            }
        } else if (bl2) {
            stringBuilder.append("<tr><th>Column</th><th>Data</th></tr><tr>");
            while (resultSet.next() && (n3 <= 0 || n5 < n3)) {
                stringBuilder.append("<tr><td>Row #</td><td>").append(++n5).append("</tr>");
                for (n2 = 0; n2 < n4; ++n2) {
                    stringBuilder.append("<tr><td>").append(PageParser.escapeHtml(resultSetMetaData.getColumnLabel(n2 + 1))).append("</td><td>").append(this.a(resultSet, n2 + 1)).append("</td></tr>");
                }
            }
        } else {
            stringBuilder.append("<tr>");
            if (bl3) {
                stringBuilder.append("<th>Action</th>");
            }
            for (n2 = 0; n2 < n4; ++n2) {
                stringBuilder.append("<th>").append(PageParser.escapeHtml(resultSetMetaData.getColumnLabel(n2 + 1))).append("</th>");
            }
            stringBuilder.append("</tr>");
            while (resultSet.next() && (n3 <= 0 || n5 < n3)) {
                ++n5;
                stringBuilder.append("<tr>");
                if (bl3) {
                    stringBuilder.append("<td>").append("<img onclick=\"javascript:editRow(").append(resultSet.getRow()).append(",'${sessionId}', '${text.resultEdit.save}', '${text.resultEdit.cancel}'").append(")\" width=16 height=16 src=\"ico_write.gif\" onmouseover = \"this.className ='icon_hover'\" onmouseout = \"this.className ='icon'\" class=\"icon\" alt=\"${text.resultEdit.edit}\" title=\"${text.resultEdit.edit}\" border=\"1\"/>").append("<a href=\"editResult.do?op=2&row=").append(resultSet.getRow()).append("&jsessionid=${sessionId}\" target=\"h2result\" ><img width=16 height=16 src=\"ico_remove.gif\" onmouseover = \"this.className ='icon_hover'\" onmouseout = \"this.className ='icon'\" class=\"icon\" alt=\"${text.resultEdit.delete}\" title=\"${text.resultEdit.delete}\" border=\"1\" /></a>").append("</td>");
                }
                for (n2 = 0; n2 < n4; ++n2) {
                    stringBuilder.append("<td>").append(this.a(resultSet, n2 + 1)).append("</td>");
                }
                stringBuilder.append("</tr>");
            }
        }
        n2 = 0;
        try {
            n2 = resultSet.getConcurrency() == 1008 && resultSet.getType() != 1003 ? 1 : 0;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (bl3) {
            ResultSet resultSet2 = this.session.result;
            if (resultSet2 != null) {
                resultSet2.close();
            }
            this.session.result = resultSet;
        } else {
            resultSet.close();
        }
        if (bl3) {
            stringBuilder.append("<tr><td>").append("<img onclick=\"javascript:editRow(-1, '${sessionId}', '${text.resultEdit.save}', '${text.resultEdit.cancel}'").append(")\" width=16 height=16 src=\"ico_add.gif\" onmouseover = \"this.className ='icon_hover'\" onmouseout = \"this.className ='icon'\" class=\"icon\" alt=\"${text.resultEdit.add}\" title=\"${text.resultEdit.add}\" border=\"1\"/>").append("</td>");
            for (int i2 = 0; i2 < n4; ++i2) {
                stringBuilder.append("<td></td>");
            }
            stringBuilder.append("</tr>");
        }
        stringBuilder.append("</table>");
        if (bl3) {
            stringBuilder.append("</form>");
        }
        if (n5 == 0) {
            stringBuilder.append("(${text.result.noRows}");
        } else if (n5 == 1) {
            stringBuilder.append("(${text.result.1row}");
        } else {
            stringBuilder.append('(').append(n5).append(" ${text.result.rows}");
        }
        stringBuilder.append(", ");
        l2 = System.currentTimeMillis() - l2;
        stringBuilder.append(l2).append(" ms)");
        if (!bl3 && n2 != 0 && bl4) {
            stringBuilder.append("<br /><br /><form name=\"editResult\" method=\"post\" action=\"query.do?jsessionid=${sessionId}\" target=\"h2result\"><input type=\"submit\" class=\"button\" value=\"${text.resultEdit.editResult}\" /><input type=\"hidden\" name=\"sql\" value=\"@edit ").append(PageParser.escapeHtmlData(string)).append("\" /></form>");
        }
        return stringBuilder.toString();
    }

    String settingSave() {
        ConnectionInfo connectionInfo = new ConnectionInfo();
        connectionInfo.name = this.attributes.getProperty("name", "");
        connectionInfo.driver = this.attributes.getProperty("driver", "");
        connectionInfo.url = this.attributes.getProperty("url", "");
        connectionInfo.user = this.attributes.getProperty("user", "");
        this.server.updateSetting(connectionInfo);
        this.attributes.put("setting", connectionInfo.name);
        this.server.saveProperties(null);
        return "index.do";
    }

    private String a(ResultSet resultSet, int n2) throws SQLException {
        String string = resultSet.getString(n2);
        if (string == null) {
            return "<i>null</i>";
        }
        if (string.length() > SysProperties.WEB_MAX_VALUE_LENGTH) {
            String string2 = this.a(resultSet.getMetaData().getColumnType(n2)) ? PageParser.escapeHtml(string.substring(0, 6)) + "... (" + string.length() / 2 + " ${text.result.bytes})" : PageParser.escapeHtml(string.substring(0, 100)) + "... (" + string.length() + " ${text.result.characters})";
            return "<div style='display: none'>=+</div>" + string2;
        }
        if (string.equals("null") || string.startsWith("= ") || string.startsWith("=+")) {
            return "<div style='display: none'>= </div>" + PageParser.escapeHtml(string);
        }
        return PageParser.escapeHtml(string);
    }

    private boolean a(int n2) {
        switch (n2) {
            case -4: 
            case -3: 
            case -2: 
            case 1111: 
            case 2000: 
            case 2004: {
                return true;
            }
        }
        return false;
    }

    private void a(String string, ResultSet resultSet, int n2) throws SQLException {
        if (string.equals("null")) {
            resultSet.updateNull(n2);
            return;
        }
        if (string.startsWith("=+")) {
            return;
        }
        if (string.startsWith("= ")) {
            string = string.substring(2);
        }
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n3 = resultSetMetaData.getColumnType(n2);
        if (this.session.getContents().isH2) {
            resultSet.updateString(n2, string);
            return;
        }
        switch (n3) {
            case -5: {
                resultSet.updateLong(n2, (long)Long.decode(string));
                break;
            }
            case 3: {
                resultSet.updateBigDecimal(n2, new BigDecimal(string));
                break;
            }
            case 6: 
            case 8: {
                resultSet.updateDouble(n2, Double.parseDouble(string));
                break;
            }
            case 7: {
                resultSet.updateFloat(n2, Float.parseFloat(string));
                break;
            }
            case 4: {
                resultSet.updateInt(n2, (int)Integer.decode(string));
                break;
            }
            case -6: {
                resultSet.updateShort(n2, (short)Short.decode(string));
                break;
            }
            default: {
                resultSet.updateString(n2, string);
            }
        }
    }

    private String case() {
        String string = this.attributes.getProperty("name", "");
        this.server.removeSetting(string);
        ArrayList arrayList = this.server.getSettings();
        if (arrayList.size() > 0) {
            this.attributes.put("setting", arrayList.get(0));
        }
        this.server.saveProperties(null);
        return "index.do";
    }

    String getMimeType() {
        return this.mimeType;
    }

    boolean getCache() {
        return this.cache;
    }

    WebSession getSession() {
        return this.session;
    }

    private void for(String string) {
        this.server.trace(string);
    }

    static class IndexInfo {
        String name;
        String type;
        String columns;

        IndexInfo() {
        }
    }
}

