/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import org.h2.Driver;
import org.h2.constant.SysProperties;
import org.h2.message.TraceSystem;
import org.h2.server.Service;
import org.h2.server.ShutdownHandler;
import org.h2.server.web.ConnectionInfo;
import org.h2.server.web.WebSession;
import org.h2.server.web.WebThread;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;
import org.h2.util.New;
import org.h2.util.SortedProperties;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WebServer
implements Service {
    static final String TRANSFER = "transfer";
    private static final String ac = "en";
    private static final String[][] X = new String[][]{{"de", "Deutsch"}, {"en", "English"}, {"es", "Espa\u00f1ol"}, {"fr", "Fran\u00e7ais"}, {"hu", "Magyar"}, {"in", "Indonesia"}, {"it", "Italiano"}, {"ja", "\u65e5\u672c\u8a9e"}, {"nl", "Nederlands"}, {"pl", "Polski"}, {"pt_BR", "Portugu\u00eas (Brasil)"}, {"pt_PT", "Portugu\u00eas (Europeu)"}, {"ru", "\u0440\u0443\u0441\u0441\u043a\u0438\u0439"}, {"sk", "Slovensky"}, {"tr", "T\u00fcrk\u00e7e"}, {"uk", "\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430"}, {"zh_CN", "\u4e2d\u6587 (\u7b80\u4f53)"}, {"zh_TW", "\u4e2d\u6587 (\u7e41\u9ad4)"}};
    private static final String[] R = new String[]{"Generic JNDI Data Source|javax.naming.InitialContext|java:comp/env/jdbc/Test|sa", "Generic Firebird Server|org.firebirdsql.jdbc.FBDriver|jdbc:firebirdsql:localhost:c:/temp/firebird/test|sysdba", "Generic OneDollarDB|in.co.daffodil.db.jdbc.DaffodilDBDriver|jdbc:daffodilDB_embedded:school;path=C:/temp;create=true|sa", "Generic SQLite|org.sqlite.JDBC|jdbc:sqlite:test|sa", "Generic DB2|COM.ibm.db2.jdbc.net.DB2Driver|jdbc:db2://localhost/test|", "Generic Oracle|oracle.jdbc.driver.OracleDriver|jdbc:oracle:thin:@localhost:1521:XE|sa", "Generic MS SQL Server 2000|com.microsoft.jdbc.sqlserver.SQLServerDriver|jdbc:microsoft:sqlserver://localhost:1433;DatabaseName=sqlexpress|sa", "Generic MS SQL Server 2005|com.microsoft.sqlserver.jdbc.SQLServerDriver|jdbc:sqlserver://localhost;DatabaseName=test|sa", "Generic PostgreSQL|org.postgresql.Driver|jdbc:postgresql:test|", "Generic MySQL|com.mysql.jdbc.Driver|jdbc:mysql://localhost:3306/test|", "Generic HSQLDB|org.hsqldb.jdbcDriver|jdbc:hsqldb:test;hsqldb.default_table_type=cached|sa", "Generic Derby (Server)|org.apache.derby.jdbc.ClientDriver|jdbc:derby://localhost:1527/test;create=true|sa", "Generic Derby (Embedded)|org.apache.derby.jdbc.EmbeddedDriver|jdbc:derby:test;create=true|sa", "Generic H2 (Server)|org.h2.Driver|jdbc:h2:tcp://localhost/~/test|sa", "Generic H2 (Embedded)|org.h2.Driver|jdbc:h2:~/test|sa"};
    private static int af;
    private static final long Z = 1800000L;
    private int S;
    private boolean ag;
    private boolean O;
    private Set L = Collections.synchronizedSet(new HashSet());
    private boolean V;
    private HashMap P = New.hashMap();
    private long M;
    private HashMap J = New.hashMap();
    private HashSet T = New.hashSet();
    private String ad;
    private ServerSocket K;
    private String N;
    private ShutdownHandler W;
    private Thread Y;
    private boolean U;
    private boolean ab;
    private TranslateThread ae;
    private boolean Q = true;
    private String aa = "~";

    byte[] getFile(String string) throws IOException {
        this.trace("getFile <" + string + ">");
        if (string.startsWith("transfer/") && new File(TRANSFER).exists()) {
            if (!this.isSimpleName(string = string.substring(TRANSFER.length() + 1))) {
                return null;
            }
            File file = new File(TRANSFER, string);
            if (!file.exists()) {
                return null;
            }
            return IOUtils.readBytesAndClose(new FileInputStream(file), -1);
        }
        byte[] byArray = Utils.getResource("/org/h2/server/web/res/" + string);
        if (byArray == null) {
            this.trace(" null");
        } else {
            this.trace(" size=" + byArray.length);
        }
        return byArray;
    }

    boolean isSimpleName(String string) {
        for (char c2 : string.toCharArray()) {
            if (c2 == '.' || c2 == '_' || c2 == '-' || Character.isLetterOrDigit(c2)) continue;
            return false;
        }
        return true;
    }

    synchronized void remove(WebThread webThread) {
        this.L.remove(webThread);
    }

    private String for() {
        byte[] byArray = MathUtils.secureRandomBytes(16);
        return StringUtils.convertBytesToString(byArray);
    }

    WebSession getSession(String string) {
        Object object;
        long l2 = System.currentTimeMillis();
        if (this.M + 1800000L < l2) {
            object = New.arrayList(this.J.keySet()).iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                WebSession webSession = (WebSession)this.J.get(string2);
                Long l3 = (Long)webSession.get("lastAccess");
                if (l3 == null || l3 + 1800000L >= l2) continue;
                this.trace("timeout for " + string2);
                this.J.remove(string2);
            }
            this.M = l2;
        }
        if ((object = (WebSession)this.J.get(string)) != null) {
            ((WebSession)object).lastAccess = System.currentTimeMillis();
        }
        return object;
    }

    WebSession createNewSession(String string) {
        String string2;
        while (this.J.get(string2 = this.for()) != null) {
        }
        WebSession webSession = new WebSession(this);
        webSession.put("sessionId", string2);
        webSession.put("ip", string);
        webSession.put("language", ac);
        webSession.put("frame-border", "0");
        webSession.put("frameset-border", "4");
        this.J.put(string2, webSession);
        this.readTranslations(webSession, ac);
        return this.getSession(string2);
    }

    String getStartDateTime() {
        if (this.ad == null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", new Locale(ac, ""));
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.ad = simpleDateFormat.format(new Date());
        }
        return this.ad;
    }

    public void init(String ... stringArray) {
        for (int i2 = 0; stringArray != null && i2 < stringArray.length; ++i2) {
            if (!stringArray[i2].equals("-properties")) continue;
            this.aa = stringArray[++i2];
        }
        Properties properties = this.int();
        this.S = SortedProperties.getIntProperty(properties, "webPort", 8082);
        this.V = SortedProperties.getBooleanProperty(properties, "webSSL", false);
        this.ag = SortedProperties.getBooleanProperty(properties, "webAllowOthers", false);
        for (int i3 = 0; stringArray != null && i3 < stringArray.length; ++i3) {
            String string = stringArray[i3];
            if ("-webPort".equals(string)) {
                this.S = Integer.decode(stringArray[++i3]);
                continue;
            }
            if ("-webSSL".equals(string)) {
                this.V = true;
                continue;
            }
            if ("-webAllowOthers".equals(string)) {
                this.ag = true;
                continue;
            }
            if ("-webDaemon".equals(string)) {
                this.O = true;
                continue;
            }
            if ("-baseDir".equals(string)) {
                String string2 = stringArray[++i3];
                SysProperties.setBaseDir(string2);
                continue;
            }
            if ("-ifExists".equals(string)) {
                this.U = true;
                continue;
            }
            if (stringArray[i3].equals("-properties")) {
                ++i3;
                continue;
            }
            if (!"-trace".equals(string)) continue;
            this.ab = true;
        }
        for (String[] stringArray2 : X) {
            this.T.add(stringArray2[0]);
        }
        this.do();
    }

    public String getURL() {
        this.do();
        return this.N;
    }

    private void do() {
        try {
            this.N = (this.V ? "https" : "http") + "://" + NetUtils.getLocalAddress() + ":" + this.S;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public void start() {
        this.K = NetUtils.createServerSocket(this.S, this.V);
        this.S = this.K.getLocalPort();
        this.do();
    }

    public void listen() {
        this.Y = Thread.currentThread();
        try {
            while (this.K != null) {
                Socket socket = this.K.accept();
                WebThread webThread = new WebThread(socket, this);
                this.L.add(webThread);
                webThread.start();
            }
        }
        catch (Exception exception) {
            this.trace(exception.toString());
        }
    }

    public boolean isRunning(boolean bl) {
        if (this.K == null) {
            return false;
        }
        try {
            Socket socket = NetUtils.createLoopbackSocket(this.S, this.V);
            socket.close();
            return true;
        }
        catch (Exception exception) {
            if (bl) {
                this.traceError(exception);
            }
            return false;
        }
    }

    public boolean isStopped() {
        return this.K == null;
    }

    public void stop() {
        if (this.K != null) {
            try {
                this.K.close();
            }
            catch (IOException iOException) {
                this.traceError(iOException);
            }
            this.K = null;
        }
        if (this.Y != null) {
            try {
                this.Y.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                TraceSystem.traceThrowable(interruptedException);
            }
        }
        for (Object object : New.arrayList(this.J.values())) {
            ((WebSession)object).close();
        }
        for (Object object : New.arrayList(this.L)) {
            try {
                ((WebThread)object).stopNow();
                ((WebThread)object).join(100);
            }
            catch (Exception exception) {
                this.traceError(exception);
            }
        }
    }

    void trace(String string) {
        if (this.ab) {
            System.out.println(string);
        }
    }

    void traceError(Throwable throwable) {
        if (this.ab) {
            throwable.printStackTrace();
        }
    }

    boolean supportsLanguage(String string) {
        return this.T.contains(string);
    }

    void readTranslations(WebSession webSession, String string) {
        Properties properties = new Properties();
        try {
            this.trace("translation: " + string);
            byte[] byArray = this.getFile("_text_" + string + ".prop");
            this.trace("  " + new String(byArray));
            properties = SortedProperties.fromLines(new String(byArray, "UTF-8"));
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String string2 = (String)entry.getValue();
                if (!string2.startsWith("#")) continue;
                entry.setValue(string2.substring(1));
            }
        }
        catch (IOException iOException) {
            TraceSystem.traceThrowable(iOException);
        }
        webSession.put("text", new HashMap<Object, Object>(properties));
    }

    String[][] getLanguageArray() {
        return X;
    }

    ArrayList getSessions() {
        ArrayList arrayList = New.arrayList();
        for (WebSession webSession : this.J.values()) {
            arrayList.add(webSession.getInfo());
        }
        return arrayList;
    }

    public String getType() {
        return "Web Console";
    }

    public String getName() {
        return "H2 Console Server";
    }

    void setAllowOthers(boolean bl) {
        this.ag = bl;
    }

    public boolean getAllowOthers() {
        return this.ag;
    }

    void setSSL(boolean bl) {
        this.V = bl;
    }

    void setPort(int n2) {
        this.S = n2;
    }

    boolean getSSL() {
        return this.V;
    }

    public int getPort() {
        return this.S;
    }

    ConnectionInfo getSetting(String string) {
        return (ConnectionInfo)this.P.get(string);
    }

    void updateSetting(ConnectionInfo connectionInfo) {
        this.P.put(connectionInfo.name, connectionInfo);
        connectionInfo.lastAccess = af++;
    }

    void removeSetting(String string) {
        this.P.remove(string);
    }

    private Properties int() {
        try {
            return SortedProperties.loadProperties(this.aa + "/" + ".h2.server.properties");
        }
        catch (Exception exception) {
            TraceSystem.traceThrowable(exception);
            return new Properties();
        }
    }

    String[] getSettingNames() {
        ArrayList arrayList = this.getSettings();
        String[] stringArray = new String[arrayList.size()];
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            stringArray[i2] = ((ConnectionInfo)arrayList.get((int)i2)).name;
        }
        return stringArray;
    }

    synchronized ArrayList getSettings() {
        ArrayList arrayList = New.arrayList();
        if (this.P.size() == 0) {
            Properties properties = this.int();
            if (properties.size() == 0) {
                for (String string : R) {
                    ConnectionInfo connectionInfo = new ConnectionInfo(string);
                    arrayList.add(connectionInfo);
                    this.updateSetting(connectionInfo);
                }
            } else {
                String string;
                int n2 = 0;
                while ((string = properties.getProperty(String.valueOf(n2))) != null) {
                    ConnectionInfo connectionInfo = new ConnectionInfo(string);
                    arrayList.add(connectionInfo);
                    this.updateSetting(connectionInfo);
                    ++n2;
                }
            }
        } else {
            arrayList.addAll(this.P.values());
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    synchronized void saveProperties(Properties properties) {
        try {
            Cloneable cloneable;
            if (properties == null) {
                cloneable = this.int();
                properties = new SortedProperties();
                properties.setProperty("webPort", "" + SortedProperties.getIntProperty((Properties)cloneable, "webPort", this.S));
                properties.setProperty("webAllowOthers", "" + SortedProperties.getBooleanProperty((Properties)cloneable, "webAllowOthers", this.ag));
                properties.setProperty("webSSL", "" + SortedProperties.getBooleanProperty((Properties)cloneable, "webSSL", this.V));
            }
            cloneable = this.getSettings();
            int n2 = ((ArrayList)cloneable).size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ConnectionInfo connectionInfo = (ConnectionInfo)((ArrayList)cloneable).get(i2);
                if (connectionInfo == null) continue;
                properties.setProperty(String.valueOf(n2 - i2 - 1), connectionInfo.getString());
            }
            OutputStream outputStream = IOUtils.openFileOutputStream(this.aa + "/" + ".h2.server.properties", false);
            properties.store(outputStream, "H2 Server Properties");
            outputStream.close();
        }
        catch (Exception exception) {
            TraceSystem.traceThrowable(exception);
        }
    }

    Connection getConnection(String string, String string2, String string3, String string4) throws SQLException {
        string = string.trim();
        string2 = string2.trim();
        Driver.load();
        Properties properties = new Properties();
        properties.setProperty("user", string3.trim());
        properties.setProperty("password", string4);
        if (string2.startsWith("jdbc:h2:")) {
            if (this.U) {
                string2 = string2 + ";IFEXISTS=TRUE";
            }
            return Driver.load().connect(string2, properties);
        }
        return JdbcUtils.getConnection(string, string2, properties);
    }

    void shutdown() {
        if (this.W != null) {
            this.W.shutdown();
        }
    }

    public void setShutdownHandler(ShutdownHandler shutdownHandler) {
        this.W = shutdownHandler;
    }

    public String addSession(Connection connection) throws SQLException {
        WebSession webSession = this.createNewSession("local");
        webSession.setShutdownServerOnDisconnect();
        webSession.setConnection(connection);
        webSession.put("url", connection.getMetaData().getURL());
        String string = (String)webSession.get("sessionId");
        return this.N + "/frame.jsp?jsessionid=" + string;
    }

    String startTranslate(Map map) {
        if (this.ae != null) {
            this.ae.stopNow();
        }
        this.ae = new TranslateThread(map);
        this.ae.setDaemon(true);
        this.ae.start();
        return this.ae.getFileName();
    }

    public boolean isDaemon() {
        return this.O;
    }

    void setAllowChunked(boolean bl) {
        this.Q = bl;
    }

    boolean getAllowChunked() {
        return this.Q;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class TranslateThread
    extends Thread {
        private final File if = new File("translation.properties");
        private final Map do;
        private volatile boolean a;

        TranslateThread(Map map) {
            this.do = map;
        }

        public String getFileName() {
            return this.if.getAbsolutePath();
        }

        public void stopNow() {
            this.a = true;
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void run() {
            while (!this.a) {
                try {
                    Closeable closeable;
                    SortedProperties sortedProperties = new SortedProperties();
                    if (this.if.exists()) {
                        closeable = IOUtils.openFileInputStream(this.if.getName());
                        sortedProperties.load((InputStream)closeable);
                        this.do.putAll(sortedProperties);
                    } else {
                        closeable = IOUtils.openFileOutputStream(this.if.getName(), false);
                        sortedProperties.putAll((Map<?, ?>)this.do);
                        sortedProperties.store((OutputStream)closeable, "Translation");
                    }
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    WebServer.this.traceError(exception);
                }
            }
        }
    }
}

